/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.swing.control;

import com.inet.lib.core.LibBase;
import com.inet.lib.swing.control.Control;
import com.inet.lib.swing.control.ControlManager;
import com.inet.lib.swing.control.Message;

public class SimpleControlManager
extends ControlManager {
    protected SimpleControlManager() {
    }

    public SimpleControlManager(Control[] controlArray) {
        super(controlArray);
    }

    public boolean rollback() {
        try {
            for (int i2 = 0; i2 < this.getControlCount(); ++i2) {
                Control control = this.getControl(i2);
                control.rollback();
                control.cleanUp();
            }
        }
        catch (Throwable throwable) {
            LibBase.getInstance().getLogHandler().error(throwable.getClass().getSimpleName() + " on rollback :" + throwable.getMessage());
            for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                LibBase.getInstance().getLogHandler().error(stackTraceElement.toString());
            }
        }
        return true;
    }

    public Message verify(boolean bl2) {
        for (int i2 = 0; i2 < this.getControlCount(); ++i2) {
            Control control = this.getControl(i2);
            Message message = control.verify(bl2);
            if (message == null) continue;
            message.setControl(control);
            this.setSelected(control);
            return message;
        }
        return null;
    }

    public String help() {
        Control control = this.getSelected();
        if (control != null) {
            return control.help();
        }
        return null;
    }

    public boolean commit() {
        Message message = this.verify(true);
        if (message != null && message.getType() == 1) {
            this.firePropertyChange("STATUS", message);
            return false;
        }
        this.firePropertyChange("STATUS", Message.NONE);
        for (int i2 = 0; i2 < this.getControlCount(); ++i2) {
            Control control = this.getControl(i2);
            control.commit();
            control.cleanUp();
        }
        return true;
    }

    public boolean apply() {
        for (int i2 = 0; i2 < this.getControlCount(); ++i2) {
            Control control = this.getControl(i2);
            control.apply();
        }
        return true;
    }
}

