/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.swing.ico;

import com.inet.lib.swing.ico.LittleEndianInputStream;
import com.inet.lib.swing.ico.b;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;

public class BMPDecoder {
    public static final int BI_RGB = 0;
    public static final int BI_RLE8 = 1;
    public static final int BI_RLE4 = 2;

    private static void a(Color[] colorArray, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        for (int i2 = 0; i2 < colorArray.length; ++i2) {
            byArray[i2] = (byte)colorArray[i2].getRed();
            byArray2[i2] = (byte)colorArray[i2].getGreen();
            byArray3[i2] = (byte)colorArray[i2].getBlue();
        }
    }

    public static BufferedImage read(b object, LittleEndianInputStream littleEndianInputStream) throws IOException {
        Color[] colorArray = null;
        if (((b)object).d <= 8) {
            colorArray = BMPDecoder.readColorTable((b)object, littleEndianInputStream);
        }
        object = BMPDecoder.read((b)object, littleEndianInputStream, colorArray);
        return object;
    }

    public static BufferedImage read(b b2, LittleEndianInputStream littleEndianInputStream, Color[] colorArray) throws IOException {
        if (b2.e == 0) {
            switch (b2.d) {
                case 1: {
                    return BMPDecoder.read1(b2, littleEndianInputStream, colorArray);
                }
                case 4: {
                    return BMPDecoder.read4(b2, littleEndianInputStream, colorArray);
                }
                case 8: {
                    return BMPDecoder.read8(b2, littleEndianInputStream, colorArray);
                }
                case 24: {
                    return BMPDecoder.read24(b2, littleEndianInputStream);
                }
                case 32: {
                    return BMPDecoder.read32(b2, littleEndianInputStream);
                }
            }
        }
        throw new IOException("Unrecognized bitmap format: bit count=" + b2.d + ", compression=" + b2.e);
    }

    public static Color[] readColorTable(b b2, LittleEndianInputStream littleEndianInputStream) throws IOException {
        Color[] colorArray = new Color[b2.f];
        for (int i2 = 0; i2 < b2.f; ++i2) {
            int n2 = littleEndianInputStream.readUnsignedByte();
            int n3 = littleEndianInputStream.readUnsignedByte();
            int n4 = littleEndianInputStream.readUnsignedByte();
            colorArray[i2] = new Color(n4, n3, n2);
        }
        return colorArray;
    }

    public static BufferedImage read1(b b2, LittleEndianInputStream littleEndianInputStream, Color[] object) throws IOException {
        int n2;
        Object object2 = new byte[((Color[])object).length];
        byte[] byArray = new byte[((Color[])object).length];
        byte[] byArray2 = new byte[((Color[])object).length];
        BMPDecoder.a(object, (byte[])object2, byArray, byArray2);
        object = new IndexColorModel(1, 2, (byte[])object2, byArray, byArray2);
        object = new BufferedImage(b2.b, b2.c, 12, (IndexColorModel)object);
        object2 = object.getRaster();
        int n3 = n2 = b2.b;
        if (n2 % 32 != 0) {
            n3 = n2 / 32 + 1 << 5;
        }
        n2 = n3 / 8;
        int[] nArray = new int[n2];
        for (int i2 = b2.c - 1; i2 >= 0; --i2) {
            int n4;
            for (n4 = 0; n4 < n2; ++n4) {
                nArray[n4] = littleEndianInputStream.readUnsignedByte();
            }
            for (n4 = 0; n4 < b2.b; ++n4) {
                int n5 = n4 / 8;
                n5 = nArray[n5];
                int n6 = n4 % 8;
                n5 = n5 >> 7 - n6 & 1;
                ((WritableRaster)object2).setSample(n4, i2, 0, n5);
            }
        }
        return object;
    }

    public static BufferedImage read4(b b2, LittleEndianInputStream littleEndianInputStream, Color[] object) throws IOException {
        Object object2 = new byte[((Color[])object).length];
        byte[] byArray = new byte[((Color[])object).length];
        Object[] objectArray = new byte[((Color[])object).length];
        BMPDecoder.a(object, (byte[])object2, byArray, objectArray);
        object = new IndexColorModel(4, b2.f, (byte[])object2, byArray, (byte[])objectArray);
        object = new BufferedImage(b2.b, b2.c, 12, (IndexColorModel)object);
        object2 = object.getRaster();
        int n2 = b2.b << 2;
        if (n2 % 32 != 0) {
            n2 = n2 / 32 + 1 << 5;
        }
        objectArray = new int[n2 /= 8];
        for (int i2 = b2.c - 1; i2 >= 0; --i2) {
            int n3;
            int n4;
            for (n4 = 0; n4 < n2; ++n4) {
                objectArray[n4] = n3 = littleEndianInputStream.readUnsignedByte();
            }
            for (n4 = 0; n4 < b2.b; ++n4) {
                n3 = n4 / 2;
                int n5 = n4 % 2;
                int n6 = objectArray[n3];
                n3 = n6;
                n3 = n6;
                n3 = n6 >> 4 * (1 - n5) & 0xF;
                ((WritableRaster)object2).setSample(n4, i2, 0, n3);
            }
        }
        return object;
    }

    public static BufferedImage read8(b b2, LittleEndianInputStream littleEndianInputStream, Color[] object) throws IOException {
        int n2;
        Object object2 = new byte[((Color[])object).length];
        byte[] byArray = new byte[((Color[])object).length];
        byte[] byArray2 = new byte[((Color[])object).length];
        BMPDecoder.a(object, (byte[])object2, byArray, byArray2);
        object = new IndexColorModel(8, b2.f, (byte[])object2, byArray, byArray2);
        object = new BufferedImage(b2.b, b2.c, 13, (IndexColorModel)object);
        object2 = object.getRaster();
        int n3 = n2 = b2.b;
        if (n2 % 4 != 0) {
            n3 = n2 / 4 + 1 << 2;
        }
        n2 = n3 - n2;
        for (n3 = b2.c - 1; n3 >= 0; --n3) {
            for (int i2 = 0; i2 < b2.b; ++i2) {
                int n4 = littleEndianInputStream.readUnsignedByte();
                ((WritableRaster)object2).setSample(i2, n3, 0, n4);
            }
            littleEndianInputStream.skipBytes(n2);
        }
        return object;
    }

    public static BufferedImage read24(b b2, LittleEndianInputStream littleEndianInputStream) throws IOException {
        int n2;
        BufferedImage bufferedImage = new BufferedImage(b2.b, b2.c, 1);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n3 = n2 = b2.b * 3;
        if (n2 % 4 != 0) {
            n3 = n2 / 4 + 1 << 2;
        }
        n2 = n3 - n2;
        for (n3 = b2.c - 1; n3 >= 0; --n3) {
            for (int i2 = 0; i2 < b2.b; ++i2) {
                int n4 = littleEndianInputStream.readUnsignedByte();
                int n5 = littleEndianInputStream.readUnsignedByte();
                int n6 = littleEndianInputStream.readUnsignedByte();
                writableRaster.setSample(i2, n3, 0, n6);
                writableRaster.setSample(i2, n3, 1, n5);
                writableRaster.setSample(i2, n3, 2, n4);
            }
            littleEndianInputStream.skipBytes(n2);
        }
        return bufferedImage;
    }

    public static BufferedImage read32(b b2, LittleEndianInputStream littleEndianInputStream) throws IOException {
        BufferedImage bufferedImage = new BufferedImage(b2.b, b2.c, 2);
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = bufferedImage.getAlphaRaster();
        for (int i2 = b2.c - 1; i2 >= 0; --i2) {
            for (int i3 = 0; i3 < b2.b; ++i3) {
                int n2 = littleEndianInputStream.readUnsignedByte();
                int n3 = littleEndianInputStream.readUnsignedByte();
                int n4 = littleEndianInputStream.readUnsignedByte();
                int n5 = littleEndianInputStream.readUnsignedByte();
                writableRaster.setSample(i3, i2, 0, n4);
                writableRaster.setSample(i3, i2, 1, n3);
                writableRaster.setSample(i3, i2, 2, n2);
                writableRaster2.setSample(i3, i2, 0, n5);
            }
        }
        return bufferedImage;
    }
}

