/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.swing.ico;

import com.inet.lib.swing.ico.BMPDecoder;
import com.inet.lib.swing.ico.LittleEndianInputStream;
import com.inet.lib.swing.ico.a;
import com.inet.lib.swing.ico.b;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ICODecoder {
    private static final int PNG_MAGIC = -1991225785;
    private static final int PNG_MAGIC_LE = 1196314761;
    private static final int PNG_MAGIC2 = 218765834;
    private static final int PNG_MAGIC2_LE = 169478669;

    private ICODecoder() {
    }

    public static List<BufferedImage> read(URL uRL) throws IOException {
        return ICODecoder.read(uRL.openStream());
    }

    public static List<BufferedImage> read(InputStream inputStream) throws IOException {
        int n2;
        inputStream = new LittleEndianInputStream(inputStream);
        ((LittleEndianInputStream)inputStream).readShortLE();
        ((LittleEndianInputStream)inputStream).readShortLE();
        int n3 = ((LittleEndianInputStream)inputStream).readShortLE();
        a[] aArray = new a[n3];
        for (n2 = 0; n2 < n3; n2 = (short)(n2 + 1)) {
            aArray[n2] = new a((LittleEndianInputStream)inputStream);
        }
        n2 = 0;
        ArrayList<BufferedImage> arrayList = new ArrayList<BufferedImage>(n3);
        try {
            for (n2 = 0; n2 < n3; ++n2) {
                Object object;
                Object object2;
                Object object3;
                int n4 = ((LittleEndianInputStream)inputStream).readIntLE();
                if (n4 == 40) {
                    int n5;
                    int n6;
                    Object object4 = new b((LittleEndianInputStream)inputStream, n4);
                    Object object5 = new b((b)object4);
                    new b((b)object4).c = ((b)object4).c / 2;
                    object3 = new b((b)object4);
                    new b((b)object4).c = ((b)object5).c;
                    ((b)object5).d = 1;
                    ((b)object5).f = 2;
                    object2 = BMPDecoder.read((b)object3, (LittleEndianInputStream)inputStream);
                    object = new BufferedImage(((b)object3).b, ((b)object3).c, 2);
                    Object object6 = new Color[]{new Color(255, 255, 255), new Color(0, 0, 0)};
                    if (((b)object4).d == 32) {
                        int n7 = aArray[n2].a;
                        int n8 = ((b)object4).a;
                        int n9 = ((b)object3).b * ((b)object3).c << 2;
                        n6 = n7 - n8 - n9;
                        n5 = ((DataInputStream)inputStream).skipBytes(n6);
                        int n10 = n6;
                        while (n5 < n10) {
                            if (n5 < 0) {
                                throw new IOException("Failed to read [skip]");
                            }
                            n10 = n6 - n5;
                            n5 = ((DataInputStream)inputStream).skipBytes(n10);
                        }
                        WritableRaster writableRaster = ((BufferedImage)object2).getRaster();
                        WritableRaster writableRaster2 = ((BufferedImage)object2).getAlphaRaster();
                        WritableRaster writableRaster3 = ((BufferedImage)object).getRaster();
                        WritableRaster writableRaster4 = ((BufferedImage)object).getAlphaRaster();
                        for (n8 = ((b)object3).c - 1; n8 >= 0; --n8) {
                            for (n7 = 0; n7 < ((b)object3).b; ++n7) {
                                int n11 = writableRaster.getSample(n7, n8, 0);
                                n9 = writableRaster.getSample(n7, n8, 1);
                                n6 = writableRaster.getSample(n7, n8, 2);
                                n5 = writableRaster2.getSample(n7, n8, 0);
                                writableRaster3.setSample(n7, n8, 0, n11);
                                writableRaster3.setSample(n7, n8, 1, n9);
                                writableRaster3.setSample(n7, n8, 2, n6);
                                writableRaster4.setSample(n7, n8, 0, n5);
                            }
                        }
                    } else {
                        object5 = BMPDecoder.read((b)object5, (LittleEndianInputStream)inputStream, (Color[])object6);
                        object4 = ((BufferedImage)object).getRaster();
                        object6 = ((BufferedImage)object).getAlphaRaster();
                        for (n6 = 0; n6 < ((b)object3).c; ++n6) {
                            for (n5 = 0; n5 < ((b)object3).b; ++n5) {
                                int n12 = ((BufferedImage)object2).getRGB(n5, n6);
                                int n13 = n12 >> 16 & 0xFF;
                                int n14 = n12 >> 8 & 0xFF;
                                int n15 = n12 & 0xFF;
                                ((WritableRaster)object4).setSample(n5, n6, 0, n13);
                                ((WritableRaster)object4).setSample(n5, n6, 1, n14);
                                ((WritableRaster)object4).setSample(n5, n6, 2, n15);
                                n13 = ((BufferedImage)object5).getRGB(n5, n6);
                                ((WritableRaster)object6).setSample(n5, n6, 0, n13);
                            }
                        }
                    }
                    arrayList.add((BufferedImage)object);
                    continue;
                }
                if (n4 == 1196314761) {
                    n4 = ((LittleEndianInputStream)inputStream).readIntLE();
                    if (n4 != 169478669) {
                        throw new IOException("Unrecognized icon format for image #" + n2);
                    }
                    Object object7 = aArray[n2];
                    Object object8 = new byte[((a)object7).a - 8];
                    int n16 = ((DataInputStream)inputStream).read((byte[])object8);
                    if (n16 != ((byte[])object8).length) {
                        throw new IOException("Unable to read image #" + n2 + " - incomplete PNG compressed data");
                    }
                    object2 = new ByteArrayOutputStream();
                    object = new DataOutputStream((OutputStream)object2);
                    ((DataOutputStream)object).writeInt(-1991225785);
                    ((DataOutputStream)object).writeInt(218765834);
                    ((FilterOutputStream)object).write((byte[])object8);
                    byte[] byArray = ((ByteArrayOutputStream)object2).toByteArray();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    object8 = byteArrayInputStream;
                    object7 = ImageIO.createImageInputStream(byteArrayInputStream);
                    object8 = null;
                    object3 = ImageIO.getImageReadersByFormatName("png");
                    if (object3.hasNext()) {
                        object8 = (ImageReader)object3.next();
                    }
                    byArray = object8;
                    byArray.setInput(object7);
                    BufferedImage bufferedImage = byArray.read(0);
                    arrayList.add(bufferedImage);
                    continue;
                }
                throw new IOException("Unrecognized icon format for image #" + n2);
            }
        }
        catch (IOException iOException) {
            throw new IOException("Failed to read image # " + n2);
        }
        return arrayList;
    }
}

