/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.swing.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;

public class NonStretchingGridLayout
extends GridLayout {
    public NonStretchingGridLayout() {
    }

    public NonStretchingGridLayout(int n2, int n3, int n4, int n5) {
        super(n2, n3, n4, n5);
    }

    public NonStretchingGridLayout(int n2, int n3) {
        super(n2, n3);
    }

    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            int n2 = container.getComponentCount();
            int n3 = super.getRows();
            int n4 = super.getColumns();
            if (n2 == 0) {
                return;
            }
            if (n3 > 0) {
                n4 = (n2 + n3 - 1) / n3;
            } else {
                n3 = (n2 + n4 - 1) / n4;
            }
            int n5 = super.getHgap();
            int n6 = super.getVgap();
            int n7 = container.getWidth();
            int n8 = container.getHeight();
            int n9 = n7 - (insets.left + insets.right);
            n8 -= insets.top + insets.bottom;
            n9 = (n9 - (n4 - 1) * super.getHgap()) / n4;
            n8 = (n8 - (n3 - 1) * super.getVgap()) / n3;
            if (container.getComponentOrientation().isLeftToRight()) {
                int n10 = 0;
                n7 = insets.left;
                while (n10 < n4) {
                    int n11 = 0;
                    int n12 = insets.top;
                    while (n11 < n3) {
                        int n13 = n11 * n4 + n10;
                        if (n13 < n2) {
                            this.setBounds(container.getComponent(n13), n7, n12, n9, n8);
                        }
                        ++n11;
                        n12 += n8 + n6;
                    }
                    ++n10;
                    n7 += n9 + n5;
                }
            } else {
                int n14 = 0;
                n7 = n7 - insets.right - n9;
                while (n14 < n4) {
                    int n15 = 0;
                    int n16 = insets.top;
                    while (n15 < n3) {
                        int n17 = n15 * n4 + n14;
                        if (n17 < n2) {
                            this.setBounds(container.getComponent(n17), n7, n16, n9, n8);
                        }
                        ++n15;
                        n16 += n8 + n6;
                    }
                    ++n14;
                    n7 -= n9 + n5;
                }
            }
            return;
        }
    }

    public void setBounds(Component component, int n2, int n3, int n4, int n5) {
        Dimension dimension = component.getPreferredSize();
        component.getPreferredSize().width = Math.min(n4, dimension.width);
        dimension.height = Math.min(n5, dimension.height);
        n4 = (int)((float)(n4 - dimension.width) * component.getAlignmentX());
        n5 = (int)((float)(n5 - dimension.height) * component.getAlignmentY());
        component.setBounds(n2 + n4, n3 + n5, dimension.width, dimension.height);
    }
}

