/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.swing.progress;

import com.inet.lib.core.LibBase;
import com.inet.lib.i18n.Msg;
import com.inet.lib.swing.progress.IProgressChangeListener;
import com.inet.lib.swing.progress.IProgressModel;
import com.inet.lib.swing.progress.IProgressTask;
import com.inet.lib.swing.progress.IProgressView;
import com.inet.lib.swing.progress.a;
import com.inet.lib.swing.progress.b;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ExecutionException;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgressRunner<V>
implements IProgressChangeListener,
ActionListener {
    private InterruptedException a;
    private ExecutionException b;
    private final IProgressTask<V> c;
    private V d;
    private IProgressView e;
    private IProgressModel f;
    private final Component g;
    private boolean h;
    private static final long DELAY = 500L;
    protected static final int CANCEL_CHECK_DELAY = 100;
    private Timer i;
    private SwingWorker<V, Void> j;

    public ProgressRunner(Component component, IProgressTask<V> iProgressTask) {
        this.g = component;
        this.c = iProgressTask;
        this.f = this.createProgressModel();
        this.e = this.createProgressView(this.f);
        this.e.addCancelListener(this);
        iProgressTask.addProgressChangeListener(this);
    }

    public IProgressView getProgressView() {
        return this.e;
    }

    protected IProgressView createProgressView(IProgressModel iProgressModel) {
        return new b(iProgressModel);
    }

    protected IProgressModel createProgressModel() {
        return new a();
    }

    public V call() throws InterruptedException, ExecutionException {
        try {
            Runnable runnable = new Runnable(){

                public final void run() {
                    Window window;
                    Window window2 = window = ProgressRunner.this.g == null ? null : SwingUtilities.getWindowAncestor(ProgressRunner.this.g);
                    if (ProgressRunner.this.g instanceof Window) {
                        window = (Window)ProgressRunner.this.g;
                    }
                    JDialog jDialog = window instanceof Dialog ? new JDialog((Dialog)window, true) : new JDialog((Frame)window, true);
                    jDialog.setUndecorated(true);
                    ProgressRunner.this.j = new SwingWorker<V, Void>(this, jDialog){
                        private /* synthetic */ JDialog a;
                        private /* synthetic */ 1 b;
                        {
                            this.b = var1_1;
                            this.a = jDialog;
                        }

                        @Override
                        protected final V doInBackground() throws Exception {
                            Object v2 = this.b.ProgressRunner.this.c.call();
                            this.b.ProgressRunner.this.e.setCancelButtonEnabled(false);
                            this.b.ProgressRunner.this.d = v2;
                            return v2;
                        }

                        @Override
                        protected final void done() {
                            try {
                                this.b.ProgressRunner.this.a();
                            }
                            finally {
                                JDialog jDialog = this.a;
                                synchronized (jDialog) {
                                    ProgressRunner.a(this.b.ProgressRunner.this, this.a);
                                }
                            }
                        }
                    };
                    jDialog.add(ProgressRunner.this.e.getComponent());
                    jDialog.pack();
                    jDialog.setLocationRelativeTo(window);
                    window = jDialog;
                    synchronized (window) {
                        ProgressRunner.this.j.execute();
                        try {
                            jDialog.wait(500L);
                            if (!ProgressRunner.this.j.isDone()) {
                                ProgressRunner.b(ProgressRunner.this, jDialog);
                                jDialog.setVisible(true);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            LibBase.getInstance().getLogHandler().debug(interruptedException.getMessage());
                        }
                        return;
                    }
                }
            };
            if (EventQueue.isDispatchThread()) {
                runnable.run();
            } else {
                EventQueue.invokeAndWait(runnable);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ExecutionException(invocationTargetException);
        }
        this.a();
        if (this.b != null) {
            throw this.b;
        }
        if (this.a != null) {
            throw this.a;
        }
        if (this.h) {
            return null;
        }
        return this.d;
    }

    @Override
    public void setCurrentMessage(String string) {
        if (!this.h) {
            this.f.setCurrentMessage(string);
            this.e.refresh();
        }
    }

    @Override
    public void setCurrentValue(int n2) {
        if (!this.h) {
            this.f.setValue(n2);
            this.e.refresh();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.f.setCurrentMessage(Msg.getMsg("ProgressRunner.canceling"));
        this.h = true;
        this.c.cancel();
        this.e.refresh();
    }

    private void a() {
        try {
            if (this.j.isDone()) {
                this.j.get();
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            this.a = interruptedException;
            return;
        }
        catch (ExecutionException executionException) {
            this.b = executionException;
            return;
        }
    }

    public boolean isCanceled() {
        return this.h;
    }

    static /* synthetic */ void a(ProgressRunner progressRunner, JDialog jDialog) {
        SwingUtilities.invokeLater(new Runnable(progressRunner, jDialog){
            private /* synthetic */ JDialog a;
            private /* synthetic */ ProgressRunner b;
            {
                this.b = progressRunner;
                this.a = jDialog;
            }

            public final void run() {
                this.a.setVisible(false);
                this.a.dispose();
                if (this.b.i != null) {
                    this.b.i.stop();
                }
                this.b.e.stopTimer();
            }
        });
    }

    static /* synthetic */ void b(ProgressRunner progressRunner, JDialog jDialog) {
        v0.i = new Timer(100, new ActionListener(progressRunner, jDialog){
            private /* synthetic */ JDialog a;
            private /* synthetic */ ProgressRunner b;
            {
                this.b = progressRunner;
                this.a = jDialog;
            }

            public final void actionPerformed(ActionEvent actionEvent) {
                if (this.b.h) {
                    ProgressRunner.a(this.b, this.a);
                }
            }
        });
        progressRunner.i.start();
    }
}

