/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.swing.widgets;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JButton;

public class ArrowButton
extends JButton {
    public static final int ARROW_LEFT = 1;
    public static final int ARROW_RIGHT = 2;
    public static final int ARROW_DOWN = 3;
    public static final int ARROW_UP = 4;
    private int a;
    private int b;
    private int[] c = new int[3];
    private int[] d = new int[3];

    public ArrowButton() {
        this(4, 16, 0);
    }

    public ArrowButton(int n2) {
        this(n2, 16, 0);
    }

    public ArrowButton(int n2, int n3) {
        this(n2, n3, 0);
    }

    public ArrowButton(int n2, int n3, int n4) {
        this.a = n2;
        this.b = 3;
        if (n3 <= 0) {
            n3 = this.getWidth();
        }
        if (n4 <= 0) {
            n4 = this.getHeight();
        }
        this.setMinimumSize(new Dimension(n3, n4));
        this.setPreferredSize(new Dimension(n3, n4));
        this.setSize(new Dimension(n3, n4));
    }

    public void setDeltaX(int n2) {
        this.b = n2;
    }

    public void setArrowType(int n2) {
        if (this.a != n2) {
            this.a = n2;
            this.repaint();
        }
    }

    public int getArrowType() {
        return this.a;
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int n2 = this.getWidth() - 1;
        int n3 = this.getHeight() / 2 - 2;
        int n4 = this.getHeight() / 2 + 2;
        switch (this.a) {
            case 1: {
                this.c[0] = this.b;
                this.d[0] = 2;
                this.c[1] = n2 - this.b;
                this.d[1] = n3;
                this.c[2] = n2 - this.b;
                this.d[2] = n4;
                break;
            }
            case 2: {
                this.c[0] = this.b;
                this.d[0] = n3;
                this.c[1] = this.b;
                this.d[1] = n4;
                this.c[2] = n2 - this.b;
                this.d[2] = 2;
                break;
            }
            case 4: {
                this.c[0] = this.b;
                this.d[0] = n4;
                this.c[1] = n2 - this.b;
                this.d[1] = n4;
                this.c[2] = n2 / 2;
                this.d[2] = n3;
                break;
            }
            case 3: {
                this.c[0] = this.b;
                this.d[0] = n3;
                this.c[1] = n2 - this.b;
                this.d[1] = n3;
                this.c[2] = n2 / 2;
                this.d[2] = n4;
            }
        }
        if (this.isEnabled()) {
            graphics.setColor(this.getForeground());
        } else {
            graphics.setColor(Color.lightGray.darker());
        }
        graphics.fillPolygon(this.c, this.d, this.c.length);
    }
}

