/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.swing.widgets;

import com.inet.lib.core.LibBase;
import com.inet.lib.log.LogMessage;
import com.inet.lib.swing.widgets.ValidatingInputField;
import java.awt.Color;

public class DoubleInputField
extends ValidatingInputField {
    private static final String ALLOWED_NORMAL = "-.1234567890";
    private static final String ALLOWED_POSITIVE = ".1234567890";
    private double a;
    private double b;
    private LogMessage c;
    private LogMessage d;
    private LogMessage e;
    private String f;

    public DoubleInputField() {
        this(0.0, false, -1.7976931348623157E308, Double.MAX_VALUE, Color.red);
    }

    public DoubleInputField(double d2, Color color) {
        this(d2, true, -1.7976931348623157E308, Double.MAX_VALUE, color);
    }

    public DoubleInputField(double d2, double d3) {
        this(Math.max(Math.min(d3, 0.0), d2), false, d2, d3, Color.red);
    }

    public DoubleInputField(double d2, boolean bl2) {
        this(d2, bl2, -1.7976931348623157E308, Double.MAX_VALUE, Color.red);
    }

    public DoubleInputField(double d2, boolean bl2, double d3, double d4) {
        this(d2, bl2, d3, d4, Color.red);
    }

    public DoubleInputField(double d2, boolean bl2, double d3, double d4, Color color) {
        super(color);
        this.a = d3;
        this.b = d4;
        this.c = new LogMessage(2, LibBase.getInstance().msg("inet.lib.missingcontent", new Object[0]));
        this.d = new LogMessage(2, LibBase.getInstance().msg("inet.lib.invalidformat", new Object[0]));
        this.e = new LogMessage(2, LibBase.getInstance().msg("inet.lib.valuenotinrange", new Double(this.a), new Double(this.b)));
        this.f = this.a >= 0.0 ? ALLOWED_POSITIVE : ALLOWED_NORMAL;
        if (bl2) {
            this.setValue(d2);
        }
        this.retestInput();
    }

    public void setMinimum(double d2) {
        this.a = d2;
        if (this.a > this.b) {
            this.a();
        }
        this.e.setMessage(LibBase.getInstance().msg("inet.lib.valuenotinrange", new Double(this.a), new Double(this.b)));
        this.f = this.a >= 0.0 ? ALLOWED_POSITIVE : ALLOWED_NORMAL;
        this.retestInput();
    }

    public double getMinimum() {
        return this.a;
    }

    public void setMaximum(double d2) {
        this.b = d2;
        if (this.b < this.a) {
            this.a();
        }
        this.e.setMessage(LibBase.getInstance().msg("inet.lib.valuenotinrange", new Double(this.a), new Double(this.b)));
        this.f = this.a >= 0.0 ? ALLOWED_POSITIVE : ALLOWED_NORMAL;
        this.retestInput();
    }

    public double getMaximum() {
        return this.b;
    }

    public final void setText(String string) {
        throw new UnsupportedOperationException();
    }

    public final String getText() {
        throw new UnsupportedOperationException();
    }

    public void setValue(double d2) {
        super.setText("" + d2);
        this.retestInput();
    }

    public double getValue() {
        try {
            double d2 = Double.parseDouble(super.getText());
            if (d2 < this.a || d2 > this.b) {
                return Double.NaN;
            }
            return d2;
        }
        catch (NumberFormatException numberFormatException) {
            return Double.NaN;
        }
    }

    public String toString() {
        return "" + this.getValue();
    }

    protected String allowedChars() {
        return this.f;
    }

    protected LogMessage approve() {
        String string = super.getText();
        if (string.length() > 0) {
            try {
                double d2;
                double d3 = Double.parseDouble(string);
                if (d2 >= this.a && d3 <= this.b) {
                    return null;
                }
                return this.e;
            }
            catch (NumberFormatException numberFormatException) {
                return this.d;
            }
        }
        return this.c;
    }

    private void a() {
        double d2 = this.a;
        this.a = this.b;
        this.b = d2;
    }
}

