/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.util;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;

public class ColorUtils {
    private static TexturePaint a = null;
    private static final Color[] b = new Color[]{Color.black, Color.blue, Color.cyan, Color.darkGray, Color.gray, Color.green, Color.lightGray, Color.magenta, Color.orange, Color.pink, Color.red, Color.white, Color.yellow, new Color(200, 70, 100)};
    private static Color[] c = new Color[14];
    private static int d = 0;

    public static int getLumiosity(Color color) {
        return (int)(0.2999 * (double)color.getRed() + 0.587 * (double)color.getGreen() + 0.114 * (double)color.getBlue());
    }

    public static int getColorDistance(Color color, Color color2) {
        int n2 = color.getRed() - color2.getRed();
        int n3 = color.getGreen() - color2.getGreen();
        int n4 = color.getBlue() - color2.getBlue();
        return (int)Math.sqrt(n2 * n2 + n4 * n4 + n3 * n3);
    }

    public static Color addTransparency(Color color, int n2) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), n2);
    }

    public static Color getInvertedColor(Color color) {
        return new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue(), color.getAlpha());
    }

    public static TexturePaint getDefaultCheckesPaint(Rectangle rectangle) {
        if (a == null) {
            a = ColorUtils.getCheckesPaint(rectangle, Color.DARK_GRAY, Color.GRAY);
        }
        return a;
    }

    public static TexturePaint getCheckesPaint(Rectangle rectangle, Color color, Color color2) {
        BufferedImage bufferedImage = new BufferedImage(20, 20, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(color);
        graphics2D.fillRect(0, 0, 10, 10);
        graphics2D.fillRect(10, 10, 10, 10);
        graphics2D.setColor(color2);
        graphics2D.fillRect(0, 10, 10, 10);
        graphics2D.fillRect(10, 0, 10, 10);
        return new TexturePaint(bufferedImage, rectangle);
    }

    public static TexturePaint getStripesPaint(Rectangle rectangle, Color color, Color color2) {
        BufferedImage bufferedImage = new BufferedImage(20, 20, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(color);
        graphics2D.fillRect(0, 0, 20, 20);
        graphics2D.setColor(color2);
        graphics2D.fillPolygon(new Polygon(new int[]{0, 10, 0}, new int[]{0, 0, 10}, 3));
        graphics2D.fillPolygon(new Polygon(new int[]{20, 20, 10, 0}, new int[]{0, 10, 20, 20}, 4));
        return new TexturePaint(bufferedImage, rectangle);
    }

    public static Color[] getDefaultPalette() {
        return b;
    }

    public static Color[] getUserPalette() {
        return c;
    }

    public static void addUserColor(Color color) {
        int n2;
        if (color == null || color.getAlpha() == 0) {
            return;
        }
        for (n2 = 0; n2 < b.length; ++n2) {
            if (!color.equals(b[n2])) continue;
            return;
        }
        for (n2 = 0; n2 < c.length; ++n2) {
            if (!color.equals(c[n2])) continue;
            return;
        }
        for (n2 = 0; n2 < c.length; ++n2) {
            if (c[n2] != null) continue;
            ColorUtils.c[n2] = color;
            return;
        }
        ColorUtils.c[ColorUtils.d] = color;
        if (++d == c.length) {
            d = 0;
        }
    }

    public static int getAlpha(int n2) {
        if ((n2 = ~(n2 >> 24)) < 0) {
            n2 += 256;
        }
        return n2;
    }

    public static int toCcColor(Color color) {
        if (color == null) {
            return -1;
        }
        int n2 = color.getRGB();
        return ~n2 & 0xFF000000 | ((n2 & 0xFF) << 16) + (n2 & 0xFF00) + (n2 >> 16 & 0xFF);
    }

    public static int getShadowColor(int n2) {
        return ColorUtils.toCcColor(new Color(ColorUtils.getRed(n2), ColorUtils.getGreen(n2), ColorUtils.getBlue(n2), 127));
    }

    public static int getRed(int n2) {
        return n2 & 0xFF;
    }

    public static int getBlue(int n2) {
        return n2 >> 16 & 0xFF;
    }

    public static int getGreen(int n2) {
        return n2 >> 8 & 0xFF;
    }

    public static Color toJavaColor(int n2) {
        if (ColorUtils.getAlpha(n2) == 0) {
            return null;
        }
        return new Color(~n2 & 0xFF000000 | (n2 & 0xFF) << 16 | n2 & 0xFF00 | n2 >> 16 & 0xFF, true);
    }

    public static Color getOpaqueColor(Color color, Color color2) {
        if (color == null) {
            color = new Color(255, 255, 255);
        }
        if (color2 == null || color2.getAlpha() == 0) {
            return null;
        }
        float f2 = (float)color2.getAlpha() / 255.0f;
        return new Color((int)((float)color.getRed() * (1.0f - f2)) + (int)((float)color2.getRed() * f2), (int)((float)color.getGreen() * (1.0f - f2)) + (int)((float)color2.getGreen() * f2), (int)((float)color.getBlue() * (1.0f - f2)) + (int)((float)color2.getBlue() * f2));
    }

    public static int getOpaqueColor(int n2, int n3) {
        Color color = ColorUtils.toJavaColor(n2);
        Color color2 = ColorUtils.toJavaColor(n3);
        return ColorUtils.toCcColor(ColorUtils.getOpaqueColor(color, color2));
    }

    public static Paint getOpaquePaint(Color color, Paint paint) {
        switch (paint.getTransparency()) {
            case 1: 
            case 2: {
                return paint;
            }
        }
        if (paint instanceof Color) {
            paint = (Color)paint;
            return ColorUtils.getOpaqueColor(color, (Color)paint);
        }
        if (paint instanceof GradientPaint) {
            Color color2 = ColorUtils.getOpaqueColor(color, ((GradientPaint)(paint = (GradientPaint)paint)).getColor1());
            if (color2.getAlpha() != 0) {
                color2 = Color.WHITE;
            }
            if ((color = ColorUtils.getOpaqueColor(color, ((GradientPaint)paint).getColor2())).getAlpha() != 0) {
                color = Color.WHITE;
            }
            return new GradientPaint(((GradientPaint)paint).getPoint1(), color2, ((GradientPaint)paint).getPoint2(), color);
        }
        return paint;
    }

    public static int getRgbColorVal(int n2) {
        return n2 & 0xFFFFFF;
    }

    public static int setMinTransparenceLevel(int n2, float f2) {
        int n3 = (int)(255.0f * f2);
        int n4 = ColorUtils.getAlpha(n2);
        if (n3 < n4) {
            n2 = n2 & 0xFFFFFF | ~n3 << 24;
        }
        return n2;
    }
}

