/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.util;

import com.inet.lib.core.LibBase;
import com.inet.lib.io.SuffixFilter;
import com.inet.lib.util.StringFunctions;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.annotation.Nullable;
import sun.net.www.ParseUtil;

public class IOFunctions {
    public static final byte[] PREFIX_ZIP = new byte[]{80, 75};
    public static final byte[] PREFIX_ERROR = new byte[]{69, 82, 82, 79, 82};

    private IOFunctions() {
    }

    public static final void close(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
                return;
            }
            catch (IOException iOException) {
                String string = LibBase.getInstance().msg("inet.lib.closefailed", iOException.getMessage(), StringFunctions.traceToString(iOException));
                LibBase.getInstance().getLogHandler().debug(string);
            }
        }
    }

    public static final void close(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
                return;
            }
            catch (IOException iOException) {
                String string = LibBase.getInstance().msg("inet.lib.closefailed", iOException.getMessage(), StringFunctions.traceToString(iOException));
                LibBase.getInstance().getLogHandler().debug(string);
            }
        }
    }

    public static final void close(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
                return;
            }
            catch (IOException iOException) {
                String string = LibBase.getInstance().msg("inet.lib.closefailed", iOException.getMessage(), StringFunctions.traceToString(iOException));
                LibBase.getInstance().getLogHandler().debug(string);
            }
        }
    }

    public static final void close(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
                return;
            }
            catch (IOException iOException) {
                String string = LibBase.getInstance().msg("inet.lib.closefailed", iOException.getMessage(), StringFunctions.traceToString(iOException));
                LibBase.getInstance().getLogHandler().debug(string);
            }
        }
    }

    public static final String[] loadList(File object) {
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (((File)object).isFile()) {
            object2 = null;
            BufferedReader bufferedReader = null;
            try {
                object2 = new FileReader((File)object);
                bufferedReader = new BufferedReader((Reader)object2);
                object = bufferedReader.readLine();
                while (object != null) {
                    if (((String)(object = ((String)object).trim())).length() > 0) {
                        arrayList.add(object);
                    }
                    object = bufferedReader.readLine();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                IOFunctions.close(bufferedReader);
                IOFunctions.close((Reader)object2);
            }
            catch (IOException iOException) {
                try {
                    String string = LibBase.getInstance().msg("inet.lib.iofailure", iOException.getMessage(), StringFunctions.traceToString(iOException));
                    LibBase.getInstance().getLogHandler().debug(string);
                }
                catch (Throwable throwable) {
                    IOFunctions.close(bufferedReader);
                    IOFunctions.close((Reader)object2);
                    throw throwable;
                }
                IOFunctions.close(bufferedReader);
                IOFunctions.close((Reader)object2);
            }
            IOFunctions.close(bufferedReader);
            IOFunctions.close((Reader)object2);
        }
        object2 = new String[arrayList.size()];
        arrayList.toArray((T[])object2);
        return object2;
    }

    public static final void saveList(File file, String[] stringArray) {
        FileOutputStream fileOutputStream = null;
        PrintStream printStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            printStream = new PrintStream(fileOutputStream);
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                printStream.println(stringArray[i2]);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                String string = LibBase.getInstance().msg("inet.lib.iofailure", fileNotFoundException.getMessage(), StringFunctions.traceToString(fileNotFoundException));
                LibBase.getInstance().getLogHandler().debug(string);
            }
            catch (Throwable throwable) {
                IOFunctions.close(printStream);
                IOFunctions.close(fileOutputStream);
                throw throwable;
            }
            IOFunctions.close(printStream);
            IOFunctions.close(fileOutputStream);
            return;
        }
        IOFunctions.close(printStream);
        IOFunctions.close(fileOutputStream);
        return;
    }

    public static final Iterator fileIterator(File file, String[] stringArray) {
        return IOFunctions.fileIterator(file, new SuffixFilter(stringArray, ""), false);
    }

    public static final Iterator fileIterator(File file, String[] stringArray, boolean bl2) {
        return IOFunctions.fileIterator(file, new SuffixFilter(stringArray, ""), bl2);
    }

    public static final Iterator fileIterator(File file, FileFilter fileFilter) {
        return IOFunctions.fileIterator(file, fileFilter, false);
    }

    public static final Iterator fileIterator(File file, FileFilter fileFilter, boolean bl2) {
        ArrayList arrayList = new ArrayList();
        IOFunctions.a(arrayList, file, fileFilter, bl2);
        return arrayList.iterator();
    }

    private static final void a(List list, File fileArray, FileFilter fileFilter, boolean bl2) {
        fileArray = fileFilter != null ? fileArray.listFiles(fileFilter) : fileArray.listFiles();
        if (fileArray != null) {
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                if (fileArray[i2].isDirectory()) {
                    if (bl2) {
                        list.add(fileArray[i2]);
                    }
                    IOFunctions.a(list, fileArray[i2], fileFilter, bl2);
                    continue;
                }
                list.add(fileArray[i2]);
            }
        }
    }

    public static boolean isZipFile(BufferedInputStream bufferedInputStream) throws IOException {
        return IOFunctions.startsWith(bufferedInputStream, PREFIX_ZIP);
    }

    public static boolean startsWith(BufferedInputStream bufferedInputStream, byte[] byArray) throws IOException {
        bufferedInputStream.mark(byArray.length);
        byte[] byArray2 = new byte[byArray.length];
        bufferedInputStream.read(byArray2, 0, byArray.length);
        bufferedInputStream.reset();
        return Arrays.equals(byArray2, byArray);
    }

    public static boolean isZipFile(BufferedReader bufferedReader) throws IOException {
        if (bufferedReader == null) {
            return false;
        }
        bufferedReader.mark(2);
        char[] cArray = new char[2];
        bufferedReader.read(cArray, 0, cArray.length);
        bufferedReader.reset();
        return Arrays.equals(cArray, new char[]{'P', 'K'});
    }

    public static boolean isDirectory(URL serializable) {
        if ("file".equals(serializable.getProtocol())) {
            serializable = IOFunctions.getFile(serializable);
            return ((File)serializable).isDirectory();
        }
        return false;
    }

    public static boolean deleteDir(File file) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                boolean bl2 = IOFunctions.deleteDir(new File(file, stringArray[i2]));
                if (bl2) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static void copyDirectory(File file, File file2) throws IOException {
        if (file.isDirectory()) {
            if (!file2.exists()) {
                file2.mkdir();
            }
            String[] stringArray = file.list();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                IOFunctions.copyDirectory(new File(file, stringArray[i2]), new File(file2, stringArray[i2]));
            }
            return;
        }
        IOFunctions.copy(file, file2);
    }

    public static byte[] getFileBuffer(URL object) throws IOException {
        InputStream inputStream = ((URL)object).openStream();
        object = IOFunctions.readBytes(inputStream);
        inputStream.close();
        return object;
    }

    public static URL getFileURL(String string) throws MalformedURLException {
        if (string.startsWith("file:")) {
            string = string.substring(5);
        }
        return IOFunctions.getFileURL(new File(string));
    }

    public static URL getFileURL(File file) throws MalformedURLException {
        return file.toURI().toURL();
    }

    public static String getFileName(URL object) throws IllegalArgumentException {
        String string = ((URL)object).getProtocol();
        if (!"file".equals(string)) {
            throw new IllegalArgumentException("Protocol is not file: " + object);
        }
        string = ((URL)object).getPath();
        string = ParseUtil.decode(string);
        if ((object = ((URL)object).getHost()) != null && ((String)object).length() > 0) {
            string = "//" + (String)object + string;
        }
        return string;
    }

    public static File getFile(URL uRL) throws IllegalArgumentException {
        return new File(IOFunctions.getFileName(uRL));
    }

    @Nullable
    public static URL getURLFromString(String string) {
        if (string == null) {
            return null;
        }
        if (string.toLowerCase().startsWith("file:")) {
            try {
                return IOFunctions.getFileURL(string);
            }
            catch (Throwable throwable) {}
        }
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (Throwable throwable) {}
        if (uRL != null) {
            try {
                return uRL.toURI().toURL();
            }
            catch (Throwable throwable) {
                try {
                    return new URI(null, string, null).toURL();
                }
                catch (Throwable throwable2) {
                }
            }
        } else {
            try {
                return new File(string).toURI().toURL();
            }
            catch (Throwable throwable) {}
        }
        return uRL;
    }

    public static File replaceTempFileWithDirectory(File file) throws IOException {
        if (!file.delete()) {
            throw new IOException("Could not delete temp file: " + file.getAbsolutePath());
        }
        if (!file.mkdir()) {
            throw new IOException("Could not create temp directory: " + file.getAbsolutePath());
        }
        file.deleteOnExit();
        return file;
    }

    public static void copy(File object, File object2) throws IOException {
        object = new FileInputStream((File)object);
        object2 = new FileOutputStream((File)object2);
        IOFunctions.copyData((InputStream)object, (OutputStream)object2);
        ((InputStream)object).close();
        ((OutputStream)object2).close();
    }

    public static String readAsciiString(InputStream object) throws IOException {
        object = IOFunctions.readBytes((InputStream)object);
        return new String((byte[])object, 0);
    }

    public static byte[] readBytes(File object) throws IOException {
        if (object == null) {
            throw new IllegalArgumentException("file is null");
        }
        object = new FileInputStream((File)object);
        try {
            byte[] byArray = IOFunctions.readBytes((InputStream)object);
            return byArray;
        }
        finally {
            IOFunctions.close((InputStream)object);
        }
    }

    public static byte[] readBytes(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(inputStream.available());
        IOFunctions.copyData(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static void copyData(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n2;
        byte[] byArray = new byte[4096];
        while ((n2 = inputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n2);
        }
    }

    public static int compareIPAdress(String object, String object2) throws Exception {
        if (object == null || object2 == null || ((String)object).length() == 0 || ((String)object2).length() == 0) {
            throw new Exception("comparing address \"" + (String)object + "\" with \"" + (String)object2 + "\" is not possible");
        }
        object = IOFunctions.a((String)object);
        object2 = IOFunctions.a((String)object2);
        for (int i2 = 0; i2 < ((Object)object2).length; ++i2) {
            if (object[i2] < object2[i2]) {
                return -1;
            }
            if (object[i2] <= object2[i2]) continue;
            return 1;
        }
        return 0;
    }

    private static int[] a(String string) throws Exception {
        int[] nArray = new int[10];
        try {
            int n2;
            Object object;
            int n3 = string.lastIndexOf(37);
            if (n3 != -1) {
                string = string.substring(0, n3);
            }
            if ((n3 = string.indexOf(47)) != -1) {
                object = string.substring(n3 + 1, string.length());
                n2 = -1;
                try {
                    n2 = Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {}
                string = n2 >= 0 && n2 <= 128 ? string.substring(0, n3) : string.substring(n3 + 1, string.length());
            }
            if (string.indexOf(46) != -1 && string.indexOf(58) == -1) {
                object = new StringTokenizer(string, ".");
                n2 = 6;
                while (((StringTokenizer)object).hasMoreElements()) {
                    String string2 = ((StringTokenizer)object).nextToken();
                    nArray[n2] = Integer.parseInt(string2);
                    ++n2;
                }
            } else if (string.indexOf(58) != -1) {
                string = IOFunctions.normalizeIPv6(string);
                object = new StringTokenizer(string, ":");
                n2 = 0;
                while (((StringTokenizer)object).hasMoreElements()) {
                    Object object2 = ((StringTokenizer)object).nextToken();
                    if (((String)object2).indexOf(46) != -1) {
                        object2 = new StringTokenizer((String)object2, ".");
                        while (((StringTokenizer)object2).hasMoreElements()) {
                            String string3 = ((StringTokenizer)object2).nextToken();
                            nArray[n2] = Integer.parseInt(string3);
                            ++n2;
                        }
                        continue;
                    }
                    nArray[n2] = Integer.parseInt((String)object2, 16);
                    ++n2;
                }
            } else {
                throw new Exception("Address \"" + string + "\" is neither an Internet Protocol version 4 (IPv4) address nor an Internet Protocol version 6 (IPv6) address.");
            }
            return nArray;
        }
        catch (NumberFormatException numberFormatException) {
            throw new Exception("Address \"" + string + "\" is invalid");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new Exception("Address \"" + string + "\" is invalid");
        }
    }

    public static String normalizeIPv6(String stringArray) {
        stringArray = stringArray.split(":");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2].length() == 0 && i2 > 0) {
                int n2 = 8 - (stringArray.length - 1);
                String string = stringArray[stringArray.length - 1];
                if (n2 > 0 && string != null && string.indexOf(46) != -1) {
                    --n2;
                }
                for (int i3 = 0; i3 < n2; ++i3) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(":");
                    }
                    stringBuilder.append("0");
                }
                continue;
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(":");
            }
            if (stringArray[i2].length() == 0) {
                stringBuilder.append("0");
                continue;
            }
            stringBuilder.append(stringArray[i2]);
        }
        return stringBuilder.toString();
    }

    public static byte[] serialize(Throwable throwable) {
        while (true) {
            try {
                return IOFunctions.b(throwable);
            }
            catch (IOException iOException) {
                if (IOFunctions.a(throwable)) continue;
                try {
                    Exception exception = new Exception(throwable.toString());
                    exception.setStackTrace(throwable.getStackTrace());
                    return IOFunctions.b(exception);
                }
                catch (Exception exception) {
                    throwable = new RuntimeException();
                    throwable.initCause(exception);
                    throw throwable;
                }
            }
            break;
        }
    }

    private static boolean a(Throwable throwable) {
        try {
            Throwable throwable2;
            Field field = Throwable.class.getDeclaredField("cause");
            field.setAccessible(true);
            while ((throwable2 = throwable.getCause()) != null) {
                Throwable throwable3 = throwable2.getCause();
                if (throwable3 == null) {
                    field.set(throwable, throwable);
                    return true;
                }
                throwable = throwable2;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static byte[] b(Throwable throwable) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(throwable);
        objectOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }
}

