/*
 * Decompiled with CFR 0.152.
 */
package com.inet.looks.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.UIManager;

public final class ExtBasicSpinnerLayout
implements LayoutManager {
    private static final Dimension ZERO_SIZE = new Dimension(0, 0);
    private Component nextButton = null;
    private Component previousButton = null;
    private Component editor = null;

    public void addLayoutComponent(String name, Component c2) {
        if ("Next".equals(name)) {
            this.nextButton = c2;
        } else if ("Previous".equals(name)) {
            this.previousButton = c2;
        } else if ("Editor".equals(name)) {
            this.editor = c2;
        }
    }

    public void removeLayoutComponent(Component c2) {
        if (c2 == this.nextButton) {
            c2 = null;
        } else if (c2 == this.previousButton) {
            this.previousButton = null;
        } else if (c2 == this.editor) {
            this.editor = null;
        }
    }

    private Dimension preferredSize(Component c2) {
        return c2 == null ? ZERO_SIZE : c2.getPreferredSize();
    }

    public Dimension preferredLayoutSize(Container parent) {
        Dimension nextD = this.preferredSize(this.nextButton);
        Dimension previousD = this.preferredSize(this.previousButton);
        Dimension editorD = this.preferredSize(this.editor);
        Dimension size = new Dimension(editorD.width, editorD.height);
        size.width += Math.max(nextD.width, previousD.width);
        Insets insets = parent.getInsets();
        size.width += insets.left + insets.right;
        size.height += insets.top + insets.bottom;
        return size;
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    private void setBounds(Component c2, int x2, int y2, int width, int height) {
        if (c2 != null) {
            c2.setBounds(x2, y2, width, height);
        }
    }

    public void layoutContainer(Container parent) {
        int buttonsX;
        int editorWidth;
        int editorX;
        int width = parent.getWidth();
        int height = parent.getHeight();
        Insets insets = parent.getInsets();
        Dimension nextD = this.preferredSize(this.nextButton);
        Dimension previousD = this.preferredSize(this.previousButton);
        int buttonsWidth = Math.max(nextD.width, previousD.width);
        int editorHeight = height - (insets.top + insets.bottom);
        Insets buttonInsets = UIManager.getInsets("Spinner.arrowButtonInsets");
        if (buttonInsets == null) {
            buttonInsets = insets;
        }
        if (parent.getComponentOrientation().isLeftToRight()) {
            editorX = insets.left;
            editorWidth = width - insets.left - buttonsWidth - buttonInsets.right;
            buttonsX = width - buttonsWidth - buttonInsets.right;
        } else {
            buttonsX = buttonInsets.left;
            editorX = buttonsX + buttonsWidth;
            editorWidth = width - buttonInsets.left - buttonsWidth - insets.right;
        }
        int nextY = buttonInsets.top;
        int nextHeight = height / 2 + height % 2 - nextY;
        int previousY = buttonInsets.top + nextHeight;
        int previousHeight = height - previousY - buttonInsets.bottom;
        this.setBounds(this.editor, editorX, insets.top, editorWidth, editorHeight);
        this.setBounds(this.nextButton, buttonsX, nextY, buttonsWidth, nextHeight);
        this.setBounds(this.previousButton, buttonsX, previousY, buttonsWidth, previousHeight);
    }
}

