/*
 * Decompiled with CFR 0.152.
 */
package com.inet.looks.plastic;

import com.inet.looks.plastic.PlasticLookAndFeel;
import com.inet.looks.plastic.PlasticUtils;
import com.inet.looks.plastic.PlasticXPUtils;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalScrollButton;

class PlasticArrowButton
extends MetalScrollButton {
    private static final long serialVersionUID = 1L;
    private Color shadowColor = UIManager.getColor("ScrollBar.darkShadow");
    private Color highlightColor = UIManager.getColor("ScrollBar.highlight");
    protected boolean isFreeStanding;

    public PlasticArrowButton(int direction, int width, boolean freeStanding) {
        super(direction, width, freeStanding);
        this.isFreeStanding = freeStanding;
    }

    public void setFreeStanding(boolean freeStanding) {
        super.setFreeStanding(freeStanding);
        this.isFreeStanding = freeStanding;
    }

    public void paint(Graphics g2) {
        boolean leftToRight = PlasticUtils.isLeftToRight(this);
        boolean isEnabled = this.getParent().isEnabled();
        boolean isPressed = this.getModel().isPressed();
        ColorUIResource arrowColor = isEnabled ? PlasticLookAndFeel.getControlInfo() : PlasticLookAndFeel.getControlDisabled();
        int width = this.getWidth();
        int height = this.getHeight();
        int w2 = width;
        int h2 = height;
        int arrowHeight = this.calculateArrowHeight(height, width);
        int arrowOffset = this.calculateArrowOffset();
        boolean paintNorthBottom = this.isPaintingNorthBottom();
        g2.setColor(this.getBackground());
        g2.fillRect(0, 0, width, height);
        g2.setColor(PlasticLookAndFeel.getPrimaryControlShadow());
        if (this.model.isRollover()) {
            PlasticUtils.paintToolBarGradient(g2, 0, 0, w2, h2);
            g2.setColor(PlasticLookAndFeel.getPrimaryControlDarkShadow());
        }
        if (isPressed) {
            PlasticUtils.paintPopupHightlight(g2, 0, 0, w2, h2);
        }
        g2.drawRect(0, 0, w2 - 1, h2 - 1);
        g2.setColor(arrowColor);
        if (this.getDirection() == 1) {
            this.paintNorth(g2, leftToRight, isEnabled, arrowColor, isPressed, width, height, w2, h2, arrowHeight, arrowOffset, paintNorthBottom);
        } else if (this.getDirection() == 5) {
            this.paintSouth(g2, leftToRight, isEnabled, arrowColor, isPressed, width, height, w2, h2, arrowHeight, arrowOffset);
        } else if (this.getDirection() == 3) {
            this.paintEast(g2, isEnabled, arrowColor, isPressed, width, height, w2, h2, arrowHeight);
        } else if (this.getDirection() == 7) {
            this.paintWest(g2, isEnabled, arrowColor, isPressed, width, height, w2, h2, arrowHeight);
        }
    }

    protected void paintMouseOver(Graphics g2, int w2, int h2) {
        int trans = 160;
        Color colorEnd = PlasticXPUtils.translucentColor(PlasticLookAndFeel.getSecondaryGradientEnd(), trans);
        Color colorStart = new Color(255, 255, 255, trans);
        PlasticUtils.paintDoubleGradient(g2, colorStart, colorEnd, 1, 1, w2 - 2, h2 - 2);
    }

    protected int calculateArrowHeight(int height, int width) {
        return (height + 1) / 4;
    }

    protected int calculateArrowOffset() {
        return 0;
    }

    protected boolean isPaintingNorthBottom() {
        return false;
    }

    private void paintWest(Graphics g2, boolean isEnabled, Color arrowColor, boolean isPressed, int width, int height, int w2, int h2, int arrowHeight) {
        int startX = (w2 + 1 - arrowHeight) / 2;
        int startY = h2 / 2;
        int line = 0;
        while (line < arrowHeight) {
            g2.drawLine(startX + line, startY - line, startX + line, startY + line + 1);
            ++line;
        }
    }

    private void paintEast(Graphics g2, boolean isEnabled, Color arrowColor, boolean isPressed, int width, int height, int w2, int h2, int arrowHeight) {
        int startX = (w2 + 1 - arrowHeight) / 2 + arrowHeight - 1;
        int startY = h2 / 2;
        int line = 0;
        while (line < arrowHeight) {
            g2.drawLine(startX - line, startY - line, startX - line, startY + line + 1);
            ++line;
        }
    }

    protected void paintSouth(Graphics g2, boolean leftToRight, boolean isEnabled, Color arrowColor, boolean isPressed, int width, int height, int w2, int h2, int arrowHeight, int arrowOffset) {
        int startY = (h2 + 0 - arrowHeight) / 2 + arrowHeight - 1;
        int startX = w2 / 2;
        int line = 0;
        while (line < arrowHeight) {
            g2.fillRect(startX - line - arrowOffset, startY - line, 2 * (line + 1), 1);
            ++line;
        }
    }

    protected void paintNorth(Graphics g2, boolean leftToRight, boolean isEnabled, Color arrowColor, boolean isPressed, int width, int height, int w2, int h2, int arrowHeight, int arrowOffset, boolean paintBottom) {
        int startY = (h2 + 1 - arrowHeight) / 2;
        int startX = w2 / 2;
        int line = 0;
        while (line < arrowHeight) {
            g2.fillRect(startX - line - arrowOffset, startY + line, 2 * (line + 1), 1);
            ++line;
        }
    }
}

