/*
 * Decompiled with CFR 0.152.
 */
package com.inet.looks.plastic;

import com.inet.looks.plastic.BumpBuffer;
import com.inet.looks.plastic.PlasticLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;

final class PlasticBumps
implements Icon {
    protected int xBumps;
    protected int yBumps;
    protected Color topColor;
    protected Color shadowColor;
    protected Color backColor;
    protected static Vector<Object> buffers = new Vector();
    protected BumpBuffer buffer;

    public PlasticBumps(Dimension bumpArea) {
        this(bumpArea.width, bumpArea.height);
    }

    public PlasticBumps(int width, int height) {
        this(width, height, PlasticLookAndFeel.getPrimaryControlHighlight(), PlasticLookAndFeel.getPrimaryControlDarkShadow(), PlasticLookAndFeel.getPrimaryControlShadow());
    }

    public PlasticBumps(int width, int height, Color newTopColor, Color newShadowColor, Color newBackColor) {
        this.setBumpArea(width, height);
        this.setBumpColors(newTopColor, newShadowColor, newBackColor);
    }

    private BumpBuffer getBuffer(GraphicsConfiguration gc2, Color aTopColor, Color aShadowColor, Color aBackColor) {
        if (this.buffer != null && this.buffer.hasSameConfiguration(gc2, aTopColor, aShadowColor, aBackColor)) {
            return this.buffer;
        }
        BumpBuffer result = null;
        Enumeration<Object> elements = buffers.elements();
        while (elements.hasMoreElements()) {
            BumpBuffer aBuffer = (BumpBuffer)elements.nextElement();
            if (!aBuffer.hasSameConfiguration(gc2, aTopColor, aShadowColor, aBackColor)) continue;
            result = aBuffer;
            break;
        }
        if (result == null) {
            result = new BumpBuffer(gc2, this.topColor, this.shadowColor, this.backColor);
            buffers.addElement(result);
        }
        return result;
    }

    public void setBumpArea(Dimension bumpArea) {
        this.setBumpArea(bumpArea.width, bumpArea.height);
    }

    public void setBumpArea(int width, int height) {
        this.xBumps = width / 2;
        this.yBumps = height / 2;
    }

    public void setBumpColors(Color newTopColor, Color newShadowColor, Color newBackColor) {
        this.topColor = newTopColor;
        this.shadowColor = newShadowColor;
        this.backColor = newBackColor;
    }

    public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
        GraphicsConfiguration gc2 = g2 instanceof Graphics2D ? ((Graphics2D)g2).getDeviceConfiguration() : null;
        this.buffer = this.getBuffer(gc2, this.topColor, this.shadowColor, this.backColor);
        int bufferWidth = this.buffer.getImageSize().width;
        int bufferHeight = this.buffer.getImageSize().height;
        int iconWidth = this.getIconWidth();
        int iconHeight = this.getIconHeight();
        int x22 = x2 + iconWidth;
        int y22 = y2 + iconHeight;
        int savex = x2;
        while (y2 < y22) {
            int h2 = Math.min(y22 - y2, bufferHeight);
            x2 = savex;
            while (x2 < x22) {
                int w2 = Math.min(x22 - x2, bufferWidth);
                g2.drawImage(this.buffer.getImage(), x2, y2, x2 + w2, y2 + h2, 0, 0, w2, h2, null);
                x2 += bufferWidth;
            }
            y2 += bufferHeight;
        }
    }

    public int getIconWidth() {
        return this.xBumps * 2;
    }

    public int getIconHeight() {
        return this.yBumps * 2;
    }
}

