/*
 * Decompiled with CFR 0.152.
 */
package com.inet.looks.plastic;

import com.inet.looks.plastic.PlasticComboBoxButton;
import com.inet.looks.plastic.PlasticLookAndFeel;
import com.inet.looks.plastic.PlasticUtils;
import com.inet.looks.plastic.PlasticXPUtils;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalButtonUI;
import javax.swing.text.View;

public class PlasticButtonUI
extends MetalButtonUI {
    private static final PlasticButtonUI INSTANCE = new PlasticButtonUI();
    private boolean borderPaintsFocus;
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();

    public static ComponentUI createUI(JComponent b2) {
        return INSTANCE;
    }

    public void installDefaults(AbstractButton b2) {
        super.installDefaults(b2);
        this.borderPaintsFocus = Boolean.TRUE.equals(UIManager.get("Button.borderPaintsFocus"));
    }

    public void update(Graphics g2, JComponent c2) {
        if (c2.isOpaque()) {
            AbstractButton b2 = (AbstractButton)c2;
            if (this.isToolBarButton(b2)) {
                c2.setOpaque(false);
            } else if (b2.isContentAreaFilled()) {
                g2.setColor(c2.getBackground());
                g2.fillRect(0, 0, c2.getWidth(), c2.getHeight());
                if (this.is3D(b2)) {
                    PlasticUtils.paintToolBarGradient(g2, 0, 0, c2.getWidth(), c2.getHeight());
                }
            }
        }
        this.paint(g2, c2);
    }

    public void paint(Graphics g2, JComponent c2) {
        AbstractButton b2 = (AbstractButton)c2;
        ButtonModel model = b2.getModel();
        FontMetrics fm2 = g2.getFontMetrics();
        Insets i2 = c2.getInsets();
        PlasticButtonUI.viewRect.x = i2.left;
        PlasticButtonUI.viewRect.y = i2.top;
        PlasticButtonUI.viewRect.width = b2.getWidth() - (i2.right + PlasticButtonUI.viewRect.x);
        PlasticButtonUI.viewRect.height = b2.getHeight() - (i2.bottom + PlasticButtonUI.viewRect.y);
        PlasticButtonUI.textRect.height = 0;
        PlasticButtonUI.textRect.width = 0;
        PlasticButtonUI.textRect.y = 0;
        PlasticButtonUI.textRect.x = 0;
        PlasticButtonUI.iconRect.height = 0;
        PlasticButtonUI.iconRect.width = 0;
        PlasticButtonUI.iconRect.y = 0;
        PlasticButtonUI.iconRect.x = 0;
        Font f2 = c2.getFont();
        g2.setFont(f2);
        String text = SwingUtilities.layoutCompoundLabel(c2, fm2, b2.getText(), b2.getIcon(), b2.getVerticalAlignment(), b2.getHorizontalAlignment(), b2.getVerticalTextPosition(), b2.getHorizontalTextPosition(), viewRect, iconRect, textRect, b2.getText() == null ? 0 : b2.getIconTextGap());
        this.clearTextShiftOffset();
        if (b2 instanceof PlasticComboBoxButton && ((PlasticComboBoxButton)b2).getComboBox().hasFocus()) {
            this.paintFocus(g2, b2);
        }
        if (b2.isFocusPainted() && b2.hasFocus()) {
            this.paintFocus(g2, b2);
        }
        if (model.isRollover() && b2.isEnabled()) {
            this.paintMouseOver(g2, b2);
        }
        if (model.isArmed() && model.isPressed()) {
            this.paintButtonPressed(g2, b2);
        }
        if (b2.getIcon() != null) {
            this.paintIcon(g2, c2, iconRect);
        }
        if (text != null && !text.equals("")) {
            View v2 = (View)c2.getClientProperty("html");
            if (v2 != null) {
                v2.paint(g2, textRect);
            } else {
                this.paintText(g2, b2, textRect, text);
            }
        }
    }

    protected void paintButtonPressed(Graphics g2, AbstractButton b2) {
        if (b2.isContentAreaFilled()) {
            Dimension size = b2.getSize();
            PlasticUtils.paintPopupHightlight(g2, 0, 0, size.width, size.height);
        }
    }

    protected void paintMouseOver(Graphics g2, AbstractButton b2) {
        Dimension size = b2.getSize();
        int trans = 160;
        if (this.isToolBarButton(b2)) {
            trans = 70;
        }
        Color colorEnd = PlasticXPUtils.translucentColor(PlasticLookAndFeel.getSecondaryGradientEnd(), trans);
        Color colorStart = new Color(255, 255, 255, trans);
        PlasticUtils.paintDoubleGradient(g2, colorStart, colorEnd, 1, 1, size.width - 2, size.height - 2);
        PlasticXPUtils.drawButtonBorder(g2, 0, 0, size.width, size.height, PlasticLookAndFeel.getPrimaryControlDarkShadow());
    }

    protected void paintFocus(Graphics g2, AbstractButton b2) {
        if (this.borderPaintsFocus) {
            return;
        }
        PlasticUtils.paintFocusHightlight(g2, 0, 0, b2.getWidth(), b2.getHeight());
    }

    protected boolean isToolBarButton(AbstractButton b2) {
        Container parent = b2.getParent();
        return parent != null && (parent instanceof JToolBar || parent.getParent() instanceof JToolBar);
    }

    protected boolean is3D(AbstractButton b2) {
        if (PlasticUtils.force3D(b2)) {
            return true;
        }
        if (PlasticUtils.forceFlat(b2)) {
            return false;
        }
        ButtonModel model = b2.getModel();
        return PlasticUtils.is3D("Button.") && b2.isBorderPainted() && model.isEnabled() && (!model.isPressed() || !model.isArmed());
    }
}

