/*
 * Decompiled with CFR 0.152.
 */
package com.inet.looks.plastic;

import com.inet.looks.plastic.PlasticLookAndFeel;
import com.inet.looks.plastic.PlasticUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JSlider;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;

final class PlasticIconFactory {
    private static Icon checkBoxIcon;
    private static Icon checkBoxMenuItemIcon;
    private static Icon radioButtonMenuItemIcon;
    private static Icon sliderThumbIcon;
    private static Icon menuArrowIcon;
    private static Icon expandedTreeIcon;
    private static Icon collapsedTreeIcon;
    private static Icon comboBoxButtonIcon;

    private PlasticIconFactory() {
    }

    private static void drawCheck(Graphics g2, int x2, int y2) {
        g2.translate(x2, y2);
        g2.drawLine(3, 5, 3, 5);
        g2.fillRect(3, 6, 2, 2);
        g2.drawLine(4, 8, 9, 3);
        g2.drawLine(5, 8, 9, 4);
        g2.drawLine(5, 9, 9, 5);
        g2.translate(-x2, -y2);
    }

    static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    static Icon getCheckBoxMenuItemIcon() {
        if (checkBoxMenuItemIcon == null) {
            checkBoxMenuItemIcon = new CheckBoxMenuItemIcon();
        }
        return checkBoxMenuItemIcon;
    }

    static Icon getRadioButtonMenuItemIcon() {
        if (radioButtonMenuItemIcon == null) {
            radioButtonMenuItemIcon = new RadioButtonMenuItemIcon();
        }
        return radioButtonMenuItemIcon;
    }

    static Icon getSliderThumbIcon() {
        if (sliderThumbIcon == null) {
            sliderThumbIcon = new VerticalSliderThumbIcon();
        }
        return sliderThumbIcon;
    }

    static Icon getMenuArrowIcon() {
        if (menuArrowIcon == null) {
            menuArrowIcon = new MenuArrowIcon();
        }
        return menuArrowIcon;
    }

    static Icon getExpandedTreeIcon() {
        if (expandedTreeIcon == null) {
            expandedTreeIcon = new ExpandedTreeIcon(null, null);
        }
        return expandedTreeIcon;
    }

    static Icon getCollapsedTreeIcon() {
        if (collapsedTreeIcon == null) {
            collapsedTreeIcon = new CollapsedTreeIcon();
        }
        return collapsedTreeIcon;
    }

    static Icon getComboBoxButtonIcon() {
        if (comboBoxButtonIcon == null) {
            comboBoxButtonIcon = new ComboBoxButtonIcon();
        }
        return comboBoxButtonIcon;
    }

    private static class CheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final int SIZE = 13;

        private CheckBoxIcon() {
        }

        public int getIconWidth() {
            return 13;
        }

        public int getIconHeight() {
            return 13;
        }

        public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
            JCheckBox cb2 = (JCheckBox)c2;
            ButtonModel model = cb2.getModel();
            if (model.isEnabled()) {
                if (cb2.isBorderPaintedFlat()) {
                    g2.setColor(PlasticLookAndFeel.getControlDarkShadow());
                    g2.drawRect(x2, y2, 11, 11);
                    g2.setColor(PlasticLookAndFeel.getControlHighlight());
                    g2.fillRect(x2 + 1, y2 + 1, 10, 10);
                } else if (model.isPressed() && model.isArmed()) {
                    g2.setColor(MetalLookAndFeel.getControlShadow());
                    g2.fillRect(x2, y2, 12, 12);
                    PlasticUtils.drawPressed3DBorder(g2, x2, y2, 13, 13);
                } else {
                    PlasticUtils.drawFlush3DBorder(g2, x2, y2, 13, 13);
                }
                g2.setColor(MetalLookAndFeel.getControlInfo());
            } else {
                g2.setColor(MetalLookAndFeel.getControlShadow());
                g2.drawRect(x2, y2, 11, 11);
            }
            if (model.isSelected()) {
                PlasticIconFactory.drawCheck(g2, x2, y2);
            }
        }
    }

    private static class CheckBoxMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final int SIZE = 13;

        private CheckBoxMenuItemIcon() {
        }

        public int getIconWidth() {
            return 13;
        }

        public int getIconHeight() {
            return 13;
        }

        public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
            JMenuItem b2 = (JMenuItem)c2;
            if (b2.isSelected()) {
                PlasticIconFactory.drawCheck(g2, x2, y2 + 1);
            }
        }
    }

    private static class CollapsedTreeIcon
    extends ExpandedTreeIcon {
        private static final long serialVersionUID = 1L;

        private CollapsedTreeIcon() {
        }

        public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
            super.paintIcon(c2, g2, x2, y2);
            g2.drawLine(x2 + 4, y2 + 2, x2 + 4, y2 + 6);
        }
    }

    private static class ComboBoxButtonIcon
    implements Icon,
    Serializable {
        private static final long serialVersionUID = 1L;

        private ComboBoxButtonIcon() {
        }

        public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
            JComponent component = (JComponent)c2;
            int iconWidth = this.getIconWidth();
            g2.translate(x2, y2);
            g2.setColor(component.isEnabled() ? MetalLookAndFeel.getControlInfo() : MetalLookAndFeel.getControlShadow());
            g2.drawLine(0, 0, iconWidth - 1, 0);
            g2.drawLine(1, 1, 1 + (iconWidth - 3), 1);
            g2.drawLine(2, 2, 2 + (iconWidth - 5), 2);
            g2.drawLine(3, 3, 3 + (iconWidth - 7), 3);
            g2.translate(-x2, -y2);
        }

        public int getIconWidth() {
            return 8;
        }

        public int getIconHeight() {
            return 4;
        }
    }

    private static class ExpandedTreeIcon
    implements Icon,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected static final int SIZE = 9;
        protected static final int HALF_SIZE = 4;

        private ExpandedTreeIcon() {
        }

        public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
            g2.setColor(Color.WHITE);
            g2.fillRect(x2, y2, 8, 8);
            g2.setColor(Color.GRAY);
            g2.drawRect(x2, y2, 8, 8);
            g2.setColor(Color.BLACK);
            g2.drawLine(x2 + 2, y2 + 4, x2 + 6, y2 + 4);
        }

        public int getIconWidth() {
            return 9;
        }

        public int getIconHeight() {
            return 9;
        }

        /* synthetic */ ExpandedTreeIcon(ExpandedTreeIcon expandedTreeIcon, ExpandedTreeIcon expandedTreeIcon2) {
            this();
        }
    }

    private static class MenuArrowIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final int WIDTH = 4;
        private static final int HEIGHT = 8;

        private MenuArrowIcon() {
        }

        public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
            JMenuItem b2 = (JMenuItem)c2;
            g2.translate(x2, y2);
            if (PlasticUtils.isLeftToRight(b2)) {
                g2.drawLine(0, 0, 0, 7);
                g2.drawLine(1, 1, 1, 6);
                g2.drawLine(2, 2, 2, 5);
                g2.drawLine(3, 3, 3, 4);
            } else {
                g2.drawLine(4, 0, 4, 7);
                g2.drawLine(3, 1, 3, 6);
                g2.drawLine(2, 2, 2, 5);
                g2.drawLine(1, 3, 1, 4);
            }
            g2.translate(-x2, -y2);
        }

        public int getIconWidth() {
            return 4;
        }

        public int getIconHeight() {
            return 8;
        }
    }

    private static class RadioButtonMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final int SIZE = 13;

        private RadioButtonMenuItemIcon() {
        }

        public int getIconWidth() {
            return 13;
        }

        public int getIconHeight() {
            return 13;
        }

        public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
            JMenuItem b2 = (JMenuItem)c2;
            if (b2.isSelected()) {
                this.drawDot(g2, x2, y2);
            }
        }

        private void drawDot(Graphics g2, int x2, int y2) {
            g2.translate(x2, y2);
            g2.drawLine(5, 4, 8, 4);
            g2.fillRect(4, 5, 6, 4);
            g2.drawLine(5, 9, 8, 9);
            g2.translate(-x2, -y2);
        }
    }

    private static class VerticalSliderThumbIcon
    implements Icon,
    Serializable,
    UIResource {
        private static int WIDTH = 12;
        private static int HEIGHT = 12;
        private int w = WIDTH;
        private int h = WIDTH;

        public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
            JSlider slider = (JSlider)c2;
            boolean leftToRight = c2.getComponentOrientation().isLeftToRight();
            g2.translate(x2, y2);
            if (slider.getOrientation() == 1) {
                this.h = WIDTH;
                this.w = HEIGHT;
            } else {
                this.h = HEIGHT;
                this.w = WIDTH;
            }
            if (slider.isEnabled()) {
                PlasticUtils.paintToolBarGradient(g2, x2, y2, this.w, this.h);
                if (slider.hasFocus()) {
                    PlasticUtils.paintPopupHightlight(g2, x2, y2, this.w, this.h);
                } else {
                    PlasticUtils.paintToolBarGradient(g2, x2, y2, this.w, this.h);
                }
                g2.setColor(PlasticLookAndFeel.getControlDarkShadow());
                g2.drawRoundRect(x2, y2, this.w - 1, this.h - 1, 5, 5);
            }
            g2.translate(-x2, -y2);
        }

        public int getIconWidth() {
            return WIDTH;
        }

        public int getIconHeight() {
            return HEIGHT;
        }
    }
}

