/*
 * Decompiled with CFR 0.152.
 */
package com.inet.looks.plastic;

import com.inet.looks.plastic.PlasticUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;

public class PlasticListUI
extends BasicListUI {
    public static ComponentUI createUI(JComponent list) {
        return new PlasticListUI();
    }

    protected void paintCell(Graphics g2, int row, Rectangle rowBounds, ListCellRenderer cellRenderer, ListModel dataModel, ListSelectionModel selModel, int leadIndex) {
        Object value = dataModel.getElementAt(row);
        boolean cellHasFocus = this.list.hasFocus() && row == leadIndex;
        boolean isSelected = selModel.isSelectedIndex(row);
        Component rendererComponent = cellRenderer.getListCellRendererComponent(this.list, value, row, isSelected, cellHasFocus);
        ((JComponent)rendererComponent).setOpaque(false);
        int cx2 = rowBounds.x;
        int cy2 = rowBounds.y;
        int cw2 = rowBounds.width;
        int ch2 = rowBounds.height;
        this.rendererPane.paintComponent(g2, rendererComponent, this.list, cx2, cy2, cw2, ch2, true);
        if (this.list != null) {
            Color oldColor = g2.getColor();
            if (isSelected) {
                PlasticUtils.paintPopupHightlight(g2, cx2, cy2, cw2, ch2);
            }
            g2.setColor(oldColor);
        }
        if (rendererComponent.getParent() != this.rendererPane) {
            this.rendererPane.add(rendererComponent);
        }
        rendererComponent.setBounds(cx2, cy2, cw2, ch2);
        rendererComponent.validate();
        boolean wasDoubleBuffered = false;
        if (rendererComponent instanceof JComponent && ((JComponent)rendererComponent).isDoubleBuffered()) {
            wasDoubleBuffered = true;
            ((JComponent)rendererComponent).setDoubleBuffered(false);
        }
        Graphics cg2 = g2.create(cx2, cy2, cw2, ch2);
        try {
            rendererComponent.paint(cg2);
        }
        finally {
            cg2.dispose();
        }
        if (wasDoubleBuffered && rendererComponent instanceof JComponent) {
            ((JComponent)rendererComponent).setDoubleBuffered(true);
        }
        rendererComponent.setBounds(-cw2, -ch2, 0, 0);
    }
}

