/*
 * Decompiled with CFR 0.152.
 */
package com.inet.looks.plastic;

import com.inet.looks.FontPolicies;
import com.inet.looks.FontPolicy;
import com.inet.looks.LookUtils;
import com.inet.looks.MicroLayout;
import com.inet.looks.MicroLayoutPolicies;
import com.inet.looks.MicroLayoutPolicy;
import com.inet.looks.common.MinimumSizedIcon;
import com.inet.looks.common.RGBGrayFilter;
import com.inet.looks.common.ShadowPopupFactory;
import com.inet.looks.plastic.PlasticBorders;
import com.inet.looks.plastic.PlasticIconFactory;
import com.inet.looks.plastic.PlasticTheme;
import com.inet.looks.plastic.theme.InetBlueYellow;
import com.inet.looks.plastic.theme.InetTheme;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlasticLookAndFeel
extends MetalLookAndFeel {
    private static final long serialVersionUID = 1L;
    private static final String THEME_CLASSNAME_PREFIX = "com.inet.looks.plastic.theme.";
    public static final String BORDER_STYLE_KEY = "Plastic.borderStyle";
    public static final String IS_3D_KEY = "Plastic.is3D";
    public static final String DEFAULT_THEME_KEY = "Plastic.defaultTheme";
    public static final String HIGH_CONTRAST_FOCUS_ENABLED_KEY = "Plastic.highContrastFocus";
    protected static final String TAB_STYLE_KEY = "Plastic.tabStyle";
    public static final String TAB_STYLE_DEFAULT_VALUE = "default";
    public static final String TAB_STYLE_METAL_VALUE = "metal";
    private static final Object THEME_KEY = new StringBuffer("Plastic.theme");
    private static boolean useMetalTabs = LookUtils.getSystemProperty("Plastic.tabStyle", "").equalsIgnoreCase("metal");
    private static boolean useHighContrastFocusColors = LookUtils.getSystemProperty("Plastic.highContrastFocus") != null;
    private static List<MetalTheme> installedThemes;
    private static boolean is3DEnabled;
    private static boolean selectTextOnKeyboardFocusGained;
    private static Method getCurrentThemeMethod;

    static {
        is3DEnabled = false;
        selectTextOnKeyboardFocusGained = LookUtils.IS_OS_WINDOWS;
        getCurrentThemeMethod = null;
        if (LookUtils.IS_JAVA_5_OR_LATER) {
            getCurrentThemeMethod = PlasticLookAndFeel.getMethodGetCurrentTheme();
        }
    }

    public PlasticLookAndFeel() {
        PlasticLookAndFeel.getPlasticTheme();
    }

    @Override
    public String getID() {
        return "JGoodies Plastic";
    }

    @Override
    public String getName() {
        return "JGoodies Plastic";
    }

    @Override
    public String getDescription() {
        return "The JGoodies Plastic Look and Feel - \u00a9 2001-2007 JGoodies Karsten Lentzsch";
    }

    public static FontPolicy getFontPolicy() {
        FontPolicy policy = (FontPolicy)UIManager.get("Plastic.fontPolicy");
        if (policy != null) {
            return policy;
        }
        FontPolicy defaultPolicy = FontPolicies.getDefaultPlasticPolicy();
        return FontPolicies.customSettingsPolicy(defaultPolicy);
    }

    public static void setFontPolicy(FontPolicy fontPolicy) {
        UIManager.put("Plastic.fontPolicy", fontPolicy);
    }

    public static MicroLayoutPolicy getMicroLayoutPolicy() {
        MicroLayoutPolicy policy = (MicroLayoutPolicy)UIManager.get("Plastic.MicroLayoutPolicy");
        return policy != null ? policy : MicroLayoutPolicies.getDefaultPlasticPolicy();
    }

    public static void setMicroLayoutPolicy(MicroLayout microLayoutPolicy) {
        UIManager.put("Plastic.MicroLayoutPolicy", microLayoutPolicy);
    }

    protected boolean is3DEnabled() {
        return is3DEnabled;
    }

    public static void set3DEnabled(boolean b2) {
        is3DEnabled = b2;
    }

    public static String getTabStyle() {
        return useMetalTabs ? TAB_STYLE_METAL_VALUE : TAB_STYLE_DEFAULT_VALUE;
    }

    public static void setTabStyle(String tabStyle) {
        useMetalTabs = tabStyle.equalsIgnoreCase(TAB_STYLE_METAL_VALUE);
    }

    public static boolean getHighContrastFocusColorsEnabled() {
        return useHighContrastFocusColors;
    }

    public static void setHighContrastFocusColorsEnabled(boolean b2) {
        useHighContrastFocusColors = b2;
    }

    public static boolean isSelectTextOnKeyboardFocusGained() {
        return selectTextOnKeyboardFocusGained;
    }

    public static void setSelectTextOnKeyboardFocusGained(boolean b2) {
        selectTextOnKeyboardFocusGained = b2;
    }

    @Override
    public void initialize() {
        super.initialize();
        ShadowPopupFactory.install();
    }

    @Override
    public void uninitialize() {
        super.uninitialize();
        ShadowPopupFactory.uninstall();
    }

    @Override
    public Icon getDisabledIcon(JComponent component, Icon icon) {
        Icon disabledIcon = RGBGrayFilter.getDisabledIcon(component, icon);
        return disabledIcon != null ? new IconUIResource(disabledIcon) : null;
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        String plasticPrefix = "com.inet.looks.plastic.Plastic";
        String commonPrefix = "com.inet.looks.common.ExtBasic";
        Object[] uiDefaults = new Object[]{"ButtonUI", "com.inet.looks.plastic.PlasticButtonUI", "ToggleButtonUI", "com.inet.looks.plastic.PlasticToggleButtonUI", "ComboBoxUI", "com.inet.looks.plastic.PlasticComboBoxUI", "ScrollBarUI", "com.inet.looks.plastic.PlasticScrollBarUI", "SpinnerUI", "com.inet.looks.plastic.PlasticSpinnerUI", "MenuBarUI", "com.inet.looks.plastic.PlasticMenuBarUI", "ToolBarUI", "com.inet.looks.plastic.PlasticToolBarUI", "MenuUI", "com.inet.looks.plastic.PlasticMenuUI", "MenuItemUI", "com.inet.looks.common.ExtBasicMenuItemUI", "CheckBoxMenuItemUI", "com.inet.looks.common.ExtBasicCheckBoxMenuItemUI", "RadioButtonMenuItemUI", "com.inet.looks.common.ExtBasicRadioButtonMenuItemUI", "PopupMenuUI", "com.inet.looks.plastic.PlasticPopupMenuUI", "PopupMenuSeparatorUI", "com.inet.looks.common.ExtBasicPopupMenuSeparatorUI", "ProgressBarUI", "com.inet.looks.plastic.PlasticProgressBarUI", "OptionPaneUI", "com.inet.looks.plastic.PlasticOptionPaneUI", "ScrollPaneUI", "com.inet.looks.plastic.PlasticScrollPaneUI", "SplitPaneUI", "com.inet.looks.plastic.PlasticSplitPaneUI", "PasswordFieldUI", "com.inet.looks.plastic.PlasticPasswordFieldUI", "TextAreaUI", "com.inet.looks.plastic.PlasticTextAreaUI", "TreeUI", "com.inet.looks.plastic.PlasticTreeUI", "TableUI", "com.inet.looks.plastic.PlasticTableUI", "TableHeaderUI", "com.inet.looks.plastic.PlasticTableHeaderUI", "InternalFrameUI", "com.inet.looks.plastic.PlasticInternalFrameUI", "InternalFrameTitlePaneUI", "com.inet.looks.plastic.PlasticInternalFrameTitlePaneUI", "SeparatorUI", "com.inet.looks.plastic.PlasticSeparatorUI", "ToolBarSeparatorUI", "com.inet.looks.plastic.PlasticToolBarSeparatorUI", "FileChooserUI", "com.inet.looks.plastic.PlasticFileChooserUI", "ListUI", "com.inet.looks.plastic.PlasticListUI", "ToolTipUI", "com.inet.looks.plastic.PlasticToolTipUI", "RootPaneUI", "com.inet.looks.plastic.PlasticRootPaneUI"};
        if (!useMetalTabs) {
            uiDefaults = PlasticLookAndFeel.append(uiDefaults, "TabbedPaneUI", "com.inet.looks.plastic.PlasticTabbedPaneUI");
        }
        if (PlasticLookAndFeel.isSelectTextOnKeyboardFocusGained()) {
            uiDefaults = PlasticLookAndFeel.append(uiDefaults, "TextFieldUI", "com.inet.looks.plastic.PlasticTextFieldUI");
            uiDefaults = PlasticLookAndFeel.append(uiDefaults, "FormattedTextFieldUI", "com.inet.looks.plastic.PlasticFormattedTextFieldUI");
        }
        table.putDefaults(uiDefaults);
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        MicroLayout microLayout = PlasticLookAndFeel.getMicroLayoutPolicy().getMicroLayout(this.getName(), table);
        Insets buttonBorderInsets = microLayout.getButtonBorderInsets();
        String menuItemAcceleratorDelimiter = new String("+");
        Border rootPaneBorder = PlasticBorders.getFrameBorder();
        BasicBorders.MarginBorder marginBorder = new BasicBorders.MarginBorder();
        Border buttonBorder = PlasticBorders.getButtonBorder(buttonBorderInsets);
        Border comboBoxButtonBorder = PlasticBorders.getComboBoxArrowButtonBorder();
        Border comboBoxEditorBorder = PlasticBorders.getComboBoxEditorBorder();
        Border menuItemBorder = PlasticBorders.getMenuItemBorder();
        Border textFieldBorder = PlasticBorders.getTextFieldBorder();
        Border toggleButtonBorder = PlasticBorders.getToggleButtonBorder(buttonBorderInsets);
        Border scrollPaneBorder = PlasticBorders.getScrollPaneBorder();
        BasicBorders.MarginBorder menuBarEmptyBorder = marginBorder;
        Border menuBarSeparatorBorder = PlasticBorders.getSeparatorBorder();
        Border menuBarEtchedBorder = PlasticBorders.getEtchedBorder();
        Border menuBarHeaderBorder = PlasticBorders.getMenuBarHeaderBorder();
        BasicBorders.MarginBorder toolBarEmptyBorder = marginBorder;
        Border toolBarSeparatorBorder = PlasticBorders.getSeparatorBorder();
        Border etchedBorder = PlasticBorders.getEtchedBorder();
        Border toolBarHeaderBorder = PlasticBorders.getToolBarHeaderBorder();
        BorderUIResource paletteBorder = PlasticLookAndFeel.getPaletteBorder();
        Color controlColor = table.getColor("control");
        Icon checkBoxIcon = PlasticIconFactory.getCheckBoxIcon();
        InsetsUIResource checkBoxMargin = microLayout.getCheckBoxMargin();
        InsetsUIResource buttonMargin = microLayout.getButtonMargin();
        InsetsUIResource textInsets = microLayout.getTextInsets();
        InsetsUIResource wrappedTextInsets = microLayout.getWrappedTextInsets();
        InsetsUIResource comboEditorInsets = microLayout.getComboBoxEditorInsets();
        Insets comboEditorBorderInsets = comboBoxEditorBorder.getBorderInsets(null);
        int comboBorderSize = comboEditorBorderInsets.left;
        int comboPopupBorderSize = microLayout.getComboPopupBorderSize();
        int comboRendererGap = comboEditorInsets.left + comboBorderSize - comboPopupBorderSize;
        EmptyBorder comboRendererBorder = new EmptyBorder(1, comboRendererGap, 1, comboRendererGap);
        Insets comboTableEditorInsets = new Insets(0, 0, 0, 0);
        InsetsUIResource menuItemMargin = microLayout.getMenuItemMargin();
        InsetsUIResource menuMargin = microLayout.getMenuMargin();
        MinimumSizedIcon menuItemCheckIcon = new MinimumSizedIcon();
        Icon checkBoxMenuItemIcon = PlasticIconFactory.getCheckBoxMenuItemIcon();
        Icon radioButtonMenuItemIcon = PlasticIconFactory.getRadioButtonMenuItemIcon();
        Icon sliderThumbIcon = PlasticIconFactory.getSliderThumbIcon();
        Color menuItemForeground = table.getColor("MenuItem.foreground");
        Integer tableRowHeight = new Integer(table.getFont("Table.font").getSize() + 5);
        int treeFontSize = table.getFont("Tree.font").getSize();
        Integer rowHeight = new Integer(treeFontSize + 6);
        Icon treeExpandedIcon = PlasticIconFactory.getExpandedTreeIcon();
        Icon treeCollapsedIcon = PlasticIconFactory.getCollapsedTreeIcon();
        ColorUIResource gray = new ColorUIResource(Color.GRAY);
        Boolean is3D = this.is3DEnabled();
        Character passwordEchoChar = new Character(LookUtils.IS_OS_WINDOWS ? (char)'\u25cf' : '\u2022');
        String iconPrefix = "icons/" + (LookUtils.IS_LOW_RESOLUTION ? "32x32/" : "48x48/");
        Object errorIcon = PlasticLookAndFeel.makeIcon(this.getClass(), String.valueOf(iconPrefix) + "dialog-error.png");
        Object informationIcon = PlasticLookAndFeel.makeIcon(this.getClass(), String.valueOf(iconPrefix) + "dialog-information.png");
        Object questionIcon = PlasticLookAndFeel.makeIcon(this.getClass(), String.valueOf(iconPrefix) + "dialog-question.png");
        Object warningIcon = PlasticLookAndFeel.makeIcon(this.getClass(), String.valueOf(iconPrefix) + "dialog-warning.png");
        Object maximizeIcon = PlasticLookAndFeel.makeIcon(this.getClass(), "icons/maximize.png");
        Object minimizeIcon = PlasticLookAndFeel.makeIcon(this.getClass(), "icons/minimize.png");
        Object closeIcon = PlasticLookAndFeel.makeIcon(this.getClass(), "icons/close.png");
        Object iconifyIcon = PlasticLookAndFeel.makeIcon(this.getClass(), "icons/iconify.png");
        Object[] defaults = new Object[]{"RootPane.frameBorder", rootPaneBorder, "RootPane.plainDialogBorder", rootPaneBorder, "RootPane.informationDialogBorder", rootPaneBorder, "RootPane.errorDialogBorder", rootPaneBorder, "RootPane.colorChooserDialogBorder", rootPaneBorder, "RootPane.fileChooserDialogBorder", rootPaneBorder, "RootPane.questionDialogBorder", rootPaneBorder, "RootPane.warningDialogBorder", rootPaneBorder, "Button.border", buttonBorder, "Button.rollover", Boolean.TRUE, "Button.borderPaintsFocus", Boolean.FALSE, "Button.margin", buttonMargin, "Button.defaultButtonFollowsFocus", Boolean.TRUE, "CheckBox.margin", checkBoxMargin, "CheckBox.icon", checkBoxIcon, "CheckBoxMenuItem.border", menuItemBorder, "CheckBoxMenuItem.margin", menuItemMargin, "CheckBoxMenuItem.checkIcon", checkBoxMenuItemIcon, "CheckBoxMenuItem.background", PlasticLookAndFeel.getMenuItemBackground(), "CheckBoxMenuItem.selectionForeground", PlasticLookAndFeel.getMenuItemSelectedForeground(), "CheckBoxMenuItem.selectionBackground", PlasticLookAndFeel.getMenuItemSelectedBackground(), "CheckBoxMenuItem.acceleratorForeground", menuItemForeground, "CheckBoxMenuItem.acceleratorSelectionForeground", PlasticLookAndFeel.getMenuItemSelectedForeground(), "CheckBoxMenuItem.acceleratorSelectionBackground", PlasticLookAndFeel.getMenuItemSelectedBackground(), "ComboBox.selectionForeground", PlasticLookAndFeel.getMenuSelectedForeground(), "ComboBox.selectionBackground", PlasticLookAndFeel.getMenuSelectedBackground(), "ComboBox.arrowButtonBorder", comboBoxButtonBorder, "ComboBox.editorBorder", comboBoxEditorBorder, "ComboBox.editorColumns", new Integer(5), "ComboBox.editorBorderInsets", comboEditorBorderInsets, "ComboBox.editorInsets", textInsets, "ComboBox.tableEditorInsets", comboTableEditorInsets, "ComboBox.rendererBorder", comboRendererBorder, "ComboBox.borderPaintsFocus", Boolean.FALSE, "EditorPane.margin", wrappedTextInsets, "InternalFrame.border", rootPaneBorder, "InternalFrame.maximizeIcon", maximizeIcon, "InternalFrame.minimizeIcon", minimizeIcon, "InternalFrame.closeIcon", closeIcon, "InternalFrame.iconifyIcon", iconifyIcon, "InternalFrame.paletteBorder", paletteBorder, "List.font", PlasticLookAndFeel.getControlTextFont(), "List.selectionForeground", PlasticLookAndFeel.getMenuItemSelectedForeground(), "List.focusCellHighlightBorder", PlasticBorders.getCellFocusBorder(), "Menu.border", PlasticBorders.getMenuBorder(), "Menu.margin", menuMargin, "Menu.arrowIcon", PlasticIconFactory.getMenuArrowIcon(), "MenuBar.emptyBorder", menuBarEmptyBorder, "MenuBar.separatorBorder", menuBarSeparatorBorder, "MenuBar.etchedBorder", menuBarEtchedBorder, "MenuBar.headerBorder", menuBarHeaderBorder, "MenuItem.border", menuItemBorder, "MenuItem.checkIcon", menuItemCheckIcon, "MenuItem.margin", menuItemMargin, "MenuItem.background", PlasticLookAndFeel.getMenuItemBackground(), "MenuItem.selectionForeground", PlasticLookAndFeel.getMenuItemSelectedForeground(), "MenuItem.selectionBackground", PlasticLookAndFeel.getMenuItemSelectedBackground(), "MenuItem.acceleratorForeground", menuItemForeground, "MenuItem.acceleratorSelectionForeground", PlasticLookAndFeel.getMenuItemSelectedForeground(), "MenuItem.acceleratorSelectionBackground", PlasticLookAndFeel.getMenuItemSelectedBackground(), "MenuItem.acceleratorDelimiter", menuItemAcceleratorDelimiter, "OptionPane.errorIcon", errorIcon, "OptionPane.informationIcon", informationIcon, "OptionPane.questionIcon", questionIcon, "OptionPane.warningIcon", warningIcon, "FileView.computerIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/Computer.gif"), "FileView.directoryIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/TreeClosed.gif"), "FileView.fileIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/File.gif"), "FileView.floppyDriveIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/FloppyDrive.gif"), "FileView.hardDriveIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/HardDrive.gif"), "FileChooser.homeFolderIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/HomeFolder.gif"), "FileChooser.useSystemIcons", Boolean.TRUE, "FileChooser.newFolderIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/NewFolder.gif"), "FileChooser.upFolderIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/UpFolder.gif"), "Tree.closedIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/TreeClosed.gif"), "Tree.openIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/TreeOpen.gif"), "Tree.leafIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/TreeLeaf.gif"), "Tree.rendererFillBackground", Boolean.FALSE, "Tree.selectionForeground", Color.BLACK, "Tree.textForeground", Color.BLACK, "FormattedTextField.border", textFieldBorder, "FormattedTextField.margin", textInsets, "TableHeader.cellBorder", new EmptyBorder(0, 0, 0, 0), "PasswordField.border", textFieldBorder, "PasswordField.margin", textInsets, "PasswordField.echoChar", passwordEchoChar, "PopupMenu.border", PlasticBorders.getPopupMenuBorder(), "PopupMenu.noMarginBorder", PlasticBorders.getNoMarginPopupMenuBorder(), "PopupMenuSeparator.margin", new InsetsUIResource(3, 4, 3, 4), "RadioButton.margin", checkBoxMargin, "RadioButtonMenuItem.border", menuItemBorder, "RadioButtonMenuItem.checkIcon", radioButtonMenuItemIcon, "RadioButtonMenuItem.margin", menuItemMargin, "RadioButtonMenuItem.background", PlasticLookAndFeel.getMenuItemBackground(), "RadioButtonMenuItem.selectionForeground", PlasticLookAndFeel.getMenuItemSelectedForeground(), "RadioButtonMenuItem.selectionBackground", PlasticLookAndFeel.getMenuItemSelectedBackground(), "RadioButtonMenuItem.acceleratorForeground", menuItemForeground, "RadioButtonMenuItem.acceleratorSelectionForeground", PlasticLookAndFeel.getMenuItemSelectedForeground(), "RadioButtonMenuItem.acceleratorSelectionBackground", PlasticLookAndFeel.getMenuItemSelectedBackground(), "Separator.foreground", PlasticLookAndFeel.getControlDarkShadow(), "ScrollPane.border", scrollPaneBorder, "ScrollPane.etchedBorder", scrollPaneBorder, "SimpleInternalFrame.activeTitleForeground", PlasticLookAndFeel.getSimpleInternalFrameForeground(), "SimpleInternalFrame.activeTitleBackground", PlasticLookAndFeel.getSimpleInternalFrameBackground(), "Spinner.border", PlasticBorders.getFlush3DBorder(), "Spinner.defaultEditorInsets", textInsets, "Slider.horizontalThumbIcon", sliderThumbIcon, "Slider.verticalThumbIcon", sliderThumbIcon, "SplitPane.dividerSize", new Integer(6), "SplitPane.border", new EmptyBorder(0, 0, 0, 0), "TabbedPane.focus", PlasticLookAndFeel.getFocusColor(), "TabbedPane.tabInsets", new InsetsUIResource(1, 9, 1, 8), "Table.rowHeight", tableRowHeight, "Table.foreground", table.get("textText"), "Table.gridColor", controlColor, "Table.scrollPaneBorder", scrollPaneBorder, "Table.selectionForeground", PlasticLookAndFeel.getBlack(), "Table.selectionBackground", PlasticLookAndFeel.getMenuItemSelectedBackground(), "TextArea.margin", wrappedTextInsets, "TextField.border", textFieldBorder, "TextField.margin", textInsets, "TitledBorder.font", PlasticLookAndFeel.getTitleTextFont(), "TitledBorder.titleColor", PlasticLookAndFeel.getTitleTextColor(), "ToggleButton.border", toggleButtonBorder, "ToggleButton.margin", buttonMargin, "ToggleButton.borderPaintsFocus", Boolean.FALSE, "ToolBar.emptyBorder", toolBarEmptyBorder, "ToolBar.separatorBorder", toolBarSeparatorBorder, "ToolBar.etchedBorder", etchedBorder, "ToolBar.headerBorder", toolBarHeaderBorder, "ToolTip.hideAccelerator", Boolean.TRUE, "Tree.expandedIcon", treeExpandedIcon, "Tree.collapsedIcon", treeCollapsedIcon, "Tree.line", gray, "Tree.hash", gray, "Tree.rowHeight", rowHeight, "Button.is3DEnabled", is3D, "ComboBox.is3DEnabled", is3D, "MenuBar.is3DEnabled", is3D, "ToolBar.is3DEnabled", is3D, "ScrollBar.is3DEnabled", is3D, "ToggleButton.is3DEnabled", is3D, "CheckBox.border", marginBorder, "RadioButton.border", marginBorder, "ProgressBar.selectionForeground", PlasticLookAndFeel.getSystemTextColor(), "ProgressBar.selectionBackground", PlasticLookAndFeel.getSystemTextColor(), "MarkColor.color1", new Color(150, 162, 220), "MarkColor.color2", Color.BLUE};
        table.putDefaults(defaults);
        String soundPathPrefix = "/javax/swing/plaf/metal/";
        Object[] auditoryCues = (Object[])table.get("AuditoryCues.allAuditoryCues");
        if (auditoryCues != null) {
            Object[] audioDefaults = new String[auditoryCues.length * 2];
            int i2 = 0;
            while (i2 < auditoryCues.length) {
                Object auditoryCue;
                audioDefaults[2 * i2] = auditoryCue = auditoryCues[i2];
                audioDefaults[2 * i2 + 1] = String.valueOf(soundPathPrefix) + table.getString(auditoryCue);
                ++i2;
            }
            table.putDefaults(audioDefaults);
        }
        this.convertInputMap(table, "EditorPane.focusInputMap");
        this.convertInputMap(table, "TextPane.focusInputMap");
        this.convertInputMap(table, "TextField.focusInputMap");
    }

    private void convertInputMap(UIDefaults table, String inputMapKey) {
        InputMap inputMap = (InputMap)table.get(inputMapKey);
        if (inputMap == null) {
            return;
        }
        int currentMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        if (currentMask == 2) {
            return;
        }
        KeyStroke[] keystrokes = inputMap.allKeys();
        InputMapUIResource im = new InputMapUIResource();
        int i2 = 0;
        while (i2 < keystrokes.length) {
            KeyStroke key = keystrokes[i2];
            Object actionName = inputMap.get(key);
            int modifiers = key.getModifiers();
            int keyCode = key.getKeyCode();
            if ((modifiers & 2) > 0) {
                if (keyCode == 39 || keyCode == 37) {
                    modifiers = modifiers & 0xFFFFFF7D | 8;
                    im.put(KeyStroke.getKeyStroke(keyCode, modifiers, key.isOnKeyRelease()), actionName);
                } else {
                    modifiers = modifiers & 0xFFFFFF7D | currentMask;
                    im.put(KeyStroke.getKeyStroke(keyCode, modifiers, key.isOnKeyRelease()), actionName);
                }
            } else if (keyCode == 35) {
                im.put(KeyStroke.getKeyStroke(39, modifiers |= 4, key.isOnKeyRelease()), actionName);
            } else if (keyCode == 36) {
                im.put(KeyStroke.getKeyStroke(37, modifiers |= 4, key.isOnKeyRelease()), actionName);
            } else {
                im.put(key, actionName);
            }
            ++i2;
        }
        table.put(inputMapKey, im);
    }

    @Override
    protected void initSystemColorDefaults(UIDefaults table) {
        super.initSystemColorDefaults(table);
        table.put("unifiedControlShadow", table.getColor("controlDkShadow"));
        table.put("primaryControlHighlight", PlasticLookAndFeel.getPrimaryControlHighlight());
    }

    public static PlasticTheme createMyDefaultTheme() {
        PlasticTheme result;
        String defaultName = LookUtils.IS_LAF_WINDOWS_XP_ENABLED ? "InetBlueYellow" : (LookUtils.IS_OS_WINDOWS_MODERN ? "InetBlueYellow" : "InetBlueYellow");
        defaultName = "InetBlueYellow";
        String userName = LookUtils.getSystemProperty(DEFAULT_THEME_KEY, "");
        boolean overridden = userName.length() > 0;
        String themeName = overridden ? userName : defaultName;
        PlasticTheme theme = PlasticLookAndFeel.createTheme(defaultName);
        PlasticTheme plasticTheme = result = theme != null ? theme : new InetBlueYellow();
        if (overridden) {
            String className = result.getClass().getName().substring(THEME_CLASSNAME_PREFIX.length());
            if (className.equals(userName)) {
                LookUtils.log("I have successfully installed the '" + result.getName() + "' theme.");
            } else {
                LookUtils.log("I could not install the Plastic theme '" + userName + "'.");
                LookUtils.log("I have installed the '" + result.getName() + "' theme, instead.");
            }
        }
        return result;
    }

    public static List<MetalTheme> getInstalledThemes() {
        if (installedThemes == null) {
            PlasticLookAndFeel.installDefaultThemes();
        }
        Collections.sort(installedThemes, new Comparator<MetalTheme>(){

            @Override
            public int compare(MetalTheme o1, MetalTheme o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return installedThemes;
    }

    protected static void installDefaultThemes() {
        installedThemes = new ArrayList<MetalTheme>();
        String[] themeNames = new String[]{"InetBlueYellow"};
        int i2 = themeNames.length - 1;
        while (i2 >= 0) {
            PlasticLookAndFeel.installTheme(PlasticLookAndFeel.createTheme(themeNames[i2]));
            --i2;
        }
    }

    protected static PlasticTheme createTheme(String themeName) {
        String className = THEME_CLASSNAME_PREFIX + themeName;
        try {
            Class<?> cl2 = Class.forName(className);
            return (PlasticTheme)cl2.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        LookUtils.log("Can't create theme " + className);
        return null;
    }

    public static void installTheme(PlasticTheme theme) {
        if (installedThemes == null) {
            PlasticLookAndFeel.installDefaultThemes();
        }
        installedThemes.add(theme);
    }

    public static PlasticTheme getPlasticTheme() {
        MetalTheme theme;
        if (LookUtils.IS_JAVA_5_OR_LATER && (theme = PlasticLookAndFeel.getCurrentTheme0()) instanceof PlasticTheme) {
            return (PlasticTheme)theme;
        }
        PlasticTheme uimanagerTheme = (PlasticTheme)UIManager.get(THEME_KEY);
        if (uimanagerTheme != null) {
            return uimanagerTheme;
        }
        PlasticTheme initialTheme = PlasticLookAndFeel.createMyDefaultTheme();
        PlasticLookAndFeel.setPlasticTheme(initialTheme);
        return initialTheme;
    }

    public static InetTheme getInetTheme() {
        MetalTheme theme;
        if (LookUtils.IS_JAVA_5_OR_LATER && (theme = PlasticLookAndFeel.getCurrentTheme0()) instanceof InetTheme) {
            return (InetTheme)theme;
        }
        InetTheme uimanagerTheme = (InetTheme)UIManager.get(THEME_KEY);
        if (uimanagerTheme != null) {
            return uimanagerTheme;
        }
        InetBlueYellow initialTheme = new InetBlueYellow();
        PlasticLookAndFeel.setPlasticTheme(initialTheme);
        return initialTheme;
    }

    public static void setPlasticTheme(PlasticTheme theme) {
        if (theme == null) {
            throw new NullPointerException("The theme must not be null.");
        }
        UIManager.put(THEME_KEY, theme);
        PlasticLookAndFeel.setCurrentTheme(theme);
    }

    public static BorderUIResource getInternalFrameBorder() {
        return new BorderUIResource(PlasticBorders.getInternalFrameBorder());
    }

    public static BorderUIResource getFrameBorder() {
        return new BorderUIResource(PlasticBorders.getFrameBorder());
    }

    public static BorderUIResource getPaletteBorder() {
        return new BorderUIResource(PlasticBorders.getPaletteBorder());
    }

    public static ColorUIResource getPrimarywControlDarkShadow() {
        return PlasticLookAndFeel.getPlasticTheme().getPrimaryControlDarkShadow();
    }

    public static ColorUIResource getPrimaryControlDarkShadow() {
        return PlasticLookAndFeel.getPlasticTheme().getPrimaryControlDarkShadow();
    }

    public static ColorUIResource getPrimaryControlHighlight() {
        return PlasticLookAndFeel.getPlasticTheme().getPrimaryControlHighlight();
    }

    public static ColorUIResource getPrimaryControlInfo() {
        return PlasticLookAndFeel.getPlasticTheme().getPrimaryControlInfo();
    }

    public static ColorUIResource getPrimaryControlShadow() {
        return PlasticLookAndFeel.getPlasticTheme().getPrimaryControlShadow();
    }

    public static ColorUIResource getPrimaryControl() {
        return PlasticLookAndFeel.getPlasticTheme().getPrimaryControl();
    }

    public static ColorUIResource getControlHighlight() {
        return PlasticLookAndFeel.getPlasticTheme().getControlHighlight();
    }

    public static ColorUIResource getControlDarkShadow() {
        return PlasticLookAndFeel.getPlasticTheme().getControlDarkShadow();
    }

    public static ColorUIResource getControl() {
        return PlasticLookAndFeel.getPlasticTheme().getControl();
    }

    public static ColorUIResource getFocusColor() {
        return PlasticLookAndFeel.getPlasticTheme().getFocusColor();
    }

    public static ColorUIResource getMenuItemBackground() {
        return PlasticLookAndFeel.getPlasticTheme().getMenuItemBackground();
    }

    public static ColorUIResource getMenuItemSelectedBackground() {
        return PlasticLookAndFeel.getPlasticTheme().getMenuItemSelectedBackground();
    }

    public static ColorUIResource getMenuItemSelectedForeground() {
        return PlasticLookAndFeel.getPlasticTheme().getMenuItemSelectedForeground();
    }

    public static ColorUIResource getWindowTitleBackground() {
        return PlasticLookAndFeel.getPlasticTheme().getWindowTitleBackground();
    }

    public static ColorUIResource getWindowTitleForeground() {
        return PlasticLookAndFeel.getPlasticTheme().getWindowTitleForeground();
    }

    public static ColorUIResource getWindowTitleInactiveBackground() {
        return PlasticLookAndFeel.getPlasticTheme().getWindowTitleInactiveBackground();
    }

    public static ColorUIResource getWindowTitleInactiveForeground() {
        return PlasticLookAndFeel.getPlasticTheme().getWindowTitleInactiveForeground();
    }

    public static ColorUIResource getSimpleInternalFrameForeground() {
        return PlasticLookAndFeel.getPlasticTheme().getSimpleInternalFrameForeground();
    }

    public static ColorUIResource getSimpleInternalFrameBackground() {
        return PlasticLookAndFeel.getPlasticTheme().getSimpleInternalFrameBackground();
    }

    public static ColorUIResource getTitleTextColor() {
        return PlasticLookAndFeel.getPlasticTheme().getTitleTextColor();
    }

    public static ColorUIResource getTabForeground() {
        return PlasticLookAndFeel.getPlasticTheme().getTabForeground();
    }

    public static ColorUIResource getTabBackGround() {
        return PlasticLookAndFeel.getPlasticTheme().getTabBackGround();
    }

    public static FontUIResource getTitleTextFont() {
        return PlasticLookAndFeel.getPlasticTheme().getTitleTextFont();
    }

    public static ColorUIResource getPrimaryGradientStart() {
        return PlasticLookAndFeel.getInetTheme().getBlueGradientStart();
    }

    public static ColorUIResource getPrimaryGradientEnd() {
        return PlasticLookAndFeel.getInetTheme().getBlueGradientEnd();
    }

    public static ColorUIResource getSecondaryGradientStart() {
        return PlasticLookAndFeel.getInetTheme().getYellowGradientStart();
    }

    public static ColorUIResource getSecondaryGradientEnd() {
        return PlasticLookAndFeel.getInetTheme().getYellowGradientEnd();
    }

    private static MetalTheme getCurrentTheme0() {
        if (getCurrentThemeMethod != null) {
            try {
                return (MetalTheme)getCurrentThemeMethod.invoke(null, null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Method getMethodGetCurrentTheme() {
        try {
            Class<MetalLookAndFeel> clazz = MetalLookAndFeel.class;
            return clazz.getMethod("getCurrentTheme", new Class[0]);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    private static Object[] append(Object[] source, String key, Object value) {
        int length = source.length;
        Object[] destination = new Object[length + 2];
        System.arraycopy(source, 0, destination, 0, length);
        destination[length] = key;
        destination[length + 1] = value;
        return destination;
    }

    @Override
    public UIDefaults getDefaults() {
        return super.getDefaults();
    }
}

