/*
 * Decompiled with CFR 0.152.
 */
package com.inet.looks.plastic;

import com.inet.looks.plastic.PlasticUtils;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class PlasticProgressBarUI
extends BasicProgressBarUI {
    public static ComponentUI createUI(JComponent x2) {
        return new PlasticProgressBarUI();
    }

    public void paint(Graphics g2, JComponent c2) {
        if (this.progressBar.isIndeterminate()) {
            this.paintIndeterminate(g2, c2);
        } else {
            this.paintDeterminate(g2, c2);
        }
    }

    protected void paintDeterminate(Graphics g2, JComponent c2) {
        if (!(g2 instanceof Graphics2D)) {
            return;
        }
        Insets b2 = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth();
        int barRectHeight = this.progressBar.getHeight();
        int amountFull = this.getAmountFull(b2, barRectWidth, barRectHeight);
        Graphics2D g22 = (Graphics2D)g2;
        g22.setColor(this.progressBar.getForeground());
        if (this.progressBar.getOrientation() == 0) {
            PlasticUtils.paintToolBarGradient(g2, 0, 0, barRectWidth, barRectHeight);
            if (c2.getComponentOrientation().isLeftToRight()) {
                PlasticUtils.paintPopupHightlight(g22, 0, 0, amountFull, barRectHeight);
            } else {
                PlasticUtils.paintPopupHightlight(g22, barRectWidth - amountFull, 0, amountFull, barRectHeight);
            }
        } else {
            AffineTransform normal = g22.getTransform();
            g22.rotate(1.5707963267948966);
            g22.translate(0, -barRectWidth + 1);
            PlasticUtils.paintToolBarGradient(g2, 0, 0, c2.getHeight(), barRectWidth);
            PlasticUtils.paintPopupHightlight(g22, barRectHeight - amountFull, 0, amountFull, barRectWidth);
            g22.setTransform(normal);
        }
        if (this.progressBar.isStringPainted()) {
            this.paintString(g2, b2.left, b2.top, barRectWidth - (b2.right + b2.left), barRectHeight - (b2.top + b2.bottom), amountFull, b2);
        }
    }

    protected void paintIndeterminate(Graphics g2, JComponent c2) {
        if (!(g2 instanceof Graphics2D)) {
            return;
        }
        Insets b2 = this.progressBar.getInsets();
        if (b2 == null) {
            b2 = new Insets(0, 0, 0, 0);
        }
        int barRectWidth = this.progressBar.getWidth();
        int barRectHeight = this.progressBar.getHeight();
        Graphics2D g22 = (Graphics2D)g2;
        Rectangle box = this.getBox(this.boxRect);
        if (box != null) {
            AffineTransform normal = g22.getTransform();
            if (this.progressBar.getOrientation() != 0) {
                g22.rotate(1.5707963267948966);
                g22.translate(0, -barRectWidth + 1);
                PlasticUtils.paintToolBarGradient(g2, 0, 0, c2.getHeight(), barRectWidth);
                PlasticUtils.paintPopupHightlight(g2, box.x, box.y, box.width, box.height);
            } else {
                PlasticUtils.paintToolBarGradient(g2, 0, 0, barRectWidth, barRectHeight);
                PlasticUtils.paintPopupHightlight(g2, box.x, box.y, box.width, box.height);
            }
            g22.setTransform(normal);
            if (this.progressBar.isStringPainted()) {
                if (this.progressBar.getOrientation() == 0) {
                    this.paintString(g2, b2.left, b2.top, barRectWidth - (b2.right + b2.left), barRectHeight - (b2.top + b2.bottom), box.width, b2);
                } else {
                    this.paintString(g2, b2.left, b2.top, barRectWidth - (b2.right + b2.left), barRectHeight - (b2.top + b2.bottom), box.height, b2);
                }
            }
        }
    }
}

