/*
 * Decompiled with CFR 0.152.
 */
package com.inet.looks.plastic;

import com.inet.looks.plastic.PlasticTitlePane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;

public class PlasticRootPaneUI
extends BasicRootPaneUI {
    private static final String[] BORDER_KEYS;
    private static final int CORNER_DRAG_WIDTH = 16;
    private static final int BORDER_DRAG_THICKNESS = 3;
    private Window window;
    private PlasticTitlePane titlePane;
    private MouseInputListener mouseInputListener;
    private LayoutManager layoutManager;
    private LayoutManager savedOldLayout;
    private JRootPane root;
    private Cursor lastCursor = Cursor.getPredefinedCursor(0);
    private static final int[] CURSORMAPPINGS;

    static {
        String[] stringArray = new String[9];
        stringArray[1] = "RootPane.frameBorder";
        stringArray[2] = "RootPane.plainDialogBorder";
        stringArray[3] = "RootPane.informationDialogBorder";
        stringArray[4] = "RootPane.errorDialogBorder";
        stringArray[5] = "RootPane.colorChooserDialogBorder";
        stringArray[6] = "RootPane.fileChooserDialogBorder";
        stringArray[7] = "RootPane.questionDialogBorder";
        stringArray[8] = "RootPane.warningDialogBorder";
        BORDER_KEYS = stringArray;
        int[] nArray = new int[25];
        nArray[0] = 6;
        nArray[1] = 6;
        nArray[2] = 8;
        nArray[3] = 7;
        nArray[4] = 7;
        nArray[5] = 6;
        nArray[9] = 7;
        nArray[10] = 10;
        nArray[14] = 11;
        nArray[15] = 4;
        nArray[19] = 5;
        nArray[20] = 4;
        nArray[21] = 4;
        nArray[22] = 9;
        nArray[23] = 5;
        nArray[24] = 5;
        CURSORMAPPINGS = nArray;
    }

    public static ComponentUI createUI(JComponent c2) {
        return new PlasticRootPaneUI();
    }

    public void installUI(JComponent c2) {
        super.installUI(c2);
        this.root = (JRootPane)c2;
        int style = this.root.getWindowDecorationStyle();
        if (style != 0) {
            this.installClientDecorations(this.root);
        }
    }

    public void uninstallUI(JComponent c2) {
        super.uninstallUI(c2);
        this.uninstallClientDecorations(this.root);
        this.layoutManager = null;
        this.mouseInputListener = null;
        this.root = null;
    }

    void installBorder(JRootPane root) {
        int style = root.getWindowDecorationStyle();
        if (style == 0) {
            LookAndFeel.uninstallBorder(root);
        } else {
            LookAndFeel.installBorder(root, BORDER_KEYS[style]);
        }
    }

    private void uninstallBorder(JRootPane root) {
        LookAndFeel.uninstallBorder(root);
    }

    private void installWindowListeners(JRootPane root, Component parent) {
        this.window = parent instanceof Window ? (Window)parent : SwingUtilities.getWindowAncestor(parent);
        if (this.window != null) {
            if (this.mouseInputListener == null) {
                this.mouseInputListener = this.createWindowMouseInputListener(root);
            }
            this.window.addMouseListener(this.mouseInputListener);
            this.window.addMouseMotionListener(this.mouseInputListener);
        }
    }

    private void uninstallWindowListeners(JRootPane root) {
        if (this.window != null) {
            this.window.removeMouseListener(this.mouseInputListener);
            this.window.removeMouseMotionListener(this.mouseInputListener);
        }
    }

    private void installLayout(JRootPane root) {
        if (this.layoutManager == null) {
            this.layoutManager = this.createLayoutManager();
        }
        this.savedOldLayout = root.getLayout();
        root.setLayout(this.layoutManager);
    }

    private void uninstallLayout(JRootPane root) {
        if (this.savedOldLayout != null) {
            root.setLayout(this.savedOldLayout);
            this.savedOldLayout = null;
        }
    }

    private void installClientDecorations(JRootPane root) {
        this.installBorder(root);
        this.setTitlePane(root, this.createTitlePane(root));
        this.installWindowListeners(root, root.getParent());
        this.installLayout(root);
        if (this.window != null) {
            root.revalidate();
            root.repaint();
        }
    }

    private void uninstallClientDecorations(JRootPane root) {
        this.uninstallBorder(root);
        this.uninstallWindowListeners(root);
        this.setTitlePane(root, null);
        this.uninstallLayout(root);
        int style = root.getWindowDecorationStyle();
        if (style == 0) {
            root.repaint();
            root.revalidate();
        }
        if (this.window != null) {
            this.window.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.window = null;
    }

    private PlasticTitlePane createTitlePane(JRootPane root) {
        return new PlasticTitlePane(root, this);
    }

    private MouseInputListener createWindowMouseInputListener(JRootPane root) {
        return new MouseInputHandler();
    }

    private LayoutManager createLayoutManager() {
        return new MetalRootLayout();
    }

    private void setTitlePane(JRootPane root, PlasticTitlePane titlePane) {
        JLayeredPane layeredPane = root.getLayeredPane();
        PlasticTitlePane oldTitlePane = this.getTitlePane();
        if (oldTitlePane != null) {
            oldTitlePane.setVisible(false);
            layeredPane.remove(oldTitlePane);
        }
        if (titlePane != null) {
            layeredPane.add((Component)titlePane, JLayeredPane.FRAME_CONTENT_LAYER);
            titlePane.setVisible(true);
        }
        this.titlePane = titlePane;
    }

    private PlasticTitlePane getTitlePane() {
        return this.titlePane;
    }

    private JRootPane getRootPane() {
        return this.root;
    }

    public void propertyChange(PropertyChangeEvent e2) {
        super.propertyChange(e2);
        String propertyName = e2.getPropertyName();
        if (propertyName == null) {
            return;
        }
        if (propertyName.equals("windowDecorationStyle")) {
            JRootPane root = (JRootPane)e2.getSource();
            int style = root.getWindowDecorationStyle();
            boolean undecorated = false;
            if (root.getParent() instanceof Dialog) {
                undecorated = ((Dialog)root.getParent()).isUndecorated();
            } else if (root.getParent() instanceof Frame) {
                undecorated = ((Frame)root.getParent()).isUndecorated();
            }
            this.uninstallClientDecorations(root);
            if (style != 0) {
                this.installClientDecorations(root);
            }
        } else if (propertyName.equals("ancestor")) {
            this.uninstallWindowListeners(this.root);
            if (((JRootPane)e2.getSource()).getWindowDecorationStyle() != 0) {
                this.installWindowListeners(this.root, this.root.getParent());
            }
        }
    }

    private static class MetalRootLayout
    implements LayoutManager2 {
        private MetalRootLayout() {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension tpd;
            PlasticTitlePane titlePane;
            Dimension mbd;
            int cpWidth = 0;
            int cpHeight = 0;
            int mbWidth = 0;
            int mbHeight = 0;
            int tpWidth = 0;
            int tpHeight = 0;
            Insets i2 = parent.getInsets();
            JRootPane root = (JRootPane)parent;
            Dimension cpd = root.getContentPane() != null ? root.getContentPane().getPreferredSize() : root.getSize();
            if (cpd != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            if (root.getMenuBar() != null && (mbd = root.getMenuBar().getPreferredSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof PlasticRootPaneUI && (titlePane = ((PlasticRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = ((JComponent)titlePane).getPreferredSize()) != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            return new Dimension(Math.max(Math.max(cpWidth, mbWidth), tpWidth) + i2.left + i2.right, cpHeight + mbHeight + tpHeight + i2.top + i2.bottom);
        }

        public Dimension minimumLayoutSize(Container parent) {
            Dimension tpd;
            PlasticTitlePane titlePane;
            Dimension mbd;
            int cpWidth = 0;
            int cpHeight = 0;
            int mbWidth = 0;
            int mbHeight = 0;
            int tpWidth = 0;
            int tpHeight = 0;
            Insets i2 = parent.getInsets();
            JRootPane root = (JRootPane)parent;
            Dimension cpd = root.getContentPane() != null ? root.getContentPane().getMinimumSize() : root.getSize();
            if (cpd != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            if (root.getMenuBar() != null && (mbd = root.getMenuBar().getMinimumSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof PlasticRootPaneUI && (titlePane = ((PlasticRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = ((JComponent)titlePane).getMinimumSize()) != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            return new Dimension(Math.max(Math.max(cpWidth, mbWidth), tpWidth) + i2.left + i2.right, cpHeight + mbHeight + tpHeight + i2.top + i2.bottom);
        }

        public Dimension maximumLayoutSize(Container target) {
            int maxWidth;
            int maxHeight;
            Dimension tpd;
            PlasticTitlePane titlePane;
            Dimension mbd;
            Dimension cpd;
            int cpWidth = Integer.MAX_VALUE;
            int cpHeight = Integer.MAX_VALUE;
            int mbWidth = Integer.MAX_VALUE;
            int mbHeight = Integer.MAX_VALUE;
            int tpWidth = Integer.MAX_VALUE;
            int tpHeight = Integer.MAX_VALUE;
            Insets i2 = target.getInsets();
            JRootPane root = (JRootPane)target;
            if (root.getContentPane() != null && (cpd = root.getContentPane().getMaximumSize()) != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            if (root.getMenuBar() != null && (mbd = root.getMenuBar().getMaximumSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof PlasticRootPaneUI && (titlePane = ((PlasticRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getMaximumSize()) != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            if ((maxHeight = Math.max(Math.max(cpHeight, mbHeight), tpHeight)) != Integer.MAX_VALUE) {
                maxHeight = cpHeight + mbHeight + tpHeight + i2.top + i2.bottom;
            }
            if ((maxWidth = Math.max(Math.max(cpWidth, mbWidth), tpWidth)) != Integer.MAX_VALUE) {
                maxWidth += i2.left + i2.right;
            }
            return new Dimension(maxWidth, maxHeight);
        }

        public void layoutContainer(Container parent) {
            Dimension tpd;
            PlasticTitlePane titlePane;
            JRootPane root = (JRootPane)parent;
            Rectangle b2 = root.getBounds();
            Insets i2 = root.getInsets();
            int nextY = 0;
            int w2 = b2.width - i2.right - i2.left;
            int h2 = b2.height - i2.top - i2.bottom;
            if (root.getLayeredPane() != null) {
                root.getLayeredPane().setBounds(i2.left, i2.top, w2, h2);
            }
            if (root.getGlassPane() != null) {
                root.getGlassPane().setBounds(i2.left, i2.top, w2, h2);
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof PlasticRootPaneUI && (titlePane = ((PlasticRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = ((JComponent)titlePane).getPreferredSize()) != null) {
                int tpHeight = tpd.height;
                titlePane.setBounds(0, 0, w2, tpHeight);
                nextY += tpHeight;
            }
            if (root.getMenuBar() != null) {
                Dimension mbd = root.getMenuBar().getPreferredSize();
                root.getMenuBar().setBounds(0, nextY, w2, mbd.height);
                nextY += mbd.height;
            }
            if (root.getContentPane() != null) {
                root.getContentPane().getPreferredSize();
                root.getContentPane().setBounds(0, nextY, w2, h2 < nextY ? 0 : h2 - nextY);
            }
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public void addLayoutComponent(Component comp, Object constraints) {
        }

        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        public void invalidateLayout(Container target) {
        }
    }

    private class MouseInputHandler
    implements MouseInputListener {
        private boolean isMovingWindow;
        private int dragCursor;
        private int dragOffsetX;
        private int dragOffsetY;
        private int dragWidth;
        private int dragHeight;

        private MouseInputHandler() {
        }

        public void mousePressed(MouseEvent ev2) {
            int frameState;
            JRootPane rootPane = PlasticRootPaneUI.this.getRootPane();
            if (rootPane.getWindowDecorationStyle() == 0) {
                return;
            }
            Point dragWindowOffset = ev2.getPoint();
            Window w2 = (Window)ev2.getSource();
            if (w2 != null) {
                w2.toFront();
            }
            Point convertedDragWindowOffset = SwingUtilities.convertPoint(w2, dragWindowOffset, PlasticRootPaneUI.this.getTitlePane());
            Frame f2 = null;
            Dialog d2 = null;
            if (w2 instanceof Frame) {
                f2 = (Frame)w2;
            } else if (w2 instanceof Dialog) {
                d2 = (Dialog)w2;
            }
            int n2 = frameState = f2 != null ? f2.getExtendedState() : 0;
            if (PlasticRootPaneUI.this.getTitlePane() != null && PlasticRootPaneUI.this.getTitlePane().contains(convertedDragWindowOffset)) {
                if (ev2.getButton() == 3) {
                    PlasticRootPaneUI.this.getTitlePane().showMenu(convertedDragWindowOffset);
                }
                if ((f2 != null && (frameState & 6) == 0 || d2 != null) && dragWindowOffset.y >= 3 && dragWindowOffset.x >= 3 && dragWindowOffset.x < w2.getWidth() - 3) {
                    this.isMovingWindow = true;
                    this.dragOffsetX = dragWindowOffset.x;
                    this.dragOffsetY = dragWindowOffset.y;
                }
            } else if (f2 != null && f2.isResizable() && (frameState & 6) == 0 || d2 != null && d2.isResizable()) {
                this.dragOffsetX = dragWindowOffset.x;
                this.dragOffsetY = dragWindowOffset.y;
                this.dragWidth = w2.getWidth();
                this.dragHeight = w2.getHeight();
                this.dragCursor = this.getCursor(this.calculateCorner(w2, dragWindowOffset.x, dragWindowOffset.y));
            }
        }

        public void mouseReleased(MouseEvent ev2) {
            if (this.dragCursor != 0 && PlasticRootPaneUI.this.window != null && !PlasticRootPaneUI.this.window.isValid()) {
                PlasticRootPaneUI.this.window.validate();
                PlasticRootPaneUI.this.getRootPane().repaint();
            }
            this.isMovingWindow = false;
            this.dragCursor = 0;
        }

        public void mouseMoved(MouseEvent ev2) {
            JRootPane root = PlasticRootPaneUI.this.getRootPane();
            if (root.getWindowDecorationStyle() == 0) {
                return;
            }
            Window w2 = (Window)ev2.getSource();
            Frame f2 = null;
            Dialog d2 = null;
            if (w2 instanceof Frame) {
                f2 = (Frame)w2;
            } else if (w2 instanceof Dialog) {
                d2 = (Dialog)w2;
            }
            int cursor = this.getCursor(this.calculateCorner(w2, ev2.getX(), ev2.getY()));
            if (cursor != 0 && (f2 != null && f2.isResizable() && (f2.getExtendedState() & 6) == 0 || d2 != null && d2.isResizable())) {
                w2.setCursor(Cursor.getPredefinedCursor(cursor));
            } else {
                w2.setCursor(PlasticRootPaneUI.this.lastCursor);
            }
        }

        private void adjust(Rectangle bounds, Dimension min, int deltaX, int deltaY, int deltaWidth, int deltaHeight) {
            bounds.x += deltaX;
            bounds.y += deltaY;
            bounds.width += deltaWidth;
            bounds.height += deltaHeight;
            if (min != null) {
                int correction;
                if (bounds.width < min.width) {
                    correction = min.width - bounds.width;
                    if (deltaX != 0) {
                        bounds.x -= correction;
                    }
                    bounds.width = min.width;
                }
                if (bounds.height < min.height) {
                    correction = min.height - bounds.height;
                    if (deltaY != 0) {
                        bounds.y -= correction;
                    }
                    bounds.height = min.height;
                }
            }
        }

        public void mouseDragged(MouseEvent ev2) {
            Window w2 = (Window)ev2.getSource();
            Point pt = ev2.getPoint();
            if (this.isMovingWindow) {
                Point windowPt = w2.getLocationOnScreen();
                windowPt.x += pt.x - this.dragOffsetX;
                windowPt.y += pt.y - this.dragOffsetY;
                w2.setLocation(windowPt);
            } else if (this.dragCursor != 0) {
                Rectangle r2 = w2.getBounds();
                Rectangle startBounds = new Rectangle(r2);
                Dimension min = w2.getMinimumSize();
                switch (this.dragCursor) {
                    case 11: {
                        this.adjust(r2, min, 0, 0, pt.x + (this.dragWidth - this.dragOffsetX) - r2.width, 0);
                        break;
                    }
                    case 9: {
                        this.adjust(r2, min, 0, 0, 0, pt.y + (this.dragHeight - this.dragOffsetY) - r2.height);
                        break;
                    }
                    case 8: {
                        this.adjust(r2, min, 0, pt.y - this.dragOffsetY, 0, -(pt.y - this.dragOffsetY));
                        break;
                    }
                    case 10: {
                        this.adjust(r2, min, pt.x - this.dragOffsetX, 0, -(pt.x - this.dragOffsetX), 0);
                        break;
                    }
                    case 7: {
                        this.adjust(r2, min, 0, pt.y - this.dragOffsetY, pt.x + (this.dragWidth - this.dragOffsetX) - r2.width, -(pt.y - this.dragOffsetY));
                        break;
                    }
                    case 5: {
                        this.adjust(r2, min, 0, 0, pt.x + (this.dragWidth - this.dragOffsetX) - r2.width, pt.y + (this.dragHeight - this.dragOffsetY) - r2.height);
                        break;
                    }
                    case 6: {
                        this.adjust(r2, min, pt.x - this.dragOffsetX, pt.y - this.dragOffsetY, -(pt.x - this.dragOffsetX), -(pt.y - this.dragOffsetY));
                        break;
                    }
                    case 4: {
                        this.adjust(r2, min, pt.x - this.dragOffsetX, 0, -(pt.x - this.dragOffsetX), pt.y + (this.dragHeight - this.dragOffsetY) - r2.height);
                        break;
                    }
                }
                if (!r2.equals(startBounds)) {
                    w2.setBounds(r2);
                    if (Toolkit.getDefaultToolkit().isDynamicLayoutActive()) {
                        w2.validate();
                        PlasticRootPaneUI.this.getRootPane().repaint();
                    }
                }
            }
        }

        public void mouseEntered(MouseEvent ev2) {
            Window w2 = this.windowForEvent(ev2);
            PlasticRootPaneUI.this.lastCursor = w2.getCursor();
            if (PlasticRootPaneUI.this.lastCursor.getType() != 8 || PlasticRootPaneUI.this.lastCursor.getType() != 7 || PlasticRootPaneUI.this.lastCursor.getType() != 6 || PlasticRootPaneUI.this.lastCursor.getType() != 10 || PlasticRootPaneUI.this.lastCursor.getType() != 11 || PlasticRootPaneUI.this.lastCursor.getType() != 9 || PlasticRootPaneUI.this.lastCursor.getType() != 5 || PlasticRootPaneUI.this.lastCursor.getType() != 4) {
                PlasticRootPaneUI.this.lastCursor = Cursor.getPredefinedCursor(0);
            }
            this.mouseMoved(ev2);
        }

        public void mouseExited(MouseEvent ev2) {
            Window w2 = this.windowForEvent(ev2);
            w2.setCursor(PlasticRootPaneUI.this.lastCursor);
        }

        public void mouseClicked(MouseEvent ev2) {
            Window w2 = (Window)ev2.getSource();
            Frame f2 = null;
            if (!(w2 instanceof Frame)) {
                return;
            }
            f2 = (Frame)w2;
            Point convertedPoint = SwingUtilities.convertPoint(w2, ev2.getPoint(), PlasticRootPaneUI.this.getTitlePane());
            int state = f2.getExtendedState();
            if (PlasticRootPaneUI.this.getTitlePane() != null && PlasticRootPaneUI.this.getTitlePane().contains(convertedPoint) && ev2.getClickCount() % 2 == 0 && (ev2.getModifiers() & 0x10) != 0 && f2.isResizable()) {
                if ((state & 6) != 0) {
                    f2.setExtendedState(state & 0xFFFFFFF9);
                    PlasticRootPaneUI.this.installBorder(PlasticRootPaneUI.this.root);
                } else {
                    GraphicsConfiguration graphicsConfiguration = f2.getGraphicsConfiguration();
                    Rectangle screenbounds = graphicsConfiguration.getBounds();
                    Insets screenInsets = f2.getToolkit().getScreenInsets(graphicsConfiguration);
                    f2.setMaximizedBounds(new Rectangle(screenInsets.left, screenInsets.top, screenbounds.width - screenInsets.left - screenInsets.right, screenbounds.height - screenInsets.top - screenInsets.bottom));
                    f2.setExtendedState(state | 6);
                }
                return;
            }
        }

        private int calculateCorner(Component c2, int x2, int y2) {
            int xPosition = this.calculatePosition(x2, c2.getWidth());
            int yPosition = this.calculatePosition(y2, c2.getHeight());
            if (xPosition == -1 || yPosition == -1) {
                return -1;
            }
            return yPosition * 5 + xPosition;
        }

        private Window windowForEvent(MouseEvent ev2) {
            Component source = (Component)ev2.getSource();
            return source instanceof Window ? (Window)source : SwingUtilities.getWindowAncestor(source);
        }

        private int getCursor(int corner) {
            if (corner == -1) {
                return 0;
            }
            return CURSORMAPPINGS[corner];
        }

        private int calculatePosition(int spot, int width) {
            if (spot < 3) {
                return 0;
            }
            if (spot < 16) {
                return 1;
            }
            if (spot >= width - 3) {
                return 4;
            }
            if (spot >= width - 16) {
                return 3;
            }
            return 2;
        }
    }
}

