/*
 * Decompiled with CFR 0.152.
 */
package com.inet.looks.plastic;

import com.inet.looks.plastic.PlasticArrowButton;
import com.inet.looks.plastic.PlasticUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalScrollBarUI;

public final class PlasticScrollBarUI
extends MetalScrollBarUI {
    private static final String PROPERTY_PREFIX = "ScrollBar.";
    public static final String MAX_BUMPS_WIDTH_KEY = "ScrollBar.maxBumpsWidth";
    private Color shadowColor;
    private Color highlightColor;
    private Color thumbColor;

    public static ComponentUI createUI(JComponent b2) {
        return new PlasticScrollBarUI();
    }

    protected void installDefaults() {
        super.installDefaults();
    }

    protected JButton createDecreaseButton(int orientation) {
        this.decreaseButton = new PlasticArrowButton(orientation, this.scrollBarWidth, this.isFreeStanding);
        return this.decreaseButton;
    }

    protected JButton createIncreaseButton(int orientation) {
        this.increaseButton = new PlasticArrowButton(orientation, this.scrollBarWidth, this.isFreeStanding);
        return this.increaseButton;
    }

    protected void configureScrollBarColors() {
        super.configureScrollBarColors();
        this.shadowColor = UIManager.getColor("ScrollBar.shadow");
        this.highlightColor = UIManager.getColor("ScrollBar.highlight");
        this.thumbColor = UIManager.getColor("ScrollBar.thumb");
    }

    protected void paintTrack(Graphics g2, JComponent c2, Rectangle trackBounds) {
        g2.setColor(this.thumbColor);
        g2.fillRect(trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height);
    }

    protected void paintThumb(Graphics g2, JComponent c2, Rectangle thumbBounds) {
        if (!c2.isEnabled()) {
            return;
        }
        boolean leftToRight = PlasticUtils.isLeftToRight(c2);
        g2.translate(thumbBounds.x, thumbBounds.y);
        if (this.scrollbar.getOrientation() == 1) {
            if (!this.isFreeStanding) {
                if (!leftToRight) {
                    ++thumbBounds.width;
                    g2.translate(-1, 0);
                } else {
                    thumbBounds.width += 2;
                }
            }
            PlasticUtils.paintPrimaryGradient(g2, 0, 0, thumbBounds.width - 2, thumbBounds.height - 1, 1);
            PlasticUtils.paintPrimaryGradient(g2, 3, 2, thumbBounds.width - 7, thumbBounds.height - 4, 2);
            g2.setColor(this.shadowColor);
            g2.drawRect(0, 0, thumbBounds.width - 2, thumbBounds.height - 1);
            this.paintRibbon(g2, 0, 0, thumbBounds.width - 2, thumbBounds.height - 1);
            if (!this.isFreeStanding) {
                if (!leftToRight) {
                    --thumbBounds.width;
                    g2.translate(1, 0);
                } else {
                    thumbBounds.width -= 2;
                }
            }
        } else {
            if (!this.isFreeStanding) {
                thumbBounds.height += 2;
            }
            PlasticUtils.paintPrimaryGradient(g2, 0, 0, thumbBounds.width - 1, thumbBounds.height - 2, 0);
            PlasticUtils.paintPrimaryGradient(g2, 2, 3, thumbBounds.width - 5, thumbBounds.height - 7, 3);
            g2.setColor(this.shadowColor);
            g2.drawRect(0, 0, thumbBounds.width - 1, thumbBounds.height - 2);
            this.paintRibbon(g2, 0, 0, thumbBounds.width - 1, thumbBounds.height - 2);
            if (!this.isFreeStanding) {
                thumbBounds.height -= 2;
            }
        }
        g2.translate(-thumbBounds.x, -thumbBounds.y);
    }

    private void paintRibbon(Graphics g2, int x2, int y2, int width, int height) {
        int i2;
        int t2;
        if (this.scrollbar.getOrientation() == 1) {
            t2 = (y2 + height) / 2 - 4;
            i2 = 0;
            while (i2 < 4) {
                g2.setColor(this.shadowColor);
                g2.drawLine(x2 + 4, t2 + i2 * 3, width - 4, t2 + i2 * 3);
                g2.setColor(this.highlightColor);
                g2.drawLine(x2 + 4, t2 + i2 * 3 + 1, width - 4, t2 + i2 * 3 + 1);
                ++i2;
            }
        }
        if (this.scrollbar.getOrientation() == 0) {
            t2 = (x2 + width) / 2 - 4;
            i2 = 0;
            while (i2 < 4) {
                g2.setColor(this.shadowColor);
                g2.drawLine(t2 + i2 * 3, y2 + 4, t2 + i2 * 3, height - 4);
                g2.setColor(this.highlightColor);
                g2.drawLine(t2 + i2 * 3 + 1, y2 + 4, t2 + i2 * 3 + 1, height - 4);
                ++i2;
            }
        }
    }
}

