/*
 * Decompiled with CFR 0.152.
 */
package com.inet.looks.plastic;

import com.inet.looks.plastic.PlasticLookAndFeel;
import com.inet.looks.plastic.PlasticUtils;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalScrollPaneUI;

public final class PlasticScrollPaneUI
extends MetalScrollPaneUI {
    private PropertyChangeListener borderStyleChangeHandler;

    public static ComponentUI createUI(JComponent b2) {
        return new PlasticScrollPaneUI();
    }

    protected void installDefaults(JScrollPane scrollPane) {
        super.installDefaults(scrollPane);
        this.installEtchedBorder(scrollPane);
    }

    public void installListeners(JScrollPane scrollPane) {
        super.installListeners(scrollPane);
        this.borderStyleChangeHandler = new BorderStyleChangeHandler();
        scrollPane.addPropertyChangeListener("inet.isEtched", this.borderStyleChangeHandler);
    }

    protected void uninstallListeners(JComponent c2) {
        ((JScrollPane)c2).removePropertyChangeListener("inet.isEtched", this.borderStyleChangeHandler);
        super.uninstallListeners(c2);
    }

    protected void installEtchedBorder(JScrollPane scrollPane) {
        Object value = scrollPane.getClientProperty("inet.isEtched");
        boolean hasEtchedBorder = Boolean.TRUE.equals(value);
        LookAndFeel.installBorder(scrollPane, hasEtchedBorder ? "ScrollPane.etchedBorder" : "ScrollPane.border");
    }

    public void paint(Graphics g2, JComponent c2) {
        JViewport vp = ((JScrollPane)c2).getColumnHeader();
        if (vp != null) {
            int height = (int)vp.getSize().getHeight();
            PlasticUtils.paintPrimaryGradient(g2, 0, 0, c2.getWidth(), height, 3);
            PlasticUtils.drawThinFlush3DBorder(g2, 1, 1, c2.getWidth(), height);
            g2.setColor(PlasticLookAndFeel.getControlDarkShadow());
            g2.drawRect(2, 0, c2.getWidth(), height);
        }
    }

    private class BorderStyleChangeHandler
    implements PropertyChangeListener {
        private BorderStyleChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            JScrollPane scrollPane = (JScrollPane)evt.getSource();
            PlasticScrollPaneUI.this.installEtchedBorder(scrollPane);
        }
    }
}

