/*
 * Decompiled with CFR 0.152.
 */
package com.inet.looks.plastic;

import com.inet.looks.common.ExtBasicArrowButtonHandler;
import com.inet.looks.common.ExtBasicSpinnerLayout;
import com.inet.looks.plastic.PlasticArrowButton;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSpinnerUI;

public class PlasticSpinnerUI
extends BasicSpinnerUI {
    private static final ExtBasicArrowButtonHandler nextButtonHandler = new ExtBasicArrowButtonHandler("increment", true);
    private static final ExtBasicArrowButtonHandler previousButtonHandler = new ExtBasicArrowButtonHandler("decrement", false);

    public static ComponentUI createUI(JComponent b2) {
        return new PlasticSpinnerUI();
    }

    protected Component createPreviousButton() {
        return new SpinnerArrowButton(5, previousButtonHandler);
    }

    protected Component createNextButton() {
        return new SpinnerArrowButton(1, nextButtonHandler);
    }

    protected LayoutManager createLayout() {
        return new ExtBasicSpinnerLayout();
    }

    protected JComponent createEditor() {
        JComponent editor = this.spinner.getEditor();
        this.configureEditorBorder(editor);
        return editor;
    }

    protected void replaceEditor(JComponent oldEditor, JComponent newEditor) {
        this.spinner.remove(oldEditor);
        this.configureEditorBorder(newEditor);
        this.spinner.add((Component)newEditor, "Editor");
    }

    private void configureEditorBorder(JComponent editor) {
        if (editor instanceof JSpinner.DefaultEditor) {
            JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)editor;
            JFormattedTextField editorField = defaultEditor.getTextField();
            Insets insets = UIManager.getInsets("Spinner.defaultEditorInsets");
            editorField.setBorder(new EmptyBorder(insets));
        } else if (editor instanceof JPanel && editor.getBorder() == null && editor.getComponentCount() > 0) {
            JComponent editorField = (JComponent)editor.getComponent(0);
            Insets insets = UIManager.getInsets("Spinner.defaultEditorInsets");
            editorField.setBorder(new EmptyBorder(insets));
        }
    }

    private static final class SpinnerArrowButton
    extends PlasticArrowButton {
        private static final long serialVersionUID = 1L;

        private SpinnerArrowButton(int direction, ExtBasicArrowButtonHandler handler) {
            super(direction, UIManager.getInt("ScrollBar.width"), true);
            this.addActionListener(handler);
            this.addMouseListener(handler);
        }

        protected int calculateArrowHeight(int height, int width) {
            int arrowHeight = Math.min((height - 4) / 3, (width - 4) / 3);
            return Math.max(arrowHeight, 3);
        }

        protected int calculateArrowOffset() {
            return 1;
        }

        protected boolean isPaintingNorthBottom() {
            return true;
        }
    }
}

