/*
 * Decompiled with CFR 0.152.
 */
package com.inet.looks.plastic;

import com.inet.looks.plastic.PlasticUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class PlasticTableHeaderUI
extends BasicTableHeaderUI {
    private int magins = 0;

    public static ComponentUI createUI(JComponent h2) {
        return new PlasticTableHeaderUI();
    }

    public void installUI(JComponent c2) {
        this.header = (JTableHeader)c2;
        this.rendererPane = new CellRendererPane();
        this.header.add(this.rendererPane);
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void paint(Graphics g2, JComponent c2) {
        int column;
        if (this.header.getColumnModel().getColumnCount() <= 0) {
            return;
        }
        boolean ltr = this.header.getComponentOrientation().isLeftToRight();
        Rectangle clip = g2.getClipBounds();
        Point left = clip.getLocation();
        Point right = new Point(clip.x + clip.width - 1, clip.y);
        TableColumnModel cm2 = this.header.getColumnModel();
        int cMin = this.header.columnAtPoint(ltr ? left : right);
        int cMax = this.header.columnAtPoint(ltr ? right : left);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = cm2.getColumnCount() - 1;
        }
        TableColumn draggedColumn = this.header.getDraggedColumn();
        int columnMargin = cm2.getColumnMargin();
        Rectangle cellRect = this.header.getHeaderRect(cMin);
        Rectangle rect = this.header.getBounds();
        PlasticUtils.paintPrimaryGradient(g2, 0, 0, rect.width, rect.height, 3);
        PlasticUtils.drawThinFlush3DBorder(g2, 0, 0, rect.width + 3, rect.height);
        if (ltr) {
            column = cMin;
            while (column <= cMax) {
                TableColumn aColumn = cm2.getColumn(column);
                int columnWidth = aColumn.getWidth();
                cellRect.width = columnWidth - columnMargin;
                if (aColumn != draggedColumn) {
                    this.paintCell(g2, cellRect, column, false);
                }
                cellRect.x += columnWidth;
                ++column;
            }
        } else {
            int columnWidth;
            TableColumn aColumn = cm2.getColumn(cMin);
            if (aColumn != draggedColumn) {
                columnWidth = aColumn.getWidth();
                cellRect.width = columnWidth - columnMargin;
                cellRect.x += columnMargin;
                this.paintCell(g2, cellRect, cMin, false);
            }
            column = cMin + 1;
            while (column <= cMax) {
                aColumn = cm2.getColumn(column);
                columnWidth = aColumn.getWidth();
                cellRect.width = columnWidth - columnMargin;
                cellRect.x -= columnWidth;
                if (aColumn != draggedColumn) {
                    this.paintCell(g2, cellRect, column, false);
                }
                ++column;
            }
        }
        if (draggedColumn != null) {
            int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
            Rectangle draggedCellRect = this.header.getHeaderRect(draggedColumnIndex);
            draggedCellRect.x += this.header.getDraggedDistance();
            this.paintCell(g2, draggedCellRect, draggedColumnIndex, true);
        }
        this.rendererPane.removeAll();
    }

    private int viewIndexForColumn(TableColumn aColumn) {
        TableColumnModel cm2 = this.header.getColumnModel();
        int column = 0;
        while (column < cm2.getColumnCount()) {
            if (cm2.getColumn(column) == aColumn) {
                return column;
            }
            ++column;
        }
        return -1;
    }

    private void paintCell(Graphics g2, Rectangle cellRect, int columnIndex, boolean isDragging) {
        JComponent c2 = (JComponent)this.getHeaderRenderer(columnIndex);
        if (isDragging) {
            PlasticUtils.paintSecondaryGradient(g2, cellRect.x, cellRect.y, cellRect.width, cellRect.height, 3);
        } else {
            PlasticUtils.paintPrimaryGradient(g2, cellRect.x + this.magins, cellRect.y, cellRect.width - 2 * this.magins, cellRect.height, 3);
        }
        c2.setBorder(new EmptyBorder(0, 4, 0, 4));
        this.rendererPane.paintComponent(g2, c2, this.header, cellRect.x + this.magins, cellRect.y, cellRect.width - 2 * this.magins, cellRect.height, true);
        PlasticUtils.drawThinFlush3DBorder(g2, cellRect.x, cellRect.y, cellRect.width, cellRect.height);
    }

    private Component getHeaderRenderer(int columnIndex) {
        TableColumn aColumn = this.header.getColumnModel().getColumn(columnIndex);
        TableCellRenderer renderer = aColumn.getHeaderRenderer();
        if (renderer == null) {
            renderer = this.header.getDefaultRenderer();
        }
        return renderer.getTableCellRendererComponent(this.header.getTable(), aColumn.getHeaderValue(), false, false, -1, columnIndex);
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    private TableColumn getResizingColumn(Point p2, int column) {
        int columnIndex;
        if (column == -1) {
            return null;
        }
        Rectangle r2 = this.header.getHeaderRect(column);
        r2.grow(-3, 0);
        if (r2.contains(p2)) {
            return null;
        }
        int midPoint = r2.x + r2.width / 2;
        if (this.header.getComponentOrientation().isLeftToRight()) {
            columnIndex = p2.x < midPoint ? column - 1 : column;
        } else {
            int n2 = columnIndex = p2.x < midPoint ? column : column - 1;
        }
        if (columnIndex == -1) {
            return null;
        }
        return this.header.getColumnModel().getColumn(columnIndex);
    }

    class MouseInputHandler
    extends BasicTableHeaderUI.MouseInputHandler {
        private int mouseXOffset;

        MouseInputHandler() {
            super(PlasticTableHeaderUI.this);
        }

        public void mouseDragged(MouseEvent e2) {
            int mouseX = e2.getX();
            TableColumn resizingColumn = PlasticTableHeaderUI.this.header.getResizingColumn();
            TableColumn draggedColumn = PlasticTableHeaderUI.this.header.getDraggedColumn();
            boolean headerLeftToRight = PlasticTableHeaderUI.this.header.getComponentOrientation().isLeftToRight();
            if (resizingColumn != null) {
                JTable table;
                Container container;
                int oldWidth = resizingColumn.getWidth();
                int newWidth = headerLeftToRight ? mouseX - this.mouseXOffset : this.mouseXOffset - mouseX;
                resizingColumn.setWidth(newWidth);
                if (PlasticTableHeaderUI.this.header.getParent() == null || (container = PlasticTableHeaderUI.this.header.getParent().getParent()) == null || !(container instanceof JScrollPane)) {
                    return;
                }
                if (!container.getComponentOrientation().isLeftToRight() && !headerLeftToRight && (table = PlasticTableHeaderUI.this.header.getTable()) != null) {
                    JViewport viewport = ((JScrollPane)container).getViewport();
                    int viewportWidth = viewport.getWidth();
                    int diff = newWidth - oldWidth;
                    int newHeaderWidth = table.getWidth() + diff;
                    Dimension tableSize = table.getSize();
                    tableSize.width += diff;
                    table.setSize(tableSize);
                    if (newHeaderWidth >= viewportWidth && table.getAutoResizeMode() == 0) {
                        Point p2 = viewport.getViewPosition();
                        p2.x = Math.max(0, Math.min(newHeaderWidth - viewportWidth, p2.x + diff));
                        viewport.setViewPosition(p2);
                        this.mouseXOffset += diff;
                    }
                }
            } else if (draggedColumn != null) {
                TableColumnModel cm2 = PlasticTableHeaderUI.this.header.getColumnModel();
                int draggedDistance = mouseX - this.mouseXOffset;
                int direction = draggedDistance < 0 ? -1 : 1;
                int columnIndex = PlasticTableHeaderUI.this.viewIndexForColumn(draggedColumn);
                int newColumnIndex = columnIndex + (headerLeftToRight ? direction : -direction);
                if (newColumnIndex >= 0 && newColumnIndex < cm2.getColumnCount()) {
                    int width = cm2.getColumn(newColumnIndex).getWidth();
                    if (Math.abs(draggedDistance) > width / 2) {
                        cm2.moveColumn(columnIndex, newColumnIndex);
                        if (PlasticTableHeaderUI.this.viewIndexForColumn(draggedColumn) == newColumnIndex) {
                            this.mouseXOffset += direction * width;
                            PlasticTableHeaderUI.this.header.setDraggedDistance(draggedDistance - direction * width);
                            return;
                        }
                    }
                }
                this.setDraggedDistance(draggedDistance, columnIndex);
            }
        }

        private boolean canResize(TableColumn column) {
            return column != null && PlasticTableHeaderUI.this.header.getResizingAllowed() && column.getResizable();
        }

        public void mousePressed(MouseEvent e2) {
            PlasticTableHeaderUI.this.header.setDraggedColumn(null);
            PlasticTableHeaderUI.this.header.setResizingColumn(null);
            PlasticTableHeaderUI.this.header.setDraggedDistance(0);
            Point p2 = e2.getPoint();
            TableColumnModel columnModel = PlasticTableHeaderUI.this.header.getColumnModel();
            int index = PlasticTableHeaderUI.this.header.columnAtPoint(p2);
            if (index != -1) {
                TableColumn resizingColumn = PlasticTableHeaderUI.this.getResizingColumn(p2, index);
                if (this.canResize(resizingColumn)) {
                    PlasticTableHeaderUI.this.header.setResizingColumn(resizingColumn);
                    this.mouseXOffset = PlasticTableHeaderUI.this.header.getComponentOrientation().isLeftToRight() ? p2.x - resizingColumn.getWidth() : p2.x + resizingColumn.getWidth();
                } else if (PlasticTableHeaderUI.this.header.getReorderingAllowed()) {
                    TableColumn hitColumn = columnModel.getColumn(index);
                    PlasticTableHeaderUI.this.header.setDraggedColumn(hitColumn);
                    this.mouseXOffset = p2.x;
                }
            }
        }

        private void setDraggedDistance(int draggedDistance, int column) {
            PlasticTableHeaderUI.this.header.setDraggedDistance(draggedDistance);
            if (column != -1) {
                PlasticTableHeaderUI.this.header.getColumnModel().moveColumn(column, column);
            }
        }
    }
}

