/*
 * Decompiled with CFR 0.152.
 */
package com.inet.looks.plastic;

import com.inet.looks.plastic.PlasticFieldCaret;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalTextFieldUI;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public final class PlasticTextFieldUI
extends MetalTextFieldUI {
    private JTextComponent text;
    final UndoManager manager = new UndoManager();

    public void installUI(JComponent c2) {
        super.installUI(c2);
        this.text = (JTextComponent)c2;
        this.registerUndoListerner();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getPropertyName().equalsIgnoreCase("document")) {
            Object newDoc = evt.getNewValue();
            Object oldDoc = evt.getOldValue();
            if (oldDoc != null && oldDoc instanceof Document) {
                ((Document)oldDoc).removeUndoableEditListener(this.manager);
            }
            if (newDoc != null && newDoc instanceof Document) {
                ((Document)newDoc).addUndoableEditListener(this.manager);
            }
        }
    }

    private void registerUndoListerner() {
        this.text.getActionMap().put("Undo", new AbstractAction("Undo"){

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (PlasticTextFieldUI.this.manager.canUndo()) {
                        PlasticTextFieldUI.this.manager.undo();
                    }
                }
                catch (CannotUndoException e2) {
                    e2.printStackTrace();
                }
            }
        });
        this.text.getInputMap().put(KeyStroke.getKeyStroke("control Z"), "Undo");
        this.text.getActionMap().put("Redo", new AbstractAction("Redo"){

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (PlasticTextFieldUI.this.manager.canRedo()) {
                        PlasticTextFieldUI.this.manager.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
        this.text.getInputMap().put(KeyStroke.getKeyStroke("control Y"), "Redo");
    }

    public void uninstallUI(JComponent c2) {
        super.uninstallUI(c2);
        this.text = null;
    }

    public static ComponentUI createUI(JComponent c2) {
        return new PlasticTextFieldUI();
    }

    protected Caret createCaret() {
        return new PlasticFieldCaret();
    }
}

