/*
 * Decompiled with CFR 0.152.
 */
package com.inet.looks.plastic;

import com.inet.looks.plastic.PlasticBorders;
import com.inet.looks.plastic.PlasticRootPaneUI;
import com.inet.looks.plastic.PlasticUtils;
import com.inet.looks.plastic.PlasticXPUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class PlasticTitlePane
extends JComponent {
    private static final long serialVersionUID = 1L;
    private JLabel lblTitle = new JLabel();
    JPopupMenu menu;
    private PropertyChangeListener propertyChangeListener;
    private Action closeAction;
    private Action iconifyAction;
    private Action restoreAction;
    private Action maximizeAction;
    private JButton toggleButton;
    private JButton iconifyButton;
    private JButton closeButton;
    private Icon maximizeIcon;
    private Icon minimizeIcon;
    private WindowListener windowListener;
    private Window window;
    private JRootPane rootPane;
    private int state;
    private PlasticRootPaneUI rootPaneUI;
    private Color inactiveBackground = UIManager.getColor("inactiveCaption");
    private Color inactiveShadow = UIManager.getColor("inactiveCaptionBorder");
    private Color highlight = MetalLookAndFeel.getPrimaryControlHighlight();
    private Color activeBackground = null;
    private Color activeShadow = null;
    Icon WindowIcon;

    public PlasticTitlePane(JRootPane root, PlasticRootPaneUI ui) {
        this.rootPane = root;
        this.rootPaneUI = ui;
        this.state = -1;
        Border border = PlasticBorders.getTitlePaneBorder();
        this.setBorder(border);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0);
        if (this.getWindowDecorationStyle() == 1) {
            this.closeAction = new CloseAction();
            this.iconifyAction = new IconifyAction();
            this.restoreAction = new RestoreAction();
            this.maximizeAction = new MaximizeAction();
            this.add(Box.createHorizontalStrut(3), gbc);
            this.lblTitle.setForeground(this.activeBackground);
            ++gbc.gridx;
            gbc.weightx = 1.0;
            this.add((Component)this.lblTitle, gbc);
            this.add(Box.createHorizontalGlue());
            this.createButtons();
            gbc.weightx = 0.0;
            ++gbc.gridx;
            this.add((Component)this.iconifyButton, gbc);
            ++gbc.gridx;
            this.add((Component)this.toggleButton, gbc);
            ++gbc.gridx;
            this.add((Component)this.closeButton, gbc);
        } else if (this.getWindowDecorationStyle() == 2 || this.getWindowDecorationStyle() == 5 || this.getWindowDecorationStyle() == 4 || this.getWindowDecorationStyle() == 6 || this.getWindowDecorationStyle() == 3 || this.getWindowDecorationStyle() == 7 || this.getWindowDecorationStyle() == 8) {
            this.closeAction = new CloseAction();
            this.add(Box.createHorizontalStrut(3), gbc);
            this.lblTitle.setForeground(this.activeBackground);
            ++gbc.gridx;
            gbc.weightx = 1.0;
            this.add((Component)this.lblTitle, gbc);
            gbc.weightx = 0.0;
            ++gbc.gridx;
            this.add(Box.createHorizontalGlue(), gbc);
            this.createButtons();
            ++gbc.gridx;
            this.add((Component)this.closeButton, gbc);
        }
        this.lblTitle.setAlignmentY(0.4f);
        this.determineColors();
        this.installDefaults();
    }

    public void showMenu(Point pos) {
        if (this.menu == null) {
            this.menu = this.createMenu();
        }
        if (this.menu.getComponentCount() > 0) {
            this.menu.show(this, pos.x, pos.y);
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Dimension preferredSize = this.lblTitle.getPreferredSize();
        dimension.width = dimension.width - preferredSize.width + 50;
        return dimension;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        Dimension preferredSize = this.lblTitle.getMinimumSize();
        dimension.width = dimension.width - preferredSize.width + 50;
        return dimension;
    }

    private void installListeners() {
        if (this.window != null) {
            this.windowListener = this.createWindowListener();
            this.window.addWindowListener(this.windowListener);
            this.propertyChangeListener = this.createWindowPropertyChangeListener();
            this.window.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    private void uninstallListeners() {
        if (this.window != null) {
            this.window.removeWindowListener(this.windowListener);
            this.window.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    private WindowListener createWindowListener() {
        return new WindowHandler();
    }

    private PropertyChangeListener createWindowPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    private int getWindowDecorationStyle() {
        return this.getRootPane().getWindowDecorationStyle();
    }

    public void addNotify() {
        super.addNotify();
        this.uninstallListeners();
        this.window = SwingUtilities.getWindowAncestor(this);
        if (this.window != null) {
            if (this.window instanceof Frame) {
                this.setState(((Frame)this.window).getExtendedState());
            } else {
                this.setState(0);
            }
            this.setActive(this.window.isActive());
            this.installListeners();
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.uninstallListeners();
        this.window = null;
    }

    private void determineColors() {
        switch (this.getWindowDecorationStyle()) {
            case 1: {
                this.activeBackground = UIManager.getColor("activeCaption");
                this.activeShadow = UIManager.getColor("activeCaptionBorder");
                break;
            }
            case 4: {
                this.activeBackground = UIManager.getColor("OptionPane.errorDialog.titlePane.background");
                this.activeShadow = UIManager.getColor("OptionPane.errorDialog.titlePane.shadow");
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                this.activeBackground = UIManager.getColor("OptionPane.questionDialog.titlePane.background");
                this.activeShadow = UIManager.getColor("OptionPane.questionDialog.titlePane.shadow");
                break;
            }
            case 8: {
                this.activeBackground = UIManager.getColor("OptionPane.warningDialog.titlePane.background");
                this.activeShadow = UIManager.getColor("OptionPane.warningDialog.titlePane.shadow");
                break;
            }
            default: {
                this.activeBackground = UIManager.getColor("activeCaption");
                this.activeShadow = UIManager.getColor("activeCaptionBorder");
            }
        }
    }

    private void installDefaults() {
        this.setFont(UIManager.getFont("InternalFrame.titleFont", this.getLocale()));
    }

    private void close() {
        Window window = this.getWindow();
        if (window != null) {
            window.dispatchEvent(new WindowEvent(window, 201));
        }
    }

    private void iconify() {
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(this.state | 1);
        }
    }

    private void maximize() {
        Frame frame = this.getFrame();
        if (frame != null) {
            GraphicsConfiguration graphicsConfiguration = frame.getGraphicsConfiguration();
            Rectangle screenbounds = graphicsConfiguration.getBounds();
            Insets screenInsets = frame.getToolkit().getScreenInsets(graphicsConfiguration);
            frame.setMaximizedBounds(new Rectangle(screenInsets.left, screenInsets.top, screenbounds.width - screenInsets.left - screenInsets.right, screenbounds.height - screenInsets.top - screenInsets.bottom));
            frame.setExtendedState(this.state | 6);
        }
    }

    private void restore() {
        Frame frame = this.getFrame();
        if (frame == null) {
            return;
        }
        if ((this.state & 1) != 0) {
            frame.setExtendedState(this.state & 0xFFFFFFFE);
        } else {
            frame.setExtendedState(this.state & 0xFFFFFFF9);
        }
    }

    private JPopupMenu createMenu() {
        JPopupMenu menu = new JPopupMenu();
        if (this.getWindowDecorationStyle() == 1) {
            JMenuItem mi = menu.add(this.restoreAction);
            int mnemonic = this.getInt("MetalTitlePane.restoreMnemonic", -1);
            if (mnemonic != -1) {
                mi.setMnemonic(mnemonic);
            }
            mi = menu.add(this.iconifyAction);
            mnemonic = this.getInt("MetalTitlePane.iconifyMnemonic", -1);
            if (mnemonic != -1) {
                mi.setMnemonic(mnemonic);
            }
            if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
                mi = menu.add(this.maximizeAction);
                mnemonic = this.getInt("MetalTitlePane.maximizeMnemonic", -1);
                if (mnemonic != -1) {
                    mi.setMnemonic(mnemonic);
                }
            }
            menu.add(new JSeparator());
            mi = menu.add(this.closeAction);
            mnemonic = this.getInt("MetalTitlePane.closeMnemonic", -1);
            if (mnemonic != -1) {
                mi.setMnemonic(mnemonic);
            }
        }
        return menu;
    }

    int getInt(Object key, int defaultValue) {
        Object value = UIManager.get(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private JButton createTitleButton() {
        JButton button = new JButton();
        button.setPreferredSize(new Dimension(20, 20));
        button.setMinimumSize(new Dimension(20, 20));
        button.setFocusPainted(false);
        button.setFocusable(false);
        button.setOpaque(false);
        button.setBorderPainted(false);
        return button;
    }

    private void createButtons() {
        this.maximizeIcon = UIManager.getIcon("InternalFrame.maximizeIcon");
        this.minimizeIcon = UIManager.getIcon("InternalFrame.minimizeIcon");
        this.closeButton = this.createTitleButton();
        this.closeButton.setAction(this.closeAction);
        this.closeButton.setText(null);
        this.closeButton.putClientProperty("paintActive", Boolean.TRUE);
        this.closeButton.getAccessibleContext().setAccessibleName("Close");
        this.closeButton.setIcon(UIManager.getIcon("InternalFrame.closeIcon"));
        this.iconifyButton = this.createTitleButton();
        this.iconifyButton.setAction(this.iconifyAction);
        this.iconifyButton.setText(null);
        this.iconifyButton.putClientProperty("paintActive", Boolean.TRUE);
        this.iconifyButton.getAccessibleContext().setAccessibleName("Iconify");
        this.iconifyButton.setIcon(UIManager.getIcon("InternalFrame.iconifyIcon"));
        this.toggleButton = this.createTitleButton();
        this.toggleButton.setAction(this.restoreAction);
        this.toggleButton.putClientProperty("paintActive", Boolean.TRUE);
        this.toggleButton.getAccessibleContext().setAccessibleName("Maximize");
        this.toggleButton.setIcon(this.maximizeIcon);
    }

    private void setActive(boolean isActive) {
        if (this.getWindowDecorationStyle() == 1) {
            Boolean activeB = isActive ? Boolean.TRUE : Boolean.FALSE;
            this.iconifyButton.putClientProperty("paintActive", activeB);
            this.closeButton.putClientProperty("paintActive", activeB);
            this.toggleButton.putClientProperty("paintActive", activeB);
        }
        this.getRootPane().repaint();
    }

    private void setState(int state) {
        this.setState(state, false);
    }

    private void setState(int state, boolean updateRegardless) {
        Window w2 = this.getWindow();
        if (w2 != null && this.getWindowDecorationStyle() == 1) {
            if (this.state == state && !updateRegardless) {
                return;
            }
            Frame frame = this.getFrame();
            if (frame != null) {
                JRootPane rootPane = this.getRootPane();
                if ((state & 6) != 0 && (rootPane.getBorder() == null || rootPane.getBorder() instanceof UIResource) && frame.isShowing()) {
                    rootPane.setBorder(null);
                } else if ((state & 6) == 0) {
                    this.rootPaneUI.installBorder(rootPane);
                }
                if (frame.isResizable()) {
                    if ((state & 6) != 0) {
                        this.updateToggleButton(this.restoreAction, this.minimizeIcon);
                        this.maximizeAction.setEnabled(false);
                        this.restoreAction.setEnabled(true);
                    } else {
                        this.updateToggleButton(this.maximizeAction, this.maximizeIcon);
                        this.maximizeAction.setEnabled(true);
                        this.restoreAction.setEnabled(false);
                    }
                    if (this.toggleButton.getParent() == null || this.iconifyButton.getParent() == null) {
                        this.add(this.toggleButton);
                        this.add(this.iconifyButton);
                        this.revalidate();
                        this.repaint();
                    }
                    this.toggleButton.setText(null);
                } else {
                    this.maximizeAction.setEnabled(false);
                    this.restoreAction.setEnabled(false);
                    if (this.toggleButton.getParent() != null) {
                        this.remove(this.toggleButton);
                        this.revalidate();
                        this.repaint();
                    }
                }
            } else {
                this.maximizeAction.setEnabled(false);
                this.restoreAction.setEnabled(false);
                this.iconifyAction.setEnabled(false);
                this.remove(this.toggleButton);
                this.remove(this.iconifyButton);
                this.revalidate();
                this.repaint();
            }
            this.closeAction.setEnabled(true);
            this.state = state;
        }
    }

    private void updateToggleButton(Action action, Icon icon) {
        this.toggleButton.setAction(action);
        this.toggleButton.setIcon(icon);
        this.toggleButton.setText(null);
    }

    private Frame getFrame() {
        Window window = this.getWindow();
        if (window instanceof Frame) {
            return (Frame)window;
        }
        return null;
    }

    private Icon getIcon() {
        if (this.WindowIcon == null) {
            Frame frame = this.getFrame();
            Window window = this.getWindow();
            if (window instanceof JDialog) {
                while (!(window instanceof Frame)) {
                    JDialog d2 = (JDialog)window;
                    if (d2 == null) {
                        return null;
                    }
                    window = d2.getOwner();
                }
                frame = (Frame)window;
            }
            if (frame != null && frame.getIconImage() != null) {
                this.WindowIcon = new ImageIcon(frame.getIconImage().getScaledInstance(16, 16, 4));
            }
        }
        return this.WindowIcon;
    }

    private Window getWindow() {
        return this.window;
    }

    private String getTitle() {
        Window w2 = this.getWindow();
        if (w2 instanceof Frame) {
            return ((Frame)w2).getTitle();
        }
        if (w2 instanceof Dialog) {
            return ((Dialog)w2).getTitle();
        }
        return null;
    }

    public void paintComponent(Graphics g2) {
        int xOffset;
        Window window;
        if (this.getFrame() != null) {
            this.setState(this.getFrame().getExtendedState());
        }
        boolean leftToRight = (window = this.getWindow()) == null ? this.getRootPane().getComponentOrientation().isLeftToRight() : window.getComponentOrientation().isLeftToRight();
        boolean isSelected = window == null ? true : window.isActive();
        int width = this.getWidth();
        int height = this.getHeight();
        if (isSelected) {
            if (this.getFrame() != null) {
                PlasticUtils.paintPrimaryGradient(g2, 1, 0, width - 2, height - 1, 3);
                g2.setColor(PlasticXPUtils.translucentColor(this.inactiveBackground, 70));
                g2.fillRect(1, 1, width - 2, height - 2);
            } else {
                PlasticUtils.paintPrimaryGradient(g2, 1, 0, width - 2, height - 1, 3);
                g2.setColor(PlasticXPUtils.translucentColor(this.inactiveBackground, 70));
                g2.fillRect(1, 1, width - 2, height - 2);
            }
            this.lblTitle.setForeground(this.inactiveShadow);
        } else {
            PlasticUtils.paintPrimaryGradient(g2, 1, 0, width - 2, height - 1, 3);
            g2.setColor(PlasticXPUtils.translucentColor(new Color(230, 230, 230), 170));
            g2.fillRect(1, 1, width - 2, height - 2);
            this.lblTitle.setForeground(this.activeShadow);
        }
        g2.setColor(this.highlight);
        g2.fillRect(1, 1, width - 2, 2);
        this.lblTitle.setFont(this.getFont());
        this.lblTitle.setText(this.getTitle());
        Icon icon = this.getIcon();
        int n2 = xOffset = leftToRight ? 5 : width - 5;
        if (icon != null) {
            this.lblTitle.setIcon(icon);
        }
    }

    private class CloseAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CloseAction() {
            super(UIManager.getString((Object)"MetalTitlePane.closeTitle", PlasticTitlePane.this.getLocale()));
        }

        public void actionPerformed(ActionEvent e2) {
            PlasticTitlePane.this.close();
        }
    }

    private class IconifyAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public IconifyAction() {
            super(UIManager.getString((Object)"MetalTitlePane.iconifyTitle", PlasticTitlePane.this.getLocale()));
        }

        public void actionPerformed(ActionEvent e2) {
            PlasticTitlePane.this.iconify();
        }
    }

    private class MaximizeAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public MaximizeAction() {
            super(UIManager.getString((Object)"MetalTitlePane.maximizeTitle", PlasticTitlePane.this.getLocale()));
        }

        public void actionPerformed(ActionEvent e2) {
            PlasticTitlePane.this.maximize();
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent pce) {
            String name = pce.getPropertyName();
            if ("resizable".equals(name) || "state".equals(name)) {
                Frame frame = PlasticTitlePane.this.getFrame();
                if (frame != null) {
                    PlasticTitlePane.this.setState(frame.getExtendedState(), true);
                }
                if ("resizable".equals(name)) {
                    PlasticTitlePane.this.getRootPane().repaint();
                }
            } else if ("title".equals(name)) {
                PlasticTitlePane.this.repaint();
            } else if ("componentOrientation".equals(name)) {
                PlasticTitlePane.this.revalidate();
                PlasticTitlePane.this.repaint();
            }
        }
    }

    private class RestoreAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public RestoreAction() {
            super(UIManager.getString((Object)"MetalTitlePane.restoreTitle", PlasticTitlePane.this.getLocale()));
        }

        public void actionPerformed(ActionEvent e2) {
            PlasticTitlePane.this.restore();
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        public void windowActivated(WindowEvent ev2) {
            PlasticTitlePane.this.setActive(true);
        }

        public void windowDeactivated(WindowEvent ev2) {
            PlasticTitlePane.this.setActive(false);
        }
    }
}

