/*
 * Decompiled with CFR 0.152.
 */
package com.inet.looks.plastic;

import com.inet.looks.plastic.PlasticLookAndFeel;
import com.inet.looks.plastic.PlasticUtils;
import com.inet.looks.plastic.PlasticXPUtils;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalToggleButtonUI;
import javax.swing.text.View;

public class PlasticToggleButtonUI
extends MetalToggleButtonUI {
    private static final PlasticToggleButtonUI INSTANCE = new PlasticToggleButtonUI();
    protected static final String HTML_KEY = "html";
    private boolean borderPaintsFocus;

    public static ComponentUI createUI(JComponent b2) {
        return INSTANCE;
    }

    public void installDefaults(AbstractButton b2) {
        super.installDefaults(b2);
        this.borderPaintsFocus = Boolean.TRUE.equals(UIManager.get("ToggleButton.borderPaintsFocus"));
    }

    public void update(Graphics g2, JComponent c2) {
        AbstractButton b2 = (AbstractButton)c2;
        if (c2.isOpaque()) {
            if (this.isToolBarButton(b2)) {
                c2.setOpaque(false);
            } else if (b2.isContentAreaFilled()) {
                g2.setColor(c2.getBackground());
                g2.fillRect(0, 0, c2.getWidth(), c2.getHeight());
                if (this.is3D(b2)) {
                    Rectangle r2 = new Rectangle(1, 1, c2.getWidth() - 2, c2.getHeight() - 1);
                    PlasticUtils.add3DEffekt(g2, r2);
                }
            }
        }
        this.paint(g2, c2);
    }

    protected void paintFocus(Graphics g2, AbstractButton b2, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (this.borderPaintsFocus) {
            return;
        }
        PlasticUtils.paintFocusHightlight(g2, 0, 0, b2.getWidth(), b2.getHeight());
    }

    protected void paintButtonPressed(Graphics g2, AbstractButton b2) {
        if (b2.isContentAreaFilled()) {
            Dimension size = b2.getSize();
            PlasticUtils.paintPopupHightlight(g2, 0, 0, size.width, size.height);
        }
    }

    private void paintMouseOver(Graphics g2, AbstractButton b2) {
        int trans = 160;
        Dimension size = b2.getSize();
        if (this.isToolBarButton(b2)) {
            trans = 70;
        }
        Color colorEnd = PlasticXPUtils.translucentColor(PlasticLookAndFeel.getSecondaryGradientEnd(), trans);
        Color colorStart = new Color(255, 255, 255, trans);
        PlasticUtils.paintDoubleGradient(g2, colorStart, colorEnd, 1, 1, size.width - 2, size.height - 2);
        PlasticXPUtils.drawButtonBorder(g2, 0, 0, size.width, size.height, PlasticLookAndFeel.getPrimaryControlDarkShadow());
    }

    public void paint(Graphics g2, JComponent c2) {
        AbstractButton b2 = (AbstractButton)c2;
        ButtonModel model = b2.getModel();
        Dimension size = b2.getSize();
        FontMetrics fm2 = g2.getFontMetrics();
        Insets i2 = c2.getInsets();
        Rectangle viewRect = new Rectangle(size);
        viewRect.x += i2.left;
        viewRect.y += i2.top;
        viewRect.width -= i2.right + viewRect.x;
        viewRect.height -= i2.bottom + viewRect.y;
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        if (b2.isFocusPainted() && b2.hasFocus()) {
            this.paintFocus(g2, b2, viewRect, textRect, iconRect);
        }
        Font f2 = c2.getFont();
        g2.setFont(f2);
        String text = SwingUtilities.layoutCompoundLabel(c2, fm2, b2.getText(), b2.getIcon(), b2.getVerticalAlignment(), b2.getHorizontalAlignment(), b2.getVerticalTextPosition(), b2.getHorizontalTextPosition(), viewRect, iconRect, textRect, b2.getText() == null ? 0 : b2.getIconTextGap());
        g2.setColor(b2.getBackground());
        if (model.isRollover() && b2.isEnabled()) {
            this.paintMouseOver(g2, b2);
        }
        if ((model.isArmed() && model.isPressed() || model.isSelected()) && b2.isEnabled()) {
            this.paintButtonPressed(g2, b2);
        }
        if (b2.getIcon() != null) {
            this.paintIcon(g2, b2, iconRect);
        }
        if (text != null && !text.equals("")) {
            View v2 = (View)c2.getClientProperty(HTML_KEY);
            if (v2 != null) {
                v2.paint(g2, textRect);
            } else {
                this.paintText(g2, c2, textRect, text);
            }
        }
    }

    protected boolean isToolBarButton(AbstractButton b2) {
        Container parent = b2.getParent();
        return parent != null && (parent instanceof JToolBar || parent.getParent() instanceof JToolBar);
    }

    protected boolean is3D(AbstractButton b2) {
        if (PlasticUtils.force3D(b2)) {
            return true;
        }
        if (PlasticUtils.forceFlat(b2)) {
            return false;
        }
        ButtonModel model = b2.getModel();
        return PlasticUtils.is3D("ToggleButton.") && b2.isBorderPainted() && model.isEnabled() && !model.isPressed();
    }
}

