/*
 * Decompiled with CFR 0.152.
 */
package com.inet.looks.plastic;

import com.inet.looks.common.PlasticTreeCellRenderer;
import com.inet.looks.plastic.PlasticLookAndFeel;
import com.inet.looks.plastic.PlasticUtils;
import com.inet.looks.plastic.PlasticXPUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public final class PlasticTreeUI
extends BasicTreeUI {
    private boolean linesEnabled = true;
    private static final Insets EMPTY_INSETS = new Insets(2, 2, 2, 2);
    private int lastWidth;
    private PropertyChangeListener lineStyleHandler;

    public static ComponentUI createUI(JComponent b2) {
        return new PlasticTreeUI();
    }

    public void installUI(JComponent c2) {
        super.installUI(c2);
        this.updateLineStyle(c2.getClientProperty("JTree.lineStyle"));
        this.lineStyleHandler = new LineStyleHandler();
        c2.addPropertyChangeListener(this.lineStyleHandler);
    }

    public void uninstallUI(JComponent c2) {
        c2.removePropertyChangeListener(this.lineStyleHandler);
        super.uninstallUI(c2);
    }

    protected void paintVerticalLine(Graphics g2, JComponent c2, int x2, int top, int bottom) {
        if (this.linesEnabled) {
            this.drawDashedVerticalLine(g2, x2, top, bottom);
        }
    }

    protected void paintHorizontalLine(Graphics g2, JComponent c2, int y2, int left, int right) {
        if (this.linesEnabled) {
            this.drawDashedHorizontalLine(g2, y2, left, right);
        }
    }

    protected void prepareForUIInstall() {
        super.prepareForUIInstall();
        this.lastWidth = this.tree.getWidth();
    }

    private boolean isLeftToRight() {
        return this.tree.getComponentOrientation().isLeftToRight();
    }

    private void redoTheLayout() {
        if (this.treeState != null) {
            this.treeState.invalidateSizes();
        }
    }

    public void paint(Graphics g2, JComponent c2) {
        if (this.tree != c2) {
            throw new IllegalStateException("incorrect component");
        }
        if (this.treeState == null) {
            return;
        }
        int width = this.tree.getWidth();
        if (width != this.lastWidth) {
            this.lastWidth = width;
            if (!this.isLeftToRight()) {
                this.redoTheLayout();
                this.updateSize();
            }
        }
        Rectangle paintBounds = g2.getClipBounds();
        Insets insets = this.tree.getInsets();
        if (insets == null) {
            insets = EMPTY_INSETS;
        }
        TreePath initialPath = this.getClosestPathForLocation(this.tree, 0, paintBounds.y);
        Enumeration<TreePath> paintingEnumerator = this.treeState.getVisiblePathsFrom(initialPath);
        int row = this.treeState.getRowForPath(initialPath);
        int endY = paintBounds.y + paintBounds.height;
        this.drawingCache.clear();
        if (initialPath != null && paintingEnumerator != null) {
            TreePath parentPath = initialPath;
            parentPath = parentPath.getParentPath();
            while (parentPath != null) {
                this.paintVerticalPartOfLeg(g2, paintBounds, insets, parentPath);
                this.drawingCache.put(parentPath, Boolean.TRUE);
                parentPath = parentPath.getParentPath();
            }
            boolean done = false;
            Rectangle boundsBuffer = new Rectangle();
            boolean rootVisible = this.isRootVisible();
            while (!done && paintingEnumerator.hasMoreElements()) {
                TreePath path = paintingEnumerator.nextElement();
                if (path != null) {
                    boolean isExpanded;
                    boolean hasBeenExpanded;
                    boolean isLeaf = this.treeModel.isLeaf(path.getLastPathComponent());
                    if (isLeaf) {
                        hasBeenExpanded = false;
                        isExpanded = false;
                    } else {
                        isExpanded = this.treeState.getExpandedState(path);
                        hasBeenExpanded = this.tree.hasBeenExpanded(path);
                    }
                    Rectangle bounds = this.treeState.getBounds(path, boundsBuffer);
                    if (bounds == null) {
                        return;
                    }
                    if (this.getCellRenderer() instanceof PlasticTreeCellRenderer) {
                        ((PlasticTreeCellRenderer)this.getCellRenderer()).checkBounds(bounds, path.getLastPathComponent());
                    }
                    bounds.x += insets.left;
                    bounds.y += insets.top;
                    this.paintRowSelectionBackground(g2, row, bounds);
                    parentPath = path.getParentPath();
                    if (parentPath != null) {
                        if (this.drawingCache.get(parentPath) == null) {
                            this.paintVerticalPartOfLeg(g2, paintBounds, insets, parentPath);
                            this.drawingCache.put(parentPath, Boolean.TRUE);
                        }
                        this.paintHorizontalPartOfLeg(g2, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                    } else if (rootVisible && row == 0) {
                        this.paintHorizontalPartOfLeg(g2, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                    }
                    if (this.shouldPaintExpandControl(path, row, isExpanded, hasBeenExpanded, isLeaf)) {
                        this.paintExpandControl(g2, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                    }
                    if (!this.isLeftToRight()) {
                        bounds.x += 4;
                    }
                    this.paintRow(g2, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                    if (bounds.y + bounds.height >= endY) {
                        done = true;
                    }
                } else {
                    done = true;
                }
                ++row;
            }
        }
        this.rendererPane.removeAll();
    }

    private void paintRowSelectionBackground(Graphics g2, int row, Rectangle bounds) {
        if (this.tree.isRowSelected(row)) {
            PlasticUtils.paintPopupHightlight(g2, 0, bounds.y, this.tree.getWidth(), bounds.height);
            int leadIndex = this.tree.hasFocus() ? this.getRowForPath(this.tree, this.tree.getLeadSelectionPath()) : -1;
            if (leadIndex == row) {
                g2.setColor(PlasticXPUtils.translucentColor(PlasticLookAndFeel.getFocusColor(), 85));
                g2.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            }
        }
    }

    public Rectangle getPathBounds(TreePath path, Insets i2) {
        if (this.tree != null && this.treeState != null) {
            Rectangle bounds = this.treeState.getBounds(path, null);
            if (bounds != null && i2 != null) {
                bounds.x += i2.left;
                bounds.y += i2.top;
            }
            return bounds;
        }
        return null;
    }

    public Rectangle getPathBounds(JTree tree, TreePath path) {
        if (tree != null && this.treeState != null) {
            Insets i2 = tree.getInsets();
            Rectangle bounds = this.getPathBounds(path, i2);
            if (bounds != null && i2 != null && !this.isEditing(tree)) {
                bounds.x = i2.left;
                bounds.width = tree.getWidth() - i2.left;
            }
            return bounds;
        }
        return null;
    }

    protected void selectPathForEvent(TreePath path, MouseEvent event) {
        if (path != null && this.isLocationInExpandControl(path, event.getX(), event.getY())) {
            return;
        }
        super.selectPathForEvent(path, event);
    }

    protected TreeCellRenderer createDefaultCellRenderer() {
        return new PlasticTreeCellRenderer();
    }

    protected void drawCentered(Component c2, Graphics graphics, Icon icon, int x2, int y2) {
        icon.paintIcon(c2, graphics, x2 - icon.getIconWidth() / 2 - 1, y2 - icon.getIconHeight() / 2);
    }

    private void updateLineStyle(Object lineStyle) {
        this.linesEnabled = !"None".equals(lineStyle) && lineStyle != null;
    }

    private class LineStyleHandler
    implements PropertyChangeListener {
        private LineStyleHandler() {
        }

        public void propertyChange(PropertyChangeEvent e2) {
            String name = e2.getPropertyName();
            Object value = e2.getNewValue();
            if (name.equals("JTree.lineStyle")) {
                PlasticTreeUI.this.updateLineStyle(value);
            }
        }
    }
}

