/*
 * Decompiled with CFR 0.152.
 */
package com.inet.problemfinder.i18n;

import com.inet.report.AbstractFontElement;
import com.inet.report.Area;
import com.inet.report.BaseUtils;
import com.inet.report.Element;
import com.inet.report.Field;
import com.inet.report.FieldPart;
import com.inet.report.Group;
import com.inet.report.Paragraph;
import com.inet.report.ReportException;
import com.inet.report.Section;
import com.inet.report.Subreport;
import com.inet.report.Text;
import com.inet.report.TextPart;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class Msg {
    private static final ResourceBundle hx = ResourceBundle.getBundle("com.inet.problemfinder.i18n.LanguageResources");

    public static String getMsg(String string, Object object, Object object2, Object object3, Object object4) {
        return Msg.getMsg(string, new Object[]{object, object2, object3, object4});
    }

    public static String getMsg(String string, Object object, Object object2, Object object3) {
        return Msg.getMsg(string, new Object[]{object, object2, object3});
    }

    public static String getMsg(String string, Object object, Object object2) {
        return Msg.getMsg(string, new Object[]{object, object2});
    }

    public static String getMsg(String string, Object object) {
        return Msg.getMsg(string, new Object[]{object});
    }

    public static String getMsg(String string) {
        String string2;
        try {
            string2 = hx.getString(string);
        }
        catch (Throwable throwable) {
            string2 = "$" + string + "$";
        }
        return string2;
    }

    public static boolean existsMsg(String string) {
        try {
            hx.getString(string);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static String getMsgColon(String string) {
        String string2;
        try {
            string2 = hx.getString(string);
        }
        catch (Throwable throwable) {
            return "$" + string + "$";
        }
        return string2 + ":";
    }

    public static String getMsg(String string, Object[] objectArray) {
        int n2;
        StringBuffer stringBuffer;
        String string2;
        try {
            string2 = hx.getString(string);
        }
        catch (Throwable throwable) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            stringBuffer.append('(');
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                if (n2 > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append('{');
                stringBuffer.append(n2);
                stringBuffer.append('}');
            }
            stringBuffer.append(')');
            string2 = "$" + MessageFormat.format(stringBuffer.toString(), objectArray) + "$";
        }
        try {
            string2 = MessageFormat.format(string2, objectArray);
        }
        catch (Throwable throwable) {
            stringBuffer = new StringBuffer();
            stringBuffer.append('$').append(throwable.toString()).append('_').append(string).append('(');
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                if (n2 > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(objectArray[n2]);
            }
            stringBuffer.append(')').append('$');
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    public static ResourceBundle getLanguageResources() {
        return hx;
    }

    public static String getElementDisplayName(Element element) {
        String string = Msg.getElementTypeName(element.getType());
        switch (element.getType()) {
            case 35: {
                Text text = (Text)element;
                String string2 = Msg.getTotalText(text);
                if (string2.length() > 13) {
                    string2 = string2.substring(0, 10) + "...";
                }
                return string + " \"" + string2 + "\"";
            }
            case 36: {
                return Msg.getFieldDisplayName(element.getField());
            }
            case 39: {
                Subreport subreport = (Subreport)element;
                try {
                    return string + " \"" + subreport.getEngine().getReportTitle() + "\"";
                }
                catch (ReportException reportException) {
                    if (!BaseUtils.isDebug()) break;
                    BaseUtils.debug(reportException);
                }
            }
        }
        return string;
    }

    public static String getTotalText(Text text) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < text.getParagraphCount(); ++i2) {
            Paragraph paragraph = text.getParagraph(i2);
            for (int i3 = 0; i3 < paragraph.getPartCount(); ++i3) {
                AbstractFontElement abstractFontElement = (AbstractFontElement)paragraph.getPart(i3);
                if (abstractFontElement instanceof FieldPart) {
                    stringBuilder.append(abstractFontElement.getField().getPlaceholderName());
                }
                if (!(abstractFontElement instanceof TextPart)) continue;
                stringBuilder.append(((TextPart)abstractFontElement).getText());
            }
        }
        return stringBuilder.toString();
    }

    public static String getFieldDisplayName(Field field) {
        StringBuilder stringBuilder = new StringBuilder(Msg.getLocalizedFieldTypeName(field.getType()));
        stringBuilder.append(" \"");
        stringBuilder.append(field.getName());
        stringBuilder.append("\" ");
        return stringBuilder.toString();
    }

    public static String getLocalizedFieldTypeName(int n2) {
        switch (n2) {
            case 10: {
                return Msg.getMsg("Special_Field");
            }
            case 11: {
                return Msg.getMsg("Summary_Field");
            }
            case 12: {
                return Msg.getMsg("Group_Name_Field");
            }
            case 13: {
                return Msg.getMsg("Formula_Field");
            }
            case 14: {
                return Msg.getMsg("Database_Field");
            }
            case 15: {
                return Msg.getMsg("Sort_Field");
            }
            case 16: {
                return Msg.getMsg("prompt.field");
            }
            case 17: {
                return Msg.getMsg("SQL_Expression_Field");
            }
        }
        return Msg.getMsg("Unknown");
    }

    public static final String getElementTypeName(int n2) {
        switch (n2) {
            case 38: {
                return Msg.getMsg("Box");
            }
            case 42: {
                return Msg.getMsg("Chart");
            }
            case 49: {
                return Msg.getMsg("CrossTab");
            }
            case 68: {
                return Msg.getMsg("JavaBean");
            }
            case 37: {
                return Msg.getMsg("Line");
            }
            case 46: {
                return Msg.getMsg("Picture");
            }
            case 39: {
                return Msg.getMsg("Subreport");
            }
            case 35: {
                return Msg.getMsg("TextObject");
            }
            case 70: {
                return Msg.getMsg("Signature");
            }
            case 48: {
                return Msg.getMsg("Database_Picture");
            }
        }
        return Msg.getMsg("Unknown");
    }

    public static String getAreaName(Area area) {
        switch (area.getType()) {
            case 0: {
                return Msg.getMsg("Report_Header");
            }
            case 3: {
                return Msg.getMsg("Report_Footer");
            }
            case 1: {
                return Msg.getMsg("Page_Header");
            }
            case 4: {
                return Msg.getMsg("Page_Footer");
            }
            case 2: {
                return Msg.getMsg("Detail");
            }
            case 5: {
                Group group = (Group)area.getParent();
                return Msg.getMsg("groupHeader", new Integer(group.indexOf()));
            }
            case 6: {
                Group group = (Group)area.getParent();
                return Msg.getMsg("groupFooter", new Integer(group.indexOf()));
            }
        }
        return Msg.getMsg("Utils.Unknown_Area");
    }

    public static String getValueTypeString(int n2) {
        switch (n2) {
            case 6: {
                return "NUMBER";
            }
            case 7: {
                return "CURRENCY";
            }
            case 8: {
                return "BOOLEAN";
            }
            case 9: {
                return "DATE";
            }
            case 10: {
                return "TIME";
            }
            case 11: {
                return "STRING";
            }
            case 14: {
                return "BINARY";
            }
            case 15: {
                return "DATETIME";
            }
            case -10: {
                return "CURSOR";
            }
        }
        return "UNKNOWN";
    }

    public static String getSectionName(Section section) throws IllegalStateException, ReportException {
        return Msg.getAreaName((Area)section.getParent()) + " - " + section.getSectionNameByNumber(section.indexOf());
    }
}

