/*
 * Decompiled with CFR 0.152.
 */
package com.inet.problemfinder.rules;

import com.inet.problemfinder.ProblemFinderWarning;
import com.inet.problemfinder.ProblemFinderWarningImpl;
import com.inet.problemfinder.i18n.Msg;
import com.inet.problemfinder.rules.AbstractRuleSection;
import com.inet.problemfinder.rules.e;
import com.inet.problemfinder.rules.f;
import com.inet.report.Area;
import com.inet.report.BaseUtils;
import com.inet.report.Element;
import com.inet.report.Engine;
import com.inet.report.ReportException;
import com.inet.report.ReportProperties;
import com.inet.report.Section;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;

public class RuleSectionTooLarge
extends AbstractRuleSection {
    private int iL;

    @Override
    public List<ProblemFinderWarning> findErrors(Engine engine) {
        try {
            ReportProperties reportProperties = engine.getReportProperties();
            this.iL = reportProperties.getPaperHeight() - reportProperties.getMarginBottom() - reportProperties.getMarginTop();
            ArrayList<Section> arrayList = new ArrayList<Section>();
            ArrayList<Area> arrayList2 = new ArrayList<Area>();
            arrayList2.add(engine.getArea(1));
            arrayList2.add(engine.getArea(4));
            for (Area region : arrayList2) {
                if (region == null) continue;
                for (int i2 = 0; i2 < region.getSectionCount(); ++i2) {
                    Section section = region.getSection(i2);
                    if (section.getSuppressFormula() != null && !section.getSuppressFormula().isEmpty() || section.isSuppress()) continue;
                    arrayList.add(section);
                }
            }
            for (Section section : arrayList) {
                this.iL -= section.getHeight();
            }
            return super.findErrors(engine);
        }
        catch (ReportException reportException) {
            if (BaseUtils.isDebug()) {
                BaseUtils.debug(reportException);
            }
            return new LinkedList<ProblemFinderWarning>();
        }
    }

    @Override
    public ProblemFinderWarning check(Engine engine, Section section) {
        try {
            ProblemFinderWarning problemFinderWarning = this.b(engine, section);
            if (problemFinderWarning != null) {
                return problemFinderWarning;
            }
            return this.a(engine, section);
        }
        catch (ReportException reportException) {
            if (BaseUtils.isDebug()) {
                BaseUtils.debug(reportException);
            }
            return null;
        }
    }

    private ProblemFinderWarning a(Engine engine, Section section) {
        block4: {
            if (!(section.getType() != 2 && section.getType() != 5 && section.getType() != 6 || section.isSuppress() || section.getHeight() <= this.iL)) {
                try {
                    int n2 = RuleSectionTooLarge.getMaximumUsedHeightSection(section);
                    int n3 = n2 <= this.iL ? this.iL : (n2 < section.getHeight() ? n2 : 0);
                    e e2 = new e(this, Msg.getMsg("ProblemFinder.Rule.ContentSectionTooLarge.AutofixDetail"), section, n3);
                    String string = Msg.getSectionName(section);
                    String string2 = Msg.getMsg("ProblemFinder.Rule.ContentSectionTooLarge.warn", string);
                    if (n3 < section.getHeight() && n3 > 0) {
                        return new ProblemFinderWarningImpl(section, ProblemFinderWarning.Type.WARNING, this, string2, string, e2);
                    }
                    return new ProblemFinderWarningImpl(section, ProblemFinderWarning.Type.WARNING, this, string2, string, new AbstractAction[0]);
                }
                catch (ReportException reportException) {
                    if (!BaseUtils.isDebug()) break block4;
                    BaseUtils.debug(reportException);
                }
            }
        }
        return null;
    }

    private ProblemFinderWarning b(Engine engine, Section section) throws ReportException {
        ReportProperties reportProperties = engine.getReportProperties();
        int n2 = reportProperties.getPaperHeight() - reportProperties.getMarginBottom() - reportProperties.getMarginTop();
        if (section.getHeight() > n2) {
            int n3;
            if (section.getType() == 2 || section.getType() == 6 || section.getType() == 1) {
                n2 = this.iL;
            }
            int n4 = (n3 = RuleSectionTooLarge.getMaximumUsedHeightSection(section)) <= n2 ? n2 : (n3 < section.getHeight() ? n3 : 0);
            String string = Msg.getSectionName(section);
            String string2 = Msg.getMsg("ProblemFinder.Rule.SectionTooLarge.warn", string);
            if (n4 > 0) {
                f f2 = new f(this, Msg.getMsg("ProblemFinder.Rule.SectionTooLarge.AutofixDetail"), section, n4);
                return new ProblemFinderWarningImpl(section, ProblemFinderWarning.Type.WARNING, this, string2, string, f2);
            }
            return new ProblemFinderWarningImpl(section, ProblemFinderWarning.Type.WARNING, this, string2, string, new AbstractAction[0]);
        }
        return null;
    }

    public static int getMaximumUsedHeightSection(Section section) {
        int n2 = 0;
        for (Element element : section.getElements()) {
            int n3 = element.getY() + element.getHeight();
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    @Override
    public String getRuleLabel() {
        return Msg.getMsg("ProblemFinder.Rule.ContentSectionTooLarge.label");
    }
}

