/*
 * Decompiled with CFR 0.152.
 */
package com.inet.problemfinder.rules;

import com.inet.problemfinder.ProblemFinderWarning;
import com.inet.problemfinder.ProblemFinderWarningImpl;
import com.inet.problemfinder.i18n.Msg;
import com.inet.problemfinder.rules.AbstractRuleSection;
import com.inet.report.BaseUtils;
import com.inet.report.DatabaseTables;
import com.inet.report.Datasource;
import com.inet.report.Engine;
import com.inet.report.Join;
import com.inet.report.ReportException;
import com.inet.report.Section;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;

public class RuleUnlinkedTables
extends AbstractRuleSection {
    @Override
    public List<ProblemFinderWarning> findErrors(Engine engine) {
        LinkedList<ProblemFinderWarning> linkedList;
        block10: {
            linkedList = new LinkedList<ProblemFinderWarning>();
            if (engine == null) {
                return linkedList;
            }
            try {
                Object object;
                DatabaseTables databaseTables = engine.getDatabaseTables();
                ArrayList<String> arrayList = new ArrayList<String>(20);
                for (int i2 = 0; i2 < databaseTables.getDatasourceCount(); ++i2) {
                    object = databaseTables.getDatasource(i2);
                    arrayList.addAll(Arrays.asList(((Datasource)object).getAliasList()));
                }
                if (arrayList.size() < 2) {
                    return linkedList;
                }
                Vector vector = databaseTables.getJoinsEntries();
                for (Join object2 : vector) {
                    arrayList.remove(object2.getSourceAlias());
                    arrayList.remove(object2.getTargetAlias());
                }
                for (String string : arrayList) {
                    String string2 = Msg.getMsg("ProblemFinder.Rule.UnlinkedTables.warn", string);
                    linkedList.add(new ProblemFinderWarningImpl((Object)ProblemFinderWarning.Sources.DATATABLE, ProblemFinderWarning.Type.ERROR, this, string2, string2, new AbstractAction[0]));
                }
                if (linkedList.isEmpty()) {
                    if (!databaseTables.areAllTablesJoined()) {
                        object = Msg.getMsg("ProblemFinder.Rule.UnlinkedTables.warn2");
                        linkedList.add(new ProblemFinderWarningImpl((Object)ProblemFinderWarning.Sources.DATABASE, ProblemFinderWarning.Type.ERROR, this, (String)object, (String)object, new AbstractAction[0]));
                    }
                    if (databaseTables.joinsContainCycle()) {
                        object = Msg.getMsg("ProblemFinder.Rule.UnlinkedTables.warn3");
                        linkedList.add(new ProblemFinderWarningImpl((Object)ProblemFinderWarning.Sources.DATABASE, ProblemFinderWarning.Type.ERROR, this, (String)object, (String)object, new AbstractAction[0]));
                    }
                }
            }
            catch (ReportException reportException) {
                if (!BaseUtils.isDebug()) break block10;
                BaseUtils.debug(reportException);
            }
        }
        return linkedList;
    }

    @Override
    public String getRuleLabel() {
        return Msg.getMsg("ProblemFinder.Rule.UnlinkedTables.label");
    }

    @Override
    public ProblemFinderWarning check(Engine engine, Section section) {
        return null;
    }
}

