/*
 * Decompiled with CFR 0.152.
 */
package com.inet.remote.gui;

import com.inet.remote.gui.IModule;
import com.inet.remote.gui.RemoteModuleContainer;
import com.inet.remote.gui.RemoteModuleFactory;
import com.inet.remote.gui.access.i;
import com.inet.remote.gui.access.k;
import com.inet.remote.gui.d;
import com.inet.remote.gui.e;
import com.inet.remote.gui.h;
import com.inet.remote.gui.i18n.a;
import com.inet.remote.gui.modules.adhoc.p;
import com.inet.remote.gui.modules.datasource.t;
import com.inet.remote.gui.modules.error.c;
import com.inet.remote.gui.modules.repositorybrowser.b;
import com.inet.report.BaseUtils;
import com.inet.report.SystemPermissionChecker;
import com.inet.report.config.Configuration;
import com.inet.report.config.ConfigurationManager;
import com.inet.report.permissions.Permission;
import com.inet.report.permissions.WebUserInfo;
import com.inet.report.permissions.WebUserInfoFactory;
import java.io.Serializable;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Command;
import nextapp.echo2.app.ContentPane;
import nextapp.echo2.webcontainer.command.BrowserRedirectCommand;
import nextapp.echo2.webrender.WebRenderServlet;

public class ModuleManager
implements Serializable {
    private AbstractMap<String, IModule> iZ;
    private a ja;
    private Locale locale;

    public ModuleManager(RemoteModuleContainer remoteModuleContainer) {
        Set<RemoteModuleFactory> set;
        block4: {
            this.iZ = new HashMap<String, IModule>();
            this.registerModule(new c());
            this.registerModule(new i());
            this.registerModule(new com.inet.remote.gui.access.a());
            this.registerModule(new com.inet.remote.gui.access.c());
            this.registerModule(new com.inet.remote.gui.access.d());
            this.registerModule(new k(this));
            this.registerModule(new t());
            this.registerModule(new b());
            try {
                this.registerModule(new p());
            }
            catch (Throwable throwable) {
                if (!BaseUtils.isError()) break block4;
                BaseUtils.error("Unable to start the AdHoc interface");
                BaseUtils.error(throwable);
            }
        }
        this.bc();
        if (remoteModuleContainer != null && (set = remoteModuleContainer.getRemoteModules()).size() > 0) {
            Iterator<RemoteModuleFactory> iterator = set.iterator();
            while (iterator.hasNext()) {
                IModule iModule = iterator.next().getRemoteModule();
                if (iModule == null) continue;
                this.registerModule(iModule);
            }
        }
        this.setLocale(Locale.getDefault());
    }

    private void bc() {
        try {
            ClassLoader classLoader = BaseUtils.getUpdateableClassLoader();
            Enumeration<URL> enumeration = classLoader.getResources("angular/module.properties");
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                Properties properties = new Properties();
                properties.load(uRL.openStream());
                String string = properties.getProperty("moduleClassName");
                try {
                    Class<?> clazz = Class.forName(string, true, classLoader);
                    IModule iModule = (IModule)clazz.newInstance();
                    this.registerModule(iModule);
                }
                catch (Throwable throwable) {
                    if (!BaseUtils.isError()) continue;
                    BaseUtils.error("Error in loading remote module '" + string + "'");
                    BaseUtils.error(throwable);
                }
            }
        }
        catch (Exception exception) {
            BaseUtils.error(exception);
        }
    }

    public final void registerModule(IModule iModule) throws IllegalArgumentException {
        String string;
        String string2 = string = iModule == null ? null : iModule.getPath();
        if (iModule == null || string == null) {
            throw new IllegalArgumentException(this.ja.getMsg("manager.error.nullNotAllowed"));
        }
        if (this.iZ.containsKey(string)) {
            throw new IllegalArgumentException(this.ja.getMsg("manager.error.pathAlreadyRegistered", string));
        }
        if (this.iZ.containsValue(iModule)) {
            throw new IllegalArgumentException(this.ja.getMsg("manager.error.nameAlreadyRegistered", iModule.getName()));
        }
        if (!string.startsWith("/")) {
            throw new IllegalArgumentException(this.ja.getMsg("manager.error.pathMustStartWithSlash"));
        }
        this.iZ.put(string, iModule);
    }

    public void unregisterModule(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException(this.ja.getMsg("manager.error.nullNotAllowed"));
        }
        this.iZ.remove(string);
    }

    public void unregisterModule(IModule iModule) throws IllegalArgumentException {
        String string;
        String string2 = string = iModule == null ? null : iModule.getPath();
        if (string == null || iModule == null) {
            throw new IllegalArgumentException(this.ja.getMsg("manager.error.nullNotAllowed"));
        }
        IModule iModule2 = this.iZ.get(string);
        if (iModule2 != null) {
            if (iModule2.equals(iModule)) {
                this.iZ.remove(string);
            } else {
                throw new IllegalArgumentException(this.ja.getMsg("manager.error.anotherModuleIsRegisteredAtPath"));
            }
        }
    }

    public ArrayList<IModule> getModules(boolean bl2) {
        ArrayList<IModule> arrayList = new ArrayList<IModule>();
        for (IModule iModule : this.iZ.values()) {
            if (iModule.isInternal() || bl2 && !this.isModuleAllowed(iModule)) continue;
            arrayList.add(iModule);
        }
        return arrayList;
    }

    public ArrayList<String> getPaths() {
        ArrayList<String> arrayList = new ArrayList<String>();
        TreeSet<IModule> treeSet = new TreeSet<IModule>(new d(this));
        treeSet.addAll(this.iZ.values());
        for (IModule iModule : treeSet) {
            boolean bl2;
            if (iModule.isInternal() || !(bl2 = this.isModuleAllowed(iModule))) continue;
            arrayList.add(iModule.getPath());
        }
        return arrayList;
    }

    public boolean isModuleAllowed(IModule iModule) {
        if (iModule == null) {
            return false;
        }
        Permission permission = iModule.getRequiredPermission();
        if (permission == null) {
            return true;
        }
        WebUserInfo webUserInfo = WebUserInfoFactory.getSessionWebUserInfo();
        if (webUserInfo == null) {
            return false;
        }
        if (webUserInfo.isSystemAdministrator()) {
            return true;
        }
        return SystemPermissionChecker.checkAccess(webUserInfo, permission);
    }

    public IModule getModule(String string) {
        if (string != null && string.length() > 1 && string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return this.iZ.get(string);
    }

    public void printException(Throwable throwable) {
        IModule iModule = this.getModule("/error");
        if (iModule != null) {
            ApplicationInstance applicationInstance = ApplicationInstance.getActive();
            applicationInstance.setContextProperty("errormessage", (Object)throwable);
            applicationInstance.getDefaultWindow().setContent(iModule.getContent(this));
        }
    }

    public void createContent(String string) {
        h h2 = new h(this);
        ApplicationInstance applicationInstance = ApplicationInstance.getActive();
        if (!h2.b(applicationInstance)) {
            try {
                applicationInstance.setContextProperty("redirectPath", (Object)string);
                h2.bd();
            }
            catch (Throwable throwable) {
                this.printException(throwable);
            }
        } else {
            Object object = applicationInstance.getContextProperty("redirectPath");
            if (object != null) {
                applicationInstance.setContextProperty("redirectPath", null);
                string = object.toString();
            }
            if ("/".equals(string) || string.length() == 0) {
                string = "/start";
            }
            IModule iModule = null;
            ArrayList<IModule> arrayList = this.getModules(false);
            ArrayList<IModule> arrayList2 = this.getModules(true);
            iModule = arrayList != null && arrayList.size() == 1 && !string.equals("/error") && !string.equals("/login") && !string.equals("/logout") ? arrayList.get(0) : this.getModule(string);
            if (iModule != null) {
                if (iModule.getPath().equals("/start") && arrayList2.size() == 1) {
                    iModule = arrayList2.get(0);
                }
                if (!this.isModuleAllowed(iModule)) {
                    this.printException(new com.inet.report.permissions.a(string));
                } else {
                    try {
                        if (iModule.getType() == IModule.TYPE.GWT) {
                            applicationInstance.setContextProperty("redirectPath", null);
                            String string2 = iModule.getPath();
                            String string3 = WebRenderServlet.getActiveConnection().getUserInstance().getServletUri();
                            if (string3.endsWith("/")) {
                                string3 = string3.substring(0, string3.length() - 1);
                            }
                            if (string3.endsWith(string2)) {
                                string3 = string3.substring(0, string3.length() - string2.length());
                            }
                            applicationInstance.enqueueCommand((Command)new BrowserRedirectCommand(string3 + string2));
                        } else {
                            ContentPane contentPane = iModule.getContent(this);
                            if (contentPane != null) {
                                applicationInstance.getDefaultWindow().setContent(contentPane);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        this.printException(throwable);
                    }
                }
            } else {
                this.printException(new e(string));
            }
        }
    }

    public static boolean checkForRedirectToAccessDenied(IModule iModule) {
        com.inet.remote.gui.c c2;
        ModuleManager moduleManager;
        ApplicationInstance applicationInstance;
        ConfigurationManager configurationManager = ConfigurationManager.getInstance();
        boolean bl2 = false;
        Configuration configuration = configurationManager.getCurrent();
        if (configuration != null) {
            bl2 = Boolean.valueOf(configuration.get("systempermission.enabled", "false"));
        }
        if (bl2 && (applicationInstance = ApplicationInstance.getActive()) instanceof com.inet.remote.gui.c && !(moduleManager = (c2 = (com.inet.remote.gui.c)applicationInstance).ba()).isModuleAllowed(iModule)) {
            HttpServletRequest httpServletRequest = WebRenderServlet.getActiveConnection().getRequest();
            String string = httpServletRequest.getRequestURI();
            string = string.substring(httpServletRequest.getContextPath().length());
            string = string.substring("/remote".length());
            moduleManager.createContent(string);
            return true;
        }
        return false;
    }

    public void setLocale(Locale locale) {
        Locale locale2 = locale = locale == null ? Locale.getDefault() : locale;
        if (!locale.equals(this.locale)) {
            this.locale = locale;
            this.ja = new a(locale, "com.inet.remote.gui.i18n.LanguageResources");
            for (Map.Entry<String, IModule> entry : this.iZ.entrySet()) {
                entry.getValue().setLocale(locale);
            }
        }
    }

    public Locale getLocale() {
        return this.locale;
    }
}

