/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.designer.jnlp.BaseUpdateableClassLoader;
import com.inet.lib.util.DotNetUtils;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.dk;
import com.inet.report.f;
import com.inet.report.i18n.ErrorCode;
import com.inet.report.logging.StaticStreamLogger;
import com.inet.report.util.UpdateableClassLoader;
import com.inet.report.util.UrlUpdateableClassLoader;
import com.inet.report.util.ab;
import com.inet.viewer.SwingReportViewer;
import com.inet.viewer.SwingViewerUtils;
import com.inet.viewer.ViewerUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.sql.DriverManager;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;

public class BaseUtils {
    public static boolean IS_STANDALONE_SERVER;
    private static Charset ic;
    public static SAXParserFactory IV;
    public static ClassLoader IW;
    private static StaticStreamLogger IX;
    private static final String[] IY;
    public static final Class IZ;
    public static UpdateableClassLoader.ClassLoaderListener Ja;
    public static ArrayList Jb;

    public static String getVersion() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string = System.getProperty("test.versionOverride");
            if (string != null) {
                return string;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        stringBuffer.append(13);
        stringBuffer.append(".");
        stringBuffer.append(1);
        stringBuffer.append(".");
        stringBuffer.append("225");
        stringBuffer.append(SwingReportViewer.getVersionSuffix());
        return stringBuffer.toString();
    }

    public static void a(StaticStreamLogger staticStreamLogger) {
        if (staticStreamLogger == null) {
            throw new IllegalArgumentException("logger may not be null");
        }
        IX = staticStreamLogger;
    }

    public static StaticStreamLogger gj() {
        return IX;
    }

    public static boolean isParanoid() {
        return BaseUtils.getLogLevel() >= 4;
    }

    public static boolean isDebug() {
        return BaseUtils.getLogLevel() >= 4;
    }

    public static boolean isInfo() {
        return BaseUtils.getLogLevel() >= 3;
    }

    public static boolean gk() {
        return BaseUtils.getLogLevel() >= 2;
    }

    public static boolean isError() {
        return BaseUtils.getLogLevel() >= 1;
    }

    public static void O(String string) {
        if (IX == null) {
            return;
        }
        IX.fatal(string);
    }

    public static void error(Object object) {
        if (IX == null) {
            return;
        }
        IX.error(object);
    }

    public static void warning(Object object) {
        if (IX == null) {
            return;
        }
        IX.warn(object);
    }

    public static void info(Object object) {
        if (IX == null) {
            return;
        }
        IX.info(object);
    }

    public static void debug(Object object) {
        if (IX == null) {
            return;
        }
        IX.debug(object);
    }

    public static void paranoid(Object object) {
        BaseUtils.debug(object);
    }

    public static boolean gl() {
        if (IX == null) {
            return false;
        }
        return IX.isEnabled();
    }

    public static void status(Object object) {
        if (IX == null) {
            return;
        }
        IX.status(object);
    }

    public static void printStackTrace(Throwable throwable) {
        if (IX == null) {
            return;
        }
        IX.printStackTrace(throwable);
    }

    public static void setLogLevel(int n2) {
        if (IX == null) {
            return;
        }
        IX.setLogLevel(n2);
    }

    public static void closeLogStream() {
        if (IX == null) {
            return;
        }
        IX.closeLogStream();
    }

    public static PrintStream getLogStream() {
        if (IX == null) {
            return null;
        }
        return IX.getLogStream();
    }

    public static int getLogLevel() {
        if (IX == null) {
            return 0;
        }
        return IX.getLogLevel();
    }

    public static void setLogStream(PrintStream printStream) {
        if (IX != null) {
            IX.setLogStream(printStream);
        }
        try {
            ViewerUtils.setLogStream(printStream);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            BaseUtils.warning(ReportExceptionFactory.createReportExceptionWithCause(noClassDefFoundError, ErrorCode.MissingViewer, new Object[0]));
        }
    }

    public static byte[] getBytes(String string) {
        byte[] byArray = new byte[string.length()];
        for (int i2 = 0; i2 < string.length(); ++i2) {
            byArray[i2] = (byte)string.charAt(i2);
        }
        return byArray;
    }

    public static byte[] getBytesUTF8(String string) {
        return SwingViewerUtils.getBytesUTF8(string);
    }

    public static String getStringUTF8(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return new String(byArray, ic);
    }

    public static String a(byte[] byArray, int n2, int n3) {
        return new String(byArray, n2, n3, ic);
    }

    public static String encrypt(String string) {
        return SwingViewerUtils.encrypt(string);
    }

    private static byte[] unhex(String string) {
        byte[] byArray = new byte[string.length() / 2];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = (byte)Integer.parseInt(string.substring(2 * i2, 2 * i2 + 2), 16);
        }
        return byArray;
    }

    public static String decrypt(String string) {
        if (string == null) {
            return "";
        }
        if (string.startsWith("00")) {
            int n2;
            int n3 = "00".length();
            byte[] byArray = BaseUtils.unhex(string.substring(n3, n3 += 32));
            byte[] byArray2 = BaseUtils.unhex(string.substring(n3));
            byte by2 = 0;
            for (n2 = 0; n2 < byArray2.length; ++n2) {
                by2 = byArray2[n2] = (byte)(byArray2[n2] ^ by2 ^ byArray[n2 % 15]);
            }
            n2 = (byArray2[0] & 0xFF) + ((byArray2[1] & 0xFF) << 8);
            try {
                return new String(byArray2, 2, n2, "UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new String(byArray2, 2, n2);
            }
        }
        return string;
    }

    public static String L(int n2) {
        if (n2 >= 0 && n2 < IY.length) {
            return IY[n2];
        }
        return BaseUtils.M(n2);
    }

    private static String M(int n2) {
        n2 = Math.max(0, n2);
        char[] cArray = new char[n2 * 2];
        Arrays.fill(cArray, ' ');
        return new String(cArray);
    }

    public static ClassLoader getUpdateableClassLoader() {
        return IW;
    }

    private static void gm() {
        block9: {
            ClassLoader classLoader = IW;
            if (classLoader instanceof UpdateableClassLoader) {
                ((UpdateableClassLoader)((Object)classLoader)).removeClassLoaderListener(Ja);
            }
            IW = IZ.getClassLoader();
            try {
                if (IW instanceof BaseUpdateableClassLoader) {
                    if (BaseUtils.isDebug()) {
                        BaseUtils.debug("Use parent classloader as updatable: " + IW.getClass().getName());
                    }
                    IW = new ab((BaseUpdateableClassLoader)((Object)IW));
                } else {
                    if (BaseUtils.isDebug()) {
                        BaseUtils.debug("Use URLUpdateableClassLoader.");
                    }
                    IW = new ab(new UrlUpdateableClassLoader(IW));
                }
                if (classLoader instanceof UpdateableClassLoader) {
                    ((UpdateableClassLoader)((Object)classLoader)).close();
                }
            }
            catch (SecurityException securityException) {
                if (!BaseUtils.gk()) break block9;
                BaseUtils.warning("[UpdateableClassLoader] no UpdateableClassLoader available");
                BaseUtils.warning(securityException);
            }
        }
        if (IW instanceof UpdateableClassLoader) {
            ((UpdateableClassLoader)((Object)IW)).addClassLoaderListener(Ja);
        }
    }

    private static Class a(String string, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            return Class.forName(string.trim(), true, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (DotNetUtils.isDotNet()) {
                try {
                    return Class.forName("cli." + string.trim(), true, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    // empty catch block
                }
            }
            throw classNotFoundException;
        }
    }

    public static Class classForName(String string) throws ClassNotFoundException {
        try {
            return BaseUtils.a(string.trim(), IW);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return BaseUtils.a(string.trim(), Thread.currentThread().getContextClassLoader());
        }
    }

    public static <T> List<T> a(String string, Class<T> clazz) {
        String[] stringArray;
        ArrayList arrayList = new ArrayList();
        if (string == null) {
            return arrayList;
        }
        for (String string2 : stringArray = string.split(",|;")) {
            if ((string2 = string2.trim()).isEmpty()) continue;
            try {
                Class clazz2 = BaseUtils.classForName(string2);
                if (clazz.isAssignableFrom(clazz2)) {
                    arrayList.add(clazz2.newInstance());
                    continue;
                }
                BaseUtils.warning("Loading of Class \"" + string2 + "\" failed. Reason: Not an instance of : " + clazz.getName());
            }
            catch (Throwable throwable) {
                BaseUtils.warning("Loading of Class \"" + string2 + "\" failed. Reason: " + throwable);
            }
        }
        return arrayList;
    }

    public static List<Object> getParams(String string, String string2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (string == null) {
            return arrayList;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String[] stringArray = string.split("\"", -1);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string3 = stringArray[i2];
            if (i2 % 2 == 0) {
                String string4;
                int n2;
                int n3 = string3.length();
                int n4 = 0;
                char[] cArray = string3.toCharArray();
                for (n2 = 0; n2 < n3 && cArray[n4 + n2] <= ','; ++n2) {
                }
                while (n2 < n3 && cArray[n4 + n3 - 1] <= ',') {
                    --n3;
                }
                String string5 = string4 = n2 > 0 || n3 < string3.length() ? string3.substring(n2, n3) : string3;
                if (string4.isEmpty()) continue;
                arrayList2.addAll(Arrays.asList(string4.split(string2)));
                continue;
            }
            arrayList2.add(string3);
        }
        for (String string3 : arrayList2) {
            string3 = string3.trim();
            try {
                arrayList.add(Integer.parseInt(string3));
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    arrayList.add(Double.parseDouble(string3));
                }
                catch (NumberFormatException numberFormatException2) {
                    if (string3.equalsIgnoreCase("true")) {
                        arrayList.add(Boolean.TRUE);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("false")) {
                        arrayList.add(Boolean.FALSE);
                        continue;
                    }
                    if (string3.startsWith("\"") && string3.endsWith("\"") && string3.length() > 1) {
                        arrayList.add(string3.substring(1, string3.length() - 1));
                        continue;
                    }
                    try {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
                        simpleDateFormat.setLenient(false);
                        Date date = simpleDateFormat.parse(string3);
                        if (date != null) {
                            arrayList.add(date);
                            continue;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    arrayList.add(string3);
                }
            }
        }
        return arrayList;
    }

    public static String validateKeyStore(String string, String string2, String string3, String string4, String string5) {
        String string6 = null;
        KeyStore keyStore = null;
        if (string == null || string.trim().length() == 0) {
            string6 = "key store type not defined";
        } else if (string2 == null || string2.trim().length() == 0) {
            string6 = "key store path not defined";
        } else if (string3 == null || string3.trim().length() == 0) {
            string6 = "key store password not defined";
        } else {
            char[] cArray = string3.toCharArray();
            try {
                keyStore = KeyStore.getInstance(string);
            }
            catch (KeyStoreException keyStoreException) {
                string6 = keyStoreException.getMessage();
            }
            if (keyStore != null) {
                try {
                    keyStore.load(new FileInputStream(string2), cArray);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    string6 = "file " + string2 + " not found";
                }
                catch (IOException iOException) {
                    String string7 = iOException.getMessage();
                    if (string7.indexOf("password") == -1) {
                        String string8 = BaseUtils.P(string2);
                        if (string8 != null) {
                            if (!string8.equalsIgnoreCase(string)) {
                                string6 = "Incorrect keystore format. Please try to take " + string8 + " format";
                            } else if (string.equalsIgnoreCase("PKCS12")) {
                                int n2 = string7.indexOf(58);
                                if (n2 != -1 && n2 < string7.length() - 1) {
                                    string7 = string7.substring(0, n2);
                                }
                                string6 = "Keystore was tampered with, or password was incorrect: " + string7;
                            } else {
                                string6 = string7;
                            }
                        } else {
                            string6 = "Unknown format of key store";
                        }
                    } else {
                        string6 = string7;
                    }
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    string6 = noSuchAlgorithmException.getMessage();
                }
                catch (CertificateException certificateException) {
                    string6 = certificateException.getMessage();
                }
            }
        }
        if (keyStore != null && string6 == null) {
            try {
                BaseUtils.a(keyStore, string3, string4, string5, string2, string, true);
            }
            catch (RuntimeException runtimeException) {
                string6 = runtimeException.getMessage();
            }
            catch (Throwable throwable) {
                int n3;
                String string9 = throwable.getLocalizedMessage();
                if (string.equalsIgnoreCase("PKCS12") && (n3 = string9.indexOf(58)) != -1 && n3 < string9.length() - 1) {
                    string9 = string9.substring(0, n3);
                }
                string6 = "incorrect key password: " + string9;
            }
        }
        return string6;
    }

    @Nonnull
    public static dk a(@Nonnull KeyStore keyStore, @Nonnull String string, @Nullable String string2, @Nullable String string3, @Nonnull String string4, @Nonnull String string5, boolean bl2) throws RuntimeException {
        PrivateKey privateKey = null;
        Certificate certificate = null;
        Certificate[] certificateArray = null;
        String string6 = string2;
        String string7 = string3;
        if (string7 == null || string7.length() == 0) {
            string7 = string;
        }
        try {
            char[] cArray = string7.toCharArray();
            if (string6 != null && string6.length() != 0) {
                privateKey = (PrivateKey)keyStore.getKey(string6, cArray);
            } else {
                Enumeration<String> enumeration = keyStore.aliases();
                while (privateKey == null && enumeration.hasMoreElements()) {
                    string6 = enumeration.nextElement();
                    privateKey = (PrivateKey)keyStore.getKey(string6, cArray);
                }
            }
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            if (string3 != null && string3.length() != 0) {
                BaseUtils.a("Key error: key password may be wrong", unrecoverableKeyException, "Key password may be wrong", bl2);
            }
            BaseUtils.a("Read key from " + string4 + " failed:" + unrecoverableKeyException.getMessage(), unrecoverableKeyException, "Read key failed: " + unrecoverableKeyException.getMessage(), bl2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            BaseUtils.a("Getting private key from " + string4 + " failed because the algorithm for this key is not available: " + noSuchAlgorithmException.getMessage(), noSuchAlgorithmException, "Algorithm is not available: " + noSuchAlgorithmException.getMessage(), bl2);
        }
        catch (KeyStoreException keyStoreException) {
            BaseUtils.a("Cannot access keys in " + string4 + ": " + keyStoreException.getMessage(), keyStoreException, "Cannot access key " + keyStoreException.getMessage(), bl2);
        }
        catch (Throwable throwable) {
            int n2;
            String string8 = throwable.getLocalizedMessage();
            if (string5.equalsIgnoreCase("PKCS12") && (n2 = string8.indexOf(58)) != -1 && n2 < string8.length() - 1) {
                string8 = string8.substring(0, n2);
            }
            throw new RuntimeException("Loading key error: " + string8, throwable);
        }
        if (privateKey == null) {
            if (string2 != null && string2.length() != 0) {
                BaseUtils.a("Key error: key name may be wrong", null, "Key name may be wrong", bl2);
            } else {
                BaseUtils.a("Key error: No key has been found in key store", null, "No key has been found", bl2);
            }
        }
        try {
            certificate = keyStore.getCertificate(string6);
            certificateArray = keyStore.getCertificateChain(string6);
        }
        catch (KeyStoreException keyStoreException) {
            BaseUtils.a("Reading of certificate from " + string4 + " failed: " + keyStoreException.getMessage(), keyStoreException, "Reading of certificate failed: " + keyStoreException.getMessage(), bl2);
        }
        if (certificate == null) {
            BaseUtils.a("Certificate from " + string4 + " is null", null, "certificate is not defined", bl2);
        }
        if (certificateArray == null && BaseUtils.isDebug()) {
            BaseUtils.debug("Certificate chain not found");
        }
        return new dk(privateKey, certificate, certificateArray);
    }

    private static String P(String string) {
        String string2 = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            byte[] byArray = new byte[4];
            fileInputStream.read(byArray);
            if (byArray[0] == 48 && byArray[1] == -126) {
                string2 = "PKCS12";
            } else if (byArray[0] == -2 && byArray[1] == -19 && byArray[2] == -2 && byArray[3] == -19) {
                string2 = "JKS";
            } else if (byArray[0] == -50 && byArray[1] == -50 && byArray[2] == -50 && byArray[3] == -50) {
                string2 = "JCEKS";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string2;
    }

    public static URL getURL(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (uRL == null) {
            try {
                uRL = new File(string).toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return uRL;
    }

    public static void Q(String string) {
        if (!(IW instanceof UpdateableClassLoader)) {
            return;
        }
        List<URL> list = BaseUtils.R(string);
        if (BaseUtils.s(list)) {
            BaseUtils.gm();
        }
        for (URL uRL : list) {
            if (IW instanceof UpdateableClassLoader) {
                ((UpdateableClassLoader)((Object)IW)).addUrl(uRL);
                continue;
            }
            if (!BaseUtils.isDebug()) continue;
            BaseUtils.debug("[UpdateableClassLoader] NO UpdateableClassLoader available: can not add " + uRL.toString() + " to the classpath");
        }
        if (IW instanceof UpdateableClassLoader) {
            ((UpdateableClassLoader)((Object)IW)).fireLibrariesLoadedEvent();
        }
    }

    private static boolean s(List<URL> list) {
        URL[] uRLArray;
        HashSet<URL> hashSet = new HashSet<URL>();
        hashSet.addAll(list);
        UpdateableClassLoader updateableClassLoader = (UpdateableClassLoader)((Object)IW);
        for (URL uRL : uRLArray = updateableClassLoader.getUrls()) {
            if (hashSet.contains(uRL)) continue;
            return true;
        }
        return false;
    }

    public static List<URL> R(String string) {
        if (string == null) {
            string = "";
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (String malformedURLException : string.split(",")) {
            String object = malformedURLException.trim();
            if (object.length() <= 1) continue;
            hashSet.add(object);
        }
        ArrayList arrayList = new ArrayList();
        for (String string2 : hashSet) {
            File file;
            if (string2.endsWith(".jar") || string2.endsWith(".zip") || string2.endsWith(".dll") || string2.endsWith(".exe")) {
                try {
                    URL uRL = new URL(string2);
                    arrayList.add(uRL);
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if ((file = new File(string2)).exists() && file.isDirectory()) {
                BaseUtils.a(arrayList, file);
                continue;
            }
            if (!BaseUtils.isDebug()) continue;
            BaseUtils.debug("file or directory at location " + string2 + " not found.");
        }
        return arrayList;
    }

    private static void a(List<URL> list, File file) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("scan: " + file);
            }
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                File file2 = fileArray[i2];
                if (file2.isFile()) {
                    String string = file2.getName().toLowerCase();
                    if (!string.endsWith(".jar") && !string.endsWith(".zip") && !string.endsWith(".dll") && !string.endsWith(".exe")) continue;
                    try {
                        list.add(file2.toURI().toURL());
                    }
                    catch (MalformedURLException malformedURLException) {}
                    continue;
                }
                BaseUtils.a(list, file2);
            }
        }
    }

    public static SAXParserFactory newSaxParserFactory() {
        if (IV != null) {
            return IV;
        }
        try {
            Class clazz = BaseUtils.classForName("com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl");
            return (SAXParserFactory)clazz.newInstance();
        }
        catch (Exception exception) {
            BaseUtils.info("SAXParserFactory: " + exception.getMessage());
            return SAXParserFactory.newInstance();
        }
    }

    public static DocumentBuilderFactory newDocumentBuilderFactory() {
        try {
            Class clazz = BaseUtils.classForName("com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl");
            return (DocumentBuilderFactory)clazz.newInstance();
        }
        catch (Exception exception) {
            BaseUtils.info("DocumentBuilderFactory: " + exception.getMessage());
            return DocumentBuilderFactory.newInstance();
        }
    }

    public static void checkForBuildInDocumentBuilderFactory(String string) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        if (!documentBuilderFactory.getClass().getName().startsWith("com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactory")) {
            BaseUtils.warning("You are using the DocumentBuilderFactory '" + documentBuilderFactory.getClass().getName() + "' which is not the default factory. This may cause problem using the " + string + ".");
        }
    }

    public static int b(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return 0;
        }
        if (byArray.length >= 512 && byArray[0] == -48 && byArray[1] == -49 && byArray[2] == 17 && byArray[3] == -32 && byArray[4] == -95 && byArray[5] == -79 && byArray[6] == 26 && byArray[7] == -31) {
            return 1;
        }
        if (byArray.length > 2 && byArray[0] == 80 && byArray[1] == 75) {
            return 4;
        }
        int n2 = 0;
        while ((byArray[n2] & 0xFF) != 60) {
            if (++n2 < byArray.length) continue;
            return 0;
        }
        if (byArray.length > n2 + 60 && byArray[n2] == 60 && byArray[n2 + 1] == 63 && (byArray[n2 + 2] | 0x20) == 120 && (byArray[n2 + 3] | 0x20) == 109 && (byArray[n2 + 4] | 0x20) == 108) {
            n2 += 4;
            while (++n2 < byArray.length) {
                if (byArray[n2] != 60 || byArray[n2 + 1] == 38 || byArray[n2 + 1] == 63 || byArray[n2 + 1] == 37 || byArray[n2 + 1] == 33) continue;
                if (n2 + 6 < byArray.length) {
                    if (byArray[n2 + 1] == 105 && byArray[n2 + 2] == 110 && byArray[n2 + 3] == 101 && byArray[n2 + 4] == 116) {
                        return 2;
                    }
                    if (byArray[n2 + 1] == 82 && byArray[n2 + 2] == 101 && byArray[n2 + 3] == 112 && byArray[n2 + 4] == 111 && byArray[n2 + 5] == 114 && byArray[n2 + 6] == 116) {
                        return 3;
                    }
                    return 0;
                }
                return 0;
            }
        }
        return 0;
    }

    public static int a(InputStream inputStream) throws IOException {
        int n2;
        byte[] byArray = new byte[512];
        for (int i2 = 0; i2 < 512 && (n2 = inputStream.read(byArray, i2, 512 - i2)) >= 0; i2 += n2) {
        }
        return BaseUtils.b(byArray);
    }

    public static void S(String string) {
        if (BaseUtils.isParanoid()) {
            Runtime runtime = Runtime.getRuntime();
            long l2 = runtime.totalMemory();
            long l3 = runtime.freeMemory();
            long l4 = runtime.maxMemory();
            l2 = l2 / 1024L / 1024L;
            l3 = l3 / 1024L / 1024L;
            l4 = l4 / 1024L / 1024L;
            long l5 = l2 - l3;
            BaseUtils.paranoid("Memory at \"" + string + "\": " + "max=" + l4 + " MB\t" + "total=" + l2 + " MB\t" + "free=" + l3 + " MB\t" + "used=" + l5 + " MB");
        }
    }

    public static void gn() {
        block10: {
            try {
                block9: {
                    String string = System.getProperty("java.protocol.handler.pkgs", "");
                    if (string.indexOf("com.inet.protocol") < 0) {
                        if (string.length() > 0) {
                            string = string + "|";
                        }
                        string = string + "com.inet.protocol";
                        System.getProperties().put("java.protocol.handler.pkgs", string);
                    }
                    try {
                        Class<?> clazz = Class.forName("com.inet.protocol.repo.Handler");
                        try {
                            new URL("repo:x.rpt");
                        }
                        catch (MalformedURLException malformedURLException) {
                            Field field = URL.class.getDeclaredField("handlers");
                            field.setAccessible(true);
                            Hashtable hashtable = (Hashtable)field.get(null);
                            hashtable.put("repo", clazz.newInstance());
                        }
                    }
                    catch (Throwable throwable) {
                        if (!BaseUtils.gk()) break block9;
                        BaseUtils.warning("Repository protocol handler unreachable, the protocol may be out of service.");
                        if (!BaseUtils.isDebug()) break block9;
                        BaseUtils.debug(throwable);
                    }
                }
                new URL("repo:x.rpt");
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug("Repository protocol registered");
                }
            }
            catch (Throwable throwable) {
                if (!BaseUtils.isError()) break block10;
                BaseUtils.error("Could not register the repository protocol.");
                BaseUtils.error(throwable);
            }
        }
    }

    public static void a(Thread thread) {
        if (thread != null) {
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("wait until '" + thread.getName() + "' thread dies");
            }
            for (int i2 = 0; i2 < 1000; ++i2) {
                thread.interrupt();
                try {
                    thread.join(10L);
                    if (thread.isAlive()) continue;
                    if (BaseUtils.isDebug()) {
                        BaseUtils.debug("'" + thread.getName() + "' thread ended");
                    }
                    return;
                }
                catch (InterruptedException interruptedException) {
                    BaseUtils.printStackTrace(interruptedException);
                }
            }
            if (thread.isAlive()) {
                BaseUtils.error("thread '" + thread.getName() + "' is alive");
                try {
                    ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
                    ThreadInfo threadInfo = threadMXBean.getThreadInfo(thread.getId(), Integer.MAX_VALUE);
                    BaseUtils.error(threadInfo.toString());
                }
                catch (Throwable throwable) {
                    BaseUtils.error(throwable);
                }
            }
        }
    }

    private static void a(String string, @Nullable Exception exception, String string2, boolean bl2) {
        if (bl2) {
            throw new RuntimeException(string2);
        }
        throw new RuntimeException(string, exception);
    }

    static {
        ic = Charset.forName("UTF8");
        IW = BaseUtils.class.getClassLoader();
        IX = StaticStreamLogger.getInstance("Config");
        IX.setLogStream(System.out);
        DriverManager.getDrivers();
        IY = new String[]{BaseUtils.M(0), BaseUtils.M(1), BaseUtils.M(2), BaseUtils.M(3), BaseUtils.M(4), BaseUtils.M(5), BaseUtils.M(6), BaseUtils.M(7), BaseUtils.M(8), BaseUtils.M(9), BaseUtils.M(10)};
        IZ = BaseUtils.class;
        Ja = new f();
        Jb = new ArrayList();
        BaseUtils.gm();
    }
}

