/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.report.BaseUtils;
import com.inet.report.PropertiesChecker;
import com.inet.report.ReportException;
import com.inet.report.ReportKeyFactory;
import com.inet.report.ajax.a;
import com.inet.report.cache.Cache;
import com.inet.report.cache.EngineFactory;
import com.inet.report.cache.KeyNotFoundException;
import com.inet.report.cache.PageOutOfRangeException;
import com.inet.report.cache.ReportCacheKey;
import com.inet.report.cg;
import com.inet.report.dw;
import com.inet.report.svg.SVGUtils;
import com.inet.report.util.u;
import com.inet.viewer.RenderData;
import com.inet.viewer.ViewerException;
import com.inet.viewer.ViewerUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class CacheRenderData
implements RenderData {
    private final Cache JF;
    private final Properties Iq = new Properties();
    private final PropertiesChecker o;
    private final Object JG;
    private Properties JH = new Properties();
    private String title;
    private String url;
    private ReportCacheKey Ir;
    private int Is = 1;
    private boolean It;

    public CacheRenderData(String string, PropertiesChecker propertiesChecker, Object object) {
        this.JF = Cache.getCache();
        this.setReportLocation(string);
        this.o = propertiesChecker;
        this.JG = object;
    }

    public CacheRenderData(Properties properties, PropertiesChecker propertiesChecker, Object object) {
        this.JF = Cache.getCache();
        this.Iq.putAll((Map<?, ?>)properties);
        this.o = propertiesChecker;
        this.JG = object;
    }

    @Override
    public void setReportTitle(String string) {
        this.title = string;
    }

    @Override
    public String getReportTitle() {
        return this.title;
    }

    @Override
    public void setReportLocation(String string) {
        this.Iq.clear();
        dw.saveParams(string, this.Iq, false);
        try {
            ReportKeyFactory.decodeProps(this.Iq);
        }
        catch (Throwable throwable) {
            BaseUtils.error("cannot decode props " + throwable);
        }
        this.url = string;
    }

    @Override
    public String getReportLocation() {
        return this.url;
    }

    private void ex() throws ViewerException {
        this.Iq.put("export_fmt", "java");
        try {
            this.Ir = this.getKey(this.Iq);
        }
        catch (ReportException reportException) {
            ViewerUtils.printStackTrace(reportException);
            throw new ViewerException("Problem while creating key... ", reportException);
        }
    }

    protected ReportCacheKey getKey(Properties properties) throws ReportException {
        return this.JF.getKey(properties, this.o, this.getEngineFactory(), this.JG);
    }

    @Override
    public byte[] getPageData(int n2) throws ViewerException {
        this.ex();
        try {
            return this.JF.getPageAndWait(this.Ir, n2, 600000);
        }
        catch (PageOutOfRangeException pageOutOfRangeException) {
            return null;
        }
        catch (ReportException reportException) {
            throw ViewerException.createViewerException(reportException);
        }
    }

    @Override
    public int getPageCount() throws ViewerException {
        this.ex();
        try {
            return this.JF.getPageCountAndWait(this.Ir, 600000);
        }
        catch (Exception exception) {
            throw new ViewerException("problem with getting page count", exception);
        }
    }

    @Override
    public boolean isPageLimitExceeded() {
        this.ex();
        try {
            return this.JF.isPageLimitExceeded(this.Ir);
        }
        catch (Exception exception) {
            throw new ViewerException("problem with getting page count", exception);
        }
    }

    @Override
    public byte[] getNextExportChunk() throws ViewerException {
        try {
            String string = this.JH.getProperty("export_fmt");
            if (string.equals("svg")) {
                if (this.Is == 0) {
                    ++this.Is;
                    String string2 = this.JH.getProperty("file");
                    string2 = string2.substring(string2.lastIndexOf("/") + 1, string2.lastIndexOf("."));
                    int n2 = SVGUtils.getAutoRefresh(this.JH);
                    return SVGUtils.getSvgViewerPackage(-1, true, string2, n2);
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                u.a(byteArrayOutputStream, this.Is + ".svg", this.JF.getPageAndWait(this.Ir, this.Is++, 600000));
                return byteArrayOutputStream.toByteArray();
            }
            if (this.Is >= 0) {
                return this.JF.getPageAndWait(this.Ir, this.Is++, 600000);
            }
            ++this.Is;
            if (string.startsWith("htm")) {
                String string3 = this.JH.getProperty("file");
                string3 = string3.substring(string3.lastIndexOf("/") + 1);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                u.a(byteArrayOutputStream, string3, u.Zj());
                return byteArrayOutputStream.toByteArray();
            }
            return null;
        }
        catch (PageOutOfRangeException pageOutOfRangeException) {
            BaseUtils.error("Chunk " + this.Is + " out of range...");
            BaseUtils.printStackTrace(pageOutOfRangeException);
        }
        catch (KeyNotFoundException keyNotFoundException) {
            BaseUtils.printStackTrace(keyNotFoundException);
        }
        catch (ReportException reportException) {
            BaseUtils.printStackTrace(reportException);
        }
        catch (IOException iOException) {
            BaseUtils.printStackTrace(iOException);
        }
        return null;
    }

    @Override
    public int getExportChunkCount(Properties properties) throws ViewerException {
        this.JH = dw.b(this.Iq, properties);
        try {
            this.Ir = this.getKey(this.JH);
        }
        catch (ReportException reportException) {
            ViewerUtils.printStackTrace(reportException);
            throw new ViewerException("Problem while creating key... ", reportException);
        }
        try {
            int n2;
            String string = properties.getProperty("export_fmt");
            if (string.equals("svg")) {
                this.Is = 0;
                n2 = this.JF.getPageCountAndWait(this.Ir, 600000) + 1;
            } else if (string.startsWith("htm")) {
                this.Is = -1;
                n2 = this.JF.getPageCountAndWait(this.Ir, 600000) + 2;
            } else {
                this.Is = 1;
                n2 = this.JF.getPageCountAndWait(this.Ir, 600000);
            }
            Throwable throwable = this.JF.getFailureCause(this.Ir);
            if (throwable != null) {
                throw ViewerException.createViewerException(throwable);
            }
            return n2;
        }
        catch (KeyNotFoundException keyNotFoundException) {
            ViewerUtils.printStackTrace(keyNotFoundException);
        }
        catch (ReportException reportException) {
            ViewerUtils.printStackTrace(reportException);
        }
        return -1;
    }

    protected EngineFactory getEngineFactory() {
        return Cache.getEngineFactory();
    }

    @Override
    public byte[] getGroupTree() throws ViewerException {
        this.ex();
        try {
            return this.JF.getGroupTreeAndWait(this.Ir, -1, 3, 600000);
        }
        catch (KeyNotFoundException keyNotFoundException) {
            ViewerUtils.printStackTrace(keyNotFoundException);
        }
        catch (ReportException reportException) {
            ViewerUtils.printStackTrace(reportException);
        }
        return null;
    }

    @Override
    public byte[] refreshPageData(int n2) throws ViewerException {
        if (this.It) {
            this.Iq.put("promptonrefresh", "1");
        }
        return this.getPageData(n2);
    }

    @Override
    public void setReportProperty(String string, String string2) {
        if (string2 == null) {
            this.Iq.remove(string);
        } else {
            this.Iq.setProperty(string, string2);
        }
    }

    @Override
    public String getReportProperty(String string) {
        return this.Iq.getProperty(string);
    }

    @Override
    public Properties getProperties() {
        return this.Iq;
    }

    @Override
    public void setPromptOnRefresh(boolean bl2) {
        this.It = bl2;
    }

    @Override
    public boolean isPromptOnRefresh() {
        return this.It;
    }

    @Override
    public RenderData getCopy() {
        return new CacheRenderData(this.url, this.o, this.JG);
    }

    @Override
    public void stop() {
    }

    @Override
    public byte[] search(String string, int n2, int n3) {
        try {
            return new a(this).search(string, n2, n3);
        }
        catch (ViewerException viewerException) {
            return cg.b(viewerException, this.Iq);
        }
    }

    @Override
    public byte[] getFontData(int n2) {
        try {
            return this.JF.getPageAndWait(this.Ir, -n2, 600000);
        }
        catch (PageOutOfRangeException pageOutOfRangeException) {
            return null;
        }
        catch (ReportException reportException) {
            throw ViewerException.createViewerException(reportException);
        }
    }

    @Override
    public void resetServerCacheTimeout() {
        Properties properties = (Properties)this.Iq.clone();
        try {
            this.Ir = this.JF.createKey(properties, this.o, this.JG);
        }
        catch (ReportException reportException) {
            ViewerUtils.printStackTrace(reportException);
            throw new ViewerException("Problem while creating key... ", reportException);
        }
        if (!this.JF.exists(this.Ir)) {
            throw new ViewerException("report is no longer in the cache. You should not see this error.");
        }
        this.JF.resetCacheTimeout(this.Ir);
    }
}

