/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.report.CrossTab;
import com.inet.report.CrossTabBodyCell;
import com.inet.report.CrossTabHeader;
import com.inet.report.CrossTabHeaderList;
import com.inet.report.Element;
import com.inet.report.Field;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.SummaryField;
import com.inet.report.ah;
import com.inet.report.i18n.ErrorCode;
import com.inet.report.parser.NodeParser;
import com.inet.report.s;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CrossTabBody
implements Serializable {
    private final CrossTab Lh;
    private final List<CrossTabBodyCell> Li;
    private final List<SummaryField> Lj;

    CrossTabBody(@Nonnull CrossTab crossTab) {
        this.Lh = crossTab;
        this.Li = new ArrayList<CrossTabBodyCell>();
        this.Lj = new ArrayList<SummaryField>();
    }

    public int getCellCount() {
        return this.Li.size();
    }

    public void removeSummaryField(int n2) throws ReportException {
        if (n2 >= this.Lj.size()) {
            throw ReportExceptionFactory.createReportException(ErrorCode.elementNotFound, new Object[0]);
        }
        if (n2 < 0) {
            throw ah.a("index", n2, null);
        }
        SummaryField summaryField = this.Lj.remove(n2);
        for (int i2 = 0; i2 < this.Li.size(); ++i2) {
            this.Li.get(i2).remove(n2);
        }
        summaryField.getField().removeReferenceHolder(this.Lh);
        this.Lh.gZ().hk();
        this.Lh.gZ().hl();
    }

    @Nonnull
    public SummaryField getSummaryField(int n2) {
        return this.Lj.get(n2);
    }

    public int getSummaryFieldsCount() {
        return this.Lj.size();
    }

    public SummaryField addSummaryField(@Nonnull Field field, int n2) {
        SummaryField summaryField = new SummaryField(this.Lh.DE);
        summaryField.setName(field.getName());
        summaryField.setField(field);
        summaryField.setSummaryOperation(n2);
        summaryField.setSummaryFieldType(1);
        this.addSummaryField(summaryField);
        return summaryField;
    }

    void addSummaryField(@Nonnull SummaryField summaryField) {
        this.Lj.add(summaryField);
        for (int i2 = 0; i2 < this.Li.size(); ++i2) {
            this.Li.get(i2).b(summaryField);
        }
        this.Lh.gZ().hk();
        this.Lh.gZ().hl();
        Field field = summaryField.getField();
        if (field != null) {
            field.removeReferenceHolder(summaryField);
            field.addReferenceHolder(this.Lh);
        }
    }

    void hg() {
        if (this.Li.size() > 0) {
            CrossTabBodyCell crossTabBodyCell = this.Li.get(0);
            for (int i2 = this.Lj.size(); i2 < crossTabBodyCell.getFieldElementCount(); ++i2) {
                this.Lj.add((SummaryField)crossTabBodyCell.getFieldElement(i2).getField());
            }
        }
    }

    void setReferences() {
        NodeParser nodeParser;
        int n2;
        this.hg();
        for (n2 = 0; n2 < this.Lj.size(); ++n2) {
            nodeParser = this.Lj.get(n2);
            if (((Field)nodeParser).getField() != null) {
                ((Field)nodeParser).getField().addReferenceHolder(this.Lh);
            }
            if (((SummaryField)nodeParser).getField2nd() == null) continue;
            ((SummaryField)nodeParser).getField2nd().addReferenceHolder(this.Lh);
        }
        for (n2 = 0; n2 < this.Li.size(); ++n2) {
            nodeParser = this.Li.get(n2);
            for (int i2 = 0; i2 < ((CrossTabBodyCell)nodeParser).getFieldElementCount(); ++i2) {
                ((CrossTabBodyCell)nodeParser).getFieldElement(i2).setReferences();
            }
        }
    }

    void resetReferences() {
        NodeParser nodeParser;
        int n2;
        for (n2 = 0; n2 < this.Lj.size(); ++n2) {
            nodeParser = this.Lj.get(n2);
            if (((Field)nodeParser).getField() != null) {
                ((Field)nodeParser).getField().removeReferenceHolder(this.Lh);
            }
            ((SummaryField)nodeParser).resetReferences();
        }
        for (n2 = 0; n2 < this.Li.size(); ++n2) {
            nodeParser = this.Li.get(n2);
            for (int i2 = 0; i2 < ((CrossTabBodyCell)nodeParser).getFieldElementCount(); ++i2) {
                ((CrossTabBodyCell)nodeParser).getFieldElement(i2).resetReferences();
            }
        }
    }

    public CrossTabBodyCell getCell(int n2) {
        return this.Li.get(n2);
    }

    @Nonnull
    public CrossTabBodyCell getCell(int n2, int n3) {
        CrossTabHeader crossTabHeader = this.Lh.getRows().get(n2);
        CrossTabHeader crossTabHeader2 = this.Lh.getColumns().get(n3);
        int n4 = this.Li.size() - n2 - n3 * this.Lh.getRows().size() - 1;
        CrossTabBodyCell crossTabBodyCell = this.Li.get(n4);
        if (crossTabBodyCell.getRow() == crossTabHeader && crossTabBodyCell.getColumn() == crossTabHeader2) {
            return crossTabBodyCell;
        }
        Collections.sort(this.Li, new a(this.Lh));
        crossTabBodyCell = this.Li.get(n4);
        if (crossTabBodyCell.getRow() == crossTabHeader && crossTabBodyCell.getColumn() == crossTabHeader2) {
            return crossTabBodyCell;
        }
        throw new IllegalStateException("Cell not found: " + n2 + ", " + n3);
    }

    @Nonnull
    CrossTabBodyCell hh() {
        return this.a(this.Li.size(), null, null);
    }

    void a(@Nullable CrossTabHeader crossTabHeader) {
        for (int i2 = 0; i2 < this.Li.size(); ++i2) {
            CrossTabBodyCell crossTabBodyCell = this.Li.get(i2);
            if (crossTabBodyCell.getRow() != crossTabHeader && crossTabBodyCell.getColumn() != crossTabHeader) continue;
            this.Li.remove(i2);
            --i2;
        }
    }

    void b(@Nonnull CrossTabHeader crossTabHeader) {
        CrossTabHeaderList crossTabHeaderList = this.Lh.getColumns();
        int n2 = crossTabHeaderList.size();
        int n3 = this.Lh.getRows().size();
        for (int i2 = 0; i2 < n2; ++i2) {
            CrossTabHeader crossTabHeader2 = crossTabHeaderList.get(i2);
            this.a((i2 + 1) * n3 - 1, crossTabHeader, crossTabHeader2);
        }
    }

    void c(@Nonnull CrossTabHeader crossTabHeader) {
        CrossTabHeaderList crossTabHeaderList = this.Lh.getRows();
        int n2 = crossTabHeaderList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            CrossTabHeader crossTabHeader2 = crossTabHeaderList.get(i2);
            this.a(this.Li.size(), crossTabHeader2, crossTabHeader);
        }
    }

    @Nonnull
    private CrossTabBodyCell a(int n2, @Nullable CrossTabHeader crossTabHeader, @Nullable CrossTabHeader crossTabHeader2) {
        CrossTabBodyCell crossTabBodyCell = new CrossTabBodyCell(this.Lh, crossTabHeader, crossTabHeader2);
        this.Li.add(n2, crossTabBodyCell);
        if (crossTabHeader != null && crossTabHeader2 != null) {
            int n3 = this.Lj.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                crossTabBodyCell.b(this.Lj.get(i2));
            }
        }
        return crossTabBodyCell;
    }

    int f(@Nullable Element element) {
        for (int i2 = this.Li.size() - 1; i2 >= 0; --i2) {
            CrossTabBodyCell crossTabBodyCell = this.Li.get(i2);
            for (int i3 = crossTabBodyCell.getFieldElementCount() - 1; i3 >= 0; --i3) {
                if (element != crossTabBodyCell.getFieldElement(i3)) continue;
                return i2;
            }
        }
        return -1;
    }

    void hi() {
        s s2 = this.Lh.gZ();
        for (int i2 = 0; i2 < this.Li.size(); ++i2) {
            CrossTabBodyCell crossTabBodyCell = this.Li.get(i2);
            int n2 = crossTabBodyCell.getFieldElementCount();
            for (int i3 = 0; i3 < n2; ++i3) {
                crossTabBodyCell.getFieldElement(i3).addPropertyChangeListener(s2);
            }
        }
    }

    private static class a
    implements Comparator<CrossTabBodyCell> {
        private final CrossTabHeaderList Kq;
        private final CrossTabHeaderList Kp;

        private a(@Nonnull CrossTab crossTab) {
            this.Kq = crossTab.getRows();
            this.Kp = crossTab.getColumns();
        }

        public int a(CrossTabBodyCell crossTabBodyCell, CrossTabBodyCell crossTabBodyCell2) {
            int n2;
            int n3 = this.Kp.g(crossTabBodyCell.getColumn());
            if (n3 == (n2 = this.Kp.g(crossTabBodyCell2.getColumn()))) {
                int n4;
                int n5 = this.Kq.g(crossTabBodyCell.getRow());
                return n5 < (n4 = this.Kq.g(crossTabBodyCell2.getRow())) ? 1 : (n5 == n4 ? 0 : -1);
            }
            return n3 < n2 ? 1 : -1;
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((CrossTabBodyCell)object, (CrossTabBodyCell)object2);
        }
    }
}

