/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.report.CrossTab;
import com.inet.report.CrossTabBody;
import com.inet.report.CrossTabHeader;
import com.inet.report.Element;
import com.inet.report.Field;
import com.inet.report.FieldElement;
import com.inet.report.FormulaField;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.ah;
import com.inet.report.i18n.ErrorCode;
import com.inet.report.s;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class CrossTabHeaderList
implements Serializable {
    private final CrossTab Lh;
    @Nonnull
    private final List<CrossTabHeader> headers;
    private boolean LQ;
    private FormulaField LR;
    private FormulaField LS;
    private boolean LT;
    private boolean LU;
    private int LV;

    CrossTabHeaderList(CrossTab crossTab) {
        this.Lh = crossTab;
        this.headers = new ArrayList<CrossTabHeader>();
    }

    public void remove(int n2) throws ReportException {
        if (n2 == 0) {
            throw ReportExceptionFactory.createReportException(ErrorCode.CantDropGrandTotal, new Object[0]);
        }
        CrossTabHeader crossTabHeader = this.headers.get(n2);
        this.Lh.getBody().a(crossTabHeader);
        this.headers.remove(n2);
        crossTabHeader.resetReferences();
        this.Lh.gZ().hk();
        this.Lh.gZ().hl();
    }

    @Nonnull
    public CrossTabHeader add(@Nonnull Field field) {
        int n2;
        int n3;
        CrossTabHeader crossTabHeader = new CrossTabHeader(this.Lh, this, field);
        this.headers.add(crossTabHeader);
        CrossTabBody crossTabBody = this.Lh.getBody();
        if (this.isRow()) {
            crossTabBody.b(crossTabHeader);
            n3 = 2036;
            int n4 = Math.max(1, crossTabBody.getSummaryFieldsCount());
            n2 = 230 * n4;
        } else {
            crossTabBody.c(crossTabHeader);
            n3 = 810;
            n2 = 230;
        }
        Element element = crossTabHeader.getFieldElement();
        if (element == null) {
            element = crossTabHeader.getText();
        }
        element.setWidth(n3);
        element.setHeight(n2);
        return crossTabHeader;
    }

    public void move(int n2, int n3) throws ReportException {
        if (n2 == 0 || n3 == 0) {
            throw ReportExceptionFactory.createReportException(ErrorCode.CantDropGrandTotal, new Object[0]);
        }
        this.headers.get(n3);
        CrossTabHeader crossTabHeader = this.headers.remove(n2);
        this.headers.add(n3, crossTabHeader);
        this.Lh.gZ().hk();
        this.Lh.gZ().hl();
    }

    @Nonnull
    @Deprecated
    CrossTabHeader hD() {
        CrossTabHeader crossTabHeader = new CrossTabHeader(this.Lh, this, null);
        this.headers.add(crossTabHeader);
        return crossTabHeader;
    }

    @Nonnull
    public CrossTabHeader get(int n2) {
        return this.headers.get(n2);
    }

    public boolean isRow() {
        return this == this.Lh.getRows();
    }

    public int size() {
        return this.headers.size();
    }

    @Nonnull
    public CrossTabHeader getGrandTotal() {
        return this.headers.get(0);
    }

    public boolean getTotalOnStart() {
        return this.LQ;
    }

    public void setTotalOnStart(boolean bl2) {
        this.LQ = bl2;
    }

    public void setTotalOnStartFormula(FormulaField formulaField) {
        String string;
        int n2;
        FormulaField.e(this.LR);
        if (this.isRow()) {
            n2 = 465;
            string = "rowTotalOnLeft";
        } else {
            n2 = 466;
            string = "columnTotalOnTop";
        }
        this.LR = this.Lh.a(formulaField, n2, string);
    }

    public FormulaField getTotalOnStartFormula() {
        return this.LR;
    }

    public boolean getSuppressEmptyLines() {
        return this.LT;
    }

    public void setSuppressEmptyLines(boolean bl2) {
        this.LT = bl2;
    }

    public void setSuppressEmptyLinesFormula(FormulaField formulaField) {
        String string;
        int n2;
        FormulaField.e(this.LS);
        if (this.isRow()) {
            n2 = 455;
            string = "suppressEmptyRows";
        } else {
            n2 = 454;
            string = "suppressEmptyColumns";
        }
        this.LS = this.Lh.a(formulaField, n2, string);
    }

    public FormulaField getSuppressEmptyLinesFormula() {
        return this.LS;
    }

    public boolean getIndentLabel() {
        return this.LU;
    }

    public void setIndentLabel(boolean bl2) {
        if (this.LU != bl2) {
            this.LU = bl2;
            this.Lh.gZ().hk();
            this.Lh.gZ().hl();
        }
    }

    public int getIndentLabelSize() {
        return this.LV;
    }

    public void setIndentLabelSize(int n2) {
        if (n2 < 0) {
            throw ah.a("indentLabelSize", n2, null);
        }
        if (this.LV != n2) {
            this.LV = n2;
            if (this.isRow()) {
                this.Lh.gZ().hk();
            } else {
                this.Lh.gZ().hl();
            }
        }
    }

    void setReferences() {
        for (int i2 = 0; i2 < this.headers.size(); ++i2) {
            this.headers.get(i2).setReferences();
        }
    }

    void resetReferences() {
        for (int i2 = 0; i2 < this.headers.size(); ++i2) {
            this.headers.get(i2).resetReferences();
        }
    }

    void t(@Nonnull List<FormulaField> list) {
        for (int i2 = 0; i2 < this.headers.size(); ++i2) {
            this.headers.get(i2).t(list);
        }
        if (this.LS != null) {
            list.add(this.LS);
        }
        if (this.LR != null) {
            list.add(this.LR);
        }
    }

    int g(CrossTabHeader crossTabHeader) {
        return this.headers.indexOf(crossTabHeader);
    }

    int f(Element element) {
        for (int i2 = 0; i2 < this.headers.size(); ++i2) {
            CrossTabHeader crossTabHeader = this.headers.get(i2);
            if (crossTabHeader.getText() != element && crossTabHeader.getFieldElement() != element) continue;
            return i2;
        }
        return -1;
    }

    void hi() {
        s s2 = this.Lh.gZ();
        for (int i2 = 0; i2 < this.headers.size(); ++i2) {
            CrossTabHeader crossTabHeader = this.headers.get(i2);
            crossTabHeader.getText().addPropertyChangeListener(s2);
            FieldElement fieldElement = crossTabHeader.getFieldElement();
            if (fieldElement == null) continue;
            fieldElement.addPropertyChangeListener(s2);
        }
    }
}

