/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.lib.list.IntList;
import com.inet.lib.list.StringList;
import com.inet.report.BaseUtils;
import com.inet.report.DatabaseConfiguration;
import com.inet.report.DatabaseCore;
import com.inet.report.DatabaseField;
import com.inet.report.DatabaseMetaDataFactory;
import com.inet.report.DatabaseTables;
import com.inet.report.Datasource;
import com.inet.report.Engine;
import com.inet.report.Field;
import com.inet.report.Fields;
import com.inet.report.FormulaField;
import com.inet.report.Group;
import com.inet.report.Join;
import com.inet.report.PromptField;
import com.inet.report.ReferenceHolder;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.SQLField;
import com.inet.report.SortField;
import com.inet.report.TableSource;
import com.inet.report.TablesourceList;
import com.inet.report.cb;
import com.inet.report.cc;
import com.inet.report.config.ConfigValue;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.config.structure.model.ConfigKey;
import com.inet.report.cu;
import com.inet.report.database.BaseDataFactory;
import com.inet.report.database.DataFactory;
import com.inet.report.database.JdbcData;
import com.inet.report.database.sql.SqlSyntax;
import com.inet.report.dc;
import com.inet.report.dd;
import com.inet.report.dj;
import com.inet.report.dw;
import com.inet.report.formula.Evaluable;
import com.inet.report.formula.FormulaException;
import com.inet.report.formula.ToSQLResult;
import com.inet.report.formula.ast.o;
import com.inet.report.formula.h;
import com.inet.report.i18n.ErrorCode;
import com.inet.report.list.g;
import com.inet.report.pool.PoolManager;
import com.inet.report.rowsource.f;
import com.inet.report.rowsource.k;
import com.inet.report.rowsource.l;
import com.inet.report.util.i;
import com.inet.report.util.z;
import com.inet.report.v;
import com.inet.report.w;
import com.inet.report.x;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class Database
extends JdbcData
implements SqlSyntax,
Serializable {
    private static final String[] Mf = new String[]{"absolute", "action", "add", "all", "allocate", "alter", "and", "any", "are", "as", "asc", "assertion", "at", "authorization", "avg", "begin", "between", "bit", "bit_length", "both", "by", "cascade", "cascaded", "case", "cast", "catalog", "char", "character", "char_length", "character_length", "check", "close", "coalesce", "collate", "collation", "column", "commit", "connect", "connection", "constraint", "constraints", "continue", "convert", "corresponding", "count", "create", "cross", "current", "current_date", "current_time", "current_timestamp", "current_user", "cursor", "date", "day", "deallocate", "dec", "decimal", "declare", "default", "deferrable", "deferred", "delete", "desc", "describe", "descriptor", "diagnostics", "disconnect", "distinct", "domain", "double", "drop", "else", "end", "end-exec", "escape", "except", "exception", "exec", "execute", "exists", "external", "extract", "false", "fetch", "first", "float", "for", "foreign", "found", "from", "full", "get", "global", "go", "goto", "grant", "group", "having", "hour", "identity", "immediate", "in", "indicator", "initially", "inner", "input", "insensitive", "insert", "int", "integer", "intersect", "interval", "into", "is", "isolation", "join", "key", "language", "last", "leading", "left", "level", "like", "local", "lower", "match", "max", "min", "minute", "module", "month", "names", "national", "natural", "nchar", "next", "no", "not", "null", "nullif", "numeric", "octet_length", "of", "on", "only", "open", "option", "or", "order", "outer", "output", "overlaps", "pad", "partial", "position", "precision", "prepare", "preserve", "primary", "prior", "privileges", "procedure", "public", "read", "real", "references", "relative", "restrict", "revoke", "right", "rollback", "rows", "schema", "scroll", "second", "section", "select", "session", "session_user", "set", "size", "smallint", "some", "space", "sql", "sqlcode", "sqlerror", "sqlstate", "substring", "sum", "system_user", "table", "temporary", "then", "time", "timestamp", "timezone_hour", "timezone_minute", "to", "trailing", "transaction", "translate", "translation", "trim", "true", "union", "unique", "unknown", "update", "upper", "usage", "user", "using", "value", "values", "varchar", "varying", "view", "when", "whenever", "where", "with", "work", "write", "year", "zone"};
    private static int Mg = -154;
    private static int Mh = -153;
    private static ArrayList<String> Mi = new ArrayList();
    private ArrayList<String> Mj = null;
    protected boolean filterSelectionErrorNotShownYet = true;
    static final ConfigValue<Boolean> Mk;
    static final z Ml;
    private static final ConfigValue<Integer> Mm;
    transient TablesourceList Mn;
    transient boolean Mo;
    private transient Vector<Join> Mp;
    private transient StringList Mq;
    private transient Evaluable Mr;
    private transient String Ms;
    private static final ConfigValue<Boolean> Mt;

    public Database() {
        this.initTransient();
    }

    protected void initTransient() {
        this.Mp = new Vector(1);
        this.Mq = new StringList(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean scanSourceType(TableSource tableSource, d d2, boolean bl2) throws SQLException, ReportException {
        if (!this.useJdbcDriver()) {
            return true;
        }
        boolean bl3 = false;
        Datasource datasource = tableSource.getDatasource();
        String[] stringArray = this.parseSourceName(tableSource.sq());
        if (datasource.iL() && stringArray[0] != null) {
            stringArray[0] = datasource.getCatalog();
        }
        if (datasource.iK()) {
            stringArray[1] = datasource.getSchema();
        }
        if (stringArray[0] != null && stringArray[0].length() == 0) {
            stringArray[0] = null;
        }
        if (stringArray[1] != null && stringArray[1].length() == 0) {
            stringArray[1] = null;
        }
        if (stringArray[2] != null && stringArray[2].length() == 0) {
            stringArray[2] = null;
        }
        if (BaseUtils.isInfo()) {
            BaseUtils.info(stringArray[0] + " " + stringArray[1] + " " + stringArray[2] + "  " + this.getClass());
        }
        com.inet.report.database.metadata.a a2 = null;
        com.inet.report.database.metadata.b b2 = null;
        if (Mk.get().booleanValue() && (b2 = (com.inet.report.database.metadata.b)Ml.get(a2 = com.inet.report.database.metadata.a.a(tableSource.getDatasource(), stringArray[0], stringArray[1], stringArray[2]))) != null && bl2) {
            d2.a(b2.AM());
            return b2.AL();
        }
        d2.clear();
        boolean bl4 = datasource.hasValidConnection();
        Connection connection = datasource.getConnection();
        if (connection == null) {
            return false;
        }
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ResultSet resultSet = null;
        int n2 = 4;
        try {
            resultSet = databaseMetaData.getTables(stringArray[0], stringArray[1], stringArray[2], null);
            if (resultSet.next()) {
                String string = resultSet.getString(4);
                n2 = string == null ? 1 : (string.equals("TABLE") ? 1 : (string.equals("VIEW") ? 2 : (string.equals("SYSTEM TABLE") ? 1 : 1)));
            }
        }
        catch (SQLException sQLException) {
            BaseUtils.warning("metadata get tables failed: " + sQLException);
            BaseUtils.printStackTrace(sQLException);
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
            if (!bl4) {
                datasource.closeConnection();
            }
        }
        if (n2 > 1) {
            try {
                resultSet = this.getProcedureColumns(datasource, stringArray[0], stringArray[1], stringArray[2]);
                boolean bl5 = this.scanSourceTypeParameter(resultSet, d2);
                resultSet.close();
                if (n2 == 4 && bl5 || n2 == 2 && d2.MA > 0) {
                    bl3 = true;
                    ++n2;
                } else if (!bl5 && n2 == 4) {
                    try {
                        resultSet = databaseMetaData.getProcedures(stringArray[0], stringArray[1], stringArray[2]);
                        bl3 = resultSet.next();
                        resultSet.close();
                    }
                    catch (Throwable throwable) {
                        BaseUtils.printStackTrace(throwable);
                    }
                }
            }
            catch (Throwable throwable) {
                if (n2 == 4) {
                    bl3 = false;
                }
                BaseUtils.warning("metadata get procedure columns failed: " + throwable);
                BaseUtils.printStackTrace(throwable);
            }
        }
        if (Mk.get().booleanValue() && b2 == null) {
            b2 = new com.inet.report.database.metadata.b(bl3, d2.hM());
            Ml.put(a2, b2);
        }
        return bl3;
    }

    protected void scanIdentifierQuoteString(Datasource datasource) throws SQLException, ReportException {
        Connection connection = datasource.getConnection();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        datasource.getDataFactory().getConfiguration().setIdentifierQuoteString(databaseMetaData.getIdentifierQuoteString(), true);
        Database.a(databaseMetaData, true, true);
    }

    static final void a(DatabaseMetaData databaseMetaData, boolean bl2, boolean bl3) {
        String string;
        String string2;
        String string3;
        String string4;
        block16: {
            block14: {
                string4 = "unknown driver name";
                string3 = "unknown driver version";
                string2 = "unknown database product name";
                string = "unknown database product version";
                if (bl2) {
                    block13: {
                        try {
                            string4 = databaseMetaData.getDriverName();
                        }
                        catch (Throwable throwable) {
                            if (!BaseUtils.isDebug()) break block13;
                            BaseUtils.debug("DatabaseMetaData did not return info about driver name, caused by: " + throwable.toString());
                        }
                    }
                    try {
                        string3 = databaseMetaData.getDriverVersion();
                    }
                    catch (Throwable throwable) {
                        if (!BaseUtils.isDebug()) break block14;
                        BaseUtils.debug("DatabaseMetaData did not return info about driver version, caused by: " + throwable.toString());
                    }
                }
            }
            if (bl3) {
                block15: {
                    try {
                        string2 = databaseMetaData.getDatabaseProductName();
                    }
                    catch (Throwable throwable) {
                        if (!BaseUtils.isDebug()) break block15;
                        BaseUtils.debug("DatabaseMetaData did not return info about database product name, caused by: " + throwable.toString());
                    }
                }
                try {
                    string = databaseMetaData.getDatabaseProductVersion();
                }
                catch (Throwable throwable) {
                    if (!BaseUtils.isDebug()) break block16;
                    BaseUtils.debug("DatabaseMetaData did not return info about database product version, caused by: " + throwable.toString());
                }
            }
        }
        if (BaseUtils.isInfo()) {
            if (bl2) {
                BaseUtils.info("Driver Info  : " + string4 + " , Version: " + string3);
            }
            if (bl3) {
                BaseUtils.info("Database Info: " + string2 + " , Version: " + string);
            }
        }
    }

    protected boolean scanSourceTypeParameter(ResultSet resultSet, d d2) throws SQLException {
        d2.clear();
        boolean bl2 = false;
        while (resultSet.next()) {
            bl2 = true;
            String string = resultSet.getString(4);
            int n2 = resultSet.getInt(5);
            int n3 = resultSet.getInt(6);
            int n4 = resultSet.getInt(10);
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("Add parameter name " + string + " type " + n2 + " dataType " + n3 + " scale " + n4);
            }
            if (string != null) {
                d2.c(new c(string, n2, n3, n4, this.isCursor(n3)));
                continue;
            }
            d2.c(new c("der Treiber hat keinen Namen geliefert", n2, n3, n4, this.isCursor(n3)));
        }
        return bl2;
    }

    protected String[] parseSourceName(String string) {
        return com.inet.report.database.a.a(this.getConfiguration(), string);
    }

    protected String getColumnName(String string, String string2, int n2, TableSource tableSource, int n3) {
        return string;
    }

    void a(DatabaseTables databaseTables) {
        if (this.Mj != null) {
            return;
        }
        if (databaseTables != null) {
            this.Mj = new ArrayList();
            for (int i2 = 0; i2 < databaseTables.getDatasourceCount(); ++i2) {
                Datasource datasource = databaseTables.getDatasource(i2);
                try {
                    String string;
                    boolean bl2 = datasource.hasValidConnection();
                    Connection connection = datasource.getConnection();
                    if (connection == null) continue;
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    if (databaseMetaData != null && (string = databaseMetaData.getSQLKeywords()) != null) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                        while (stringTokenizer.hasMoreElements()) {
                            String string2 = (String)stringTokenizer.nextElement();
                            this.Mj.add(string2.toLowerCase());
                        }
                    }
                    if (bl2) continue;
                    datasource.closeConnection();
                    continue;
                }
                catch (ReportException reportException) {
                    continue;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }

    protected boolean needQuote(String string) {
        if (Mi.contains(string.toLowerCase())) {
            return true;
        }
        if (this.Mj != null && this.Mj.contains(string.toLowerCase())) {
            return true;
        }
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        while (n2-- > 0) {
            switch (cArray[n2]) {
                case ' ': 
                case '!': 
                case '$': 
                case '%': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case '=': 
                case '@': 
                case '\\': 
                case '^': 
                case '`': 
                case '{': 
                case '}': 
                case '~': 
                case '\u00b4': {
                    return true;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (n2 != 0) break;
                    return true;
                }
            }
        }
        return false;
    }

    protected String getSqlIdentifier(DatabaseTables databaseTables, String string, boolean bl2) {
        int n2;
        this.a(databaseTables);
        int n3 = 0;
        String string2 = this.getConfiguration().getIdentifierQuoteString();
        if (string2 == null || string2.length() == 0 || string2.equals(" ")) {
            return string;
        }
        if (bl2) {
            return string2 + string + string2;
        }
        int n4 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n4 * 2);
        n3 = 0;
        do {
            String string3;
            boolean bl3;
            if (bl3 = this.needQuote(string3 = (n2 = string.indexOf(46, n3)) != -1 ? string.substring(n3, n2) : string.substring(n3))) {
                stringBuilder.append(string2);
            }
            if (n2 != -1) {
                stringBuilder.append(string3);
                if (bl3) {
                    stringBuilder.append(string2);
                }
                if (n4 > n2 + 1 && string.charAt(n2 + 1) == '.') {
                    stringBuilder.append("..");
                    n3 = n2 + 2;
                    continue;
                }
                stringBuilder.append('.');
            } else {
                stringBuilder.append(string3);
                if (bl3) {
                    stringBuilder.append(string2);
                }
            }
            n3 = n2 + 1;
        } while (n2 != -1);
        return stringBuilder.toString();
    }

    public String getSqlIdentifier_Alias(DatabaseTables databaseTables, String string) {
        int n2;
        this.a(databaseTables);
        int n3 = 0;
        if (this.getConfiguration().getIdentifierQuoteString() == null || this.getConfiguration().getIdentifierQuoteString().length() == 0 || this.getConfiguration().getIdentifierQuoteString().equals(" ")) {
            return string;
        }
        int n4 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n4 * 2);
        n3 = 0;
        do {
            if ((n2 = string.indexOf(46, n3)) != -1 && n2 != n4 - 1) {
                stringBuilder.append(string.substring(n3, n2));
                if (n4 > n2 + 1 && string.charAt(n2 + 1) == '.') {
                    stringBuilder.append("..");
                    n3 = n2 + 2;
                    continue;
                }
                stringBuilder.append('.');
            } else {
                String string2 = string.substring(n3);
                boolean bl2 = this.needQuote(string2);
                if (bl2) {
                    stringBuilder.append(this.getConfiguration().getIdentifierQuoteString());
                }
                stringBuilder.append(string2);
                if (bl2) {
                    stringBuilder.append(this.getConfiguration().getIdentifierQuoteString());
                }
            }
            n3 = n2 + 1;
        } while (n2 != -1);
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void a(cc cc2, StringBuilder stringBuilder, boolean bl2) throws ReportException {
        DatabaseTables databaseTables = cc2.rh();
        if (databaseTables.id()) {
            FormulaField formulaField = cc2.rj();
            if (formulaField == null || formulaField.getFormula() == null || formulaField.getFormula().trim().length() == 0) {
                databaseTables.a(DatabaseTables.a.Ob);
                return;
            }
            try {
                String string = FormulaField.d(formulaField);
                if (string != null && string.trim().length() > 0) {
                    if (this.Mr != null) {
                        if (this.Ms == formulaField.getFormula()) {
                            formulaField.setFormulaTree(this.Mr);
                        } else {
                            this.Mr = null;
                            formulaField.setFormulaTree(null);
                        }
                    }
                    h h2 = cc2.ks().a(formulaField, null, null);
                    if (cc2.rh().iy()) {
                        h2.bF(true);
                    }
                    h2.bH(bl2);
                    if (this.Mr == null) {
                        this.Mr = formulaField.getFormulaTree();
                        this.Ms = formulaField.getFormula();
                    }
                    h2.optimize();
                    if (h2.DO() && h2.eval() == Boolean.TRUE) {
                        return;
                    }
                    ToSQLResult toSQLResult = h2.a(this, bl2, true, null);
                    Evaluable evaluable = formulaField.getFormulaTree();
                    formulaField.resetReferences();
                    formulaField.setFormulaTree(evaluable);
                    ((com.inet.report.formula.b)h2).DP();
                    if (toSQLResult.hasDBpart()) {
                        stringBuilder.append(toSQLResult.getSqlResult());
                        if (toSQLResult.hasNonDBPart()) {
                            databaseTables.a(DatabaseTables.a.NZ);
                            return;
                        }
                        databaseTables.a(DatabaseTables.a.NY);
                        return;
                    }
                    if (!toSQLResult.hasNonDBPart()) return;
                    throw toSQLResult.getPartExceptions().get(0);
                }
                databaseTables.a(DatabaseTables.a.Ob);
                return;
            }
            catch (Throwable throwable) {
                databaseTables.a(DatabaseTables.a.Oa);
                if (!Mt.get().booleanValue()) {
                    if (!(throwable instanceof ReportException) || ((ReportException)throwable).getErrorCode() != -150) throw new ReportException(throwable.getMessage(), -150);
                    throw (ReportException)throwable;
                }
                if (BaseUtils.gk()) {
                    BaseUtils.warning("Could not optimize SF to run in the database.  Reason: " + String.valueOf(throwable.getMessage()));
                }
                if (!BaseUtils.isDebug()) return;
                BaseUtils.debug(throwable);
                this.filterSelectionErrorNotShownYet = false;
                return;
            }
            finally {
                if (cc2.rh().iy()) {
                    formulaField.setFormulaTree(null);
                }
            }
        } else {
            FormulaField formulaField = cc2.rj();
            if (formulaField == null || this.Mr == null || this.Ms != formulaField.getFormula()) return;
            formulaField.resetReferences();
            formulaField.setFormulaTree(this.Mr);
            formulaField.setReferences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String a(cc cc2, DatabaseTables databaseTables, com.inet.report.list.e e2, boolean bl2) throws ReportException {
        try {
            int n2;
            cc2.op().aG(true);
            if (!cc2.oc()) {
                String string = null;
                return string;
            }
            databaseTables.a(new com.inet.report.list.c());
            e2.clear();
            if (BaseUtils.isInfo()) {
                int n3;
                for (n3 = 0; n3 < databaseTables.it().length; ++n3) {
                    BaseUtils.info("change query: " + String.valueOf(databaseTables.it()[n3]));
                }
                if (databaseTables.iu() != null) {
                    for (n3 = 0; n3 < databaseTables.iu().length; ++n3) {
                        BaseUtils.info(n3 + " " + databaseTables.iu()[n3]);
                    }
                }
            }
            cu cu2 = cc2.op();
            boolean bl3 = cu2.fO();
            cu2.aF(false);
            StringList stringList = new StringList();
            boolean bl4 = false;
            boolean bl5 = false;
            cu2.a((k)null);
            StringBuilder stringBuilder = new StringBuilder();
            int n4 = cc2.ri().size();
            int n5 = 0;
            if (!this.getConfiguration().isUseOrderBy()) {
                databaseTables.L(false);
            }
            if (!this.getConfiguration().isUseWhereClause()) {
                databaseTables.M(false);
            }
            StringBuilder stringBuilder2 = new StringBuilder();
            if (!databaseTables.it()[3] && cc2.rj() != null && cc2.rj().getFormula() != null && cc2.rj().getFormula().length() > 0 && databaseTables.it()[4] && databaseTables.iu()[2] != null) {
                stringBuilder2.append(" ");
                stringBuilder2.append(databaseTables.iu()[2]);
            }
            try {
                this.a(cc2, stringBuilder2, bl2);
            }
            catch (ReportException reportException) {
                ReportException reportException2 = new ReportException(reportException.getMessage(), Mh);
                reportException2.setCause(reportException.getCause());
                throw reportException2;
            }
            this.addJoinsToWhere(stringBuilder2, databaseTables.ik(), databaseTables);
            if (databaseTables.it()[5] && databaseTables.iu()[3] != null) {
                stringBuilder2.append(" ");
                stringBuilder2.append(databaseTables.iu()[3]);
            }
            stringBuilder.append("SELECT ");
            if (cc2.getReportProperties().isDistinct()) {
                stringBuilder.append("DISTINCT ");
            }
            if (cc2.arW != null && cc2.arW.length > 0) {
                for (n2 = 0; n2 < cc2.arW.length; ++n2) {
                    if (!cc2.arW[n2].sh() || !cc2.arW[n2].isUsed()) continue;
                    if (bl5) {
                        stringBuilder.append(',');
                    }
                    bl5 = true;
                    bl4 = true;
                    stringBuilder.append(cc2.arW[n2].sg());
                    e2.q(cc2.arW[n2]);
                    ++n5;
                    stringBuilder.append(" ");
                    stringBuilder.append(this.getConfiguration().getAliasToken());
                    stringBuilder.append(" ");
                    stringBuilder.append(this.getSqlIdentifier(databaseTables, cc2.arW[n2].name, true));
                }
            }
            if (cc2.ri() != null && n4 > 0) {
                for (n2 = 0; n2 < n4; ++n2) {
                    DatabaseField databaseField = cc2.ri().fQ(n2);
                    boolean bl6 = false;
                    if ((!databaseTables.ib() || cc2.getReportProperties().isDistinct()) && !databaseField.isUsed() && Database.a(databaseField, cc2)) {
                        bl6 = true;
                    }
                    if (!databaseField.isUsed() && !bl6) continue;
                    if (!(!cc2.getReportProperties().isDistinct() || cc2.rh().ib() && cc2.rh().ie() || !this.a(databaseField, cc2) || databaseTables.ii().i(databaseField))) {
                        databaseTables.ii().f(databaseField);
                    }
                    if (Database.a((Field)databaseField, cc2.rj()) && cc2.rh().id() && cc2.rj().isEmpty()) continue;
                    String string = this.getSqlIdentifier_Alias(databaseTables, databaseField.name);
                    if (bl5) {
                        stringBuilder.append(',');
                    }
                    bl5 = true;
                    e2.q(databaseField);
                    stringBuilder.append(string);
                    stringList.addElement(string);
                    ++n5;
                }
            }
            if (!(bl5 = this.a(false, cc2, stringBuilder, bl5, e2))) {
                stringBuilder.append(" 1 ");
            }
            this.a(databaseTables, stringBuilder, true, null);
            if (databaseTables.it()[3]) {
                if ((databaseTables.it()[4] || databaseTables.it()[5]) && databaseTables.iu()[2] != null) {
                    stringBuilder.append(" WHERE ");
                    stringBuilder.append('(');
                    stringBuilder.append(databaseTables.iu()[2]);
                    stringBuilder.append(')');
                }
            } else if (stringBuilder2.length() > 0) {
                stringBuilder.append(" WHERE ");
                stringBuilder.append((CharSequence)stringBuilder2);
            }
            if (bl4) {
                StringBuilder stringBuilder3 = new StringBuilder();
                for (int i2 = 0; i2 < stringList.size(); ++i2) {
                    if (i2 != 0) {
                        stringBuilder3.append(',');
                    }
                    String string = stringList.elementAt(i2);
                    stringBuilder3.append(string);
                }
                if (stringBuilder3.length() > 0) {
                    stringBuilder.append(" GROUP BY ");
                    stringBuilder.append((CharSequence)stringBuilder3);
                }
            }
            if (databaseTables.ib()) {
                try {
                    this.a(stringBuilder, cc2, databaseTables);
                }
                catch (ReportException reportException) {
                    ReportException reportException3 = new ReportException(reportException.getMessage(), Mg);
                    reportException3.setCause(reportException.getCause());
                    throw reportException3;
                }
            }
            cu2.aF(bl3);
            if (bl2) {
                String string = stringBuilder.toString();
                return string;
            }
            String string = this.a(stringBuilder.toString(), cc2, false, true);
            return string;
        }
        finally {
            cc2.op().aG(false);
        }
    }

    static boolean a(DatabaseField databaseField, cc cc2) {
        int n2;
        for (n2 = 0; n2 < cc2.arY.length; ++n2) {
            if (!cc2.arY[n2].name.equals(databaseField.name)) continue;
            return true;
        }
        for (n2 = 0; cc2.arY != null && n2 < cc2.arY.length; ++n2) {
            SortField sortField = cc2.arY[n2];
            if (!(sortField.getField() instanceof FormulaField)) continue;
            ArrayList arrayList = dw.b((FormulaField)sortField.getField(), DatabaseField.class, false);
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                if (databaseField != arrayList.get(i2)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean a(cb cb2, cc cc2) {
        if (cb2.getReferenceHolderCount() > 0) {
            ReferenceHolder[] referenceHolderArray = cb2.getReferenceHolders();
            for (int i2 = 0; referenceHolderArray != null && i2 < referenceHolderArray.length; ++i2) {
                ReferenceHolder referenceHolder = referenceHolderArray[i2];
                if (!(referenceHolder instanceof FormulaField ? ((FormulaField)referenceHolder).getFormulaType() != 1 && !this.a((FormulaField)referenceHolder, cc2) : !(referenceHolder instanceof SortField))) continue;
                return false;
            }
        }
        return true;
    }

    final String a(String string, cc cc2, boolean bl2, boolean bl3) throws ReportException {
        HashMap<String, a> hashMap = null;
        String string2 = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "{}'?@ ", true);
        int n2 = 0;
        boolean bl4 = false;
        boolean bl5 = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equals("{")) {
                bl5 = true;
            } else {
                if ((string3.equals("?") || string3.equals("@")) && bl5) {
                    Object object;
                    Object object2;
                    String string4 = string3;
                    String string5 = "";
                    int n3 = n2 + 1;
                    while (stringTokenizer.hasMoreTokens() && !(string3 = stringTokenizer.nextToken()).equals("}")) {
                        string5 = string5 + string3;
                        n3 += string3.length();
                    }
                    if (hashMap == null) {
                        object2 = cc2.getFields();
                        hashMap = new HashMap<String, a>();
                        this.b(bl2, (Fields)object2, hashMap);
                        this.a(bl2, (Fields)object2, hashMap);
                    }
                    if ((object2 = (a)hashMap.get("{" + string4 + string5.toLowerCase() + "}")) == null) {
                        object = string4.equals("?") ? ErrorCode.PromptIsUsed : ErrorCode.FormulaIsUsed;
                        throw ReportExceptionFactory.createReportException((ErrorCode)((Object)object), string5);
                    }
                    if (!((a)object2).valid) {
                        throw ReportExceptionFactory.createReportException(ErrorCode.FormulaNotBRR, string5);
                    }
                    object = bl4 || !bl3 && ((a)object2).Mu.getValueType() == 11 ? ((a)object2).value.toString() : o.a(((a)object2).value, null, this);
                    string2 = string2.substring(0, n2 - 1) + (String)object + string2.substring(n3 + 1);
                    n2 += ((String)object).length() - 1;
                    bl5 = false;
                    continue;
                }
                if (string3.equals("'")) {
                    bl4 = !bl4;
                }
                bl5 = false;
            }
            n2 += string3.length();
        }
        return string2;
    }

    private void a(boolean bl2, Fields fields, Map<String, a> map) throws ReportException {
        for (int i2 = 0; i2 < fields.getFormulaFieldsCount(); ++i2) {
            FormulaField formulaField = fields.getFormulaField(i2);
            if (!formulaField.isUsed()) continue;
            if (formulaField.getEvaluateTime() == 0) {
                a a2 = new a(formulaField);
                Object object = formulaField.a(null, (Object)null);
                a2.value = object;
                map.put(formulaField.getPlaceholderName().toLowerCase(), a2);
                continue;
            }
            map.put(formulaField.getPlaceholderName().toLowerCase(), new a(formulaField, false));
        }
    }

    private void b(boolean bl2, Fields fields, Map<String, a> map) throws ReportException {
        for (int i2 = 0; i2 < fields.getPromptFieldsCount(); ++i2) {
            PromptField promptField = fields.getPromptField(i2);
            if (!promptField.isUsed()) continue;
            a a2 = new a(promptField);
            map.put(promptField.getPlaceholderName().toLowerCase(), a2);
            a2.value = promptField.getPromptValue();
            if (a2.value == null && !promptField.isValueSet() && promptField.getDefaultValueProvider() == null && promptField.getDefaultValues() != null && promptField.getDefaultValues().length > 0) {
                a2.value = promptField.getDefaultValues()[0].getValue();
            }
            if (bl2 && a2.value == null) {
                a2.value = this.f(promptField);
            }
            if (a2.value == null) {
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug("[Database] PromptField:" + promptField.getName() + "  No value was set. Flag calledToCheckTableSource is " + bl2);
                }
                a2.value = "";
            }
            if (!promptField.getAllowMultipleValues() || a2.value instanceof Object[]) continue;
            a2.value = new Object[]{a2.value};
        }
    }

    private Object f(Field field) {
        switch (field.getValueType() % 128) {
            case 6: 
            case 7: {
                return new Double(0.0);
            }
            case 8: {
                return Boolean.FALSE;
            }
            case 9: {
                return new java.sql.Date(System.currentTimeMillis());
            }
            case 15: {
                return new Timestamp(System.currentTimeMillis());
            }
            case 10: {
                return new Time(System.currentTimeMillis());
            }
            case 11: 
            case 14: {
                return "test string";
            }
        }
        if (BaseUtils.isDebug()) {
            String string = field.getClass().getSimpleName();
            BaseUtils.debug("[Database] " + string + ":" + field.getName() + "  unknown " + string + " type " + field.getValueType() + " in set command parameter");
        }
        return null;
    }

    private boolean a(boolean bl2, cc cc2, StringBuilder stringBuilder, boolean bl3, com.inet.report.list.e e2) {
        SQLField[] sQLFieldArray = cc2.arX;
        if (sQLFieldArray == null || sQLFieldArray.length == 0) {
            return bl3;
        }
        for (int i2 = 0; i2 < sQLFieldArray.length; ++i2) {
            if (!sQLFieldArray[i2].isUsed() && !bl2 || Database.a(sQLFieldArray[i2], cc2.rj()) && cc2.rh().ig()) continue;
            if (bl3) {
                stringBuilder.append(',');
            }
            bl3 = true;
            e2.q(sQLFieldArray[i2]);
            stringBuilder.append('(');
            stringBuilder.append(sQLFieldArray[i2].auL);
            stringBuilder.append(')');
            stringBuilder.append(' ');
            stringBuilder.append(this.getConfiguration().getAliasToken());
            stringBuilder.append(' ');
            stringBuilder.append(this.getSqlIdentifier(cc2.rh(), sQLFieldArray[i2].name, false));
        }
        return bl3;
    }

    private void a(DatabaseTables databaseTables, StringBuilder stringBuilder, boolean bl2, Datasource datasource) throws ReportException {
        StringBuilder stringBuilder2 = this.addJoinsToFrom(databaseTables.ik(), databaseTables, true, true, datasource);
        stringBuilder.append(" FROM ");
        if (!databaseTables.it()[0]) {
            if (stringBuilder2.length() > 0) {
                if (!this.getConfiguration().isUseSQL92syntax() && this.getConfiguration().isUseParenthesiseForJoin()) {
                    stringBuilder.append("{oj ").append((CharSequence)stringBuilder2).append(" } ");
                } else {
                    stringBuilder.append((CharSequence)stringBuilder2);
                }
            } else {
                Datasource datasource2;
                if (databaseTables.it()[1] && databaseTables.iu()[0] != null && databaseTables.iu()[0].length() > 0) {
                    stringBuilder.append(" ");
                    stringBuilder.append(databaseTables.iu()[0]);
                }
                if ((datasource2 = datasource) == null) {
                    datasource2 = databaseTables.getDatasource(0);
                }
                boolean bl3 = false;
                for (int i2 = 0; i2 < datasource2.getTableSourceCount(); ++i2) {
                    TableSource tableSource = datasource2.getTableSource(i2);
                    if (tableSource.getAlias().startsWith("%") || tableSource.getAlias().startsWith("#") || bl2 && (databaseTables.ij().arX == null || databaseTables.ij().arX.length <= 0) && !tableSource.ss()) continue;
                    String string = tableSource.sp();
                    String string2 = tableSource.getAlias();
                    if (bl3) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(string);
                    stringBuilder.append(' ').append(string2);
                    bl3 = true;
                }
                if (datasource2.getTableSourceCount() == 0) {
                    stringBuilder.setLength(0);
                    return;
                }
                if (databaseTables.it()[2] && databaseTables.iu()[1] != null && databaseTables.iu()[1].length() > 0) {
                    stringBuilder.append(" ");
                    stringBuilder.append(databaseTables.iu()[1]);
                }
            }
        } else if (databaseTables.it()[1] || databaseTables.it()[2]) {
            if (databaseTables.iu()[0] != null) {
                stringBuilder.append(" ");
                stringBuilder.append(databaseTables.iu()[0]);
            } else {
                stringBuilder.append(" ");
            }
        }
    }

    private void a(StringBuilder stringBuilder, cc cc2, DatabaseTables databaseTables) throws ReportException {
        int n2;
        Object object;
        cb cb2;
        int n3;
        boolean bl2 = true;
        boolean bl3 = false;
        StringList stringList = new StringList();
        StringList stringList2 = new StringList();
        IntList intList = new IntList();
        int n4 = 0;
        cu cu2 = cc2.op();
        for (n3 = 0; n3 < cc2.rl().length; ++n3) {
            cb2 = cc2.rl()[n3];
            object = ((Group)cb2).getField();
            if (object == null) continue;
            try {
                n2 = 0;
                if (stringList.indexOf(((Field)object).name) >= 0) {
                    if (!((Group)cb2).isDate()) continue;
                    for (int i2 = n3 - 1; i2 >= 0; --i2) {
                        Group group = cc2.rl()[i2];
                        if (group.getField() == null || group.getSectionWillBePrinted() == ((Group)cb2).getSectionWillBePrinted()) continue;
                        n2 = 1;
                        break;
                    }
                }
                String string = null;
                boolean bl4 = true;
                if (((Field)object).getValueType() == 8 && Database.a(cc2, ((Field)object).name)) {
                    databaseTables.L(false);
                    bl2 = false;
                    continue;
                }
                if (((Group)cb2).isDate()) {
                    if (cc2.by(n3)) {
                        if (n2 != 0) continue;
                        string = String.valueOf(cu2.a(true, (Field)object));
                    } else {
                        String[] stringArray = this.a((Group)cb2);
                        if (stringArray != null && stringArray.length > 0) {
                            StringBuilder stringBuilder2 = new StringBuilder();
                            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                                if (n2 != 0) {
                                    for (int i4 = 0; i4 < stringList2.size(); ++i4) {
                                        if (stringList2.elementAt(i4).indexOf(stringArray[i3]) >= 0) continue;
                                        stringBuilder2.append(stringArray[i3]);
                                        ((Group)cb2).a(stringBuilder2);
                                        if (i3 == stringArray.length - 1) continue;
                                        stringBuilder2.append(", ");
                                    }
                                    continue;
                                }
                                stringBuilder2.append(stringArray[i3]);
                                ((Group)cb2).a(stringBuilder2);
                                if (i3 == stringArray.length - 1) continue;
                                stringBuilder2.append(", ");
                            }
                            string = stringBuilder2.toString();
                            bl4 = false;
                        } else {
                            string = ((Field)object).name;
                            databaseTables.L(false);
                        }
                    }
                } else {
                    if (object instanceof FormulaField && ((FormulaField)object).Y(true) == 0) continue;
                    string = object instanceof SQLField ? this.getSqlIdentifier(cc2.rh(), ((Field)object).getName(), false) : String.valueOf(cu2.a(true, (Field)object));
                }
                int n5 = 0;
                n5 = ((Group)cb2).getGroupDirectionFormula() != null ? ((Group)cb2).ke() : ((Group)cb2).getSort();
                if (n5 == 2 || n5 == 5) {
                    bl2 = false;
                    bl3 = true;
                    break;
                }
                stringList.addElement(((Field)object).name);
                if (bl4) {
                    intList.addElement(n5);
                } else {
                    intList.addElement(0);
                }
                stringList2.addElement(string);
                continue;
            }
            catch (Throwable throwable) {
                if (BaseUtils.gk()) {
                    BaseUtils.warning(throwable.getMessage());
                }
                bl2 = false;
                stringList.clear();
                stringList2.clear();
                intList.clear();
            }
        }
        if (bl2 && cc2.arY != null) {
            for (n3 = 0; n3 < cc2.arY.length; ++n3) {
                cb2 = cc2.arY[n3];
                try {
                    if (-1 != stringList.indexOf(((SortField)cb2).name)) continue;
                    if (BaseUtils.isInfo()) {
                        BaseUtils.info("Evaluate sort formula.");
                    }
                    Object object2 = (object = ((Field)cb2).getField()) == null ? cu2.b(true, ((SortField)cb2).name) : cu2.a(true, (Field)object);
                    int n6 = 2;
                    n6 = ((SortField)cb2).getSortDirectionFormula() != null ? ((SortField)cb2).rY() : ((SortField)cb2).avU;
                    if (n6 == 2) continue;
                    String string = String.valueOf(object2);
                    stringList.addElement(((SortField)cb2).name);
                    stringList2.addElement(string);
                    intList.addElement(n6);
                    continue;
                }
                catch (Throwable throwable) {
                    if (BaseUtils.gk()) {
                        BaseUtils.warning(throwable);
                    }
                    bl2 = false;
                    stringList.clear();
                    stringList2.clear();
                    intList.clear();
                }
            }
        }
        if (!bl2) {
            cc2.rh().L(false);
            if (bl3) {
                BaseUtils.info("Creating ORDER BY was brocken because the original sort order is used.");
            } else {
                throw new ReportException("Creating ORDER BY clause failed.", -100);
            }
        }
        StringBuilder stringBuilder3 = new StringBuilder();
        for (int i5 = 0; i5 < stringList2.size(); ++i5) {
            object = stringList2.elementAt(i5);
            if (((String)object).length() == 0) continue;
            n2 = intList.elementAt(i5);
            if (n4 != 0) {
                stringBuilder3.append(", ");
            }
            stringBuilder3.append((String)object);
            ++n4;
            if (n2 == 0) continue;
            stringBuilder3.append(" DESC");
        }
        if (stringBuilder3.length() > 0) {
            stringBuilder.append(" ORDER BY ");
            stringBuilder.append((CharSequence)stringBuilder3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int a(DatabaseTables databaseTables, Datasource datasource, String string, Connection connection) throws ReportException, SQLException {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SELECT ");
            stringBuilder.append(string);
            this.a(databaseTables, stringBuilder, false, datasource);
            stringBuilder.append(" WHERE 1=0");
            Statement statement = connection.createStatement();
            ResultSet resultSet = com.inet.report.database.a.a(statement, this.a(stringBuilder.toString(), databaseTables.ij(), false, true), null);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            if (resultSetMetaData.getColumnCount() != 1) {
                throw ReportExceptionFactory.createReportException(ErrorCode.MultiSqlCols, string);
            }
            int n2 = DatabaseTables.mapSqlTypeToCCType(resultSetMetaData.getColumnType(1));
            return n2;
        }
        finally {
            block8: {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    if (!BaseUtils.gk()) break block8;
                    BaseUtils.warning(sQLException.toString());
                }
            }
        }
    }

    String b(TableSource tableSource, boolean bl2) {
        Datasource datasource = tableSource.getDatasource();
        DatabaseTables databaseTables = datasource.getEngine().DE.rh();
        String string = tableSource.getDatabaseIdentifier();
        if (datasource.iK() || datasource.iL()) {
            String[] stringArray = this.parseSourceName(string);
            StringBuilder stringBuilder = new StringBuilder();
            if (datasource.iL() && stringArray[0] != null) {
                stringArray[0] = datasource.getCatalog();
            }
            if (datasource.iK()) {
                stringArray[1] = datasource.getSchema();
            }
            if (stringArray[0] != null) {
                stringBuilder.append(stringArray[0]);
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append('.');
            }
            if (stringArray[1] != null) {
                stringBuilder.append(stringArray[1]);
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append('.');
            }
            stringBuilder.append(stringArray[2]);
            string = stringBuilder.toString();
        }
        return this.getSqlIdentifier(databaseTables, string, bl2);
    }

    private String a(DatabaseTables databaseTables, String string) throws ReportException {
        TableSource tableSource = databaseTables.getTablesource(string);
        return tableSource.sp();
    }

    private void a(b b2, StringBuilder stringBuilder, DatabaseTables databaseTables) throws ReportException {
        this.a(b2.hH(), stringBuilder, databaseTables);
        for (int i2 = 0; i2 < b2.hG().size(); ++i2) {
            b b3 = b2.hG().get(i2);
            this.a(b3, stringBuilder, databaseTables);
        }
    }

    private void a(Join join, StringBuilder stringBuilder, DatabaseTables databaseTables) throws ReportException {
        if (stringBuilder.length() != 0) {
            stringBuilder.append(this.getConfiguration().isUseParenthesiseForJoin() ? (!this.getConfiguration().isUseSQL92syntax() ? " } " : " ) ") : " ");
            stringBuilder.insert(0, this.getConfiguration().isUseParenthesiseForJoin() ? (!this.getConfiguration().isUseSQL92syntax() ? " { " : " ( ") : " ");
        } else {
            stringBuilder.append(this.a(databaseTables, join.getSourceAlias()));
            stringBuilder.append(" ");
            stringBuilder.append(join.getSourceAlias());
            this.Mq.addElement(join.getSourceAlias());
        }
        switch (join.getJoinType()) {
            case 21: {
                stringBuilder.append(" INNER JOIN ");
                break;
            }
            case 23: {
                stringBuilder.append(" LEFT OUTER JOIN ");
                break;
            }
            case 22: {
                stringBuilder.append(" RIGHT OUTER JOIN ");
                break;
            }
            case 24: {
                stringBuilder.append(" FULL OUTER JOIN ");
                break;
            }
            default: {
                Object[] objectArray = new Object[]{String.valueOf(join.getJoinType()), join.getSourceAlias(), join.getTargetAlias()};
                throw ReportExceptionFactory.createReportException(ErrorCode.UnknownJoin, objectArray);
            }
        }
        stringBuilder.append(join.getTargetTableSource().sp());
        stringBuilder.append(' ').append(join.getTargetAlias());
        this.Mq.addElement(join.getTargetAlias());
        for (int i2 = 0; i2 < join.getConditionTargetColumns().length; ++i2) {
            if (i2 == 0) {
                stringBuilder.append(" ON ");
            } else {
                stringBuilder.append(" AND ");
            }
            this.a(join, i2, stringBuilder, databaseTables);
            if (!this.Mo) continue;
            this.a(stringBuilder, databaseTables);
        }
    }

    private void a(StringBuilder stringBuilder, DatabaseTables databaseTables) throws ReportException {
        for (int i2 = 0; i2 < this.Mp.size(); ++i2) {
            Join join = this.Mp.elementAt(i2);
            if (!this.Mq.contains(join.getSourceAlias()) || !this.Mq.contains(join.getTargetAlias())) continue;
            for (int i3 = 0; i3 < join.getConditionTargetColumns().length; ++i3) {
                stringBuilder.append(" AND ");
                this.a(join, i3, stringBuilder, databaseTables);
            }
            this.Mp.remove(join);
        }
    }

    private void a(Join join, int n2, StringBuilder stringBuilder, DatabaseTables databaseTables) throws ReportException {
        stringBuilder.append(join.getSourceAlias());
        stringBuilder.append('.');
        stringBuilder.append(this.getSqlIdentifier(databaseTables, join.getConditionSourceColumn(n2), false));
        switch (join.getConditionLinkType(n2)) {
            case 1: {
                stringBuilder.append('=');
                break;
            }
            case 2: {
                stringBuilder.append('>');
                break;
            }
            case 4: {
                stringBuilder.append('<');
                break;
            }
            case 3: {
                stringBuilder.append(">=");
                break;
            }
            case 5: {
                stringBuilder.append("<=");
                break;
            }
            case 6: {
                stringBuilder.append("<>");
                break;
            }
            default: {
                Object[] objectArray = new Object[]{String.valueOf(join.getJoinType()), join.getSourceAlias(), join.getTargetAlias()};
                throw ReportExceptionFactory.createReportException(ErrorCode.UnknownJoin, objectArray);
            }
        }
        stringBuilder.append(join.getTargetAlias());
        stringBuilder.append('.');
        stringBuilder.append(this.getSqlIdentifier(databaseTables, join.getConditionTargetColumn(n2), false));
    }

    protected StringBuilder addJoinsToFrom(g g2, DatabaseTables databaseTables, boolean bl2, boolean bl3, Datasource datasource) throws ReportException {
        this.Mn = new TablesourceList();
        StringBuilder stringBuilder = new StringBuilder();
        if ((g2.size() == 0 || !this.getConfiguration().isUseSQL92syntax()) && bl2) {
            return stringBuilder;
        }
        int n2 = Database.a(g2);
        if (n2 == -1) {
            return stringBuilder;
        }
        b b2 = new b(g2.ga(n2));
        this.Mn.add(g2.ga(n2).getSourceTableSource());
        this.Mn.add(g2.ga(n2).getTargetTableSource());
        boolean[] blArray = new boolean[g2.size()];
        blArray[n2] = true;
        this.Mq.clear();
        this.Mp.clear();
        this.Mo = Database.a(b2, g2, this.Mn, blArray, this.Mp);
        if (bl2) {
            this.a(b2, stringBuilder, databaseTables);
            if (bl3) {
                Datasource datasource2 = datasource;
                if (datasource2 == null) {
                    datasource2 = databaseTables.getDatasource(0);
                }
                for (int i2 = 0; i2 < datasource2.getTableSourceCount(); ++i2) {
                    TableSource tableSource = datasource2.getTableSource(i2);
                    if (this.Mn.contains(tableSource) || tableSource.getAlias().startsWith("%") || tableSource.getAlias().startsWith("#") || (databaseTables.ij().arX == null || databaseTables.ij().arX.length <= 0) && !tableSource.ss()) continue;
                    stringBuilder.append(',').append(tableSource.sp()).append(' ').append(tableSource.getAlias());
                }
            }
        }
        return stringBuilder;
    }

    private StringBuilder a(g g2, DatabaseTables databaseTables) throws ReportException {
        TablesourceList tablesourceList = g2.e(databaseTables);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < tablesourceList.size(); ++i2) {
            TableSource tableSource = (TableSource)tablesourceList.get(i2);
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(' ').append(tableSource.sp()).append(' ').append(this.getConfiguration().getAliasToken()).append(' ').append(tableSource.getAlias());
        }
        return stringBuilder;
    }

    static int a(g g2) {
        if (g2.size() == 0) {
            return -1;
        }
        for (int i2 = 0; i2 < g2.size(); ++i2) {
            String string;
            String string2 = g2.ga(i2).getSourceAlias();
            for (int i3 = 0; i3 < g2.size() && !(string = g2.ga(i3).getTargetAlias()).equals(string2); ++i3) {
                if (i3 != g2.size() - 1) continue;
                return i2;
            }
        }
        return 0;
    }

    static boolean a(b b2, g g2, TablesourceList tablesourceList, boolean[] blArray, Vector<Join> vector) {
        int n2;
        boolean bl2 = false;
        for (n2 = 0; n2 < g2.size(); ++n2) {
            Join join = g2.ga(n2);
            if (blArray[n2] || !Database.a(b2.hH(), join)) continue;
            if (tablesourceList.contains(join.getSourceTableSource())) {
                if (tablesourceList.contains(join.getTargetTableSource())) {
                    if (BaseUtils.gk()) {
                        BaseUtils.warning("A cycle in join definition was detected. The join between " + join.getSourceAlias() + " and " + join.getTargetAlias() + " will appended to the first possible join condition.");
                    }
                    bl2 = true;
                    if (vector.contains(join)) continue;
                    vector.add(join);
                    continue;
                }
                tablesourceList.add(join.getTargetTableSource());
            } else {
                tablesourceList.addWithRefreshEvent(join.getSourceTableSource());
                join.kD();
            }
            b b3 = new b(join);
            b2.hG().add(b3);
            blArray[n2] = true;
        }
        for (n2 = 0; n2 < b2.hG().size(); ++n2) {
            if (!Database.a(b2.hG().get(n2), g2, tablesourceList, blArray, vector)) continue;
            bl2 = true;
        }
        return bl2;
    }

    private static boolean a(Join join, Join join2) {
        if (join.getSourceTableSource() == join2.getTargetTableSource() || join.getSourceTableSource() == join2.getSourceTableSource()) {
            return true;
        }
        return join.getTargetTableSource() == join2.getTargetTableSource() || join.getTargetTableSource() == join2.getSourceTableSource();
    }

    protected void addJoinsToWhere(StringBuilder stringBuilder, g g2, DatabaseTables databaseTables) throws ReportException {
        if (this.getConfiguration().isUseSQL92syntax()) {
            return;
        }
        if (!this.getConfiguration().isUseWhereClause()) {
            databaseTables.K(false);
            return;
        }
        StringBuilder stringBuilder2 = new StringBuilder(stringBuilder.length() + g2.size() * 40);
        for (int i2 = 0; i2 < g2.size(); ++i2) {
            Join join = g2.ga(i2);
            if (join.getJoinType() == 24) {
                throw ReportExceptionFactory.createReportException(ErrorCode.DisabledFOJ, new Object[0]);
            }
            if (stringBuilder2.length() != 0) {
                stringBuilder2.append(" and ");
            }
            String[] stringArray = join.getConditionSourceColumns();
            String[] stringArray2 = join.getConditionTargetColumns();
            this.a(join, databaseTables);
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                if (i3 != 0) {
                    stringBuilder2.append(" and ");
                }
                stringBuilder2.append(join.getSourceAlias());
                stringBuilder2.append('.');
                stringBuilder2.append(this.getSqlIdentifier(databaseTables, stringArray[i3], false));
                switch (join.getConditionLinkType(i3)) {
                    case 1: {
                        if (join.getJoinType() == 23) {
                            stringBuilder2.append('*');
                        }
                        stringBuilder2.append('=');
                        if (join.getJoinType() != 22) break;
                        stringBuilder2.append('*');
                        break;
                    }
                    case 2: {
                        stringBuilder2.append('>');
                        break;
                    }
                    case 4: {
                        stringBuilder2.append('<');
                        break;
                    }
                    case 3: {
                        stringBuilder2.append(">=");
                        break;
                    }
                    case 5: {
                        stringBuilder2.append("<=");
                        break;
                    }
                    case 6: {
                        stringBuilder2.append("<>");
                        break;
                    }
                    default: {
                        Object[] objectArray = new Object[]{String.valueOf(join.getJoinType()), join.getSourceAlias(), join.getTargetAlias()};
                        throw ReportExceptionFactory.createReportException(ErrorCode.UnknownJoin, objectArray);
                    }
                }
                stringBuilder2.append(join.getTargetAlias());
                stringBuilder2.append('.');
                stringBuilder2.append(this.getSqlIdentifier(databaseTables, stringArray2[i3], false));
            }
        }
        if (stringBuilder.length() > 0 && stringBuilder2.length() > 0) {
            stringBuilder2.append(" and ");
        }
        stringBuilder2.append((CharSequence)stringBuilder);
        stringBuilder.setLength(0);
        stringBuilder.append((CharSequence)stringBuilder2);
    }

    protected String getSourceNameWithChange4Call(TableSource tableSource, boolean bl2) {
        return this.b(tableSource, bl2);
    }

    protected PreparedStatement prepareStatement(TableSource tableSource) throws SQLException, ReportException {
        String string = tableSource.aP(false);
        if (BaseUtils.isInfo()) {
            BaseUtils.info(string);
        }
        Connection connection = tableSource.getDatasource().getConnection();
        return connection.prepareStatement(string);
    }

    private void a(Join join, DatabaseTables databaseTables) {
        int n2;
        DatabaseField[] databaseFieldArray = join.getConditionSourceFields();
        DatabaseField[] databaseFieldArray2 = join.getConditionTargetFields();
        for (n2 = 0; n2 < databaseFieldArray.length; ++n2) {
            if (!Database.a(databaseFieldArray[n2], join)) continue;
            databaseTables.ii().f(databaseFieldArray[n2]);
        }
        for (n2 = 0; n2 < databaseFieldArray2.length; ++n2) {
            if (!Database.a(databaseFieldArray2[n2], join)) continue;
            databaseTables.ii().f(databaseFieldArray2[n2]);
        }
    }

    @Deprecated
    public boolean useJdbcDriver() {
        return true;
    }

    public void getReportData(Engine engine, String string) throws ReportException {
        this.p(engine);
    }

    final void p(Engine engine) throws ReportException {
        Serializable serializable;
        Serializable serializable2;
        DatabaseTables databaseTables;
        cc cc2;
        block51: {
            boolean bl2;
            block50: {
                boolean bl3;
                FormulaField formulaField;
                block49: {
                    cc2 = engine.DE;
                    databaseTables = cc2.rh();
                    boolean bl4 = true;
                    if (databaseTables.getDatasourceCount() > 1) {
                        bl4 = false;
                    } else {
                        serializable2 = databaseTables.getDatasource(0);
                        if (!com.inet.report.database.a.a(serializable2.getDataFactory())) {
                            bl4 = false;
                        } else {
                            for (int i2 = 0; i2 < serializable2.getTableSourceCount(); ++i2) {
                                try {
                                    if (serializable2.getTableSource(i2).getType() == 1) continue;
                                    bl4 = false;
                                    break;
                                }
                                catch (SQLException sQLException) {
                                    // empty catch block
                                }
                            }
                            if ((serializable = serializable2.getDataSourceConfiguration()) != null && !((DataSourceConfiguration)serializable).isUseSQL92syntax() && !((DataSourceConfiguration)serializable).isUseWhereClause()) {
                                bl4 = false;
                            }
                        }
                    }
                    if (!bl4) {
                        try {
                            if (databaseTables.iy()) {
                                databaseTables.b(this.a(cc2, true));
                            } else {
                                this.a(cc2, false);
                            }
                            cc2.ox().JX();
                            return;
                        }
                        catch (SQLException sQLException) {
                            throw ReportExceptionFactory.createReportExceptionWithCause(sQLException);
                        }
                    }
                    serializable2 = null;
                    serializable = databaseTables.getDatasource(0).getDatabase();
                    formulaField = cc2.rj();
                    bl2 = formulaField != null && (!formulaField.isEmpty() || this.Mr != null) || databaseTables.ig() || databaseTables.ik() != null && databaseTables.ik().size() > 0 && !((BaseDataFactory)serializable).getConfiguration().isUseSQL92syntax();
                    bl2 = bl2 && ((BaseDataFactory)serializable).getConfiguration().isUseWhereClause();
                    bl3 = ((BaseDataFactory)serializable).getConfiguration().isUseOrderBy();
                    if (bl2 && bl3) {
                        try {
                            databaseTables.L(true);
                            databaseTables.M(true);
                            this.n(engine.DE);
                            cc2.ox().JX();
                            return;
                        }
                        catch (Throwable throwable) {
                            serializable2 = throwable;
                            if (BaseUtils.isDebug() && (!this.h(throwable) || this.filterSelectionErrorNotShownYet)) {
                                BaseUtils.debug(serializable2);
                            }
                            if (throwable instanceof l) {
                                throw ReportExceptionFactory.createReportExceptionWithCause(throwable, ErrorCode.rowLimit, new Object[0]);
                            }
                            if (throwable instanceof ReportException) {
                                if (((ReportException)throwable).getErrorCode() == Mg) {
                                    if (BaseUtils.isDebug()) {
                                        BaseUtils.debug("[DATABASE] creating order by clause failed.");
                                    }
                                    bl3 = false;
                                }
                                if (((ReportException)throwable).getErrorCode() == Mh) {
                                    if (BaseUtils.isDebug()) {
                                        BaseUtils.debug("[DATABASE] creating where clause failed.");
                                    }
                                    bl2 = false;
                                }
                            }
                            if (!this.h(throwable)) break block49;
                            throw ReportExceptionFactory.createReportExceptionWithCause(throwable, ErrorCode.InvalidRS, new Object[0]);
                        }
                    }
                }
                this.i((Throwable)serializable2);
                if (bl3) {
                    if (!Mt.get().booleanValue() && formulaField != null && !formulaField.isEmpty()) {
                        throw ReportExceptionFactory.createReportExceptionWithCause((Throwable)serializable2, ErrorCode.CouldNotFetchDataWithoutWhere, new Object[0]);
                    }
                    databaseTables.M(false);
                    ((Database)serializable).setUseWhereClause(false);
                    databaseTables.L(true);
                    if (!((BaseDataFactory)serializable).getConfiguration().isUseSQL92syntax() && databaseTables.hY() > 1) {
                        boolean bl5 = false;
                        if (cc2.arX != null && cc2.arX.length > 0) {
                            for (int i3 = 0; i3 < cc2.arX.length; ++i3) {
                                if (!cc2.arX[i3].isUsed()) continue;
                                bl5 = true;
                                break;
                            }
                        }
                        if (!bl5) {
                            try {
                                this.a(cc2, databaseTables.iy());
                                return;
                            }
                            catch (SQLException sQLException) {
                                throw ReportExceptionFactory.createReportExceptionWithCause(sQLException);
                            }
                        }
                    } else {
                        try {
                            this.n(engine.DE);
                            cc2.ox().JX();
                            return;
                        }
                        catch (Throwable throwable) {
                            serializable2 = throwable;
                            if (BaseUtils.isDebug()) {
                                BaseUtils.debug(serializable2);
                            }
                            if (throwable instanceof l) {
                                Object[] objectArray = new Object[]{};
                                throw ReportExceptionFactory.createReportExceptionWithCause(throwable, ErrorCode.rowLimit, objectArray);
                            }
                            if (!this.h(throwable)) break block50;
                            throw ReportExceptionFactory.createReportExceptionWithCause(throwable, ErrorCode.InvalidRS, new Object[0]);
                        }
                    }
                }
            }
            if (bl2) {
                try {
                    databaseTables.L(false);
                    ((Database)serializable).setUseOrderBy(false);
                    databaseTables.M(true);
                    ((Database)serializable).setUseWhereClause(true);
                    this.n(engine.DE);
                    cc2.ox().JX();
                    return;
                }
                catch (Throwable throwable) {
                    serializable2 = throwable;
                    if (BaseUtils.isDebug()) {
                        BaseUtils.debug(serializable2);
                    }
                    if (throwable instanceof l) {
                        Object[] objectArray = new Object[]{};
                        throw ReportExceptionFactory.createReportExceptionWithCause(throwable, ErrorCode.rowLimit, objectArray);
                    }
                    if (!Mt.get().booleanValue()) {
                        throw ReportExceptionFactory.createReportExceptionWithCause(throwable, ErrorCode.CouldNotFetchDataWithoutWhere, new Object[0]);
                    }
                    if (!this.h(throwable)) break block51;
                    throw ReportExceptionFactory.createReportExceptionWithCause(throwable, ErrorCode.InvalidRS, new Object[0]);
                }
            }
        }
        this.i((Throwable)serializable2);
        databaseTables.L(false);
        databaseTables.M(false);
        ((Database)serializable).setUseOrderBy(false);
        ((Database)serializable).setUseWhereClause(false);
        try {
            this.n(engine.DE);
            cc2.ox().JX();
            return;
        }
        catch (ReportException reportException) {
            if (BaseUtils.isDebug()) {
                BaseUtils.debug(reportException);
            }
            throw ReportExceptionFactory.createReportExceptionWithCause(reportException, ErrorCode.CouldNotFetchData, new Object[0]);
        }
        catch (Throwable throwable) {
            if (this.h(throwable)) {
                throw ReportExceptionFactory.createReportExceptionWithCause(throwable, ErrorCode.InvalidRS, new Object[0]);
            }
            if (BaseUtils.isDebug()) {
                BaseUtils.debug(throwable);
            }
            if (throwable instanceof l) {
                throw ReportExceptionFactory.createReportExceptionWithCause(throwable, ErrorCode.rowLimit, new Object[0]);
            }
            throw ReportExceptionFactory.createReportExceptionWithCause(throwable, ErrorCode.CouldNotFetchData, new Object[0]);
        }
    }

    private boolean h(Throwable throwable) {
        if (throwable instanceof FormulaException) {
            return true;
        }
        if (throwable instanceof dj) {
            return true;
        }
        if (throwable instanceof ReportException) {
            ReportException reportException = (ReportException)throwable;
            if (reportException.getErrorCode() >= ErrorCode.ExitWithoutLoop.getErrorCodeNumber() && reportException.getErrorCode() <= ErrorCode.FeatureForbidden.getErrorCodeNumber()) {
                return true;
            }
            if (reportException.getErrorCode() == ErrorCode.executeStatement.getErrorCodeNumber()) {
                if (reportException.getCause() instanceof dj) {
                    return true;
                }
                return this.h(reportException.getCause());
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void a(ResultSet resultSet, cc cc2) throws SQLException, ReportException {
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            com.inet.report.list.c c2 = new com.inet.report.list.c();
            DatabaseTables databaseTables = cc2.rh();
            databaseTables.a(new com.inet.report.list.e(n2));
            TableSource tableSource = null;
            if (databaseTables.getDatasource(0).getTableSourceCount() > 0 && databaseTables.getDatasource(0).getTableSource(0) != null) {
                tableSource = databaseTables.getDatasource(0).getTableSource(0);
                tableSource.getDatasource().setDataSourceConfigurationName(null);
            }
            int n3 = -1;
            try {
                Connection connection = resultSet.getStatement().getConnection();
                n3 = connection.getMetaData().getDriverMajorVersion();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            block9: for (int i2 = 0; i2 < n2; ++i2) {
                String string;
                String string2 = resultSetMetaData.getColumnName(i2 + 1);
                if (tableSource != null) {
                    string = resultSetMetaData.getColumnLabel(i2 + 1);
                    string2 = this.getColumnName(string2, string, n3, tableSource, i2);
                }
                string = resultSetMetaData.getTableName(i2 + 1);
                int n4 = -1;
                if (string != null && string.length() > 0) {
                    n4 = cc2.ri().indexOf(string + '.' + string2);
                }
                if (n4 < 0) {
                    n4 = cc2.ri().indexOf(string2);
                }
                if (n4 < 0) {
                    n4 = cc2.ri().eb(string2);
                }
                if (n4 < 0) {
                    if (cc2.arX != null) {
                        for (int i3 = 0; i3 < cc2.arX.length; ++i3) {
                            if (!cc2.arX[i3].getName().equalsIgnoreCase(string2)) continue;
                            databaseTables.iv().q(cc2.arX[i3]);
                            continue block9;
                        }
                    }
                    DatabaseField databaseField = new DatabaseField(cc2);
                    databaseField.shortName = databaseField.name = string2;
                    databaseTables.iv().q(databaseField);
                    continue;
                }
                DatabaseField databaseField = cc2.ri().fQ(n4);
                databaseTables.iv().q(databaseField);
                c2.f(databaseField);
            }
            cc2.rh().L(false);
            cu cu2 = cc2.op();
            cu2.a((k)null);
            dd.a(cc2, resultSet);
            if (cc2.asm >= 0) {
                cu2.b(dd.a(resultSet, cc2, c2));
            } else {
                cu2.b(new com.inet.report.rowsource.a(new Object[0][], cu2));
            }
            cu2.J(0);
            if (i.Zg()) {
                DatabaseCore.o(cc2);
            }
        }
        finally {
            block23: {
                try {
                    if (!dd.O(cc2)) {
                        resultSet.close();
                    }
                }
                catch (Throwable throwable) {
                    if (!BaseUtils.isParanoid()) break block23;
                    BaseUtils.paranoid(throwable);
                }
            }
        }
    }

    static final void b(DatabaseTables databaseTables) {
        int n2 = databaseTables.getDatasourceCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                Datasource datasource = databaseTables.getDatasource(i2);
                if (!databaseTables.ij().getEngine().QT) continue;
                datasource.closeConnection();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    final void m(cc cc2) {
        block5: {
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("joinsExecutedOnDB = " + cc2.rh().ia());
                BaseUtils.debug("whereExecutedOnDB = " + cc2.rh().id());
                BaseUtils.debug("RSFExecutableOnDB = " + (Object)((Object)cc2.rh().ic()));
                BaseUtils.debug("sortExecutedOnDB = " + cc2.rh().ib());
                BaseUtils.debug(this.getConfiguration().toString());
            }
            try {
                for (int i2 = 0; i2 < cc2.ri().size(); ++i2) {
                    DatabaseField databaseField = cc2.ri().fQ(i2);
                    int n2 = databaseField.valueType;
                    String string = databaseField.getShortName();
                    String string2 = databaseField.name;
                    String string3 = string;
                    if (string2 != null) {
                        string3 = string2;
                    }
                    if (!BaseUtils.isDebug()) continue;
                    BaseUtils.debug("col: " + i2 + " name: " + string3 + " type: " + n2);
                }
            }
            catch (Throwable throwable) {
                if (!BaseUtils.isInfo()) break block5;
                BaseUtils.info("exception: " + throwable);
            }
        }
    }

    private void n(cc cc2) throws ReportException {
        if (cc2.asm < 0) {
            throw ReportExceptionFactory.createReportException(ErrorCode.stopped, "Database.executeStatement");
        }
        String string = null;
        this.m(cc2);
        int n2 = PoolManager.getDefault().getMaxConnectionCount() + 1;
        boolean bl2 = false;
        DatabaseTables databaseTables = cc2.rh();
        do {
            Object object;
            Serializable serializable;
            Object object2;
            try {
                if (bl2 && BaseUtils.gk()) {
                    BaseUtils.warning("Request data second time after detecting corrupt Connection.");
                }
                Datasource datasource = databaseTables.getDatasource(0);
                object2 = datasource.getConnection();
                Database database = datasource.getDatabase();
                serializable = new com.inet.report.list.e();
                string = database.a(cc2, databaseTables, (com.inet.report.list.e)serializable, false);
                boolean bl3 = false;
                ResultSet resultSet = null;
                if (databaseTables.iy()) {
                    databaseTables.ix().addElement(string);
                    return;
                }
                if (string == null || string.trim().length() == 0) {
                    bl3 = true;
                } else {
                    cc2.agf = object2.createStatement();
                    dd.a(cc2, cc2.agf);
                    resultSet = com.inet.report.database.a.a(cc2.agf, string, null);
                }
                if (((com.inet.report.list.e)serializable).size() == 0) {
                    bl3 = true;
                }
                databaseTables.a((com.inet.report.list.e)serializable);
                if (databaseTables.ib() && databaseTables.ie() && databaseTables.ia()) {
                    databaseTables.N(true);
                }
                object = cc2.op();
                ((com.inet.report.b)object).a((k)null);
                if (cc2.asm < 0 || bl3) {
                    ((cu)object).b(new com.inet.report.rowsource.a(new Object[0][], (dc)object));
                } else {
                    ((cu)object).b(dd.a(resultSet, cc2, null));
                }
                ((com.inet.report.b)object).J(0);
                if (i.Zg()) {
                    DatabaseCore.o(cc2);
                }
                bl2 = false;
            }
            catch (Throwable throwable) {
                SQLException sQLException;
                if (throwable instanceof SQLException && "08S01".equals(((SQLException)throwable).getSQLState())) {
                    object2 = databaseTables.getDatasource(0).getConnection();
                    if (BaseUtils.gk()) {
                        BaseUtils.warning("A SQL Connection was corrupt. Connection will be closed and fetching of data will retried.");
                    }
                    try {
                        if (object2 instanceof com.inet.report.pool.b) {
                            ((com.inet.report.pool.b)object2).getConnection().close();
                        }
                        object2.close();
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    bl2 = true;
                    continue;
                }
                bl2 = false;
                object2 = throwable;
                boolean bl4 = true;
                if (throwable instanceof ReportException && ((ReportException)(serializable = (ReportException)throwable)).getErrorCode() == Mg) {
                    bl4 = false;
                }
                while (sQLException instanceof SQLException) {
                    if ((sQLException = ((SQLException)sQLException).getNextException()) == null) continue;
                    BaseUtils.printStackTrace(sQLException);
                    cc2.getEngine().setErrorMsg(cc2.getEngine().getErrorMsg() + sQLException.getMessage());
                }
                if (sQLException instanceof l) {
                    throw (l)((Object)sQLException);
                }
                if (bl4 && (!this.h((Throwable)object2) || this.filterSelectionErrorNotShownYet)) {
                    BaseUtils.printStackTrace((Throwable)object2);
                    cc2.getEngine().setErrorMsg(dw.j((Throwable)object2));
                    cc2.getEngine().setErrorMsg(cc2.getEngine().getErrorMsg() + " (for the associated SQL statement: " + string + " ). ");
                }
                if (!(sQLException instanceof ReportException)) {
                    serializable = new Object[]{dw.j((Throwable)object2), string};
                    throw ReportExceptionFactory.createReportExceptionWithCause(sQLException, ErrorCode.executeStatement, (Object[])serializable);
                }
                throw (ReportException)((Object)sQLException);
            }
            finally {
                try {
                    if (!dd.O(cc2)) {
                        object = cc2.agf;
                        cc2.agf = null;
                        object.close();
                    }
                }
                catch (Throwable throwable) {}
            }
        } while (bl2 && --n2 > 0);
    }

    private StringList a(cc cc2, boolean bl2) throws ReportException, SQLException {
        TableSource tableSource;
        e e2;
        Object object;
        Object object2;
        ArrayList<e> arrayList = new ArrayList<e>();
        DatabaseTables databaseTables = cc2.rh();
        g g2 = databaseTables.ik();
        TablesourceList tablesourceList = new TablesourceList();
        Vector<Join> vector = new Vector<Join>(1);
        ArrayList arrayList2 = dw.b(cc2.rj(), DatabaseField.class, false);
        if (g2.size() > 0) {
            int n2 = Database.a(g2);
            if (n2 == -1) {
                return new StringList();
            }
            b b2 = new b(g2.ga(n2));
            tablesourceList.addWithRefreshEvent(g2.ga(n2).getSourceTableSource());
            tablesourceList.addWithRefreshEvent(g2.ga(n2).getTargetTableSource());
            object2 = new boolean[g2.size()];
            object2[n2] = true;
            this.Mo = Database.a(b2, g2, tablesourceList, (boolean[])object2, vector);
            object = b2.hH().getSourceTableSource();
            e2 = new e(cc2.getEngine());
            e2.MI = object;
            arrayList.add(e2);
            if (((TableSource)object).getType() == 1) {
                this.a(arrayList, b2, e2, cc2);
            } else {
                this.a(arrayList, b2, null, cc2);
            }
        }
        TablesourceList tablesourceList2 = databaseTables.hZ();
        for (int i2 = 0; i2 < tablesourceList2.size(); ++i2) {
            object2 = (TableSource)tablesourceList2.get(i2);
            if (((TableSource)object2).getAlias().startsWith("%") || ((TableSource)object2).getAlias().startsWith("#") || tablesourceList.contains(object2) || (cc2.arX == null || cc2.arX.length <= 0) && !((TableSource)object2).ss()) continue;
            object = new e(cc2.getEngine());
            ((e)object).MI = object2;
            arrayList.add((e)object);
        }
        if (bl2) {
            StringList stringList = new StringList(arrayList.size());
            for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                stringList.addElement(((e)arrayList.get(i3)).hP());
            }
            return stringList;
        }
        if (arrayList.size() > 1) {
            databaseTables.M(true);
            databaseTables.L(false);
        }
        if (arrayList.size() == 1 && (tableSource = ((e)arrayList.get((int)0)).MI) != null && tableSource.getType() != 1) {
            databaseTables.M(false);
            databaseTables.L(false);
        }
        com.inet.report.list.e e3 = new com.inet.report.list.e();
        boolean bl3 = false;
        for (int i4 = 0; i4 < arrayList.size(); ++i4) {
            Object object3;
            e2 = (e)arrayList.get(i4);
            ResultSet resultSet = null;
            boolean bl4 = false;
            boolean bl5 = false;
            try {
                int n3;
                resultSet = e2.hN();
                Object object4 = null;
                if (databaseTables.iv() != null) {
                    object4 = new com.inet.report.list.e(databaseTables.iv());
                }
                object3 = e2.a(resultSet).IR();
                com.inet.report.list.c c2 = e2.MI != null && e2.MI.getType() != 1 ? e2.MI.a(null, false) : null;
                for (n3 = 0; n3 < ((com.inet.report.list.e)object3).size() && e2.MI != null && e2.MI.getType() == 2 && e2.MI.getColumnCount() > n3; ++n3) {
                    Field field = ((com.inet.report.list.e)object3).fU(n3);
                    if (field != null && !field.getName().equalsIgnoreCase(e2.MI.getAlias() + ".(expression)")) continue;
                    DatabaseField databaseField = e2.MI.getDatabaseField(n3);
                    if (BaseUtils.isDebug()) {
                        BaseUtils.debug("Stored Procedure column \"" + ((com.inet.report.list.e)object3).fU(n3) + "\" -> " + databaseField);
                    }
                    ((com.inet.report.list.e)object3).c(databaseField, n3);
                }
                e3.b((com.inet.report.list.e)object3);
                databaseTables.a(e3);
                if (!bl3) {
                    n3 = 1;
                    for (int i5 = 0; i5 < arrayList2.size(); ++i5) {
                        if (e3.t((Field)arrayList2.get(i5))) continue;
                        n3 = 0;
                        break;
                    }
                    if (n3 != 0) {
                        bl5 = true;
                    }
                }
                cu cu2 = cc2.op();
                if (i4 == 0) {
                    if (bl5) {
                        databaseTables.M(false);
                    }
                    if (arrayList.size() == 1) {
                        cu2.b(dd.a(resultSet, cc2, c2));
                        bl4 = dd.O(cc2);
                    } else {
                        cu2.b(dd.b(resultSet, cc2, c2));
                    }
                    cu2.J(0);
                    continue;
                }
                k k2 = dd.b(resultSet, cc2, c2);
                if (i4 == arrayList.size() - 1) {
                    if (arrayList.size() > 1 && !bl3) {
                        databaseTables.M(false);
                    }
                    if (this.Mo) {
                        databaseTables.a(vector);
                    } else {
                        databaseTables.a((Vector<Join>)null);
                    }
                }
                if (bl5) {
                    databaseTables.M(false);
                }
                cu2.b(new f(cu2.rq(), k2, (com.inet.report.list.e)object4, (com.inet.report.list.e)object3, e2.MG, cu2));
                cu2.J(0);
                continue;
            }
            catch (l l2) {
                object3 = new Object[]{};
                throw ReportExceptionFactory.createReportExceptionWithCause(l2, ErrorCode.rowLimit, (Object[])object3);
            }
            finally {
                try {
                    if (!databaseTables.id()) {
                        bl3 = true;
                        databaseTables.M(true);
                    }
                    if (i.Zg()) {
                        DatabaseCore.o(cc2);
                    }
                    if (!bl4) {
                        Statement statement = cc2.agf;
                        cc2.agf = null;
                        statement.close();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
        return null;
    }

    private void a(ArrayList<e> arrayList, b b2, e e2, cc<?> cc2) throws ReportException, SQLException {
        Object object;
        Datasource datasource;
        boolean bl2;
        TableSource tableSource = cc2.rh().getTablesource(b2.hH().getTargetAlias());
        e e3 = null;
        boolean bl3 = false;
        DataFactory dataFactory = tableSource.getDatasource().getDataFactory();
        DatabaseConfiguration databaseConfiguration = dataFactory.getConfiguration();
        boolean bl4 = bl2 = !databaseConfiguration.isUseWhereClause() && !databaseConfiguration.isUseSQL92syntax();
        if (tableSource.getType() == 3 || tableSource.getType() == 2 || bl2 || !com.inet.report.database.a.a(dataFactory)) {
            e3 = new e(cc2.getEngine());
            e3.MG = b2.hH();
            e3.MI = tableSource;
            arrayList.add(e3);
            bl3 = true;
        } else if (e2 != null) {
            TableSource tableSource2;
            datasource = tableSource.getDatasource();
            if (datasource == (object = (tableSource2 = b2.hH().getSourceTableSource()).getDatasource())) {
                e2.MH.a(b2.hH());
                e2.MI = null;
            } else {
                e3 = new e(cc2.getEngine());
                e3.MG = b2.hH();
                e3.MI = tableSource;
                arrayList.add(e3);
                bl3 = false;
            }
        } else {
            e3 = new e(cc2.getEngine());
            e3.MG = b2.hH();
            e3.MI = tableSource;
            arrayList.add(e3);
            bl3 = false;
        }
        datasource = e3 != null ? e3.MI.getAlias() : null;
        for (int i2 = 0; i2 < b2.hG().size(); ++i2) {
            if (e3 != null && bl3) {
                this.a(arrayList, b2.hG().get(i2), null, cc2);
                continue;
            }
            if (e3 != null) {
                object = b2.hG().get(i2);
                if (((b)object).hH().getSourceAlias().equals(datasource)) {
                    this.a(arrayList, (b)object, e3, cc2);
                    continue;
                }
                this.a(arrayList, b2.hG().get(i2), e2, cc2);
                continue;
            }
            this.a(arrayList, b2.hG().get(i2), e2, cc2);
        }
    }

    final String a(cc cc2, g g2, com.inet.report.list.c c2) throws SQLException, ReportException {
        Serializable serializable;
        DatabaseTables databaseTables = cc2.rh();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT ");
        if (cc2.getReportProperties().isDistinct()) {
            stringBuilder.append("DISTINCT ");
        }
        boolean bl2 = true;
        TablesourceList tablesourceList = g2.e(databaseTables);
        for (int i2 = 0; i2 < tablesourceList.size(); ++i2) {
            serializable = ((TableSource)tablesourceList.get(i2)).a(g2, null);
            for (int i3 = 0; i3 < serializable.size(); ++i3) {
                if (!bl2) {
                    stringBuilder.append(',').append(' ');
                }
                stringBuilder.append(this.getSqlIdentifier_Alias(databaseTables, serializable.fQ(i3).getName()));
                c2.f(serializable.fQ(i3));
                bl2 = false;
            }
        }
        if (bl2) {
            stringBuilder.append(" 1 ");
        }
        stringBuilder.append(" FROM ");
        StringBuilder stringBuilder2 = this.addJoinsToFrom(g2, databaseTables, true, false, null);
        if (stringBuilder2.length() > 0) {
            stringBuilder.append((CharSequence)stringBuilder2);
        } else {
            stringBuilder.append((CharSequence)this.a(g2, databaseTables));
            serializable = new StringBuilder();
            this.addJoinsToWhere((StringBuilder)serializable, g2, databaseTables);
            stringBuilder.append(" WHERE ").append((CharSequence)((Object)serializable));
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final ResultSet a(Engine engine, TableSource tableSource) throws ReportException, SQLException {
        cc cc2 = engine.DE;
        d d2 = tableSource.sl();
        Database database = tableSource.getDatasource().getDatabase();
        PreparedStatement preparedStatement = database.prepareStatement(tableSource);
        engine.DE.agf = preparedStatement;
        dd.a(engine.DE, engine.DE.agf);
        database.a(cc2, preparedStatement, d2);
        ResultSet resultSet = com.inet.report.database.a.a(preparedStatement, null, d2);
        if (!d2.hK()) {
            int n2 = 0;
            while (n2 < d2.hL()) {
                c c2 = d2.aj(n2);
                if (c2.Mx) {
                    return (ResultSet)((CallableStatement)preparedStatement).getObject(n2 + 1);
                }
                ++n2;
            }
            return resultSet;
        }
        if (!(preparedStatement instanceof CallableStatement)) return resultSet;
        try {
            Object object = ((CallableStatement)preparedStatement).getObject(1);
            if (object == null) return resultSet;
            if (!(object instanceof ResultSet)) return resultSet;
            return (ResultSet)object;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return resultSet;
    }

    public String getAddOp() {
        return "+";
    }

    @Override
    public String sqlConcat(Object object, Object object2) {
        return object + this.getAddOp() + object2;
    }

    @Override
    protected ResultSet getColumns(Datasource datasource, String string, String string2, String string3) throws SQLException, ReportException {
        ResultSet resultSet;
        block5: {
            Statement statement;
            block4: {
                Connection connection = datasource.getConnection();
                String string4 = this.createTableName(connection, string, string2, string3);
                statement = connection.createStatement();
                ResultSet resultSet2 = com.inet.report.database.a.a(statement, "SELECT * FROM " + string4 + " WHERE 1=0", null);
                ResultSetMetaData resultSetMetaData = resultSet2.getMetaData();
                resultSet = DatabaseMetaDataFactory.a(resultSetMetaData);
                try {
                    resultSet2.close();
                }
                catch (SQLException sQLException) {
                    if (!BaseUtils.isParanoid()) break block4;
                    BaseUtils.paranoid(sQLException);
                }
            }
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                if (!BaseUtils.isParanoid()) break block5;
                BaseUtils.paranoid(sQLException);
            }
        }
        return resultSet;
    }

    @Override
    protected ResultSet getTables(Datasource datasource, String string) throws SQLException, ReportException {
        boolean bl2 = datasource.hasValidConnection();
        Connection connection = datasource.getConnection();
        if (connection == null) {
            return DatabaseMetaDataFactory.getTables(new String[0], string);
        }
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        if (databaseMetaData == null) {
            return DatabaseMetaDataFactory.getTables(new String[0], string);
        }
        if (!bl2) {
            connection.close();
        }
        return databaseMetaData.getTables(string, null, null, null);
    }

    @Override
    protected ResultSet getProcedures(Datasource datasource, String string) throws SQLException, ReportException {
        Connection connection;
        Connection connection2 = connection = datasource == null ? null : datasource.getConnection();
        if (connection == null || connection.isClosed()) {
            return DatabaseMetaDataFactory.a(new String[0], string);
        }
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        if (databaseMetaData == null) {
            return DatabaseMetaDataFactory.a(new String[0], string);
        }
        return databaseMetaData.getProcedures(string, null, null);
    }

    @Override
    protected ResultSet getProcedureColumns(Datasource datasource, String string, String string2, String string3) throws SQLException, ReportException {
        DatabaseMetaData databaseMetaData;
        Connection connection;
        Connection connection2 = connection = datasource == null ? null : datasource.getConnection();
        if (connection != null && !connection.isClosed() && (databaseMetaData = connection.getMetaData()) != null) {
            try {
                return databaseMetaData.getProcedureColumns(string, string2, string3, null);
            }
            catch (Exception exception) {
                BaseUtils.printStackTrace(exception);
            }
        }
        return DatabaseMetaDataFactory.a(null, new String[0], new int[0], new int[0]);
    }

    public String createTableName(Connection connection, String string, String string2, String string3) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder();
        String string4 = connection.getMetaData().getIdentifierQuoteString();
        if (connection.getMetaData().supportsCatalogsInDataManipulation() && this.returnsMultipleCatalogs() && string != null && string.length() != 0) {
            stringBuilder.append(string4).append(string).append(string4).append('.');
        }
        if (connection.getMetaData().supportsSchemasInDataManipulation() && this.returnsMultipleSchemes() && string2 != null && string2.length() != 0) {
            stringBuilder.append(string4).append(string2).append(string4).append('.');
        }
        if (string4 == null) {
            string4 = "\"";
        }
        stringBuilder.append(string4).append(string3).append(string4);
        return stringBuilder.toString();
    }

    public boolean returnsMultipleCatalogs() {
        return false;
    }

    public boolean returnsMultipleSchemes() {
        return true;
    }

    public boolean isCursor(int n2) {
        return false;
    }

    private void a(cc cc2, PreparedStatement preparedStatement, d d2) throws SQLException, ReportException {
        int n2 = d2.hL();
        int n3 = 1;
        if (d2.hK()) {
            if (BaseUtils.isInfo()) {
                BaseUtils.info("output parameter ( " + n3 + "," + -10 + ")");
            }
            if (preparedStatement instanceof CallableStatement) {
                ((CallableStatement)preparedStatement).registerOutParameter(n3, -10);
            } else {
                preparedStatement.setNull(n3, -10);
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            c c2 = d2.aj(n4);
            int n5 = c2.dataType;
            if (c2.Mx) {
                n5 = this.getCursorType(n5);
            }
            if (c2.Mz) {
                if (c2.Mx) {
                    if (BaseUtils.isDebug()) {
                        BaseUtils.debug("input parameter ( " + n3 + "," + n5 + ") as cursor");
                    }
                } else {
                    Object object = c2.value;
                    int n6 = c2.dataType;
                    if (BaseUtils.isInfo()) {
                        BaseUtils.info("set SP Parameter( No. " + n3 + ", Value: " + object + ", DataType: " + n6 + ", Scale: " + c2.scale + ")");
                    }
                    if (object != null) {
                        switch (n6) {
                            case -6: {
                                if (object instanceof String) {
                                    preparedStatement.setByte(n3, Byte.parseByte((String)object));
                                    break;
                                }
                                preparedStatement.setByte(n3, ((Number)object).byteValue());
                                break;
                            }
                            case 5: {
                                if (object instanceof String) {
                                    preparedStatement.setShort(n3, Short.parseShort((String)object));
                                    break;
                                }
                                preparedStatement.setShort(n3, ((Number)object).shortValue());
                                break;
                            }
                            case 4: {
                                if (object instanceof String) {
                                    preparedStatement.setInt(n3, Integer.parseInt((String)object));
                                    break;
                                }
                                preparedStatement.setInt(n3, ((Number)object).intValue());
                                break;
                            }
                            case -5: {
                                if (object instanceof String) {
                                    preparedStatement.setLong(n3, Long.parseLong((String)object));
                                    break;
                                }
                                preparedStatement.setLong(n3, ((Number)object).longValue());
                                break;
                            }
                            case -7: {
                                if (object instanceof String) {
                                    preparedStatement.setBoolean(n3, Boolean.valueOf((String)object));
                                    break;
                                }
                                preparedStatement.setBoolean(n3, (Boolean)object);
                                break;
                            }
                            case 6: 
                            case 7: {
                                if (object instanceof String) {
                                    preparedStatement.setFloat(n3, Float.valueOf((String)object).floatValue());
                                    break;
                                }
                                preparedStatement.setFloat(n3, ((Number)object).floatValue());
                                break;
                            }
                            case 8: {
                                if (object instanceof String) {
                                    preparedStatement.setDouble(n3, Double.valueOf((String)object));
                                    break;
                                }
                                preparedStatement.setDouble(n3, ((Number)object).doubleValue());
                                break;
                            }
                            case 2: 
                            case 3: {
                                if (object instanceof String) {
                                    preparedStatement.setBigDecimal(n3, new BigDecimal((String)object));
                                    break;
                                }
                                preparedStatement.setBigDecimal(n3, new BigDecimal(((Number)object).doubleValue()).setScale(c2.scale, 4));
                                break;
                            }
                            case -102: 
                            case -101: 
                            case 91: 
                            case 92: 
                            case 93: {
                                if (object instanceof Timestamp) {
                                    preparedStatement.setTimestamp(n3, (Timestamp)object);
                                    break;
                                }
                                if (object instanceof java.sql.Date) {
                                    preparedStatement.setDate(n3, (java.sql.Date)object);
                                    break;
                                }
                                if (object instanceof Time) {
                                    preparedStatement.setTime(n3, (Time)object);
                                    break;
                                }
                                if (object instanceof java.sql.Date) {
                                    preparedStatement.setDate(n3, new java.sql.Date(((Date)object).getTime()));
                                    break;
                                }
                                Object[] objectArray = new Object[]{n6 == 93 ? " TIMESTAMP " : (n6 == 92 ? " TIME " : " DATE "), object};
                                throw ReportExceptionFactory.createReportException(ErrorCode.IllegalSprocType, objectArray);
                            }
                            default: {
                                preparedStatement.setString(n3, object.toString());
                                break;
                            }
                        }
                    } else {
                        preparedStatement.setNull(n3, n6);
                    }
                }
            }
            if (c2.My) {
                if (BaseUtils.isInfo()) {
                    BaseUtils.info("output parameter ( " + n3 + "," + n5 + ")");
                }
                if (preparedStatement instanceof CallableStatement) {
                    ((CallableStatement)preparedStatement).registerOutParameter(n3, n5);
                } else if (!c2.Mz) {
                    preparedStatement.setNull(n3, n5);
                }
            }
            ++n4;
            ++n3;
        }
    }

    protected int getCursorType(int n2) {
        return n2;
    }

    static boolean a(Field field, FormulaField formulaField) {
        ReferenceHolder[] referenceHolderArray = field.getReferenceHolders();
        for (int i2 = 0; i2 < referenceHolderArray.length; ++i2) {
            if (referenceHolderArray[i2] == formulaField) continue;
            return false;
        }
        return true;
    }

    private static boolean a(DatabaseField databaseField, Join join) {
        ReferenceHolder[] referenceHolderArray = databaseField.getReferenceHolders();
        for (int i2 = 0; i2 < referenceHolderArray.length; ++i2) {
            if (referenceHolderArray[i2] == join) continue;
            return false;
        }
        return true;
    }

    private static boolean a(cc cc2, String string) {
        if (string == null || cc2.arQ == null) {
            return false;
        }
        for (int i2 = 0; i2 < cc2.arQ.length; ++i2) {
            if (!string.equals(cc2.arQ[i2].name)) continue;
            return true;
        }
        return false;
    }

    public int getMaxAliasNameLength() {
        return 18;
    }

    @Override
    public String convertToString(String string) throws ReportException {
        return "{fn CONVERT( " + string + ", SQL_CHAR ) }";
    }

    @Override
    public String convertToInt(String string) throws ReportException {
        return "{fn CONVERT( " + string + ", SQL_INTEGER ) }";
    }

    @Override
    public String convertToDouble(String string) throws ReportException {
        return "{fn CONVERT( " + string + ", SQL_DOUBLE ) }";
    }

    @Override
    public String convertToTime(String string) throws ReportException {
        return "{fn CONVERT(" + string + ",SQL_TIME)}";
    }

    @Override
    public String convertToDate(String string) throws ReportException {
        return "{fn CONVERT(" + string + ",SQL_Date)}";
    }

    @Override
    public String convertToDate(String string, String string2, String string3) throws ReportException {
        return "convert(datetime, right( '0000' + convert(varchar," + string + "),4) + right( '00' + convert(varchar," + string2 + "), 2) + right( '00' + convert(varchar," + string3 + "), 2))";
    }

    @Override
    public String convertToTime(String string, String string2, String string3) throws ReportException {
        return "convert(datetime, right( '00' + convert(varchar," + string + "),2)+ ':'+ right( '00' + convert(varchar," + string2 + "), 2) +':'+ right( '00' + convert(varchar," + string3 + "),2),8)";
    }

    @Override
    public String convertToTimeStamp(String string, String string2, String string3, String string4, String string5, String string6) throws ReportException {
        return "convert(datetime, right( '0000' + convert(varchar," + string + "),4) + '-' + right( '00' + convert(varchar," + string2 + "), 2) + '-' +right( '00' + convert(varchar," + string3 + "),2)+' '+right( '00' + convert(varchar," + string4 + "),2)+ ':'+ right( '00' + convert(varchar," + string5 + "), 2) +':'+ right( '00' + convert(varchar," + string6 + "),2),20)";
    }

    @Override
    public String convertModOperation(String string, String string2) throws ReportException {
        return string + "%" + string2;
    }

    @Override
    public String convertStringToSQLSyntax(String string, boolean bl2) {
        int n2 = string.indexOf(39);
        if (n2 >= 0) {
            int n3 = 0;
            char[] cArray = new char[string.length()];
            string.getChars(0, string.length(), cArray, 0);
            StringBuilder stringBuilder = new StringBuilder(cArray.length + 16);
            do {
                stringBuilder.append(cArray, n3, n2 - n3 + 1);
            } while ((n2 = string.indexOf(39, (n3 = n2) + 1)) >= 0);
            if (n3 < cArray.length) {
                stringBuilder.append(cArray, n3, cArray.length - n3);
            }
            string = stringBuilder.toString();
        }
        return "'" + string + '\'';
    }

    public boolean isUseOrderBy() {
        return this.getConfiguration().isUseOrderBy();
    }

    public void setUseOrderBy(boolean bl2) {
        this.getConfiguration().setUseOrderBy(bl2, true);
    }

    public boolean isUseParenthesiseForJoin() {
        return this.getConfiguration().isUseParenthesiseForJoin();
    }

    public void setUseParenthesiseForJoin(boolean bl2) {
        this.getConfiguration().setUseParenthesiseForJoin(bl2, true);
    }

    public boolean isUseQuoteLowerCase() {
        return this.getConfiguration().isUseQuoteLowerCase();
    }

    public void setUseQuoteLowerCase(boolean bl2) {
        this.getConfiguration().setUseQuoteLowerCase(bl2, true);
    }

    public boolean isUseSQL92syntax() {
        return this.getConfiguration().isUseSQL92syntax();
    }

    public void setUseSQL92syntax(boolean bl2) {
        this.getConfiguration().setUseSQL92syntax(bl2, false, true);
    }

    public boolean isUseWhereClause() {
        return this.getConfiguration().isUseWhereClause();
    }

    public void setUseWhereClause(boolean bl2) {
        this.getConfiguration().setUseWhereClause(bl2, true);
    }

    @Deprecated
    public String getAliasToken() {
        return this.getConfiguration().getAliasToken();
    }

    @Deprecated
    public void setAliasToken(String string) {
        this.getConfiguration().setAliasToken(string, true);
    }

    public String getIdentifierQuoteString() {
        return this.getConfiguration().getIdentifierQuoteString();
    }

    public void setIdentifierQuoteString(String string) {
        this.getConfiguration().setIdentifierQuoteString(string, true);
    }

    public boolean isEscapeEverything() {
        return this.getConfiguration().isUseEscapeEverything();
    }

    public void setUseEscapeEverything(boolean bl2) {
        this.getConfiguration().setUseEscapeEverything(bl2, true);
    }

    protected void findColumnLabels(TableSource tableSource) {
    }

    private void i(Throwable throwable) throws ReportException {
        if (throwable == null) {
            return;
        }
        boolean bl2 = throwable instanceof OutOfMemoryError;
        if (!bl2) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            boolean bl3 = bl2 = stringWriter.toString().indexOf("OutOfMemoryError") != -1;
        }
        if (bl2) {
            throw ReportExceptionFactory.createReportExceptionWithCauseOutOfMemoryError("On fetching data", throwable);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initTransient();
    }

    private String[] a(Group group) {
        StringList stringList = new StringList(6);
        if (!group.isDate()) {
            return new String[0];
        }
        StringBuilder stringBuilder = new StringBuilder();
        Field field = group.getField();
        String string = field.getRefName();
        try {
            switch (group.getSectionWillBePrinted()) {
                case 8: {
                    stringList.addElement(this.toSQL92("YEAR", field));
                    stringList.addElement(this.toSQL92("MONTH", field));
                    stringList.addElement(this.toSQL92("DAYOFMONTH", field));
                    stringList.addElement(this.toSQL92("HOUR", field));
                    stringList.addElement(this.toSQL92("MINUTE", field));
                    stringList.addElement(this.toSQL92("SECOND", field));
                    break;
                }
                case 9: {
                    stringList.addElement(this.toSQL92("YEAR", field));
                    stringList.addElement(this.toSQL92("MONTH", field));
                    stringList.addElement(this.toSQL92("DAYOFMONTH", field));
                    stringList.addElement(this.toSQL92("HOUR", field));
                    stringList.addElement(this.toSQL92("MINUTE", field));
                    break;
                }
                case 10: {
                    stringList.addElement(this.toSQL92("YEAR", field));
                    stringList.addElement(this.toSQL92("MONTH", field));
                    stringList.addElement(this.toSQL92("DAYOFMONTH", field));
                    stringList.addElement(this.toSQL92("HOUR", field));
                    break;
                }
                case 0: {
                    stringList.addElement(this.toSQL92("YEAR", field));
                    stringList.addElement(this.toSQL92("MONTH", field));
                    stringList.addElement(this.toSQL92("DAYOFMONTH", field));
                    break;
                }
                case 4: {
                    stringList.addElement(this.toSQL92("YEAR", field));
                    stringList.addElement(this.toSQL92("MONTH", field));
                    break;
                }
                case 7: {
                    stringList.addElement(this.toSQL92("YEAR", field));
                    break;
                }
                case 6: {
                    stringList.addElement(this.toSQL92("YEAR", field));
                    stringBuilder.append(this.convertToInt("{fn MONTH(" + string + ")} / 7.0"));
                    stringList.addElement(stringBuilder.toString());
                    break;
                }
                case 5: {
                    stringList.addElement(this.toSQL92("YEAR", field));
                    stringBuilder.append(this.convertToInt("({fn MONTH(" + string + ")} - 1) / 3.0"));
                    stringList.addElement(stringBuilder.toString());
                    break;
                }
                case 3: {
                    stringList.addElement(this.toSQL92("YEAR", field));
                    stringList.addElement(this.toSQL92("MONTH", field));
                    stringBuilder.append(this.convertToInt("({fn DAYOFMONTH(" + string + ")} * 4) / 63.0"));
                    stringList.addElement(stringBuilder.toString());
                    break;
                }
                case 11: {
                    stringList.addElement(this.toSQL92("YEAR", field));
                    stringList.addElement(this.toSQL92("MONTH", field));
                    stringList.addElement(this.toSQL92("DAYOFMONTH", field));
                    stringBuilder.append(this.convertToInt("{fn HOUR(" + string + ")} / 12.0"));
                    stringList.addElement(stringBuilder.toString());
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        catch (ReportException reportException) {
            return null;
        }
        return stringList.toArray();
    }

    protected String toSQL92(String string, Field field) throws ReportException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{fn ").append(string).append('(').append(field.getValue()).append(")}");
        return stringBuilder.toString();
    }

    @Override
    public String convertToBoolean(boolean bl2) {
        return bl2 ? "(1=1)" : "(1=0)";
    }

    @Override
    public String convertToBoolean(String string, boolean bl2) {
        return string + (bl2 ? " = 0" : " <> 0");
    }

    @Override
    public String convertIdentifier(DatabaseTables databaseTables, String string) {
        return this.getSqlIdentifier_Alias(databaseTables, string);
    }

    static {
        for (int i2 = 0; i2 < Mf.length; ++i2) {
            Mi.add(Mf[i2]);
        }
        Mk = new v(ConfigKey.METADATACACHE_ENABLED);
        Ml = new z(600000L);
        Ml.a(new w());
        Mm = new x(ConfigKey.METADATACACHE_TIMEOUT);
        Mt = new ConfigValue(ConfigKey.ONERROR_EXECUTESQL_WITHOUTSF);
    }

    static final class e {
        Join MG = null;
        g MH = new g();
        TableSource MI = null;
        String MJ = null;
        private com.inet.report.list.c MK = null;
        private Engine ML = null;

        e(Engine engine) {
            this.ML = engine;
        }

        ResultSet hN() throws SQLException, ReportException {
            Statement statement;
            if (this.MI != null) {
                DataFactory dataFactory = this.MI.getDatasource().getDataFactory();
                return dataFactory.getTableSourceData(this.MI).getData();
            }
            if (this.MJ == null) {
                this.MJ = this.hO();
            }
            TableSource tableSource = this.ML.DE.rh().getTablesource(this.MH.ga(0).getSourceAlias());
            Datasource datasource = tableSource.getDatasource();
            Connection connection = datasource.getConnection();
            this.ML.DE.agf = statement = connection.createStatement();
            if (BaseUtils.isInfo()) {
                BaseUtils.info(this.MJ);
            }
            return com.inet.report.database.a.a(statement, this.MJ, null);
        }

        private String hO() throws SQLException, ReportException {
            this.MK = new com.inet.report.list.c();
            TableSource tableSource = this.MH.ga(0).getSourceTableSource();
            Database database = tableSource.getDatasource().getDatabase();
            String string = database.a(this.ML.DE, this.MH, this.MK);
            return string;
        }

        String hP() throws ReportException, SQLException {
            if (this.MI != null) {
                return this.MI.aP(false);
            }
            return this.hO();
        }

        com.inet.report.list.c a(ResultSet resultSet) throws SQLException, ReportException {
            if (this.MK != null) {
                return this.MK;
            }
            if (this.MI != null) {
                return this.MI.a(null, resultSet);
            }
            if (this.MK != null) {
                return this.MK;
            }
            this.hO();
            return this.MK;
        }
    }

    static class b {
        private Join Mv;
        private Vector<b> Mw = new Vector(3);

        public b(Join join) {
            this.Mv = join;
        }

        Vector<b> hG() {
            return this.Mw;
        }

        Join hH() {
            return this.Mv;
        }
    }

    private static class a {
        private Field Mu;
        private Object value;
        private boolean valid = true;

        public a(Field field) {
            this.Mu = field;
        }

        public a(Field field, boolean bl2) {
            this.Mu = field;
            this.valid = bl2;
        }
    }

    static class c
    implements Serializable,
    Cloneable {
        private final int colType;
        final int dataType;
        final int scale;
        final boolean Mx;
        private final boolean My;
        final boolean Mz;
        final String columnName;
        Object value;

        c(String string, int n2, int n3, int n4, boolean bl2) {
            this.columnName = string;
            this.colType = n2;
            this.dataType = n3;
            this.scale = n4;
            this.Mx = bl2;
            this.My = n2 == 4 || n2 == 2;
            this.Mz = n2 == 1 || n2 == 2;
        }

        public c hI() {
            return new c(this.columnName, this.colType, this.dataType, this.scale, this.Mx);
        }

        public /* synthetic */ Object clone() throws CloneNotSupportedException {
            return this.hI();
        }
    }

    public static final class d
    implements Serializable,
    Cloneable {
        int MA;
        private int MC;
        private int MD;
        private boolean ME = false;
        private final ArrayList<c> MF = new ArrayList();

        void hJ() {
            block6: for (int i2 = 0; i2 < this.MF.size(); ++i2) {
                c c2 = this.MF.get(i2);
                switch (c2.dataType) {
                    case 16: {
                        c2.value = Boolean.TRUE;
                        continue block6;
                    }
                    case 92: {
                        c2.value = new Time(System.currentTimeMillis());
                        continue block6;
                    }
                    case -102: 
                    case -101: 
                    case 93: {
                        c2.value = new Timestamp(System.currentTimeMillis());
                        continue block6;
                    }
                    case 91: {
                        c2.value = new java.sql.Date(System.currentTimeMillis());
                        continue block6;
                    }
                    default: {
                        c2.value = "1";
                    }
                }
            }
        }

        public void a(d d2) {
            if (d2 == null) {
                return;
            }
            this.MD = d2.MD;
            this.MA = d2.MA;
            this.MC = d2.MC;
            this.ME = d2.ME;
            this.MF.clear();
            for (int i2 = 0; i2 < d2.hL(); ++i2) {
                c c2 = d2.aj(i2).hI();
                this.MF.add(c2);
            }
        }

        void a(String string, Object object) throws ReportException {
            if (string.indexOf(64) == 0) {
                string = string.substring(1, string.length());
            }
            for (int i2 = 0; i2 < this.hL(); ++i2) {
                String string2 = this.aj((int)i2).columnName;
                if (string2.indexOf(64) == 0) {
                    string2 = string2.substring(1, string2.length());
                }
                if (string2 == null || !string2.equalsIgnoreCase(string)) continue;
                this.aj((int)i2).value = object;
                return;
            }
            throw new ReportException("No parameter found with parameter name >" + string + "<", 1111);
        }

        boolean ab(String string) {
            if (string.indexOf(64) == 0) {
                string = string.substring(1, string.length());
            }
            for (int i2 = 0; i2 < this.hL(); ++i2) {
                String string2 = this.aj((int)i2).columnName;
                if (string2.indexOf(64) == 0) {
                    string2 = string2.substring(1, string2.length());
                }
                if (string2 == null || !string2.equalsIgnoreCase(string)) continue;
                return true;
            }
            return false;
        }

        void c(c c2) {
            switch (c2.colType) {
                case 1: {
                    if (c2.Mx) {
                        ++this.MD;
                    } else {
                        ++this.MA;
                    }
                    this.MF.add(c2);
                    break;
                }
                case 2: {
                    ++this.MC;
                    if (c2.Mx) {
                        ++this.MD;
                    } else {
                        ++this.MA;
                    }
                    this.MF.add(c2);
                    break;
                }
                case 4: {
                    ++this.MD;
                    ++this.MC;
                    this.MF.add(c2);
                    break;
                }
                case 5: {
                    if (!c2.Mx) break;
                    this.ME = true;
                    break;
                }
            }
        }

        boolean hK() {
            return this.ME;
        }

        int hL() {
            return this.MF.size();
        }

        void clear() {
            this.MA = 0;
            this.MF.clear();
        }

        c aj(int n2) {
            return this.MF.get(n2);
        }

        public d hM() {
            d d2 = new d();
            d2.a(this);
            return d2;
        }

        public /* synthetic */ Object clone() throws CloneNotSupportedException {
            return this.hM();
        }
    }
}

