/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.report.BaseUtils;
import com.inet.report.Database;
import com.inet.report.DatabaseField;
import com.inet.report.DatabaseTables;
import com.inet.report.Datasource;
import com.inet.report.Engine;
import com.inet.report.Field;
import com.inet.report.FormulaRange;
import com.inet.report.PromptField;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.ReportKeyFactory;
import com.inet.report.SQLField;
import com.inet.report.cc;
import com.inet.report.cs;
import com.inet.report.database.b;
import com.inet.report.formula.number.h;
import com.inet.report.list.c;
import com.inet.report.list.e;
import com.inet.report.rowsource.k;
import com.inet.report.util.MemoryStream;
import com.inet.report.util.i;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;

public class DatabaseCore
extends Database {
    @Override
    public boolean getReportDataPerInstance() {
        return true;
    }

    @Override
    public boolean useJdbcDriver() {
        return false;
    }

    @Override
    public void getReportData(Engine engine, String string) throws ReportException {
        this.m(engine.DE);
        cc cc2 = engine.DE;
        String string2 = DatabaseCore.getCoreFileKey(cc2, true);
        File file = DatabaseCore.a(engine.DE.id == 0 ? engine : ((cs)engine.DE.oi()).getEngine(), engine.DE.id, string2);
        if (file == null) {
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("core file: " + string2 + " not found. Try old core names");
            }
            string2 = DatabaseCore.getCoreFileKey(cc2, false);
            file = DatabaseCore.a(engine.DE.id == 0 ? engine : ((cs)engine.DE.oi()).getEngine(), engine.DE.id, string2);
        }
        if (file == null) {
            throw ReportExceptionFactory.createReportExceptionWithCause(new FileNotFoundException("core file: " + string2));
        }
        try {
            this.a(engine, file);
        }
        catch (IOException iOException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(iOException);
        }
    }

    private static File ac(String string) {
        File file = new File(string);
        if (!file.exists() || !file.isFile()) {
            try {
                URI uRI = new URI("file:///" + string);
                file = new File(uRI);
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (file != null && file.exists() && file.isFile()) {
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("using file: " + file);
            }
            return file;
        }
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("not found: " + file);
        }
        return null;
    }

    private static File a(Engine engine, int n2, String string) {
        int n3;
        String string2;
        Engine engine2;
        File file = null;
        file = DatabaseCore.ac(i.Zh() + n2 + "." + string);
        if (file == null) {
            engine2 = engine;
            string2 = engine2.DE.Nv.getPath();
            try {
                string2 = URLDecoder.decode(string2, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                BaseUtils.printStackTrace(unsupportedEncodingException);
            }
            n3 = string2.lastIndexOf(47);
            if (n3 != -1) {
                string2 = string2.substring(0, n3);
            }
            file = DatabaseCore.ac(string2 + "/" + n2 + "." + string);
        }
        if (file == null) {
            engine2 = engine;
            string2 = engine2.DE.Nv.getPath();
            n3 = string2.lastIndexOf(47);
            if (n3 != -1) {
                string2 = string2.substring(0, n3);
            }
            file = DatabaseCore.ac(string2 + "/CCcore." + n2 + "." + string);
        }
        if (file == null) {
            engine2 = engine;
            string2 = engine2.DE.Nv.getPath();
            n3 = string2.lastIndexOf(47);
            if (n3 != -1) {
                string2 = string2.substring(0, n3);
            }
            file = DatabaseCore.ac(string2 + "/core/CCcore." + n2 + "." + string);
        }
        return file;
    }

    private void a(Engine engine, File file) throws IOException, ReportException {
        int n2;
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        dataInputStream.mark(8);
        switch (dataInputStream.read()) {
            case 67: {
                if (dataInputStream.read() == 79 && dataInputStream.read() == 82 && dataInputStream.read() == 69) {
                    n2 = dataInputStream.readInt();
                    break;
                }
                n2 = 0;
                dataInputStream.reset();
                break;
            }
            case 172: {
                n2 = 1;
                dataInputStream.reset();
                break;
            }
            case 0: {
                n2 = 2;
                dataInputStream.reset();
                break;
            }
            default: {
                n2 = 0;
                dataInputStream.reset();
            }
        }
        switch (n2) {
            case 0: {
                throw new IOException("Invalid Core File");
            }
            case 1: {
                this.a(engine, (InputStream)dataInputStream);
                break;
            }
            case 2: {
                this.a(engine, dataInputStream);
                break;
            }
            default: {
                throw new IOException("Unknown Core File format (version " + n2 + ")");
            }
        }
        dataInputStream.close();
    }

    private void a(Engine engine, InputStream inputStream) throws IOException, ReportException {
        try (ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);){
            String[] stringArray = (String[])objectInputStream.readObject();
            Object[][] objectArray = (Object[][])objectInputStream.readObject();
            int n2 = objectInputStream.readInt();
            boolean bl2 = (n2 & 0x10) == 16;
            engine.setData(stringArray, objectArray, bl2);
            engine.DE.op().aH(true);
        }
    }

    private void a(Engine engine, DataInputStream dataInputStream) throws IOException, ReportException {
        try {
            a a2 = this.a(dataInputStream);
            boolean bl2 = (a2.Nm & 0x10) == 16;
            engine.setData(a2.cz, a2.Nl, bl2);
            engine.DE.op().aH(true);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw ReportExceptionFactory.createReportExceptionWithCause(outOfMemoryError);
        }
    }

    private a a(DataInputStream dataInputStream) throws IOException {
        int n2;
        a a2 = new a();
        int n3 = dataInputStream.readInt();
        a.a(a2, new String[n3]);
        for (n2 = 0; n2 < n3; ++n2) {
            ((a)a2).cz[n2] = dataInputStream.readUTF();
        }
        n3 = dataInputStream.readInt();
        n2 = dataInputStream.readInt();
        Object[][] objectArray = new Object[n3][n2];
        a.a(a2, objectArray);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            for (int i3 = 0; i3 < objectArray[0].length; ++i3) {
                objectArray[i2][i3] = DatabaseCore.readObject(dataInputStream);
            }
        }
        a2.Nm = dataInputStream.readInt();
        return a2;
    }

    public static Object readObject(DataInputStream dataInputStream) throws IOException {
        int n2 = dataInputStream.read();
        switch (n2) {
            case 0: {
                return null;
            }
            case 1: {
                return dataInputStream.readBoolean();
            }
            case 2: {
                return new Float(dataInputStream.readFloat());
            }
            case 3: {
                return new Double(dataInputStream.readDouble());
            }
            case 4: {
                return new Byte(dataInputStream.readByte());
            }
            case 5: {
                return new Short(dataInputStream.readShort());
            }
            case 6: {
                return new Integer(dataInputStream.readInt());
            }
            case 7: {
                return new Long(dataInputStream.readLong());
            }
            case 8: {
                return dataInputStream.readUTF();
            }
            case 9: {
                return new Time(dataInputStream.readLong());
            }
            case 10: {
                return new Timestamp(dataInputStream.readLong());
            }
            case 11: {
                return new Date(dataInputStream.readLong());
            }
            case 12: {
                int n3 = dataInputStream.readInt();
                byte[] byArray = new byte[n3];
                dataInputStream.read(byArray);
                return byArray;
            }
            case 13: {
                return new BigDecimal(dataInputStream.readDouble());
            }
            case 14: {
                int n4 = dataInputStream.readInt();
                byte[] byArray = new byte[dataInputStream.readInt()];
                dataInputStream.read(byArray);
                return new BigDecimal(new BigInteger(byArray), n4);
            }
            case 16: {
                return h.b(dataInputStream.readDouble(), true);
            }
            case 32: {
                Object object = DatabaseCore.readObject(dataInputStream);
                Object object2 = DatabaseCore.readObject(dataInputStream);
                return new FormulaRange(object, object2);
            }
        }
        throw new IOException("Datatype not supported! :" + n2);
    }

    public static void writeObject(MemoryStream memoryStream, Object object) {
        if (object == null) {
            memoryStream.write(0);
        } else if (object instanceof Boolean) {
            memoryStream.write(1);
            memoryStream.writeBoolean((Boolean)object);
        } else if (object instanceof Float) {
            memoryStream.write(2);
            memoryStream.writeFloat(((Float)object).floatValue());
        } else if (object instanceof Double) {
            memoryStream.write(3);
            memoryStream.writeDouble((Double)object);
        } else if (object instanceof Byte) {
            memoryStream.write(4);
            memoryStream.writeByte(((Byte)object).intValue());
        } else if (object instanceof Short) {
            memoryStream.write(5);
            memoryStream.writeShort(((Short)object).shortValue());
        } else if (object instanceof Integer) {
            memoryStream.write(6);
            memoryStream.writeInt((Integer)object);
        } else if (object instanceof Long) {
            memoryStream.write(7);
            memoryStream.writeLong((Long)object);
        } else if (object instanceof String) {
            memoryStream.write(8);
            memoryStream.writeUTF((String)object);
        } else if (object instanceof Time) {
            memoryStream.write(9);
            memoryStream.writeLong(((Time)object).getTime());
        } else if (object instanceof Timestamp) {
            memoryStream.write(10);
            memoryStream.writeLong(((Timestamp)object).getTime());
        } else if (object instanceof Date) {
            memoryStream.write(11);
            memoryStream.writeLong(((Date)object).getTime());
        } else if (object instanceof byte[]) {
            memoryStream.write(12);
            byte[] byArray = (byte[])object;
            memoryStream.writeInt(byArray.length);
            memoryStream.write(byArray);
        } else if (object instanceof BigDecimal) {
            memoryStream.write(14);
            BigDecimal bigDecimal = (BigDecimal)object;
            memoryStream.writeInt(bigDecimal.scale());
            byte[] byArray = bigDecimal.unscaledValue().toByteArray();
            memoryStream.writeInt(byArray.length);
            memoryStream.write(byArray);
        } else if (h.aO(object)) {
            memoryStream.write(16);
            memoryStream.writeDouble(((h)object).doubleValue());
        } else if (object instanceof FormulaRange) {
            memoryStream.write(32);
            DatabaseCore.writeObject(memoryStream, ((FormulaRange)object).getFrom());
            DatabaseCore.writeObject(memoryStream, ((FormulaRange)object).getTo());
        } else if (object instanceof Number) {
            memoryStream.write(3);
            memoryStream.writeDouble(((Number)object).doubleValue());
        } else {
            memoryStream.write(8);
            memoryStream.writeUTF(object.toString());
            BaseUtils.error("[WriteCoreFile] Unknown datatype: " + object.getClass());
        }
    }

    private static void a(int n2, MemoryStream memoryStream) {
        memoryStream.writeString("CORE");
        memoryStream.writeInt(n2);
    }

    static void o(cc cc2) {
        try {
            String string = DatabaseCore.getCoreFileKey(cc2, true);
            if (BaseUtils.isInfo()) {
                BaseUtils.info("write binary core called: " + string + " file: " + i.Zh() + cc2.id + "." + string);
            }
            if (cc2.rh().iv() == null) {
                if (BaseUtils.isInfo()) {
                    BaseUtils.info("writing core file failed because of no received data");
                }
                return;
            }
            File file = new File(i.Zh() + cc2.id + "." + string);
            String string2 = file.getParent();
            if (string2 == null) {
                if (BaseUtils.isError()) {
                    BaseUtils.error("The core file prefix is invalid and contains no path info: \"" + i.Zh() + "\".");
                }
                if (BaseUtils.isInfo()) {
                    BaseUtils.info("Could not capture data.");
                }
                return;
            }
            new File(string2).mkdirs();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            MemoryStream memoryStream = new MemoryStream();
            DatabaseCore.a(2, memoryStream);
            DatabaseCore.a(cc2, memoryStream);
            fileOutputStream.write(memoryStream.getBuffer());
            memoryStream.close();
            fileOutputStream.close();
        }
        catch (Throwable throwable) {
            if (BaseUtils.isInfo()) {
                BaseUtils.info("Could not capture data:");
            }
            BaseUtils.printStackTrace(throwable);
        }
    }

    public static final String getCoreFileKey(cc cc2, boolean bl2) {
        Properties properties = new Properties();
        int n2 = "CCEmptyPrompt".hashCode();
        if (cc2.id == 0) {
            try {
                properties.put("r", new File(cc2.Nv.getFile()).getName());
            }
            catch (Throwable throwable) {
                BaseUtils.printStackTrace(throwable);
                properties.put("r", cc2.Nv.getFile());
            }
            if (cc2.isOnDemand()) {
                for (int i2 = 0; i2 < cc2.rg().length; ++i2) {
                    PromptField promptField = cc2.rg()[i2];
                    if (BaseUtils.isDebug()) {
                        BaseUtils.debug("Prompt[" + i2 + "]=" + String.valueOf(promptField.getValue()));
                    }
                    properties.put("p", String.valueOf(promptField.getValue()));
                }
            }
        } else {
            try {
                properties.put("r", cc2.getSummaryInfo().getReportTitle() + new File(((cc)cc2.oi()).Nv.getFile()).getName());
            }
            catch (Throwable throwable) {
                BaseUtils.printStackTrace(throwable);
                properties.put("r", cc2.getSummaryInfo().getReportTitle() + ((cc)cc2.oi()).Nv.getFile());
            }
            if (bl2) {
                int n3 = 0;
                for (int i3 = 0; i3 < cc2.rg().length; ++i3) {
                    Object object;
                    PromptField promptField = cc2.rg()[i3];
                    if (BaseUtils.isDebug()) {
                        BaseUtils.debug("[CCcore] Prompt[" + i3 + "]=" + String.valueOf(promptField.getValue()));
                    }
                    if ((object = promptField.value) instanceof Object[]) {
                        Object[] objectArray = (Object[])object;
                        for (int i4 = 0; i4 < objectArray.length; ++i4) {
                            if (objectArray[i4] == null) {
                                n3 += n2;
                                continue;
                            }
                            n3 += objectArray[i4].hashCode();
                        }
                        continue;
                    }
                    if (object == null) {
                        n3 += n2;
                        continue;
                    }
                    n3 += object.hashCode();
                }
                properties.put("h", Integer.toHexString(n3));
            } else {
                for (int i5 = 0; i5 < cc2.rg().length; ++i5) {
                    PromptField promptField = cc2.rg()[i5];
                    properties.put("p", String.valueOf(promptField.getValue()));
                }
            }
        }
        String string = ReportKeyFactory.f(properties).toString();
        string = ReportKeyFactory.encode(string);
        string = string.replace('*', 'A');
        if (BaseUtils.isInfo()) {
            BaseUtils.info("get binary core called: " + string);
        }
        return string;
    }

    private static void a(cc cc2, MemoryStream memoryStream) throws Exception {
        Serializable serializable;
        int n2;
        e e2 = cc2.rh().iv();
        k k2 = cc2.op().rq();
        c c2 = k2.Xq();
        e e3 = new e();
        for (n2 = 0; n2 < e2.size(); ++n2) {
            serializable = e2.fU(n2);
            if (!DatabaseCore.a(c2, (Field)serializable, cc2)) continue;
            if (((Field)serializable).getName() == null) {
                ((Field)serializable).setName("null");
            }
            e3.q((Field)serializable);
        }
        memoryStream.writeInt(e3.size());
        for (n2 = 0; n2 < e3.size(); ++n2) {
            serializable = (Field)e3.getObjectAt(n2);
            memoryStream.writeUTF(((Field)serializable).getName());
        }
        memoryStream.writeInt(k2.getRowCount());
        memoryStream.writeInt(e3.size());
        for (n2 = 0; n2 < k2.getRowCount(); ++n2) {
            k2.J(n2);
            serializable = cc2.rh();
            for (int i2 = 0; i2 < k2.Xl(); ++i2) {
                Field field = (Field)((DatabaseTables)serializable).iv().getObjectAt(i2);
                if (!e3.t(field)) continue;
                Object object = k2.getObject(i2);
                DatabaseCore.writeObject(memoryStream, object);
            }
        }
        memoryStream.writeInt(0);
    }

    private static boolean a(c c2, Field field, cc cc2) {
        if (field instanceof SQLField) {
            return true;
        }
        if (field instanceof DatabaseField) {
            if (c2 == null) {
                return true;
            }
            return c2.i((DatabaseField)field);
        }
        return false;
    }

    @Override
    protected ResultSet getColumns(Datasource datasource, String string, String string2, String string3) throws SQLException, ReportException {
        return new b();
    }

    private static class a {
        private String[] cz;
        private Object[][] Nl;
        private int Nm;

        private a() {
        }

        static /* synthetic */ String[] a(a a2, String[] stringArray) {
            a2.cz = stringArray;
            return stringArray;
        }

        static /* synthetic */ Object[][] a(a a2, Object[][] objectArray) {
            a2.Nl = objectArray;
            return objectArray;
        }
    }
}

