/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.report.BaseUtils;
import com.inet.report.Database;
import com.inet.report.DatabaseTables;
import com.inet.report.Datasource;
import com.inet.report.ReportException;
import com.inet.report.TableSource;
import com.inet.report.database.b;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class DatabaseInformix
extends Database {
    @Override
    protected String[] parseSourceName(String string) {
        String[] stringArray = new String[3];
        stringArray[0] = null;
        int n2 = string.indexOf("@");
        if (n2 != -1) {
            stringArray[0] = string.substring(0, n2);
        }
        if ((n2 = string.indexOf(":")) != -1 && stringArray[0] == null) {
            stringArray[0] = string.substring(0, n2);
        }
        if (stringArray[0] == null) {
            n2 = 0;
        }
        stringArray[1] = null;
        int n3 = string.indexOf(".");
        if (n3 != -1 && n3 > n2) {
            stringArray[1] = string.substring(n2 == 0 ? n2 : n2 + 1, n3);
        }
        stringArray[2] = null;
        if (string.length() > n3) {
            stringArray[2] = string.substring(n3 + 1);
        }
        return stringArray;
    }

    @Override
    public ResultSet getProcedureColumns(Datasource datasource, String string, String string2, String string3) throws SQLException, ReportException {
        ResultSet resultSet;
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[DB] getProcedureColumns " + string + " " + string2 + " " + string3);
        }
        if ((resultSet = super.getProcedureColumns(datasource, string, string2, string3)) instanceof b) {
            BaseUtils.error("[DB] getProcedureColumns exception occurs");
            resultSet = super.getProcedureColumns(datasource, null, null, string3);
        }
        b b2 = new b(resultSet);
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("patch ResultSet of getProcedureColumns.");
        }
        List<Object[]> list = b2.AG();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Object[] objectArray = list.get(i2);
            String string4 = (String)objectArray[3];
            if (BaseUtils.isDebug()) {
                if (string4 == null) {
                    BaseUtils.debug("[DB] row name is null");
                } else {
                    BaseUtils.debug("[DB] row name:" + string4);
                }
            }
            if (string4 != null && !string4.equals("null")) continue;
            String string5 = "(expression):" + (i2 + 1);
            objectArray[3] = string5;
            if (!BaseUtils.isDebug()) continue;
            BaseUtils.debug("row " + b2.getRow() + "  -> " + string5);
        }
        return b2;
    }

    @Override
    protected void scanIdentifierQuoteString(Datasource datasource) throws SQLException, ReportException {
        Connection connection = datasource.getConnection();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String string = this.getConfiguration().getIdentifierQuoteString();
        string = databaseMetaData.getIdentifierQuoteString();
        if (string == null || string.trim().length() == 0) {
            string = "\"";
        }
        DatabaseInformix.a(databaseMetaData, true, true);
    }

    @Override
    protected String getColumnName(String string, String string2, int n2, TableSource tableSource, int n3) {
        if (string == null || string.length() == 0 || string.equalsIgnoreCase("(expression)")) {
            String string3 = null;
            if (tableSource.getColumnCount() <= n3) {
                string3 = "(expression):" + n3;
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug("New Stored Procedure column \"" + string + "\" -> " + string3);
                }
            } else {
                string3 = tableSource.getColumnName(n3);
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug("Stored Procedure column \"" + string + "\" -> " + string3);
                }
            }
            return string3;
        }
        return string;
    }

    @Override
    public String getAddOp() {
        return "||";
    }

    @Override
    public String sqlConcat(Object object, Object object2) {
        if (object instanceof String || object2 instanceof String) {
            return object + "||" + object2;
        }
        return super.sqlConcat(object, object2);
    }

    @Override
    public int getMaxAliasNameLength() {
        return 18;
    }

    @Override
    protected boolean scanSourceType(TableSource tableSource, Database.d d2, boolean bl2) throws SQLException, ReportException {
        boolean bl3 = super.scanSourceType(tableSource, d2, bl2);
        if (!bl3) {
            String string = "(expression):";
            for (int i2 = 0; i2 < tableSource.getColumnCount(); ++i2) {
                String string2 = tableSource.getColumnName(i2);
                if (string2.indexOf(string) <= -1) continue;
                bl3 = true;
                break;
            }
        }
        if (bl3 && BaseUtils.isDebug()) {
            BaseUtils.debug("[DB] is a Informix SP");
        }
        return bl3;
    }

    @Override
    String b(TableSource tableSource, boolean bl2) {
        Datasource datasource = tableSource.getDatasource();
        DatabaseTables databaseTables = datasource.getEngine().DE.rh();
        String string = tableSource.getDatabaseIdentifier();
        String[] stringArray = this.parseSourceName(string);
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[DB] getSourceNameWithChange catalog " + stringArray[0] + " schema " + stringArray[1] + " table " + stringArray[2]);
        }
        if (datasource.iK() || datasource.iL()) {
            StringBuffer stringBuffer = new StringBuffer();
            if (datasource.iL() && stringArray[0] != null) {
                stringArray[0] = datasource.getCatalog();
            }
            if (datasource.iK()) {
                stringArray[1] = datasource.getSchema();
            }
            if (stringArray[0] != null) {
                stringBuffer.append(stringArray[0]);
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.append(':');
            }
            if (stringArray[1] != null) {
                stringBuffer.append(stringArray[1]);
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(stringArray[2]);
            string = stringBuffer.toString();
        } else if (!"informix".equalsIgnoreCase(stringArray[1])) {
            string = stringArray[stringArray.length - 1];
        }
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[DB] getSourceNameWithChange result: " + string);
        }
        return this.getSqlIdentifier(databaseTables, string, bl2);
    }
}

