/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.report.BaseUtils;
import com.inet.report.Database;
import com.inet.report.DatabaseField;
import com.inet.report.DatabaseTables;
import com.inet.report.Datasource;
import com.inet.report.Join;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.TableSource;
import com.inet.report.database.ColumnInfo;
import com.inet.report.database.a;
import com.inet.report.database.metadata.b;
import com.inet.report.i18n.ErrorCode;
import com.inet.report.list.g;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class DatabaseOracle
extends Database {
    public static final int TYPE_TIMESTAMP_WITH_TIME_ZONE = -101;
    public static final int TYPE_TIMESTAMP_WITH_LOCAL_TIME_ZONE = -102;
    private boolean Nu = false;

    public DatabaseOracle() {
        this.getConfiguration().setUseSQL92syntax(false, false, false);
    }

    @Override
    public List<ColumnInfo> getColumns(Datasource datasource, String string, String string2, String string3, int n2) throws ReportException {
        switch (n2) {
            case 2: {
                try {
                    ArrayList<ColumnInfo> arrayList = new ArrayList<ColumnInfo>();
                    ResultSet resultSet = this.getProcedureColumns(datasource, string, string2, string3);
                    while (resultSet.next()) {
                        String string4 = resultSet.getString(1);
                        if (string4 != null && !string4.equals(string)) continue;
                        String string5 = resultSet.getString(4);
                        int n3 = resultSet.getInt(5);
                        int n4 = resultSet.getInt(6);
                        int n5 = resultSet.getInt(10);
                        int n6 = DatabaseTables.mapSqlTypeToCCType(n4);
                        arrayList.add(new ColumnInfo(string5, n6, n3, n4, n5));
                    }
                    resultSet.close();
                    return arrayList;
                }
                catch (SQLException sQLException) {
                    throw ReportExceptionFactory.createReportExceptionWithCause(sQLException);
                }
            }
        }
        return super.getColumns(datasource, string, string2, string3, n2);
    }

    @Override
    protected String getSqlIdentifier(DatabaseTables databaseTables, String string, boolean bl2) {
        if (this.getConfiguration().isUseQuoteLowerCase()) {
            return super.getSqlIdentifier(databaseTables, string, bl2);
        }
        return super.getSqlIdentifier(databaseTables, this.ad(string), bl2);
    }

    @Override
    public String getSqlIdentifier_Alias(DatabaseTables databaseTables, String string) {
        if (this.getConfiguration().isUseQuoteLowerCase()) {
            return super.getSqlIdentifier_Alias(databaseTables, string);
        }
        return super.getSqlIdentifier_Alias(databaseTables, this.ad(string));
    }

    @Override
    protected boolean needQuote(String string) {
        if (this.getConfiguration().isUseQuoteLowerCase()) {
            char[] cArray = string.toCharArray();
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                if (cArray[i2] < 'a' || cArray[i2] > 'z') continue;
                return true;
            }
        }
        return super.needQuote(string);
    }

    private void c(DatabaseTables databaseTables) {
        block12: {
            if (this.Nu) {
                return;
            }
            this.Nu = true;
            if (this.getConfiguration().isUseSQL92syntax_setByConfiguration() || this.getConfiguration().isUseSQL92syntax_setByUser()) {
                return;
            }
            int n2 = 8;
            String string = null;
            try {
                Connection connection = null;
                if (databaseTables.getDatasourceCount() == 1) {
                    connection = databaseTables.getDatasource(0).getConnection();
                } else {
                    for (int i2 = 0; i2 < databaseTables.getDatasourceCount(); ++i2) {
                        if (this != databaseTables.getDatasource(i2).getDatabase()) continue;
                        connection = databaseTables.getDatasource(i2).getConnection();
                        break;
                    }
                }
                if (connection == null) {
                    connection = databaseTables.getDatasource(0).getConnection();
                }
                string = connection.getMetaData().getDatabaseProductVersion();
                StringBuffer stringBuffer = new StringBuffer(2);
                for (int i3 = 0; i3 < string.length(); ++i3) {
                    char c2 = string.charAt(i3);
                    if (c2 == '.') {
                        string = stringBuffer.toString();
                        break;
                    }
                    if (c2 >= '0' && c2 <= '9') {
                        stringBuffer.append(c2);
                        continue;
                    }
                    stringBuffer.setLength(0);
                }
                n2 = Integer.parseInt(string);
                this.getConfiguration().setUseSQL92syntax(n2 > 8, false, false);
                if (BaseUtils.isInfo()) {
                    BaseUtils.info("set property supportsSQL92syntax = " + this.getConfiguration().isUseSQL92syntax() + ". Database version : " + string);
                }
            }
            catch (Exception exception) {
                if (!BaseUtils.gk()) break block12;
                BaseUtils.warning("[DatabaseOracle]parsing database version failed. >" + string + "<");
            }
        }
    }

    @Override
    protected StringBuilder addJoinsToFrom(g g2, DatabaseTables databaseTables, boolean bl2, boolean bl3, Datasource datasource) throws ReportException {
        this.c(databaseTables);
        for (int i2 = 0; i2 < g2.size(); ++i2) {
            Join join = g2.ga(i2);
            if (join.getJoinType() != 24 || this.getConfiguration().isUseSQL92syntax()) continue;
            throw ReportExceptionFactory.createReportException(ErrorCode.UnsupportedFOJ, new Object[0]);
        }
        return super.addJoinsToFrom(g2, databaseTables, bl2, bl3, datasource);
    }

    @Override
    protected void addJoinsToWhere(StringBuilder stringBuilder, g g2, DatabaseTables databaseTables) throws ReportException {
        this.c(databaseTables);
        if (this.getConfiguration().isUseSQL92syntax()) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(stringBuilder.length() + g2.size() * 40);
        for (int i2 = 0; i2 < g2.size(); ++i2) {
            Join join;
            int n2;
            if (stringBuffer.length() != 0) {
                stringBuffer.append(" and ");
            }
            if ((n2 = (join = g2.ga(i2)).getJoinType()) == 24) {
                throw ReportExceptionFactory.createReportException(ErrorCode.DisabledFOJ, new Object[0]);
            }
            for (int i3 = 0; i3 < join.getConditionCount(); ++i3) {
                if (i3 != 0) {
                    stringBuffer.append(" and ");
                }
                stringBuffer.append(join.getSourceAlias());
                stringBuffer.append('.');
                stringBuffer.append(this.getSqlIdentifier(databaseTables, join.getConditionSourceColumn(i3), false));
                switch (join.getConditionLinkType(i3)) {
                    case 1: {
                        if (join.getJoinType() == 22) {
                            stringBuffer.append('(').append('+').append(')');
                        }
                        stringBuffer.append('=');
                        break;
                    }
                    case 2: {
                        stringBuffer.append('>');
                        break;
                    }
                    case 4: {
                        stringBuffer.append('<');
                        break;
                    }
                    case 3: {
                        stringBuffer.append(">=");
                        break;
                    }
                    case 5: {
                        stringBuffer.append("<=");
                        break;
                    }
                    case 6: {
                        stringBuffer.append("<>");
                        break;
                    }
                    default: {
                        Object[] objectArray = new Object[]{String.valueOf(n2), join.getSourceAlias(), join.getTargetAlias()};
                        throw ReportExceptionFactory.createReportException(ErrorCode.UnknownJoin, objectArray);
                    }
                }
                stringBuffer.append(join.getTargetAlias());
                stringBuffer.append('.');
                stringBuffer.append(this.getSqlIdentifier(databaseTables, join.getConditionTargetColumn(i3), false));
                switch (n2) {
                    case 23: {
                        stringBuffer.append("(+)");
                    }
                }
            }
        }
        if (stringBuilder.length() > 0 && stringBuffer.length() > 0) {
            stringBuffer.append(" and ");
        }
        stringBuffer.append((CharSequence)stringBuilder);
        stringBuilder.setLength(0);
        stringBuilder.append(stringBuffer);
    }

    @Override
    protected PreparedStatement prepareStatement(TableSource tableSource) throws SQLException, ReportException {
        String string = this.getSourceNameWithChange4Call(tableSource, false);
        Database.d d2 = tableSource.sl();
        string = d2.hK() ? "{?=call " + string + '(' : "{call " + string + '(';
        int n2 = d2.hL();
        for (int i2 = 0; i2 < n2; ++i2) {
            string = i2 == 0 ? string + '?' : string + ",?";
        }
        string = string + ")}";
        if (BaseUtils.isInfo()) {
            BaseUtils.info(string);
        }
        Connection connection = tableSource.getDatasource().getConnection();
        return connection.prepareCall(string);
    }

    @Override
    public String getAddOp() {
        return "||";
    }

    @Override
    public String sqlConcat(Object object, Object object2) {
        if (object instanceof String || object2 instanceof String) {
            return object + "||" + object2;
        }
        return super.sqlConcat(object, object2);
    }

    @Override
    protected String getSourceNameWithChange4Call(TableSource tableSource, boolean bl2) {
        Datasource datasource = tableSource.getDatasource();
        DatabaseTables databaseTables = datasource.getEngine().DE.rh();
        String string = tableSource.getDatabaseIdentifier();
        String[] stringArray = this.parseSourceName(string);
        StringBuffer stringBuffer = new StringBuffer();
        if (datasource.iK()) {
            stringArray[1] = datasource.getSchema();
        }
        if (datasource.iL()) {
            stringArray[0] = datasource.getCatalog();
        }
        if (stringArray[1] != null && stringArray[1].trim().length() != 0) {
            stringBuffer.append(stringArray[1]);
            if (stringBuffer.length() > 0) {
                stringBuffer.append('.');
            }
        }
        if (stringArray[0] != null && stringArray[0].trim().length() != 0) {
            stringBuffer.append(stringArray[0]);
            if (stringBuffer.length() > 0) {
                stringBuffer.append('.');
            }
        }
        stringBuffer.append(stringArray[2]);
        string = stringBuffer.toString();
        return this.getSqlIdentifier(databaseTables, string, bl2);
    }

    @Override
    protected String[] parseSourceName(String string) {
        String[] stringArray = super.parseSourceName(string);
        if (!this.getConfiguration().isUseQuoteLowerCase()) {
            stringArray[0] = this.ad(stringArray[0]);
            stringArray[1] = this.ad(stringArray[1]);
            stringArray[2] = this.ad(stringArray[2]);
        }
        return stringArray;
    }

    @Override
    protected boolean scanSourceType(TableSource tableSource, Database.d d2, boolean bl2) throws SQLException, ReportException {
        ResultSet resultSet;
        String string;
        boolean bl3 = false;
        Datasource datasource = tableSource.getDatasource();
        DatabaseTables databaseTables = datasource.getEngine().getDatabaseTables();
        String[] stringArray = null;
        stringArray = this.parseSourceName(tableSource.sq());
        if (datasource.iK()) {
            stringArray[1] = datasource.getSchema();
        }
        String string2 = stringArray[0] == null ? "" : stringArray[0];
        String string3 = string = stringArray[1] == null ? "" : stringArray[1];
        if (BaseUtils.isInfo()) {
            BaseUtils.info("catalog, schema, proc:" + string2 + ", " + string + ", " + stringArray[2] + "  " + this.getClass());
        }
        com.inet.report.database.metadata.a a2 = null;
        b b2 = null;
        if (((Boolean)Mk.get()).booleanValue() && (b2 = (b)Database.Ml.get(a2 = com.inet.report.database.metadata.a.a(tableSource.getDatasource(), stringArray[0], stringArray[1], stringArray[2]))) != null && bl2) {
            d2.a(b2.AM());
            return b2.AL();
        }
        d2.clear();
        DatabaseMetaData databaseMetaData = datasource.getConnection().getMetaData();
        int n2 = 4;
        try {
            resultSet = databaseMetaData.getTables(string2, string, stringArray[2], null);
            if (resultSet.next()) {
                String string4 = resultSet.getString(4);
                n2 = string4 == null ? 1 : (string4.equals("TABLE") ? 1 : (string4.equals("VIEW") ? 2 : (string4.equals("SYSTEM TABLE") ? 1 : 1)));
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            databaseTables.ij().getEngine().setErrorMsg(sQLException.getMessage());
            BaseUtils.printStackTrace(sQLException);
        }
        if (n2 > 1) {
            try {
                resultSet = databaseMetaData.getProcedureColumns(string2, string, stringArray[2], null);
                boolean bl4 = this.scanSourceTypeParameter(resultSet, d2);
                resultSet.close();
                if (n2 == 4 && bl4 || n2 == 2 && d2.MA > 0) {
                    bl3 = true;
                    ++n2;
                } else if (!bl4 && n2 == 4) {
                    try {
                        resultSet = databaseMetaData.getProcedures(string2, string, stringArray[2]);
                        if (!resultSet.next()) {
                            bl3 = false;
                        }
                        resultSet.close();
                    }
                    catch (Throwable throwable) {
                        BaseUtils.printStackTrace(throwable);
                    }
                }
            }
            catch (Throwable throwable) {
                if (n2 == 4) {
                    bl3 = false;
                }
                databaseTables.ij().getEngine().setErrorMsg(throwable.getMessage());
                BaseUtils.printStackTrace(throwable);
            }
            if (n2 == 4 && !bl3) {
                boolean bl5 = true;
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    String string5 = stringArray[i2];
                    if (string5 != null && string5.length() != 0) continue;
                    bl5 = false;
                    break;
                }
                if (bl5) {
                    bl3 = true;
                } else if (string2.trim().length() > 0) {
                    bl3 = true;
                }
            }
        }
        if (((Boolean)Mk.get()).booleanValue() && b2 == null) {
            b2 = new b(bl3, d2.hM());
            Database.Ml.put(a2, b2);
        }
        return bl3;
    }

    @Override
    protected ResultSet getTables(Datasource datasource, String string) throws SQLException, ReportException {
        return datasource.getConnection().getMetaData().getTables(null, "%", "%", null);
    }

    @Override
    protected ResultSet getProcedures(Datasource datasource, String string) throws SQLException, ReportException {
        return datasource.getConnection().getMetaData().getProcedures(null, "%", "%");
    }

    @Override
    protected ResultSet getProcedureColumns(Datasource datasource, String string, String string2, String string3) throws SQLException, ReportException {
        return datasource.getConnection().getMetaData().getProcedureColumns(string, this.getParameter(string2), this.getParameter(string3), "%");
    }

    private String getParameter(String string) {
        if (string == null) {
            return "%";
        }
        return string;
    }

    @Override
    public String createTableName(Connection connection, String string, String string2, String string3) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        String string4 = connection.getMetaData().getIdentifierQuoteString();
        if (string2 != null) {
            stringBuffer.append(string4).append(string2).append(string4).append('.');
        }
        if (string != null) {
            stringBuffer.append(string4).append(string).append(string4).append('.');
        }
        stringBuffer.append(string4).append(string3).append(string4);
        return stringBuffer.toString();
    }

    @Override
    public boolean returnsMultipleCatalogs() {
        return true;
    }

    @Override
    public boolean returnsMultipleSchemes() {
        return true;
    }

    @Override
    public boolean isCursor(int n2) {
        return n2 == -10 || n2 == 1111;
    }

    @Override
    protected int getCursorType(int n2) {
        return -10;
    }

    private String ad(String string) {
        if (string != null) {
            if (string.indexOf(61) < 0) {
                string = string.replace('\u00df', '=');
                string = string.toUpperCase(Locale.US);
                string = string.replace('=', '\u00df');
            } else {
                string = string.toUpperCase(Locale.US);
            }
        }
        return string;
    }

    @Override
    public int getMaxAliasNameLength() {
        return 30;
    }

    @Override
    public String convertToDate(String string, String string2, String string3) {
        return "to_date(" + string + "||'/'||" + string2 + "||'/'||" + string3 + ",'YYYY/mm/dd')";
    }

    @Override
    public String convertToDate(String string) throws ReportException {
        throw new ReportException("Not Executable on Database.", -150);
    }

    @Override
    public String convertToTime(String string, String string2, String string3) {
        return "to_date('1970-01-01 '||" + string + "||'/'||" + string2 + "||'/'||" + string3 + ",'yyyy-mm-dd HH24/MI/SS')";
    }

    @Override
    public String convertToTimeStamp(String string, String string2, String string3, String string4, String string5, String string6) {
        return "to_date(" + string + "||'/'||" + string2 + "||'/'||" + string3 + "|| ' ' || " + string4 + "||'/'||" + string5 + "||'/'||" + string6 + ",'YYYY/mm/dd HH24/MI/SS')";
    }

    @Override
    public String convertToString(String string) throws ReportException {
        return "to_char(" + string + ")";
    }

    @Override
    public String convertModOperation(String string, String string2) {
        return "mod(" + string + "," + string2 + ")";
    }

    @Override
    protected void findColumnLabels(TableSource tableSource) {
        block8: {
            try {
                if (tableSource.getType() != 1) {
                    return;
                }
                Connection connection = tableSource.getDatasource().getConnection();
                String string = tableSource.getDatabaseIdentifier();
                String string2 = "";
                if (string.indexOf(46) != -1) {
                    string2 = string.substring(0, string.indexOf(46));
                    string = string.substring(string.lastIndexOf(46) + 1, string.length());
                }
                if (string2.length() == 0) {
                    string2 = tableSource.getDatasource().getUsername();
                }
                ResultSet resultSet = a.a(connection.createStatement(), "SELECT OWNER, COLUMN_NAME, COMMENTS from ALL_COL_COMMENTS where TABLE_NAME = '" + string + "'", null);
                com.inet.report.database.b b2 = new com.inet.report.database.b(resultSet);
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug("search column labels OWNER\t\tCOLUMN_NAME\t\tCOMMENTS");
                }
                while (b2.next()) {
                    DatabaseField databaseField;
                    if (BaseUtils.isDebug()) {
                        BaseUtils.debug(b2.getString(1) + "\t\t" + b2.getString(2) + "\t\t" + b2.getString(3));
                    }
                    if (!b2.getString(1).equalsIgnoreCase(string2) || (databaseField = tableSource.getDatabaseField(b2.getString(2))) == null) continue;
                    databaseField.setColumnLabel(b2.getString(3));
                }
            }
            catch (Exception exception) {
                if (!BaseUtils.isDebug()) break block8;
                BaseUtils.debug(exception);
            }
        }
    }
}

