/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.report.Database;
import com.inet.report.DatabaseTables;
import com.inet.report.Join;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.i18n.ErrorCode;
import com.inet.report.list.g;

public class DatabaseSAPDB
extends Database {
    public DatabaseSAPDB() {
        this.getConfiguration().setUseParenthesiseForJoin(false, false);
    }

    @Override
    public int getMaxAliasNameLength() {
        return 32;
    }

    @Override
    protected void addJoinsToWhere(StringBuilder stringBuilder, g g2, DatabaseTables databaseTables) throws ReportException {
        if (this.getConfiguration().isUseSQL92syntax()) {
            return;
        }
        StringBuilder stringBuilder2 = new StringBuilder(stringBuilder.length() + g2.size() * 40);
        for (int i2 = 0; i2 < g2.size(); ++i2) {
            Join join;
            int n2;
            if (stringBuilder2.length() != 0) {
                stringBuilder2.append(" and ");
            }
            if ((n2 = (join = g2.ga(i2)).getJoinType()) == 24) {
                throw ReportExceptionFactory.createReportException(ErrorCode.DisabledFOJ, new Object[0]);
            }
            for (int i3 = 0; i3 < join.getConditionCount(); ++i3) {
                if (i3 != 0) {
                    stringBuilder2.append(" and ");
                }
                stringBuilder2.append(join.getSourceAlias());
                stringBuilder2.append('.');
                stringBuilder2.append(this.getSqlIdentifier(databaseTables, join.getConditionSourceColumn(i3), false));
                switch (join.getConditionLinkType(i3)) {
                    case 1: {
                        if (join.getJoinType() == 22) {
                            stringBuilder2.append('(').append('+').append(')');
                        }
                        stringBuilder2.append('=');
                        break;
                    }
                    case 2: {
                        stringBuilder2.append('>');
                        break;
                    }
                    case 4: {
                        stringBuilder2.append('<');
                        break;
                    }
                    case 3: {
                        stringBuilder2.append(">=");
                        break;
                    }
                    case 5: {
                        stringBuilder2.append("<=");
                        break;
                    }
                    case 6: {
                        stringBuilder2.append("<>");
                        break;
                    }
                    default: {
                        Object[] objectArray = new Object[]{String.valueOf(n2), join.getSourceAlias(), join.getTargetAlias()};
                        throw ReportExceptionFactory.createReportException(ErrorCode.UnknownJoin, objectArray);
                    }
                }
                stringBuilder2.append(join.getTargetAlias());
                stringBuilder2.append('.');
                stringBuilder2.append(this.getSqlIdentifier(databaseTables, join.getConditionTargetColumn(i3), false));
                switch (n2) {
                    case 23: {
                        stringBuilder2.append("(+)");
                    }
                }
            }
        }
        if (stringBuilder.length() > 0 && stringBuilder2.length() > 0) {
            stringBuilder2.append(" and ");
        }
        stringBuilder2.append((CharSequence)stringBuilder);
        stringBuilder.setLength(0);
        stringBuilder.append((CharSequence)stringBuilder2);
    }
}

