/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.report.BaseUtils;
import com.inet.report.Database;
import com.inet.report.DatabaseField;
import com.inet.report.DatabaseTables;
import com.inet.report.ReportException;
import com.inet.report.TableSource;
import com.inet.report.database.a;
import com.inet.report.database.b;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DatabaseSqlServer
extends Database {
    @Override
    protected boolean scanSourceType(TableSource tableSource, Database.d d2, boolean bl2) throws SQLException, ReportException {
        return super.scanSourceType(tableSource, d2, bl2) || tableSource.sq().endsWith(";1");
    }

    @Override
    protected String getSqlIdentifier(DatabaseTables databaseTables, String string, boolean bl2) {
        if (string.endsWith(";1")) {
            return super.getSqlIdentifier(databaseTables, string.substring(0, string.length() - 2), bl2) + ";1";
        }
        return super.getSqlIdentifier(databaseTables, string, bl2);
    }

    @Override
    protected boolean needQuote(String string) {
        if (string.startsWith("[")) {
            return false;
        }
        return super.needQuote(string);
    }

    @Override
    public int getMaxAliasNameLength() {
        return 128;
    }

    @Override
    public String convertToString(String string) throws ReportException {
        return "convert(varchar," + string + ")";
    }

    @Override
    public String convertToInt(String string) throws ReportException {
        return "convert(int," + string + ")";
    }

    @Override
    public String convertToTime(String string) throws ReportException {
        return this.convertToTime("{fn HOUR(" + string + ")}", "{fn MINUTE(" + string + ")}", "{fn SECOND(" + string + ")}");
    }

    @Override
    public String convertToDate(String string) throws ReportException {
        return this.convertToDate("{fn YEAR(" + string + ")}", "{fn MONTH(" + string + ")}", "{fn DAYOFMONTH(" + string + ")}");
    }

    @Override
    protected void findColumnLabels(TableSource tableSource) {
        block7: {
            try {
                if (tableSource.getType() != 1) {
                    return;
                }
                Connection connection = tableSource.getDatasource().getConnection();
                String string = tableSource.getDatabaseIdentifier();
                if (string.indexOf(46) != -1) {
                    string = string.substring(string.lastIndexOf(46) + 1, string.length());
                }
                ResultSet resultSet = a.a(connection.createStatement(), "select syscolumns.name ,sysobjects.name , sysproperties.value from syscolumns, sysobjects,sysproperties where syscolumns.id = sysobjects.id and sysobjects.id=sysproperties.id and syscolumns.colorder=sysproperties.smallid and sysproperties.name = 'MS_Description' and sysobjects.name = '" + string + "'", null);
                b b2 = new b(resultSet);
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug("search column labels COLUMN_NAME\t\tTABLE_NAME\t\tCOMMENTS");
                }
                while (b2.next()) {
                    DatabaseField databaseField;
                    if (BaseUtils.isDebug()) {
                        BaseUtils.debug(b2.getString(1) + "\t\t" + b2.getString(2) + "\t\t" + b2.getString(3));
                    }
                    if ((databaseField = tableSource.getDatabaseField(b2.getString(1))) == null) continue;
                    databaseField.setColumnLabel(b2.getString(3));
                }
            }
            catch (Exception exception) {
                if (!BaseUtils.isDebug()) break block7;
                BaseUtils.debug("unable to fetch column labels: " + exception);
            }
        }
    }

    @Override
    public String convertStringToSQLSyntax(String string, boolean bl2) {
        if (!bl2) {
            return "N" + super.convertStringToSQLSyntax(string, bl2);
        }
        return super.convertStringToSQLSyntax(string, bl2);
    }
}

