/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.adhoc.base.AHBaseUtils;
import com.inet.lib.list.StringList;
import com.inet.report.BaseUtils;
import com.inet.report.Database;
import com.inet.report.DatabaseField;
import com.inet.report.DatabaseTables;
import com.inet.report.Engine;
import com.inet.report.Field;
import com.inet.report.Fields;
import com.inet.report.Join;
import com.inet.report.PromptField;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.SQLField;
import com.inet.report.Section;
import com.inet.report.SortField;
import com.inet.report.TableSource;
import com.inet.report.TablesourceList;
import com.inet.report.ay;
import com.inet.report.cc;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.config.datasource.DataSourceConfigurationManager;
import com.inet.report.config.datasource.swing.PasswordDialog;
import com.inet.report.config.structure.model.ConfigKey;
import com.inet.report.cs;
import com.inet.report.database.DataFactory;
import com.inet.report.database.a;
import com.inet.report.dw;
import com.inet.report.i18n.ErrorCode;
import com.inet.report.list.c;
import com.inet.report.list.g;
import com.inet.report.parser.NodeParser;
import com.inet.report.pool.PoolManager;
import com.inet.report.q;
import java.awt.EventQueue;
import java.awt.Frame;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;

public class Datasource
implements Serializable {
    private final Properties Oi = new Properties();
    private DataSourceConfiguration Oj;
    private transient Connection Ok;
    private transient boolean Ol;
    private DataFactory Om;
    private final TablesourceList On = new TablesourceList();
    @Nonnull
    private Engine ML;
    private boolean Oo = false;
    private boolean Op = false;
    private boolean Oq = true;
    private boolean Or;

    Datasource(String string, String string2, String string3, String string4, String string5, String string6, Engine engine) {
        this(string, engine);
        if (string2 != null) {
            this.Oi.put("datasource_host", string2);
        }
        if (string3 != null) {
            this.Oi.put("datasource_schema", string3);
        }
        if (string4 != null) {
            this.Oi.put("datasource_catalog", string4);
        }
        if (string5 != null) {
            this.Oi.put("user", string5);
        }
        if (string6 != null) {
            this.Oi.put("password", string6);
        }
        this.Or = true;
        if (string2 == null && string4 == null && string5 == null && string6 == null) {
            return;
        }
        if (ay.kE().kP()) {
            this.iJ();
        }
    }

    Datasource(String string, @Nonnull Engine engine) {
        this.ML = engine;
        this.setDataSourceConfigurationName(string);
    }

    public String toString() {
        DatabaseTables databaseTables = this.ML.DE.rh();
        int n2 = databaseTables.getDatasourceCount();
        int n3 = -1;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (databaseTables.getDatasource(i2) != this) continue;
            n3 = i2;
            break;
        }
        return "#" + n3 + " (" + this.getDataSourceConfigurationName() + ")";
    }

    @Nonnull
    Engine getEngine() {
        return this.ML;
    }

    public synchronized Connection getConnection() throws ReportException {
        if (!this.hasValidConnection()) {
            block14: {
                Object object;
                if (!this.iM() && !a.a(this.Om)) {
                    return null;
                }
                if (this.Oj == null) {
                    if (this.Oi != null) {
                        object = null;
                        object = this.Oi.getProperty("datasource_name", null);
                        if (object != null && ((String)object).length() > 0) {
                            this.g((String)object, this.Or);
                        }
                    }
                    if (this.Oj == null) {
                        return null;
                    }
                }
                if ((object = (Object)this.ML.DE.oi()) != null) {
                    DatabaseTables databaseTables = ((cs)object).rh();
                    int n2 = databaseTables.getDatasourceCount();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        Datasource datasource = databaseTables.getDatasource(i2);
                        if (datasource.Ok == null || !this.equals(datasource) || !datasource.hasValidConnection()) continue;
                        this.Ok = datasource.Ok;
                        datasource.Ol = true;
                    }
                }
                if (this.Ok == null) {
                    this.Ok = this.iF();
                }
                try {
                    if (this.getCatalog().length() > 0 && !this.getCatalog().equals(this.Ok.getCatalog())) {
                        this.Ok.setCatalog(this.getCatalog());
                    }
                }
                catch (Throwable throwable) {
                    if (BaseUtils.isParanoid()) {
                        BaseUtils.paranoid("[Datasource#" + this.getIndex() + "] set catalog to " + this.getCatalog() + " failed.");
                    }
                    if (!BaseUtils.isParanoid()) break block14;
                    BaseUtils.paranoid(throwable);
                }
            }
            if (this.Oq) {
                this.iG();
            }
            this.iD();
        }
        return this.Ok;
    }

    private void iD() {
        try {
            if (this.Oj == null || this.Oj.getIdentifierQuoteString() == null || this.Oj.getIdentifierQuoteString().length() == 0) {
                ((Database)this.Om).scanIdentifierQuoteString(this);
                BaseUtils.info("IdentifierQuoteString: >" + this.Om.getConfiguration().getIdentifierQuoteString() + "<");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Properties iE() {
        String string;
        String string2;
        Properties properties = new Properties();
        String[] stringArray = this.Oj.getDriverSpecificProperties();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            string2 = stringArray[i2];
            string = this.Oj.getProperty(string2);
            if (string == null || string.length() <= 0) continue;
            properties.put(string2, string);
        }
        String string3 = this.getUsername();
        if (string3 != null && !string3.isEmpty()) {
            properties.put("user", string3);
        }
        if ((string2 = this.getPassword()) != null && !string2.isEmpty()) {
            properties.put("password", string2);
        }
        if ((string = this.getCatalog()) != null && string.length() > 0) {
            properties.put("catalog", string);
        }
        return properties;
    }

    private Connection iF() throws ReportException {
        if (EventQueue.isDispatchThread()) {
            BaseUtils.printStackTrace(new Throwable("WARNING: connecting to the DB on the event dispatch thread!"));
        }
        this.ML.iU();
        if (!dw.j(ConfigKey.PERMISSION_ALLOW_UNKNOWN_DATASOURCE.getKey(), Boolean.parseBoolean(ConfigKey.PERMISSION_ALLOW_UNKNOWN_DATASOURCE.getDefault())) && !DataSourceConfigurationManager.exists(this.getDataSourceConfigurationName())) {
            throw ReportExceptionFactory.createReportException(ErrorCode.AccessDeniedUnknownDatasource, this.getDataSourceConfigurationName());
        }
        String string = this.getUrl();
        Properties properties = this.iE();
        string = Datasource.a(string, properties, this);
        BaseUtils.info("try connection: " + this.Oj.getConfigurationName() + " / " + string);
        try {
            Connection connection;
            block9: {
                String string2;
                properties.remove("initSQL");
                connection = PoolManager.getDefault().getConnection(this.Oj.getDriverClassname(), string, properties);
                if (BaseUtils.isInfo()) {
                    BaseUtils.info("creating connection:" + connection + " for engine: " + this.ML.DE.id);
                }
                if ((string2 = this.Oj.getProperty("initSQL")).length() > 0) {
                    try {
                        if (BaseUtils.isDebug()) {
                            BaseUtils.debug("executing initSQL command: " + string2);
                        }
                        connection.createStatement().execute(string2);
                    }
                    catch (SQLException sQLException) {
                        if (!BaseUtils.isDebug()) break block9;
                        BaseUtils.debug("executing initSQL failed");
                        BaseUtils.debug(sQLException);
                    }
                }
            }
            return connection;
        }
        catch (SQLException sQLException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(sQLException);
        }
    }

    private static String a(String string, Properties properties, Datasource datasource) {
        int n2 = 0;
        while (string.indexOf(123, n2) != -1) {
            int n3;
            int n4;
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("[DataSourceConfiguration] adapt driver URL. " + string);
            }
            if ((n4 = string.indexOf(123, n2)) > (n3 = string.indexOf(125, n2))) break;
            String string2 = string.substring(n4 + 1, n3);
            String string3 = properties.getProperty(string2);
            if (string3 == null) {
                try {
                    int n5 = Integer.parseInt(string2);
                    switch (n5) {
                        case 0: {
                            string3 = datasource.getHost();
                            break;
                        }
                        case 1: {
                            string3 = datasource.getCatalog();
                            break;
                        }
                        case 2: {
                            string3 = datasource.getUsername();
                            break;
                        }
                        case 3: {
                            string3 = datasource.getPassword();
                            break;
                        }
                        case 4: {
                            string3 = datasource.getSchema();
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (string3 != null) {
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug("[DataSourceConfiguration] adapt driver URL. replace \"{" + string2 + "}\" with \"" + string3 + "\"");
                }
                properties.remove(string2);
                string = string.substring(0, n4) + string3 + string.substring(n3 + 1, string.length());
                continue;
            }
            n2 = n3 + 1;
        }
        return string;
    }

    public void closeConnection() {
        if (this.Ol) {
            return;
        }
        Connection connection = this.Ok;
        this.Ok = null;
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                BaseUtils.printStackTrace(sQLException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasValidConnection() {
        Connection connection = this.Ok;
        if (connection == null) {
            return false;
        }
        try {
            boolean bl2;
            String string;
            DataSourceConfiguration dataSourceConfiguration = this.getDataSourceConfiguration();
            String string2 = string = dataSourceConfiguration == null ? null : dataSourceConfiguration.getValidationQuery();
            if (string != null && string.trim().length() > 0) {
                if (connection.isClosed()) {
                    bl2 = true;
                } else {
                    Statement statement = connection.createStatement();
                    try {
                        if (BaseUtils.isDebug()) {
                            BaseUtils.debug("executing validation query \"" + string + "\" for DataSourceConfiguration \"" + (dataSourceConfiguration != null ? dataSourceConfiguration.getConfigurationName() : "<none>") + "\"");
                        }
                        if (statement.execute(string)) {
                            statement.getResultSet();
                        } else {
                            statement.getUpdateCount();
                        }
                        bl2 = false;
                    }
                    catch (SQLException sQLException) {
                        bl2 = true;
                    }
                    finally {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            } else {
                bl2 = connection.isClosed();
            }
            if (bl2) {
                this.Ok = null;
            }
            return !bl2;
        }
        catch (SQLException sQLException) {
            this.Ok = null;
            return false;
        }
    }

    public void setConnection(Connection connection) {
        if (this.hasValidConnection() && this.Ok != connection) {
            try {
                this.Ok.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.Ok = connection;
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[Datasource#" + this.getIndex() + "] Used connection " + this.Ok + "  is valid:" + this.hasValidConnection());
        }
        this.iG();
        this.iD();
    }

    private void iG() {
        Database database = com.inet.report.database.base.a.AH().e(this.Ok);
        if (this.Om == null || database != null && this.Om.getClass() != database.getClass()) {
            this.Om = database;
            DataSourceConfiguration dataSourceConfiguration = this.getDataSourceConfiguration();
            if (dataSourceConfiguration != null) {
                ((Database)this.Om).setConfiguration(dataSourceConfiguration.getDatabaseConfiguration());
            }
        }
        this.Oq = false;
    }

    @Deprecated
    public void setConnection(Connection connection, Properties properties) {
        this.setConnection(connection);
        if (properties != dw.azD.getProperties()) {
            dw.azD.putAll(properties);
        }
        cc.a((Database)this.Om, "setConnection.", true);
    }

    void iH() {
        this.On.clear();
    }

    public String getCatalog() {
        String string = this.Oi.getProperty("datasource_catalog", "");
        if (string.length() == 0 && this.Oj != null && (string = this.Oj.getProperty("datasource_catalog")).length() == 0) {
            string = this.Oj.getCatalog();
        }
        if (string == null) {
            return "";
        }
        return string;
    }

    public void setCatalog(String string) {
        this.aj(string);
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[Datasource#" + this.getIndex() + "]setCatalog " + this.getCatalog());
        }
        this.Oo = true;
    }

    void aj(String string) {
        if (string == null) {
            string = "";
        }
        this.Oi.put("datasource_catalog", string);
    }

    public DataSourceConfiguration getDataSourceConfiguration() {
        if (DataSourceConfigurationManager.exists(this.getDataSourceConfigurationName())) {
            return DataSourceConfigurationManager.getDataSourceConfiguration(this.getDataSourceConfigurationName(), 3);
        }
        return this.Oj;
    }

    public String getDataSourceConfigurationName() {
        String string;
        if (this.Oj != null && !(string = this.Oj.getConfigurationName()).isEmpty()) {
            return string;
        }
        return this.Oi.getProperty("datasource_name", "");
    }

    @Deprecated
    void ak(String string) {
        if (string == null) {
            string = "";
        }
        String string2 = this.getUsername();
        String string3 = this.getPassword();
        this.g(string, true);
        this.setUsername(string2);
        this.setPassword(string3);
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[Datasource#" + this.getIndex() + "]setDll " + string);
        }
    }

    public String getHost() {
        return this.Oi.getProperty("datasource_host", "");
    }

    public void setHost(String string) {
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[Datasource#" + this.getIndex() + "]setHost " + string);
        }
        if (string == null) {
            string = "";
        }
        this.Oi.put("datasource_host", string);
    }

    public String getPassword() {
        String string;
        String string2 = this.Oi.getProperty("password");
        if (string2 == null && this.getEngine() != null && (string = this.getEngine().getMetaProperties().getProperty("designer." + this.getDataSourceConfigurationName())) != null) {
            string2 = this.decrypt(string);
        }
        if (string2 == null && this.Oj != null) {
            return this.Oj.getPassword();
        }
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    private String decrypt(String string) {
        if (string.startsWith("N")) {
            return string.substring(1);
        }
        try {
            byte[] byArray = AHBaseUtils.decodeStringToArray(string.substring(1));
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(128);
            SecretKeySpec secretKeySpec = new SecretKeySpec("KEY_DATA_SOURCE_".getBytes(), "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, secretKeySpec);
            return new String(cipher.doFinal(byArray));
        }
        catch (Exception exception) {
            if (BaseUtils.isDebug()) {
                BaseUtils.debug(exception);
            }
            return null;
        }
    }

    public void setPassword(String string) {
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[Datasource#" + this.getIndex() + "]setPassword *****");
        }
        if (string == null) {
            this.Oi.remove("password");
        } else {
            this.Oi.put("password", string);
        }
    }

    public String getSchema() {
        if (this.Op) {
            return this.Oi.getProperty("datasource_schema", "");
        }
        DataSourceConfiguration dataSourceConfiguration = this.getDataSourceConfiguration();
        if (dataSourceConfiguration != null) {
            return dataSourceConfiguration.getProperty("datasource_schema");
        }
        return this.Oi.getProperty("datasource_schema", "");
    }

    public void setSchema(String string) {
        this.al(string);
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[Datasource#" + this.getIndex() + "]setSchema" + this.getSchema());
        }
        this.Op = true;
    }

    void al(String string) {
        if (string == null) {
            string = "";
        }
        this.Oi.put("datasource_schema", string);
    }

    public String getUsername() {
        String string = this.Oi.getProperty("user");
        if (string == null && this.Oj != null) {
            return this.Oj.getUser();
        }
        if (string == null) {
            return "";
        }
        return string;
    }

    public void setUsername(String string) {
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[Datasource#" + this.getIndex() + "]setUserName " + string);
        }
        if (string == null) {
            this.Oi.remove("user");
        } else {
            this.Oi.put("user", string);
        }
    }

    void b(TableSource tableSource) {
        if (this.On.contains(tableSource)) {
            return;
        }
        tableSource.setDatasource(this);
        this.On.addWithRefreshEvent(tableSource);
    }

    public TableSource getTableSource(int n2) {
        return (TableSource)this.On.get(n2);
    }

    public String getUrl() {
        String string = this.Oi.getProperty("datasource_url");
        if (string == null && this.Oj != null) {
            return this.Oj.getUrl();
        }
        if (string == null) {
            return "";
        }
        return string;
    }

    public void setUrl(String string) {
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[Datasource#" + this.getIndex() + "]setUrl " + string);
        }
        if (string == null) {
            string = "";
        }
        this.Oi.put("datasource_url", string);
    }

    public TableSource getTableSource(String string) throws ReportException {
        TableSource tableSource = this.getTableSourceIfExist(string);
        if (tableSource == null) {
            throw new ReportException("There is no table source defined with alias \"" + string + "\"", -1058);
        }
        return tableSource;
    }

    public TableSource getTableSourceIfExist(String string) {
        for (int i2 = 0; i2 < this.getTableSourceCount(); ++i2) {
            TableSource tableSource = this.getTableSource(i2);
            if (!tableSource.toString().equals(string)) continue;
            return tableSource;
        }
        return null;
    }

    public String[] getAliasList() {
        StringList stringList = new StringList(this.getTableSourceCount());
        for (int i2 = 0; i2 < this.getTableSourceCount(); ++i2) {
            TableSource tableSource = this.getTableSource(i2);
            stringList.addElement(tableSource.getAlias());
        }
        return stringList.toArray();
    }

    public boolean containsOnlyTables() {
        for (int i2 = 0; i2 < this.getTableSourceCount(); ++i2) {
            try {
                if (this.getTableSource(i2).getType() == 1) continue;
                return false;
            }
            catch (ReportException reportException) {
                return false;
            }
            catch (SQLException sQLException) {
                return false;
            }
        }
        return true;
    }

    public void removeTableSource(TableSource tableSource) throws ReportException {
        this.c(tableSource);
        this.On.removeWithRefreshEvent(tableSource);
    }

    public TableSource removeTableSourceAt(int n2) throws ReportException {
        TableSource tableSource = (TableSource)this.On.get(n2);
        this.removeTableSource(tableSource);
        return tableSource;
    }

    void a(TableSource tableSource, Datasource datasource) {
        this.On.removeWithRefreshEvent(tableSource);
        datasource.b(tableSource);
    }

    private void c(TableSource tableSource) throws ReportException {
        NodeParser nodeParser;
        int n2;
        int n3;
        Fields fields = this.ML.DE.getFields();
        for (n3 = 0; n3 < tableSource.getColumnCount(); ++n3) {
            tableSource.canRemoveColumn(tableSource.getColumnName(n3));
        }
        for (n3 = 0; n3 < tableSource.getColumnCount(); ++n3) {
            tableSource.removeColumn(tableSource.getColumnName(n3));
        }
        g g2 = this.ML.DE.rh().ik();
        for (n2 = g2.size() - 1; n2 >= 0; --n2) {
            nodeParser = g2.ga(n2);
            if (((Join)nodeParser).getSourceTableSource() != tableSource && ((Join)nodeParser).getTargetTableSource() != tableSource) continue;
            g2.gb(n2);
        }
        for (n2 = 0; n2 < fields.getPromptFieldsCount(); ++n2) {
            nodeParser = fields.getPromptField(n2);
            if (((PromptField)nodeParser).acK != tableSource) continue;
            ((PromptField)nodeParser).acJ = null;
            ((Field)nodeParser).removeReferenceHolder(tableSource);
            ((PromptField)nodeParser).acK = null;
            if (((Field)nodeParser).getRealReferenceCount() != 0) continue;
            fields.removePromptField(n2);
            --n2;
        }
        for (n2 = 0; n2 < fields.getDatabaseFieldsCount(); ++n2) {
            nodeParser = fields.getDatabaseField(n2);
            if (((DatabaseField)nodeParser).Np != tableSource) continue;
            fields.removeDatabaseField(n2);
            --n2;
        }
        tableSource.resetReferences();
        this.ML.DE.getFields().a((Field)null, 3);
    }

    public int getTableSourceCount() {
        return this.On.size();
    }

    @Deprecated
    public Database getDatabase() {
        return (Database)this.getDataFactory();
    }

    public DataFactory getDataFactory() {
        return this.Q(true);
    }

    @Deprecated
    Database P(boolean bl2) {
        return (Database)this.Q(bl2);
    }

    DataFactory Q(boolean bl2) {
        if (bl2) {
            try {
                if (this.ML.je() == 2 && this.iM()) {
                    Connection connection = this.Ok;
                    this.Ok = this.getConnection();
                    if (this.Ok != connection && this.Ok != null) {
                        this.Ok.close();
                        this.Ok = null;
                    }
                }
            }
            catch (ReportException reportException) {
            }
            catch (SQLException sQLException) {
                BaseUtils.printStackTrace(sQLException);
            }
        }
        if (this.Om == null) {
            this.Om = new Database();
        }
        return this.Om;
    }

    @Deprecated
    public void setDatabase(Database database) {
        this.setDataFactory(database);
    }

    public void setDataFactory(DataFactory dataFactory) {
        if (this.getDataSourceConfigurationName().length() == 0) {
            this.Oi.put("datasource_name", "database directly");
        }
        this.Om = dataFactory;
        this.Oq = false;
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[Datasource#" + this.getIndex() + "] used DataFactory " + dataFactory);
        }
    }

    TablesourceList iI() {
        return this.On;
    }

    void a(StringBuffer stringBuffer, int n2) {
        if (this.Oj != null || this.On.size() > 0) {
            this.iJ();
            stringBuffer.append(BaseUtils.L(n2));
            stringBuffer.append("<").append("Datasource").append(">\n").append("\n");
            ++n2;
            if (this.Oj != null && this.ML.DE.getReportProperties().isSaveDatasource()) {
                com.inet.report.config.datasource.a.a(this.Oj, stringBuffer, n2);
            } else {
                String string = this.getDataSourceConfigurationName();
                if (string.length() > 0) {
                    stringBuffer.append(BaseUtils.L(n2));
                    stringBuffer.append("<").append("DataSourceConfiguration").append(q.n("name", string)).append(">\n").append("\n");
                    stringBuffer.append(BaseUtils.L(n2));
                    stringBuffer.append("<").append("/").append("DataSourceConfiguration").append(">\n").append("\n");
                }
            }
            for (int i2 = 0; i2 < this.On.size(); ++i2) {
                ((TableSource)this.On.get(i2)).a(stringBuffer, n2);
            }
            stringBuffer.append(BaseUtils.L(--n2));
            stringBuffer.append("<").append("/").append("Datasource").append(">\n").append("\n");
        }
    }

    void iJ() {
        block33: {
            if (!this.Or || this.Oj == null) {
                return;
            }
            String string = Datasource.am(this.getHost());
            String string2 = this.getCatalog();
            String string3 = this.getUsername();
            String string4 = this.getPassword();
            boolean bl2 = this.ML.DE.rh().isSavePassword();
            StringBuilder stringBuilder = new StringBuilder();
            String string5 = this.getDataSourceConfigurationName();
            if ("pdsodbc.dll".equals(string5)) {
                stringBuilder.append(string);
                if (string3.length() > 0) {
                    stringBuilder.append('(').append(Datasource.am(string3)).append(')');
                }
            } else if ("pdssql.dll".equals(string5)) {
                stringBuilder.append("MS SQL(");
                stringBuilder.append(string).append(',');
                stringBuilder.append(Datasource.am(string2)).append(',');
                stringBuilder.append(Datasource.am(string3)).append(')');
            } else if ("pdsora7.dll".equals(string5)) {
                stringBuilder.append("Oracle(");
                stringBuilder.append(string).append(',');
                stringBuilder.append(Datasource.am(string3)).append(')');
            } else if ("core.dll".equals(string5)) {
                stringBuilder.append("Core");
            } else {
                if (string5.endsWith(".dll")) {
                    string5 = string5.substring(0, string5.length() - 4);
                    string5 = Datasource.am(string5);
                }
                stringBuilder.append(string5).append('(');
                stringBuilder.append(string).append(',');
                stringBuilder.append(string2).append(',');
                stringBuilder.append(string3).append(')');
            }
            if (stringBuilder.length() > 80) {
                stringBuilder.setLength(80);
            }
            String string6 = stringBuilder.toString();
            try {
                DataSourceConfiguration dataSourceConfiguration = DataSourceConfigurationManager.getDataSourceConfiguration(string6, 3);
                if (dataSourceConfiguration == null) {
                    dataSourceConfiguration = DataSourceConfigurationManager.createDataSourceConfiguration(string6, 4);
                    dataSourceConfiguration.addProperties(this.Oj.getProperties());
                    Properties properties = this.iE();
                    String string7 = this.getUrl();
                    String string8 = this.Oj.getDriverClassname();
                    if ("sun.jdbc.odbc.JdbcOdbcDriver".equals(string8) && "jdbc:odbc:{0}".equals(string7)) {
                        string7 = "jdbc:odbc:{datasource}";
                        dataSourceConfiguration.addProperty("datasource", string);
                    } else if ("com.inet.tds.TdsDriver".equals(string8) && "jdbc:inetdae7:{0}?database={1}".equals(string7)) {
                        string7 = "jdbc:inetdae7";
                        dataSourceConfiguration.addProperty("host", string);
                        dataSourceConfiguration.addProperty("database", string2);
                    } else if ("com.inet.ora.OraDriver".equals(string8) && "jdbc:inetora:{0}".equals(string7)) {
                        string7 = "jdbc:inetora";
                        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
                        if (stringTokenizer.hasMoreTokens()) {
                            dataSourceConfiguration.addProperty("host", stringTokenizer.nextToken());
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            dataSourceConfiguration.addProperty("port", stringTokenizer.nextToken());
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            dataSourceConfiguration.addProperty("sid", stringTokenizer.nextToken());
                        }
                    } else if ("com.mysql.jdbc.Driver".equals(string8) && "jdbc:mysql://{0}/{1}".equals(string7)) {
                        string7 = "jdbc:mysql://{host}:{port}/{database}";
                        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
                        if (stringTokenizer.hasMoreTokens()) {
                            dataSourceConfiguration.addProperty("host", stringTokenizer.nextToken());
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            dataSourceConfiguration.addProperty("port", stringTokenizer.nextToken());
                        }
                        dataSourceConfiguration.addProperty("database", string2);
                    } else if ("org.postgresql.Driver".equals(string8) && "jdbc:postgresql://{0}/{1}".equals(string7)) {
                        string7 = "jdbc:postgresql://{host}:{port}/{database}";
                        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
                        if (stringTokenizer.hasMoreTokens()) {
                            dataSourceConfiguration.addProperty("host", stringTokenizer.nextToken());
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            dataSourceConfiguration.addProperty("port", stringTokenizer.nextToken());
                        }
                        dataSourceConfiguration.addProperty("database", string2);
                    } else {
                        string7 = Datasource.a(string7, properties, this);
                    }
                    dataSourceConfiguration.setUrl(string7);
                    dataSourceConfiguration.setCatalog(string2);
                    dataSourceConfiguration.setUser(string3);
                    dataSourceConfiguration.setPassword(string4);
                    dataSourceConfiguration.setSavePassword(bl2);
                    dataSourceConfiguration.save(4);
                }
                boolean bl3 = this.Oq;
                this.a(dataSourceConfiguration, false);
                this.Oq = bl3;
                this.Or = false;
                if (!bl2) {
                    this.setPassword(string4);
                }
            }
            catch (Throwable throwable) {
                if (!BaseUtils.gk()) break block33;
                BaseUtils.warning(throwable);
            }
        }
    }

    private static String am(String string) {
        if (string.length() > 0 && Character.isLowerCase(string.charAt(0))) {
            return string.substring(0, 1).toUpperCase() + string.substring(1);
        }
        return string;
    }

    public TableSource createTableSource(String string, String string2) throws ReportException {
        if (string2 == null) {
            return this.createTableSource(string);
        }
        TableSource tableSource = new TableSource(string, string2, this.ML, this);
        if (this.On.contains(tableSource)) {
            return this.getTableSource(string2);
        }
        this.b(tableSource);
        return tableSource;
    }

    public TableSource createTableSourceCommand(String string, String string2) throws ReportException {
        return this.createTableSourceCommand(string, string2, true);
    }

    public TableSource createTableSourceCommand(String string, String string2, boolean bl2) throws ReportException {
        if (this.ML.DE.rh().ag(string)) {
            throw new ReportException("There already exists a TableSource with the alias name >" + string + "<", 1111);
        }
        TableSource tableSource = new TableSource(string, string, this.ML, this);
        tableSource.setSql(string2);
        tableSource.setQuoteStringPrompts(bl2);
        tableSource.setDatasource(this);
        try {
            tableSource.refresh();
        }
        catch (ReportException reportException) {
            tableSource.resetReferences();
            throw reportException;
        }
        catch (SQLException sQLException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(sQLException);
        }
        this.b(tableSource);
        return tableSource;
    }

    public TableSource createTableSource(String string) throws ReportException {
        String string2 = this.ML.DE.rh().a(string, this.getDataFactory());
        if (a.a(this.Om)) {
            return this.createTableSource(string, string2);
        }
        TableSource tableSource = new TableSource(this.ML, this);
        tableSource.setDatabaseIdentifierName(string);
        tableSource.bH(string2);
        if (this.On.contains(tableSource)) {
            return this.getTableSource(string2);
        }
        this.b(tableSource);
        return tableSource;
    }

    TableSource o(String string, String string2) {
        TableSource tableSource;
        try {
            tableSource = this.getTableSource(string2);
            if (tableSource != null) {
                return tableSource;
            }
        }
        catch (ReportException reportException) {
            // empty catch block
        }
        tableSource = new TableSource(this.ML, this);
        tableSource.bJ(string);
        tableSource.bH(string2);
        this.b(tableSource);
        return tableSource;
    }

    boolean iK() {
        if (this.Op) {
            return true;
        }
        DataSourceConfiguration dataSourceConfiguration = this.getDataSourceConfiguration();
        return dataSourceConfiguration != null && dataSourceConfiguration.getProperty("datasource_schema").length() > 0;
    }

    boolean iL() {
        if (this.Oo) {
            return true;
        }
        DataSourceConfiguration dataSourceConfiguration = this.getDataSourceConfiguration();
        return dataSourceConfiguration != null && dataSourceConfiguration.getProperty("datasource_catalog").length() > 0;
    }

    public String getSql(boolean bl2) throws ReportException, SQLException {
        Engine engine;
        Object object;
        Object object2;
        Object object3;
        int n2;
        if (this.ML.getDatabaseTables().getDatasourceCount() == 1) {
            return this.ML.getDatabaseTables().a(bl2, this);
        }
        if (!this.hasValidConnection()) {
            this.getConnection();
        }
        if ((n2 = this.getTableSourceCount()) > 1) {
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.getTableSource(i2).getType() == 1) continue;
                throw ReportExceptionFactory.createReportException(ErrorCode.NotOnlyTablesToSQL, this.getTableSource(i2).getAlias());
            }
        } else {
            if (n2 == 0) {
                return "";
            }
            TableSource tableSource = this.getTableSource(0);
            if (tableSource.getType() == 2) {
                tableSource.aP(bl2);
            } else if (tableSource.getType() == 3) {
                return tableSource.getSql();
            }
        }
        try {
            object3 = new ByteArrayOutputStream(5000);
            object2 = new ObjectOutputStream((OutputStream)object3);
            ((ObjectOutputStream)object2).writeObject(this.ML);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((ByteArrayOutputStream)object3).toByteArray());
            object = new ObjectInputStream(byteArrayInputStream);
            engine = (Engine)((ObjectInputStream)object).readObject();
        }
        catch (IOException iOException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(classNotFoundException);
        }
        object3 = engine.DE;
        ((cs)object3).g(null);
        ((cs)object3).h(null);
        ((cc)object3).arY = new SortField[0];
        ((cc)object3).arX = null;
        ((cc)object3).arW = null;
        object2 = new StringList(n2);
        for (int i3 = 0; i3 < n2; ++i3) {
            ((StringList)object2).addElement(this.getTableSource(i3).getAlias());
        }
        c c2 = new c(n2 * 10);
        object = ((cs)object3).getFields();
        DatabaseTables databaseTables = ((cs)object3).rh();
        for (int i4 = 0; i4 < ((StringList)object2).size(); ++i4) {
            TableSource tableSource = databaseTables.getTablesource(((StringList)object2).elementAt(i4));
            for (int i5 = 0; i5 < tableSource.getColumnCount(); ++i5) {
                c2.f(((Fields)object).getDatabaseField(tableSource.getAlias() + "." + tableSource.getColumnName(i5)));
            }
        }
        ((cs)object3).c(c2);
        Datasource datasource = databaseTables.getDatasource(this.getIndex());
        for (int i6 = 0; i6 < databaseTables.getDatasourceCount(); ++i6) {
            if (i6 == datasource.getIndex()) continue;
            Datasource datasource2 = databaseTables.getDatasource(i6);
            datasource2.iH();
            databaseTables.removeDatasource(datasource2);
            --i6;
        }
        g g2 = databaseTables.ik();
        for (int i7 = 0; i7 < g2.size(); ++i7) {
            if (((StringList)object2).contains(g2.ga(i7).getTargetAlias()) && ((StringList)object2).contains(g2.ga(i7).getSourceAlias())) continue;
            Join join = g2.ga(i7);
            StringList stringList = new StringList(join.getConditionCount());
            if (((StringList)object2).contains(g2.ga(i7).getTargetAlias())) {
                for (int i8 = 0; i8 < join.getConditionCount(); ++i8) {
                    stringList.addElement(join.getTargetAlias() + "." + join.getConditionTargetColumn(i8));
                }
            } else if (((StringList)object2).contains(g2.ga(i7).getSourceAlias())) {
                for (int i9 = 0; i9 < join.getConditionCount(); ++i9) {
                    stringList.addElement(join.getSourceAlias() + "." + join.getConditionSourceColumn(i9));
                }
            }
            Section section = engine.getArea(2).getSection(0);
            for (int i10 = 0; i10 < stringList.size(); ++i10) {
                section.addFieldElement(((Fields)object).getDatabaseField(stringList.elementAt(i10)), 1, 1, 1, 1);
            }
            g2.c(join);
            --i7;
        }
        return engine.getDatabaseTables().a(bl2, this);
    }

    int getIndex() {
        DatabaseTables databaseTables = this.ML.DE.rh();
        int n2 = databaseTables.getDatasourceCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (databaseTables.getDatasource(i2) != this) continue;
            return i2;
        }
        return 0;
    }

    boolean iM() {
        if (this.Om == null) {
            this.Oq = true;
        }
        return this.Oq;
    }

    public void addConnectionProperty(String string, String string2) {
        this.Oi.put(string, string2);
    }

    public void removeConnectionProperty(String string) {
        this.Oi.remove(string);
    }

    public Properties getConnectionProperties() {
        return (Properties)this.Oi.clone();
    }

    public void setDataSourceConfigurationName(String string) {
        this.g(string, false);
    }

    private void g(String string, boolean bl2) {
        if (string == null) {
            string = "";
        }
        if (DataSourceConfigurationManager.exists(string)) {
            this.a(DataSourceConfigurationManager.getDataSourceConfiguration(string, 3), bl2);
        } else {
            this.Oj = null;
        }
        this.Oi.put("datasource_name", string);
    }

    public void setDataSourceConfiguration(DataSourceConfiguration dataSourceConfiguration) {
        this.a(dataSourceConfiguration, false);
    }

    private void a(DataSourceConfiguration dataSourceConfiguration, boolean bl2) {
        block10: {
            String string;
            block9: {
                if (!bl2) {
                    this.Or = false;
                    this.Oo = false;
                    this.Op = false;
                    this.Oi.clear();
                }
                string = dataSourceConfiguration.getDatabaseClassname();
                String string2 = dataSourceConfiguration.getDriverClassname();
                try {
                    if (string2 != null && string2.trim().length() > 0) {
                        BaseUtils.classForName(string2);
                    }
                }
                catch (Throwable throwable) {
                    if (BaseUtils.isDebug()) {
                        BaseUtils.debug("load Driver class from DataSourceConfiguration failed.");
                    }
                    if (!BaseUtils.isDebug()) break block9;
                    BaseUtils.debug(throwable);
                }
            }
            try {
                Class clazz;
                this.Om = null;
                this.Oq = true;
                if (string.length() > 0 && DataFactory.class.isAssignableFrom(clazz = BaseUtils.classForName(string))) {
                    this.Om = (DataFactory)clazz.newInstance();
                    this.Oq = false;
                }
                if (this.Oq) {
                    this.Om = new Database();
                }
                this.Om.setConfiguration(dataSourceConfiguration.getDatabaseConfiguration());
            }
            catch (Throwable throwable) {
                if (!BaseUtils.isDebug()) break block10;
                BaseUtils.debug("load Database class from DataSourceConfiguration failed.");
                BaseUtils.debug(throwable);
            }
        }
        this.Oj = dataSourceConfiguration;
    }

    public boolean requestPasswordIfNeeded(Frame frame) {
        String string;
        boolean bl2;
        boolean bl3;
        String string2;
        DataSourceConfiguration dataSourceConfiguration = this.getDataSourceConfiguration();
        if (!this.Or) {
            this.setDataSourceConfiguration(dataSourceConfiguration);
            string2 = dataSourceConfiguration.getPassword();
            bl3 = dataSourceConfiguration.isSavePassword();
            bl2 = dataSourceConfiguration.isNeedPassword();
            string = dataSourceConfiguration.getConfigurationName();
        } else {
            string2 = this.getPassword();
            bl3 = this.ML.DE.rh().isSavePassword();
            bl2 = true;
            string = this.getDataSourceConfigurationName();
        }
        if ((string2 == null || string2.length() == 0) && !bl3 && bl2) {
            try {
                this.iF().close();
            }
            catch (Exception exception) {
                string2 = PasswordDialog.execute(frame, string);
                if (string2 != null) {
                    if (dataSourceConfiguration != null) {
                        dataSourceConfiguration.setPassword(string2);
                    }
                    this.setPassword(string2);
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    void R(boolean bl2) {
        this.Oo = bl2;
    }

    void S(boolean bl2) {
        this.Op = bl2;
    }

    public boolean isUsed() throws ReportException {
        for (TableSource tableSource : this.On) {
            if (!tableSource.isUsed()) continue;
            return true;
        }
        Fields fields = this.getEngine().getFields();
        for (int i2 = 0; i2 < fields.getSQLExpressionFieldsCount(); ++i2) {
            SQLField sQLField = fields.getSQLExpressionField(i2);
            if (sQLField.getDatasource() != this) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Datasource datasource = (Datasource)object;
        if (this.Oi.equals(datasource.Oi)) {
            if (this.Oj == null) {
                return datasource.Oj == null;
            }
            return this.Oj.equals(datasource.Oj);
        }
        return false;
    }
}

