/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.lib.list.ObjectList;
import com.inet.lib.list.StringList;
import com.inet.lib.util.DotNetUtils;
import com.inet.lib.util.IOFunctions;
import com.inet.report.Area;
import com.inet.report.BaseUtils;
import com.inet.report.CascadingValueProvider;
import com.inet.report.Database;
import com.inet.report.DatabaseCore;
import com.inet.report.DatabaseInformix;
import com.inet.report.DatabaseSetData;
import com.inet.report.DatabaseTables;
import com.inet.report.Datasource;
import com.inet.report.DefaultValue;
import com.inet.report.DynamicValueProvider;
import com.inet.report.Element;
import com.inet.report.EngineStatistics;
import com.inet.report.EngineStatus;
import com.inet.report.Field;
import com.inet.report.Fields;
import com.inet.report.FormulaField;
import com.inet.report.Group;
import com.inet.report.GroupField;
import com.inet.report.Join;
import com.inet.report.Prompt;
import com.inet.report.PromptField;
import com.inet.report.RDC;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.ReportProperties;
import com.inet.report.SQLField;
import com.inet.report.Section;
import com.inet.report.SortField;
import com.inet.report.Subreport;
import com.inet.report.SubreportLink;
import com.inet.report.SummaryField;
import com.inet.report.SummaryInfo;
import com.inet.report.TableSource;
import com.inet.report.TablesourceList;
import com.inet.report.Trigger;
import com.inet.report.ab;
import com.inet.report.ay;
import com.inet.report.bo;
import com.inet.report.bp;
import com.inet.report.bq;
import com.inet.report.bs;
import com.inet.report.cache.f;
import com.inet.report.cb;
import com.inet.report.cc;
import com.inet.report.ce;
import com.inet.report.cf;
import com.inet.report.cg;
import com.inet.report.ci;
import com.inet.report.ck;
import com.inet.report.cn;
import com.inet.report.co;
import com.inet.report.config.Configuration;
import com.inet.report.config.ConfigurationManager;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.config.datasource.DataSourceConfigurationManager;
import com.inet.report.config.font.v;
import com.inet.report.config.structure.model.ConfigKey;
import com.inet.report.cq;
import com.inet.report.cs;
import com.inet.report.cu;
import com.inet.report.database.DataFactory;
import com.inet.report.dw;
import com.inet.report.e;
import com.inet.report.event.ClippingListener;
import com.inet.report.event.EngineFinishEvent;
import com.inet.report.event.EngineFinishListener;
import com.inet.report.formula.Evaluable;
import com.inet.report.formula.FormulaException;
import com.inet.report.i18n.ErrorCode;
import com.inet.report.i18n.Msg;
import com.inet.report.list.d;
import com.inet.report.list.h;
import com.inet.report.parser.FatalParserException;
import com.inet.report.parser.NodeParser;
import com.inet.report.parser.RFReader;
import com.inet.report.parser.XMLTag;
import com.inet.report.permissions.PermissionChecker;
import com.inet.report.permissions.WebUserInfoFactory;
import com.inet.report.permissions.o;
import com.inet.report.renderer.base.i;
import com.inet.report.renderer.doc.controller.an;
import com.inet.report.translation.Translations;
import com.inet.report.util.Base64;
import com.inet.report.util.p;
import com.inet.report.util.q;
import com.inet.report.util.s;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

public class Engine
implements NodeParser,
Serializable {
    public static final String AREA_TYPE_REPORT_HEADER = "RH";
    public static final String AREA_TYPE_PAGE_HEADER = "PH";
    public static final String AREA_TYPE_GROUP_HEADER_PREFIX = "GH";
    public static final String AREA_TYPE_DETAIL = "D";
    public static final String AREA_TYPE_GROUP_FOOTER_PREFIX = "GF";
    public static final String AREA_TYPE_REPORT_FOOTER = "RF";
    public static final String AREA_TYPE_PAGE_FOOTER = "PF";
    private transient a Qy = new a(null);
    int Qz;
    protected int eC = -1;
    transient Throwable QA;
    private String QB;
    cc DE;
    h QC;
    boolean QD;
    private final boolean QE;
    boolean QF;
    private Properties QG;
    private boolean QH;
    final Object QI = new Integer(0);
    transient ArrayList<Exception> QJ;
    transient RDC.MsgListener QK;
    final String QL;
    public static final int REPORT_HEADER = 0;
    public static final int PAGE_HEADER = 1;
    public static final int DETAILS = 2;
    public static final int REPORT_FOOTER = 3;
    public static final int PAGE_FOOTER = 4;
    public static final String NO_EXPORT = "java";
    public static final String EXPORT_PDF = "pdf";
    public static final String EXPORT_RTF = "rtf";
    public static final String EXPORT_HTML = "htm";
    public static final String EXPORT_HTML_ZIP = "htm.zip";
    public static final String EXPORT_XLS = "xls";
    public static final String EXPORT_XML = "xml";
    public static final String EXPORT_TXT = "txt";
    public static final String EXPORT_CSV = "csv";
    public static final String EXPORT_PS = "ps";
    public static final String EXPORT_PS2 = "ps2";
    public static final String EXPORT_PS3 = "ps3";
    public static final String EXPORT_DATA = "data";
    public static final String EXPORT_SVG = "svg";
    public static final String EXPORT_JRA = "jra";
    public static final String EXPORT_JAR = "jar";
    public static final String EXPORT_PNG = "png";
    public static final String EXPORT_GIF = "gif";
    public static final String EXPORT_JPG = "jpg";
    public static final String EXPORT_JPEG = "jpeg";
    public static final String EXPORT_BMP = "bmp";
    public static final String EXPORT_ODS = "ods";
    private Hashtable QM;
    private static Map QN = Collections.synchronizedMap(new WeakHashMap());
    private static List QO;
    private transient ArrayList<EngineFinishListener> QP;
    private Properties QQ = new Properties();
    private Trigger QR;
    private final i QS;
    boolean QT = true;
    public static int LOG_STATUS;
    public static int LOG_ERROR;
    public static int LOG_WARN;
    public static int LOG_INFO;
    public static int LOG_DEBUG;
    int QU;
    int QV;
    @Deprecated
    HashMap QW = null;
    long time;
    private EngineStatus QX;
    private int QY = 0;
    private transient ArrayList QZ;

    @Deprecated
    public Engine() {
        this.initialize();
        QN.put(this, null);
        this.DE = new cg(this);
        this.QS = this.DE.ox();
        this.QL = NO_EXPORT;
        this.QE = false;
    }

    public Engine(String string) throws ReportException {
        String string2;
        this.initialize();
        this.QE = false;
        QN.put(this, null);
        if (string == null || string.length() == 0) {
            string = NO_EXPORT;
        }
        switch (string2 = string.toLowerCase()) {
            case "java": {
                this.DE = new cg(this);
                this.QL = NO_EXPORT;
                break;
            }
            case "pdf": 
            case "ods": 
            case "htm.zip": {
                this.DE = new an(string2);
                this.DE.setEngine(this);
                this.QL = string2;
                break;
            }
            case "ps": 
            case "ps2": 
            case "ps3": {
                this.DE = new an(string2);
                this.DE.setEngine(this);
                this.QL = EXPORT_PS;
                break;
            }
            case "rtf": {
                if ("false".equalsIgnoreCase(System.getProperty("export.new"))) {
                    this.DE = new an(EXPORT_RTF);
                    this.DE.setEngine(this);
                } else {
                    this.DE = new ci(this);
                }
                this.QL = EXPORT_RTF;
                break;
            }
            case "csv": 
            case "csv,": 
            case "csv;": {
                if (string2.length() > 3) {
                    String string3 = string2.substring(3, string2.length());
                    this.DE = new ce(this, string3);
                } else {
                    this.DE = new ce(this);
                }
                this.QL = EXPORT_CSV;
                break;
            }
            case "xls": {
                this.DE = new co(this);
                this.QL = EXPORT_XLS;
                break;
            }
            case "xml": {
                this.DE = new cq(this);
                this.QL = EXPORT_XML;
                break;
            }
            case "data": {
                this.DE = new cf(this);
                this.QL = EXPORT_DATA;
                break;
            }
            case "txt": {
                this.DE = new com.inet.report.renderer.txt.a(this);
                this.QL = EXPORT_TXT;
                break;
            }
            case "svg": {
                this.DE = new ck(this);
                this.QL = EXPORT_SVG;
                break;
            }
            case "png": 
            case "gif": 
            case "jpg": 
            case "bmp": {
                this.DE = new com.inet.report.renderer.image.a(this, string2);
                this.QL = string2;
                break;
            }
            case "jpeg": {
                this.DE = new com.inet.report.renderer.image.a(this, string2);
                this.QL = EXPORT_JPG;
                break;
            }
            default: {
                if (string2.startsWith(EXPORT_HTML)) {
                    String string4 = string.substring(3);
                    this.DE = new an(string2);
                    this.DE.setEngine(this);
                    this.QL = EXPORT_HTML + string4;
                    break;
                }
                throw ReportExceptionFactory.createReportException(ErrorCode.InvalidOutFmt, string);
            }
        }
        this.QS = this.DE.ox();
    }

    Engine(cc cc2) {
        String string;
        this.initialize();
        this.DE = cc2;
        this.QS = cc2.ox();
        try {
            string = this.getParent().QL;
        }
        catch (Throwable throwable) {
            string = null;
        }
        this.QL = string;
        this.QE = true;
    }

    private void initialize() {
        dw.sw();
        this.QX = new EngineStatus();
    }

    public static synchronized void shutdown() {
        dw.sv();
    }

    public int getRecordCount() {
        return this.eC;
    }

    public void setCachedPages(h h2) {
        if (h2 != null) {
            this.QC = h2;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.registerValidation(new ab(this), 0);
        objectInputStream.defaultReadObject();
    }

    private void iT() throws ReportException {
        if (this.DE == null || this.QD) {
            Object[] objectArray = new Object[]{};
            throw ReportExceptionFactory.createReportException(ErrorCode.EngineIsFinished, objectArray);
        }
    }

    void iU() throws ReportException {
        this.iT();
        if (this.QA != null) {
            ReportException reportException = ReportExceptionFactory.createReportExceptionWithCause(this.QA);
            BaseUtils.printStackTrace(reportException);
            throw reportException;
        }
        if (this.DE.Nv == null) {
            Object[] objectArray = new Object[]{};
            throw ReportExceptionFactory.createReportException(ErrorCode.NoRptFile, objectArray);
        }
    }

    static final Prompt[] t(cc cc2) {
        ResourceBundle resourceBundle = dw.Q(cc2);
        ArrayList<cc> arrayList = new ArrayList<cc>();
        arrayList.add(cc2);
        if (cc2.asi != null) {
            arrayList.addAll(cc2.asi);
        }
        ArrayList<Prompt> arrayList2 = new ArrayList<Prompt>();
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            cc cc3 = (cc)arrayList.get(i2);
            int n2 = cc3.rg().length;
            for (int i3 = 0; i3 < n2; ++i3) {
                PromptField promptField = cc3.rg()[i3];
                if (promptField.isSubreportLink()) continue;
                Prompt prompt = new Prompt();
                if (!promptField.isUsed()) {
                    prompt.notUsed = true;
                } else {
                    DynamicValueProvider dynamicValueProvider;
                    Datasource datasource;
                    DataFactory dataFactory;
                    int n3;
                    if (i2 > 0) {
                        prompt.setName("#" + i2 + "#" + promptField.name);
                        try {
                            prompt.setSubreportName(cc3.getEngine().getReportTitle());
                        }
                        catch (ReportException reportException) {
                            BaseUtils.printStackTrace(reportException);
                        }
                    } else {
                        prompt.setName(promptField.name);
                    }
                    if (resourceBundle != null) {
                        prompt.setDisplayName(dw.a(resourceBundle, promptField.name));
                        prompt.promptText = dw.a(resourceBundle, promptField.promptText);
                    } else {
                        prompt.setDisplayName(promptField.name);
                        prompt.promptText = promptField.promptText;
                    }
                    DefaultValue[] defaultValueArray = promptField.getDefaultValues();
                    if (defaultValueArray == null) {
                        defaultValueArray = new DefaultValue[]{};
                    }
                    Object[] objectArray = new Object[defaultValueArray.length];
                    String[] stringArray = new String[defaultValueArray.length];
                    for (n3 = 0; n3 < defaultValueArray.length; ++n3) {
                        objectArray[n3] = defaultValueArray[n3].getValue();
                        stringArray[n3] = defaultValueArray[n3].getDescription();
                    }
                    prompt.defaultValues = s.a(objectArray, promptField.valueType);
                    prompt.descs = stringArray;
                    if (promptField.value != null) {
                        prompt.value = s.i(promptField.value, promptField.valueType);
                    }
                    if (promptField.acN != null && promptField.getUseRange()) {
                        prompt.minValue = s.i(promptField.acN, promptField.valueType);
                    }
                    if (promptField.acO != null && promptField.getUseRange()) {
                        prompt.maxValue = s.i(promptField.acO, promptField.valueType);
                    }
                    prompt.valueType = promptField.valueType;
                    prompt.valueTypeNewProt = promptField.valueType % 128;
                    prompt.multi = promptField.acL;
                    prompt.discrete = promptField.acM % 2 == 0;
                    prompt.range = promptField.acM > 0;
                    prompt.editMask = promptField.isPasswordField() ? "password" : "";
                    prompt.isEditable = promptField.isEditable();
                    prompt.onlyDescs = promptField.isDescriptionOnly();
                    if (promptField.acK != null && (dataFactory = (datasource = promptField.acK.getDatasource()).getDataFactory()) instanceof DatabaseInformix) {
                        prompt.informixPrompt = true;
                    }
                    if (resourceBundle != null) {
                        prompt.promptText = dw.a(resourceBundle, prompt.promptText);
                        stringArray = prompt.descs;
                        for (n3 = 0; n3 < stringArray.length; ++n3) {
                            if (stringArray[n3] == null) continue;
                            stringArray[n3] = dw.a(resourceBundle, stringArray[n3]);
                        }
                    }
                    if ((dynamicValueProvider = promptField.getDefaultValueProvider()) instanceof CascadingValueProvider) {
                        prompt.setCascadingParent(((CascadingValueProvider)dynamicValueProvider).getParent().getName());
                    }
                }
                arrayList2.add(prompt);
            }
        }
        Prompt[] promptArray = new Prompt[arrayList2.size()];
        for (int i4 = 0; i4 < arrayList2.size(); ++i4) {
            promptArray[i4] = (Prompt)arrayList2.get(i4);
        }
        return promptArray;
    }

    public static String getCreator() {
        return cs.asn;
    }

    public static void setCreator(String string) {
        if (string == null) {
            throw new NullPointerException("The creator specified with setCreator is null.");
        }
        cs.asn = string;
    }

    public void setLocale(@Nonnull Locale locale) throws ReportException {
        String string;
        this.iU();
        if (BaseUtils.isInfo()) {
            BaseUtils.info("Set locale: " + locale);
        }
        if (locale != null && BaseUtils.gk() && (string = p.C(locale)) != null) {
            BaseUtils.warning("setLocale: " + string);
        }
        this.a(locale, locale);
    }

    public void setClientLocale(@Nonnull Locale locale) throws ReportException {
        String string;
        this.iU();
        if (BaseUtils.isInfo()) {
            BaseUtils.info("Set client locale: " + locale);
        }
        if (locale != null && BaseUtils.gk() && (string = p.C(locale)) != null) {
            BaseUtils.warning("setClientLocale: " + string);
        }
        this.a(locale, new Locale(locale.getLanguage(), this.DE.asx.getCountry(), locale.getVariant()));
    }

    private void a(@Nonnull Locale locale, @Nonnull Locale locale2) throws ReportException {
        if (locale == null || locale2 == null) {
            throw new IllegalArgumentException("locale is null");
        }
        try {
            this.DE.asy = locale;
            this.DE.asz = locale2;
            com.inet.report.statistic.a.z(locale2);
            if (this.DE.asi != null) {
                for (int i2 = 0; i2 < this.DE.asi.size(); ++i2) {
                    cc cc2 = (cc)this.DE.asi.get(i2);
                    cc2.asy = locale;
                    cc2.asz = locale2;
                }
            }
        }
        catch (Throwable throwable) {
            BaseUtils.info("Could not set the locale: " + locale);
            BaseUtils.printStackTrace(throwable);
            throw ReportExceptionFactory.createReportExceptionWithCause(throwable);
        }
    }

    public Locale getLocale() throws ReportException {
        this.iU();
        return this.DE.asy;
    }

    public void setNumeralLanguage(int n2) throws ReportException {
        this.iU();
        this.DE.setNumeralLanguage(n2);
    }

    public int getNumeralLanguage() throws ReportException {
        this.iU();
        return this.DE.getNumeralLanguage();
    }

    public void setUserProperties(Properties properties) throws ReportException {
        this.iT();
        if (this.DE != null && this.DE.id != 0) {
            this.getParent().setUserProperties(properties);
        }
        this.QG = properties;
    }

    public Properties getUserProperties() throws ReportException {
        this.iT();
        if (this.DE != null && this.DE.id != 0) {
            return this.getParent().getUserProperties();
        }
        return this.QG;
    }

    public Hashtable getUserData() {
        return this.QM;
    }

    public void setUserData(Hashtable hashtable) {
        this.QM = hashtable;
    }

    public Engine getParent() throws ReportException {
        this.iU();
        return this.DE.oi() != null ? ((cs)this.DE.oi()).getEngine() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws ReportException {
        dw.sw();
        if (this.QF) {
            Object[] objectArray = new Object[]{};
            throw ReportExceptionFactory.createReportException(ErrorCode.EngineExecuting, objectArray);
        }
        this.QF = true;
        try {
            ay ay2 = ay.kE();
            BaseUtils.info(ay2.kO() + " - " + ay2.getLicenseText());
            Configuration configuration = ConfigurationManager.getInstance().getCurrent();
            String string = ConfigurationManager.getScopeName(configuration.getScope());
            String string2 = configuration.getName();
            if (!ay2.aU(0)) {
                ay.ac(false);
                Object[] objectArray = new Object[]{ay2.getLicenseText()};
                throw ReportExceptionFactory.createReportException(ErrorCode.LicenseInvalid, objectArray);
            }
            if (!ay2.aV(0)) {
                ay.ac(false);
                Object[] objectArray = new Object[]{string, string2, BaseUtils.getVersion()};
                throw ReportExceptionFactory.createReportException(ErrorCode.LicenseInvalidVersion, objectArray);
            }
            if (ay2.a((short)0)) {
                ay.ac(false);
                Object[] objectArray = new Object[]{string, string2, ay2.ab(false)};
                throw ReportExceptionFactory.createReportException(ErrorCode.LicenseExpired, objectArray);
            }
            if (ay2.kJ()) {
                ay.ac(false);
                Object[] objectArray = new Object[]{string, string2};
                throw ReportExceptionFactory.createReportException(ErrorCode.LicenseInvalidIP, objectArray);
            }
            if (!ay2.isValidCPUCount()) {
                ay.ac(false);
                Object[] objectArray = new Object[]{string, string2, new Integer(ay2.kL()), new Integer(ay2.kK())};
                throw ReportExceptionFactory.createReportException(ErrorCode.LicenseInvalidCPUcount, objectArray);
            }
            this.iU();
            if (com.inet.report.util.i.Zg() && !this.DE.isOnDemand()) {
                com.inet.report.util.i.a(this.QG, this.DE);
                com.inet.report.util.i.e(this, "");
            } else if ((dw.sA() & 3) != 0) {
                return;
            }
            if (!"repo".equals(this.getReportFile().getProtocol())) {
                PermissionChecker.checkExecuteRight(WebUserInfoFactory.getSessionWebUserInfo(), this.getReportFile());
            }
            this.iY();
            cn.L(this.DE);
            cn.a(this.DE, this.QG, true);
            if (this.DE.rh().il()) {
                Object[] objectArray = new Object[]{this.QW.get(new Integer(this.DE.id))};
                throw ReportExceptionFactory.createReportException(ErrorCode.QueryFileNotFound, objectArray);
            }
            if (this.DE.rb() == null) {
                this.DE.b(new Date());
            }
            try {
                this.q(this);
                int n2 = this.getSubReportCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Engine engine = this.getSubReport(i2);
                    this.q(engine);
                }
            }
            catch (Exception exception) {
                BaseUtils.printStackTrace(exception);
            }
            try {
                com.inet.report.statistic.a.YF();
                this.DE.nm();
            }
            finally {
                com.inet.report.statistic.a.YG();
            }
            this.QS.JY();
        }
        catch (Throwable throwable) {
            if (this.QA == null) {
                this.QA = throwable;
            }
            try {
                this.DE.nz();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            this.finish();
            this.setErrorMsg(dw.j(this.QA));
            throw ReportExceptionFactory.createReportExceptionWithCause(throwable);
        }
    }

    private void q(Engine engine) throws Exception {
        DatabaseTables databaseTables = engine.DE.rh();
        int n2 = databaseTables.getDatasourceCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Datasource datasource = databaseTables.getDatasource(i2);
            if (datasource.hasValidConnection()) continue;
            bs.a(datasource, engine.DE);
        }
    }

    public synchronized byte[] getPageData(int n2) throws ReportException {
        if (n2 < 1) {
            throw new IllegalArgumentException("invalid page number: " + n2);
        }
        while (!this.QD && this.DE != null && (this.QC == null || n2 >= this.QC.getPageCount() || this.DE.om())) {
            this.iV();
        }
        if (this.QA != null) {
            ReportException reportException = ReportExceptionFactory.createReportExceptionWithCause(this.QA);
            BaseUtils.printStackTrace(reportException);
            throw reportException;
        }
        if (n2 > this.QC.getPageCount()) {
            return null;
        }
        return this.QC.getPageData(n2);
    }

    public synchronized byte[] getFontData(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("invalid font ID: " + n2);
        }
        if (this.QC == null || this.QC.getFontCount() == 0) {
            return null;
        }
        if (n2 > this.QC.getFontCount()) {
            return this.QC.getFontData(this.QC.getFontCount() - 1);
        }
        return this.QC.getFontData(n2 - 1);
    }

    public boolean isFinish() {
        return this.QD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finish() {
        if (this.DE == null) {
            return;
        }
        long l2 = this.QS.getTotalSystemTime() / 1000000L;
        URL uRL = this.DE.Nv;
        if (uRL != null) {
            BaseUtils.status("Rendered report " + uRL.getFile() + " in " + l2 + "ms.");
        }
        this.DE = null;
        this.QD = true;
        Object object = this.QI;
        synchronized (object) {
            this.QI.notifyAll();
        }
        this.a(uRL, l2);
        if (BaseUtils.isDebug()) {
            BaseUtils.debug(this.QS);
        }
    }

    private void iV() throws ReportException {
        if (!this.QF) {
            throw ReportExceptionFactory.createReportException(ErrorCode.EngineNotExecuted, new Object[0]);
        }
        try {
            this.wait(f.ut());
        }
        catch (InterruptedException interruptedException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(interruptedException);
        }
    }

    public synchronized int getPageCount() throws ReportException {
        while (!this.QD && this.DE != null) {
            this.iV();
        }
        if (this.QA != null) {
            ReportException reportException = ReportExceptionFactory.createReportExceptionWithCause(this.QA);
            BaseUtils.printStackTrace(reportException);
            throw reportException;
        }
        if (this.QC == null) {
            return 0;
        }
        return this.QC.getPageCount();
    }

    public synchronized int getDocumentPageCount() throws ReportException {
        while (!this.QD && this.DE != null) {
            this.iV();
        }
        if (this.QA != null) {
            ReportException reportException = ReportExceptionFactory.createReportExceptionWithCause(this.QA);
            BaseUtils.printStackTrace(reportException);
            throw reportException;
        }
        return this.Qz;
    }

    public void setCatalog(String string) throws ReportException {
        this.iU();
        try {
            if (string != null && string.length() == 0) {
                string = null;
            }
            this.DE.rh().getDatasource(0).setCatalog(string);
            if (this.DE.asi != null) {
                for (int i2 = 0; i2 < this.DE.asi.size(); ++i2) {
                    ((cc)this.DE.asi.get(i2)).rh().getDatasource(0).setCatalog(string);
                }
            }
        }
        catch (Throwable throwable) {
            throw ReportExceptionFactory.createReportExceptionWithCause(throwable);
        }
    }

    public void setSchema(String string) throws ReportException {
        this.iU();
        try {
            if (string != null && string.length() == 0) {
                string = null;
            }
            this.DE.rh().getDatasource(0).setSchema(string);
            if (this.DE.asi != null) {
                for (int i2 = 0; i2 < this.DE.asi.size(); ++i2) {
                    ((cc)this.DE.asi.get(i2)).rh().getDatasource(0).setSchema(string);
                }
            }
        }
        catch (Throwable throwable) {
            throw ReportExceptionFactory.createReportExceptionWithCause(throwable);
        }
    }

    public void setData(String[] stringArray, Object[][] objectArray, boolean bl2) throws ReportException {
        this.iU();
        BaseUtils.info("[Engine.setData] with array and long column name for id: " + this.DE.id);
        if (stringArray == null) {
            this.iW();
        } else {
            block0: for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string = stringArray[i2];
                if (string.indexOf(".") >= 0) continue;
                string = "." + string;
                for (int i3 = 0; i3 < this.DE.ri().size(); ++i3) {
                    String string2 = this.DE.ri().fQ((int)i3).name;
                    if (!string2.endsWith(string)) continue;
                    stringArray[i2] = string2;
                    continue block0;
                }
            }
            this.setData(stringArray, objectArray);
        }
    }

    public void setData(Vector vector, Vector vector2, boolean bl2) throws ReportException {
        this.iU();
        BaseUtils.info("[Engine.setData] with Vector for id: " + this.DE.id);
        if (vector == null) {
            this.iW();
        } else {
            if (vector2 == null) {
                BaseUtils.warning("[Engine.setData] Vector 'data' is null.");
                vector2 = new Vector();
            }
            try {
                String[] stringArray = new String[vector.size()];
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    stringArray[i2] = String.valueOf(vector.elementAt(i2));
                }
                Object[][] objectArray = new Object[vector2.size()][];
                for (int i3 = 0; i3 < objectArray.length; ++i3) {
                    Object e2 = vector2.elementAt(i3);
                    if (e2 instanceof Vector) {
                        objectArray[i3] = ((Vector)e2).toArray();
                        continue;
                    }
                    if (e2 instanceof ObjectList) {
                        objectArray[i3] = ((ObjectList)e2).toArray();
                        continue;
                    }
                    if (!(e2 instanceof Object[])) continue;
                    objectArray[i3] = (Object[])e2;
                }
                this.setData(stringArray, objectArray, bl2);
            }
            catch (RuntimeException runtimeException) {
                BaseUtils.printStackTrace(runtimeException);
                throw runtimeException;
            }
        }
    }

    public void setData(String[] stringArray, Object[][] objectArray) throws ReportException {
        this.iU();
        BaseUtils.info("[Engine.setData] with array for id: " + this.DE.id);
        cu cu2 = this.DE.op();
        cu2.aH(true);
        if (stringArray == null) {
            this.iW();
        } else {
            this.DE.op().setColumns(stringArray);
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("[Engine.setData] number of Fields: " + stringArray.length);
            }
            if (objectArray != null) {
                if (BaseUtils.isDebug()) {
                    int n2 = objectArray.length;
                    int n3 = 0;
                    if (n2 > 0 && objectArray[0] != null) {
                        n3 = objectArray[0].length;
                    }
                    BaseUtils.debug("[Engine.setData] data array with " + n3 + " columns and " + n2 + " rows.");
                }
                if (DotNetUtils.isDotNet()) {
                    this.b(objectArray);
                }
                cu2.b(new com.inet.report.rowsource.a((Object[][])objectArray.clone(), cu2));
            } else {
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug("[Engine.setData] array 'data' is null");
                }
                cu2.b(new com.inet.report.rowsource.a(new Object[0][], cu2));
            }
            cu2.a(cu2.rq());
            if (com.inet.report.util.i.Zg()) {
                DatabaseCore.o(this.DE);
            }
        }
    }

    private void b(Object[][] objectArray) {
        Class<?> clazz;
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[Engine.setData] converting data from .NET to Java...");
        }
        try {
            clazz = Class.forName("sun.jdbc.odbc.JdbcOdbcUtils");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
        try {
            Method method = clazz.getMethod("convertNet2Java", Object.class);
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Object[] objectArray2 = objectArray[i2];
                for (int i3 = 0; i3 < objectArray2.length; ++i3) {
                    Object object = objectArray2[i3];
                    try {
                        objectArray2[i3] = method.invoke(null, object);
                        continue;
                    }
                    catch (Exception exception) {
                        BaseUtils.printStackTrace(exception);
                    }
                }
            }
        }
        catch (Exception exception) {
            BaseUtils.printStackTrace(exception);
        }
    }

    private void iW() throws ReportException {
        BaseUtils.warning("[Engine.setData] ReportID: " + this.DE.id + ". Array of columns is null.");
        String[] stringArray = new String[this.DE.ri().size() + this.DE.arX.length];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.DE.ri().size()) {
            stringArray[n2] = this.DE.ri().fQ(n3).getName();
            ++n3;
            ++n2;
        }
        n3 = 0;
        while (n3 < this.DE.arX.length) {
            stringArray[n2] = this.DE.arX[n3].getName();
            ++n3;
            ++n2;
        }
        this.setData(stringArray, (Object[][])null);
    }

    public void setConnection(Connection connection) throws ReportException {
        this.iT();
        this.a(connection, this.DE.rh().getDatasource(0));
    }

    public void setConnectionCloseOnFinishing(boolean bl2) {
        this.QT = bl2;
    }

    void a(Connection connection, Datasource datasource) throws ReportException {
        BaseUtils.info("set connection " + connection);
        this.iU();
        if (connection != null) {
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                Database.a(databaseMetaData, false, true);
            }
            catch (SQLException sQLException) {
                throw ReportExceptionFactory.createReportExceptionWithCause(sQLException);
            }
            datasource.setConnection(connection);
        }
        datasource.setCatalog(null);
        datasource.R(false);
    }

    public void stopAfterPage(int n2) {
        cc cc2 = this.DE;
        if (cc2 != null) {
            if (n2 <= 0) {
                n2 = 0;
            }
            cc2.asm = n2;
        }
    }

    public void stop() {
        this.stop("API call Engine.stop()");
    }

    public void stop(String string) {
        block11: {
            try {
                Object object;
                cc cc2 = this.DE;
                h h2 = this.QC;
                if (cc2 != null) {
                    if ((h2 == null || h2.getPageCount() <= 0) && cc2.QA == null) {
                        object = new Object[]{string};
                        cc2.QA = ReportExceptionFactory.createReportException(ErrorCode.stopped, (Object[])object);
                    }
                    cc2.nq();
                }
                if (h2 != null) {
                    h2.stop();
                }
                if (cc2 != null) {
                    if (BaseUtils.isDebug()) {
                        if (string == null || string.trim().length() == 0) {
                            BaseUtils.debug(new Throwable("stop engine " + this));
                        } else {
                            BaseUtils.debug("stop engine " + this + " because: " + string);
                        }
                    }
                    cc2.asm = -1;
                    this.u(cc2);
                    object = cc2.asi;
                    if (object != null) {
                        for (int i2 = 0; i2 < ((ArrayList)object).size(); ++i2) {
                            cc cc3 = (cc)((ArrayList)object).get(i2);
                            cc3.asm = -1;
                            this.u(cc3);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                if (!BaseUtils.isDebug()) break block11;
                BaseUtils.debug(throwable);
            }
        }
    }

    public boolean isPageLimitExceeded() {
        return this.QC != null && this.QC.isPageLimitExceeded();
    }

    public static void stopAll() {
        for (Engine engine : QN.keySet()) {
            if (engine == null) continue;
            engine.stop("API call Engine.stopAll()");
        }
    }

    private void u(cc cc2) {
        block4: {
            Statement statement = cc2.agf;
            if (statement != null) {
                try {
                    if (BaseUtils.isDebug()) {
                        BaseUtils.debug("cancel " + statement.toString());
                    }
                    statement.cancel();
                    statement.close();
                }
                catch (Throwable throwable) {
                    if (!BaseUtils.isDebug()) break block4;
                    BaseUtils.debug(throwable);
                }
            }
        }
    }

    public void setData(ResultSet resultSet) throws NullPointerException, SQLException, ReportException {
        this.iU();
        BaseUtils.info("[Engine.setData] with ResultSet for report id: " + this.DE.id);
        if (resultSet == null) {
            BaseUtils.warning("[Engine.setData] The ResultSet that was specified with setData is null.");
            this.iW();
        } else {
            Database database = this.DE.rh().getDatasource(0).P(false);
            boolean bl2 = !this.DE.ra() && !database.getReportDataPerInstance();
            this.DE.op().aH(bl2);
            if (bl2) {
                this.DE.rh().M(true);
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug("We will filter the result-set multiple times.  Please note that this may be inefficient; please consider overriding the database callback getReportDataPerInstance() to return true");
                }
            }
            database.a(resultSet, this.DE);
        }
    }

    private DatabaseSetData ao(String string) throws ReportException {
        DatabaseTables databaseTables = this.DE.rh();
        int n2 = databaseTables.getDatasourceCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Datasource datasource = databaseTables.getDatasource(i2);
            TableSource tableSource = datasource.getTableSourceIfExist(string);
            if (tableSource == null) continue;
            Database database = datasource.getDatabase();
            if (!(database instanceof DatabaseSetData)) {
                database = new DatabaseSetData();
                datasource.setDatabase(database);
            }
            return (DatabaseSetData)database;
        }
        databaseTables.getDatasource(0).getTableSource(string);
        return null;
    }

    public void setData(String string, ResultSet resultSet) throws ReportException {
        this.ao(string).setData(string, resultSet);
    }

    public void setData(String string, String[] stringArray, Object[][] objectArray) throws ReportException {
        this.ao(string).setData(string, stringArray, objectArray);
    }

    public static void setLogStream(PrintStream printStream) {
        BaseUtils.setLogStream(printStream);
        if (dw.j(ConfigKey.LOG_DRIVER.getKey(), Boolean.parseBoolean(ConfigKey.LOG_DRIVER.getDefault()))) {
            DriverManager.setLogStream(printStream);
        }
        if (BaseUtils.getLogStream() != printStream) {
            BaseUtils.setLogStream(printStream);
        }
    }

    public static void setLogLevel(int n2) {
        BaseUtils.setLogLevel(n2);
    }

    public static PrintStream getLogStream() {
        return BaseUtils.getLogStream();
    }

    public static int getLogLevel() {
        return BaseUtils.getLogLevel();
    }

    public void setGF(String string) throws ReportException {
        this.iU();
        BaseUtils.info("Set GF: " + string);
        if (this.DE.rk() != null) {
            this.DE.rk().resetReferences();
        }
        this.DE.h(new FormulaField(this.DE));
        this.DE.rk().Ug = 2;
        this.DE.rk().setFormula(string);
        if (this.DE.rk() != null) {
            this.DE.rk().setReferences();
        }
    }

    public String getGF() throws ReportException {
        this.iU();
        if (this.DE.rk() == null) {
            return null;
        }
        return this.DE.rk().getFormula();
    }

    public FormulaField getGFField() throws ReportException {
        this.iU();
        return this.DE.rk();
    }

    public void setSF(String string) throws ReportException {
        this.iU();
        BaseUtils.info("Set SF: " + string);
        if (this.DE.rj() != null) {
            this.DE.rj().resetReferences();
        }
        this.DE.g(new FormulaField(this.DE));
        this.DE.rj().Ug = 1;
        this.DE.rj().setFormula(string);
        this.DE.rj().name = "Record_Selection";
    }

    public String getSF() throws ReportException {
        this.iU();
        if (this.DE.rj() == null) {
            return null;
        }
        return this.DE.rj().getFormula();
    }

    public FormulaField getSFField() throws ReportException {
        this.iU();
        return this.DE.rj();
    }

    public void setPrompt(String string, int n2) throws ReportException {
        this.iU();
        BaseUtils.info("Set Prompt[" + n2 + "]: " + string);
        if (n2 < 0) {
            BaseUtils.info("Prompt Index out of range");
            return;
        }
        cc cc2 = this.DE;
        int n3 = 0;
        while (n2 >= cc2.rg().length && this.DE.asi != null) {
            n2 -= cc2.rg().length;
            cc2 = null;
            if (this.DE.asi.size() <= n3) break;
            cc2 = (cc)this.DE.asi.get(n3++);
        }
        if (cc2 == null || n2 >= cc2.rg().length) {
            BaseUtils.info("Prompt Index out of range");
            return;
        }
        PromptField promptField = cc2.rg()[n2];
        if (promptField == null) {
            throw new IllegalStateException("No PromptField for " + string + " at r.prompts[" + n2 + "]");
        }
        this.a(promptField, string);
    }

    public void setPrompt(String string, String string2) throws ReportException {
        this.iU();
        cc cc2 = this.DE;
        if (string == null) {
            return;
        }
        BaseUtils.info("Set Prompt[" + string + "]: " + string2);
        PromptField promptField = cc2.bo(string);
        if (promptField != null) {
            this.a(promptField, string2);
        } else {
            BaseUtils.warning("prompt could not be found!");
        }
    }

    void a(PromptField promptField, String string) throws ReportException {
        String string2;
        if (string == null) {
            string = "";
        }
        if (!(string2 = string.trim()).toUpperCase().startsWith("FORMULA:") && promptField.acL && string2.length() > 0) {
            if (string2.charAt(0) != '[' || string2.charAt(string2.length() - 1) != ']') {
                if (promptField.valueType == 11 && string2.charAt(0) != '\"' && string2.charAt(0) != '\'') {
                    string2 = "\"" + string2 + "\"";
                }
                string = "[" + string2 + "]";
            }
        } else if (string2.length() > 1 && (string2.charAt(0) == '\"' && string2.charAt(string2.length() - 1) == '\"' || string2.charAt(0) == '\'' && string2.charAt(string2.length() - 1) == '\'')) {
            string = string2.substring(1, string2.length() - 1);
        }
        try {
            Object[] objectArray;
            int n2 = promptField.valueType;
            Object object = null;
            boolean bl2 = false;
            if (string.toUpperCase().startsWith("FORMULA:")) {
                bl2 = true;
                string = string.substring(8);
            }
            if (n2 == 14) {
                object = Base64.decode(string);
            } else if (n2 != 11 || promptField.acL || bl2) {
                objectArray = this.DE.ks().a(string, false, 0, 0, null, null);
                objectArray.di("ProfilePrompt");
                try {
                    objectArray.parse();
                    object = objectArray.eval();
                }
                catch (FormulaException formulaException) {
                    BaseUtils.printStackTrace(formulaException);
                    throw ReportExceptionFactory.createReportException(ErrorCode.InvalidPromptValue, string, promptField.getName());
                }
            } else {
                object = string;
            }
            promptField.a(object instanceof Evaluable ? (Evaluable)object : null);
            promptField.value = object;
            if (promptField.getValue() != null) {
                if (promptField.acL) {
                    if (!(promptField.getValue() instanceof Object[])) {
                        objectArray = new Object[]{promptField.getValue()};
                        promptField.value = objectArray;
                    }
                    for (int i2 = 0; i2 < ((Object[])promptField.getValue()).length; ++i2) {
                        object = ((Object[])promptField.getValue())[i2];
                        if (n2 == 15 && object instanceof java.sql.Date) {
                            object = new Timestamp(((java.sql.Date)object).getTime());
                            ((Object[])promptField.getValue())[i2] = object;
                        }
                        if (n2 == 11) {
                            object = String.valueOf(object);
                        }
                        PromptField.a(object, n2, promptField.name, promptField.jv());
                    }
                } else {
                    if (n2 == 15 && promptField.getValue() instanceof java.sql.Date) {
                        object = new Timestamp(((java.sql.Date)promptField.getValue()).getTime());
                        promptField.value = object;
                    }
                    if (n2 == 11) {
                        promptField.value = String.valueOf(promptField.getValue());
                    }
                    PromptField.a(promptField.getValue(), n2, promptField.name, promptField.jv());
                }
            }
            promptField.acF = true;
        }
        catch (Throwable throwable) {
            if (promptField != null) {
                promptField.value = null;
                promptField.acF = false;
            }
            throw ReportExceptionFactory.createReportExceptionWithCause(throwable);
        }
    }

    public void setPrompts(Vector vector) throws ReportException {
        this.iU();
        BaseUtils.info("Set Prompts: " + vector);
        if (this.DE.rg() == null) {
            this.DE.b(new PromptField[0]);
        }
        for (int i2 = 0; i2 < this.DE.rg().length; ++i2) {
            if (vector.size() <= i2) continue;
            PromptField promptField = this.DE.rg()[i2];
            this.a(promptField, (String)vector.elementAt(i2));
        }
    }

    public Object getPrompt(int n2) throws ReportException {
        this.iU();
        if (this.DE.rg() == null || this.DE.rg().length <= n2 || n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.DE.rg()[n2].getValue();
    }

    public Vector getPrompts() throws ReportException {
        this.iU();
        if (this.DE.rg() == null) {
            return new Vector();
        }
        Vector<Object> vector = new Vector<Object>();
        for (int i2 = 0; i2 < this.DE.rg().length; ++i2) {
            PromptField promptField = this.DE.rg()[i2];
            vector.addElement(promptField.getValue());
        }
        return vector;
    }

    public void setSproc(String string, int n2) throws ReportException {
        this.iU();
        try {
            int n3;
            BaseUtils.info("Set Sproc " + n2 + ':' + string);
            if (n2 < 0) {
                BaseUtils.info("Sproc Index out of range");
                return;
            }
            if (this.DE.rh().is() == null) {
                this.DE.rh().a(new StringList());
            }
            if (this.DE.rh().is().size() <= n2) {
                this.DE.rh().is().setSize(n2 + 1);
            }
            this.DE.rh().is().setElementAt(string, n2);
            cc cc2 = this.DE;
            int n4 = 0;
            for (n3 = 0; n3 < cc2.rg().length; ++n3) {
                if (cc2.rg()[n3].acJ == null) continue;
                if (n4 == n2) {
                    this.a(cc2.rg()[n3], string);
                    return;
                }
                ++n4;
            }
            for (n3 = 0; this.DE.asi != null && n3 < this.DE.asi.size(); ++n3) {
                cc cc3 = (cc)this.DE.asi.get(n3);
                for (int i2 = 0; i2 < cc3.rg().length; ++i2) {
                    if (cc3.rg()[i2].acJ == null) continue;
                    if (n4 == n2) {
                        this.a(this.DE.rg()[i2], string);
                        return;
                    }
                    ++n4;
                }
            }
            BaseUtils.info("Sproc Index out of range");
            return;
        }
        catch (Throwable throwable) {
            throw ReportExceptionFactory.createReportExceptionWithCause(throwable);
        }
    }

    @Deprecated
    public void setSprocs(Vector vector) throws ReportException {
        this.iU();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            this.setSproc(String.valueOf(vector.elementAt(i2)), i2);
        }
    }

    @Deprecated
    public String getSproc(int n2) throws ReportException {
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        this.iU();
        Datasource datasource = this.DE.rh().getDatasource(0);
        if (datasource.getTableSourceCount() == 0) {
            return null;
        }
        TableSource tableSource = datasource.getTableSource(0);
        String[] stringArray = tableSource.sr();
        if (stringArray == null) {
            throw new ArrayIndexOutOfBoundsException("there are nor input parameters defined for TablesSource " + tableSource.getAlias());
        }
        if (stringArray.length > n2) {
            for (int i2 = 0; i2 < this.DE.rg().length; ++i2) {
                if (!stringArray[n2].equals(this.DE.rg()[i2].acJ)) continue;
                return this.DE.rg()[i2].value.toString();
            }
            throw new ReportException("sproc index matches the input parameter " + stringArray[n2] + ". But there is no PromptField referencing on it.", 1111);
        }
        throw new ArrayIndexOutOfBoundsException("Set index=" + n2 + ". TableSource " + tableSource.getAlias() + " has only " + stringArray.length + " input parameter");
    }

    @Deprecated
    public Vector getSprocs() throws ReportException {
        this.iU();
        Datasource datasource = this.DE.rh().getDatasource(0);
        if (datasource.getTableSourceCount() == 0) {
            return new Vector();
        }
        TableSource tableSource = datasource.getTableSource(0);
        if (tableSource.sr() == null) {
            return new Vector();
        }
        String[] stringArray = tableSource.sr();
        Vector<Object> vector = new Vector<Object>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            for (int i3 = 0; i3 < this.DE.rg().length; ++i3) {
                if (!this.DE.rg()[i3].equals(stringArray[i2])) continue;
                vector.add(this.DE.rg()[i3].value);
                break;
            }
            vector.add(null);
        }
        return vector;
    }

    public void setSql(String string) throws ReportException {
        DatabaseTables databaseTables = this.getDatabaseTables();
        databaseTables.a(string, this.iX(), databaseTables.getDatasource(0), true);
    }

    public void setSqlIgnoreMetaData(String string) throws ReportException {
        DatabaseTables databaseTables = this.getDatabaseTables();
        databaseTables.a(string, this.iX(), databaseTables.getDatasource(0), false);
    }

    private String iX() throws ReportException {
        String string;
        String string2 = string = "Query";
        int n2 = 1;
        boolean bl2 = true;
        DatabaseTables databaseTables = this.getDatabaseTables();
        if (databaseTables != null) {
            while (bl2) {
                StringList stringList = new StringList();
                int n3 = databaseTables.getDatasourceCount();
                for (int i2 = 0; i2 < n3; ++i2) {
                    Datasource datasource = databaseTables.getDatasource(i2);
                    for (int i3 = 0; i3 < datasource.getTableSourceCount(); ++i3) {
                        stringList.addElement(datasource.getTableSource(i3).getAlias());
                    }
                }
                if (stringList.containsIgnoreCase(string2)) {
                    string2 = string + "_" + n2++;
                    continue;
                }
                bl2 = false;
            }
        }
        return string2;
    }

    public void setSql(String string, boolean bl2) throws ReportException {
        DatabaseTables databaseTables = this.getDatabaseTables();
        databaseTables.a(string, "Query", databaseTables.getDatasource(0), true);
    }

    @Deprecated
    public String getDefaultSql() throws ReportException {
        DatabaseTables databaseTables = this.getDatabaseTables();
        return databaseTables.a(false, databaseTables.getDatasource(0));
    }

    public String[] getDefaultSqlOfAllStatements(boolean bl2) throws ReportException {
        this.iT();
        DatabaseTables databaseTables = this.getDatabaseTables();
        String[] stringArray = null;
        try {
            stringArray = databaseTables.iw();
        }
        catch (ReportException reportException) {
            BaseUtils.error("Connection refused.");
            BaseUtils.error(reportException);
        }
        if (stringArray != null && stringArray.length > 0) {
            return stringArray;
        }
        StringList stringList = new StringList();
        for (int i2 = 0; i2 < databaseTables.getDatasourceCount(); ++i2) {
            Datasource datasource = databaseTables.getDatasource(i2);
            stringList.addElement(databaseTables.a(bl2, datasource));
        }
        return stringList.toArray();
    }

    public void setUser(String string) throws ReportException {
        this.iU();
        BaseUtils.info("Set User: " + string);
        this.DE.rh().getDatasource(0).setUsername(string);
        if (this.DE.asi != null) {
            for (int i2 = 0; i2 < this.DE.asi.size(); ++i2) {
                ((cc)this.DE.asi.get(i2)).rh().getDatasource(0).setUsername(string);
            }
        }
    }

    public void setPassword(String string) throws ReportException {
        this.iU();
        BaseUtils.info("Set Password: ****");
        this.DE.rh().getDatasource(0).setPassword(string);
        if (this.DE.asi != null) {
            int n2 = this.DE.asi.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ((cc)this.DE.asi.get(i2)).rh().getDatasource(0).setPassword(string);
            }
        }
    }

    public void setErrorMsg(String string) {
        this.QB = string;
    }

    public String getErrorMsg() {
        return this.QB;
    }

    public Fields getFields() throws ReportException {
        this.iU();
        return this.DE.getFields();
    }

    public Engine getSubReport(int n2) throws ReportException {
        this.iU();
        return this.DE.cl(n2).getEngine();
    }

    public Subreport getSubReportElement() throws ReportException {
        if (this.getParent() == null) {
            return null;
        }
        cc cc2 = this.getParent().DE;
        ArrayList<Section> arrayList = cc2.rc();
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            Section section = arrayList.get(i2);
            for (int i3 = 0; i3 < section.hx().size(); ++i3) {
                if (!(section.hx().fS(i3) instanceof Subreport) || ((Subreport)section.hx().fS((int)i3)).axc != this.DE.id) continue;
                return (Subreport)section.hx().fS(i3);
            }
        }
        return null;
    }

    public int getSubReportCount() throws ReportException {
        this.iU();
        return this.DE.getSubReportCount();
    }

    public void setDataSourceConfigurationName(String string) throws ReportException {
        this.iU();
        BaseUtils.info("Set DataSourceConfigurationName:" + string);
        if (string == null) {
            string = "";
        }
        string = string.toLowerCase();
        this.DE.rh().getDatasource(0).setDataSourceConfigurationName(string);
        if (this.DE.asi != null) {
            for (int i2 = 0; i2 < this.DE.asi.size(); ++i2) {
                ((cc)this.DE.asi.get(i2)).rh().getDatasource(0).setDataSourceConfigurationName(string);
            }
        }
    }

    public static int getMajorVersion() {
        return 13;
    }

    public static int getMinorVersion() {
        return 1;
    }

    public static String getVersion() {
        return BaseUtils.getVersion();
    }

    public URL getReportFile() throws ReportException {
        this.iT();
        return this.DE.Nv;
    }

    public SummaryInfo getSummaryInfo() throws ReportException {
        this.iU();
        return this.DE.getSummaryInfo();
    }

    public Translations getTranslations() throws ReportException {
        this.iU();
        Translations translations = this.DE.getTranslations();
        if (translations == null) {
            translations = com.inet.report.translation.f.YW();
            this.DE.a(translations);
        }
        return translations;
    }

    public String getReportTitle() throws ReportException {
        this.iU();
        return this.DE.getSummaryInfo().getReportTitle();
    }

    public void setReportTitle(String string) throws ReportException {
        this.iU();
        this.DE.getSummaryInfo().setReportTitle(string);
    }

    @Deprecated
    public String getQueryFile() throws ReportException {
        this.iU();
        Engine engine = this.getParent();
        if (engine != null && engine.QW != null) {
            return String.valueOf(engine.QW.get(new Integer(this.DE.id)));
        }
        if (this.QW != null) {
            return String.valueOf(this.QW.get(new Integer(this.DE.id)));
        }
        return null;
    }

    @Deprecated
    public void setQueryFile(URL uRL, int n2) throws ReportException {
        this.iT();
        if (this.QW == null) {
            this.QW = new HashMap();
        }
        this.QW.put(new Integer(n2), uRL);
    }

    @Deprecated
    public void setQueryFile(URL uRL) throws ReportException {
        this.iT();
        BaseUtils.info("setQueryFile: " + uRL);
        if (this.QW == null) {
            this.QW = new HashMap();
        }
        this.QW.put(new Integer(this.DE.id), uRL);
    }

    public void setTime(long l2) {
        this.time = l2;
    }

    public long getTime() {
        return this.time;
    }

    public int getCacheSize() {
        byte[] byArray;
        int n2;
        if (this.QC == null) {
            return 0;
        }
        int n3 = 0;
        for (n2 = 1; n2 <= this.QC.getPageCount(); ++n2) {
            byArray = this.QC.getPageData(n2);
            if (byArray == null) continue;
            n3 += byArray.length;
        }
        for (n2 = 0; n2 < this.QC.getFontCount(); ++n2) {
            byArray = this.QC.getFontData(n2);
            if (byArray == null) continue;
            n3 += byArray.length;
        }
        byArray = this.QC.getGroupTree();
        if (byArray != null) {
            n3 += byArray.length;
        }
        return n3;
    }

    public void setReportFile(String string) throws ReportException {
        try {
            URL uRL;
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                uRL = IOFunctions.getFileURL(string);
            }
            this.setReportFile(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            Object[] objectArray = new Object[]{string};
            ReportException reportException = ReportExceptionFactory.createReportExceptionWithCause(malformedURLException, ErrorCode.RptNotFound, objectArray);
            this.QA = reportException;
            throw reportException;
        }
    }

    public void relocateFile(URL uRL) throws ReportException {
        this.iT();
        this.DE.Nv = uRL;
    }

    public void setReportFile(URL uRL) throws ReportException {
        this.iT();
        try {
            BaseUtils.info("setReportFile: " + uRL);
            if (this.DE.Nv != null) {
                Object[] objectArray = new Object[]{};
                throw ReportExceptionFactory.createReportException(ErrorCode.RptAlreadySet, objectArray);
            }
            this.DE.Nv = uRL;
            if ("repo".equals(uRL.getProtocol())) {
                PermissionChecker.checkReportLocation(WebUserInfoFactory.getSessionWebUserInfo(), uRL);
            } else {
                try {
                    PermissionChecker.checkReportLocation(WebUserInfoFactory.getSessionWebUserInfo(), uRL);
                }
                catch (o o2) {
                    PermissionChecker.checkExecuteRight(WebUserInfoFactory.getSessionWebUserInfo(), uRL);
                }
            }
            this.setErrorMsg(null);
            boolean bl2 = IOFunctions.isDirectory(uRL);
            byte[] byArray = bl2 ? null : IOFunctions.getFileBuffer(uRL);
            this.a(uRL, byArray, bl2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Object[] objectArray = new Object[]{uRL};
            ReportException reportException = ReportExceptionFactory.createReportExceptionWithCause(fileNotFoundException, ErrorCode.RptNotFound, objectArray);
            this.QA = reportException;
            throw reportException;
        }
        catch (Throwable throwable) {
            throw ReportExceptionFactory.createReportExceptionWithCause(throwable);
        }
        finally {
            this.DE.ox().JW();
            BaseUtils.S("afterSetReportFile");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    void a(URL var1_1, byte[] var2_2, boolean var3_3) throws IOException, ReportException, UnsupportedEncodingException {
        block22: {
            block21: {
                var5_4 = null;
                if (!var3_3) break block21;
                var4_5 = 5;
                break block22;
            }
            var6_6 = new ByteArrayInputStream(var2_2);
            var7_7 /* !! */  = new BufferedInputStream((InputStream)var6_6);
            if (IOFunctions.isZipFile(var7_7 /* !! */ )) {
                var5_4 = new RFReader(var7_7 /* !! */ );
                var2_2 = var5_4.getContent();
            }
            if (var5_4 == null) ** GOTO lbl18
            if (var5_4.getMimetype() == null) ** GOTO lbl17
            if ("application/crystalclear.report".startsWith(var5_4.getMimetype())) {
                var4_5 = 4;
            } else {
                throw ReportExceptionFactory.createReportException(ErrorCode.InvalidMimeType, new Object[]{var5_4.getMimetype()});
lbl17:
                // 1 sources

                throw ReportExceptionFactory.createReportException(ErrorCode.InvalidMimeType, new Object[]{"<null>"});
lbl18:
                // 1 sources

                var4_5 = BaseUtils.b(var2_2);
            }
        }
        this.U(true);
        try {
            switch (var4_5) {
                case 1: {
                    var6_6 = new bp();
                    try {
                        var6_6.a(this.DE, var1_1, var2_2);
                    }
                    catch (ReportException var7_8) {
                        throw var7_8;
                    }
                    catch (Throwable var7_9) {
                        BaseUtils.printStackTrace(var7_9);
                        var8_10 = ReportExceptionFactory.createReportExceptionWithCause(var7_9, ErrorCode.InvalidRptRDC, new Object[]{var1_1});
                        this.QA = var8_10;
                        throw var8_10;
                    }
                    if (this.DE.rl() == null) {
                        throw ReportExceptionFactory.createReportException(ErrorCode.InvalidRptRDC, new Object[]{var1_1});
                    }
                    this.getReportProperties().aL(false);
                    ** break;
lbl39:
                    // 1 sources

                    break;
                }
                case 2: {
                    var7_7 /* !! */  = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(var2_2), "UTF8"));
                    new bq().a((BufferedReader)var7_7 /* !! */ , this.DE);
                    this.getReportProperties().aL(true);
                    ** break;
lbl45:
                    // 1 sources

                    break;
                }
                case 3: {
                    bo.b(this.DE, var2_2, var1_1);
                    this.getReportProperties().aL(true);
                    ** break;
lbl50:
                    // 1 sources

                    break;
                }
                case 4: {
                    RDC.s(this);
                    this.DE.Nv = var1_1;
                    if (var5_4 != null) {
                        var5_4.initSummaryInfo(this.getSummaryInfo());
                        this.setMetaProperties(var5_4.readMetaProperties());
                    }
                    var8_11 = com.inet.report.parser.b.Jb();
                    var8_11.Je().put("KEY_RF_READER", var5_4);
                    var8_11.a(this, XMLTag.Report, var2_2);
                    if (var5_4 != null && (var9_12 = var5_4.getThumbnail()) != null) {
                        this.getSummaryInfo().setThumbnailData(var9_12);
                    }
                    this.DE.a(com.inet.report.translation.f.c(var5_4));
                    this.T(true);
                    ** break;
lbl66:
                    // 1 sources

                    break;
                }
                case 5: {
                    RDC.s(this);
                    var9_13 = IOFunctions.getFile(var1_1);
                    RDC.a(this, var9_13, null);
                    ** break;
lbl72:
                    // 1 sources

                    break;
                }
                default: {
                    throw ReportExceptionFactory.createReportException(ErrorCode.InvalidRpt, new Object[]{var1_1});
                }
            }
        }
        finally {
            this.U(false);
        }
        this.DE.rh().l(null);
        this.DE.rh().m(null);
        this.DE.rh().k(null);
        if (this.DE.rh().in() != null) {
            this.DE.rh().in().mM();
        }
        this.iZ();
        this.as(0);
        this.jc();
        com.inet.report.statistic.a.g(var1_1);
        com.inet.report.statistic.a.fZ(this.QL);
    }

    private void iY() throws ReportException {
        String[] stringArray = this.getReportProperties().getEnabledFormats();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        String string = this.QL;
        if (string.equals(EXPORT_DATA)) {
            string = EXPORT_CSV;
        } else if (string.startsWith(EXPORT_PS)) {
            string = EXPORT_PS;
        } else if (string.startsWith(EXPORT_HTML)) {
            string = EXPORT_HTML;
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!stringArray[i2].equalsIgnoreCase(string)) continue;
            return;
        }
        Object[] objectArray = new Object[]{string};
        throw ReportExceptionFactory.createReportException(ErrorCode.ExportFormatDisabled, objectArray);
    }

    private void iZ() throws ReportException {
        Object object;
        Serializable serializable;
        int n2;
        ArrayList<Section> arrayList = this.DE.rc();
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            serializable = arrayList.get(n2);
            object = ((Section)serializable).getElements();
            block6: for (int i2 = 0; i2 < ((Element[])object).length; ++i2) {
                Element element = object[i2];
                switch (element.type) {
                    case 39: {
                        SubreportLink[] subreportLinkArray = ((Subreport)element).axe;
                        for (int i3 = 0; i3 < subreportLinkArray.length; ++i3) {
                            SubreportLink subreportLink = subreportLinkArray[i3];
                            try {
                                subreportLink.getSubField();
                                continue;
                            }
                            catch (ReportException reportException) {
                                BaseUtils.printStackTrace(reportException);
                            }
                        }
                        continue block6;
                    }
                }
            }
        }
        this.getFields().jz();
        if (this.DE.asi != null) {
            for (n2 = 0; n2 < this.DE.asi.size(); ++n2) {
                serializable = (cc)this.DE.asi.get(n2);
                if (serializable == null) continue;
                object = ((cs)serializable).getFields();
                if (object == null) {
                    object = new Fields((cc)serializable);
                }
                ((Fields)object).jz();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getGroupTree() throws ReportException {
        Object object = this.QI;
        synchronized (object) {
            while (!this.QD) {
                try {
                    this.QI.wait(10000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.QC != null) {
            return this.QC.getGroupTree();
        }
        return null;
    }

    void ap(String string) throws ReportException {
        if (string.length() != 0) {
            Properties properties = new Properties();
            dw.saveParams(string, properties, false);
            String string2 = properties.getProperty("type", "0");
            int n2 = Integer.parseInt(string2);
            if (n2 > 0) {
                this.QH = true;
                this.DE.e(properties);
                return;
            }
            int n3 = 0;
            try {
                Object object;
                int n4;
                Object object2;
                n3 = Integer.parseInt(properties.getProperty("subreport", null));
                cc cc2 = (cc)this.DE.asi.get(n3);
                ReportProperties reportProperties = cc2.getReportProperties();
                if (reportProperties.getPaperOrient() == 0) {
                    reportProperties.setPaperOrient(this.DE.getReportProperties().getPaperOrient(), reportProperties.getPaperFormat());
                }
                cc2.a(this.DE.getTranslations());
                Subreport subreport = null;
                ArrayList<Section> arrayList = this.DE.rc();
                int n5 = arrayList.size();
                block2: while (n5-- > 0) {
                    object2 = arrayList.get(n5);
                    Element[] elementArray = ((Section)object2).getElements();
                    n4 = elementArray.length;
                    while (n4-- > 0) {
                        object = elementArray[n4];
                        if (((Element)object).type != 39) continue;
                        Subreport subreport2 = (Subreport)object;
                        subreport2.getEngine();
                        if (subreport2.awZ != cc2) continue;
                        subreport = subreport2;
                        break block2;
                    }
                }
                Engine.a(subreport);
                cc2.Nv = this.DE.Nv;
                this.DE = cc2;
                this.DE.setEngine(this);
                this.DE.id = 0;
                this.DE.setOnDemand(true);
                this.DE.asi = null;
                this.setErrorMsg(null);
                if (string.length() > 0) {
                    Enumeration<?> enumeration = properties.propertyNames();
                    while (enumeration.hasMoreElements()) {
                        object2 = (String)enumeration.nextElement();
                        int n6 = -1;
                        if (((String)object2).startsWith("prompt")) {
                            n6 = 6;
                        }
                        if (n6 == -1) continue;
                        n4 = Integer.valueOf(((String)object2).substring(n6));
                        object = properties.getProperty((String)object2, null);
                        if (object == null) continue;
                        this.setPrompt((String)object, n4);
                    }
                }
            }
            catch (Throwable throwable) {
                BaseUtils.printStackTrace(throwable);
                Object[] objectArray = new Object[]{"subreport#", string};
                throw ReportExceptionFactory.createReportException(ErrorCode.InvalidArgument, objectArray);
            }
        }
    }

    private static StringBuffer a(StringBuffer stringBuffer, SubreportLink subreportLink) {
        if (subreportLink.axo != null) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(100);
            } else {
                stringBuffer.append(" AND ");
            }
            stringBuffer.append("{" + subreportLink.axo.getRefName() + "}={" + subreportLink.axn.getRefName() + "}");
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("SF=" + stringBuffer);
            }
        }
        return stringBuffer;
    }

    static void a(Subreport subreport) {
        if (subreport.axg) {
            return;
        }
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("setSubreportLinksToSF(" + subreport + ")");
        }
        subreport.axg = true;
        cc cc2 = subreport.getEngine().DE;
        StringBuffer stringBuffer = null;
        for (int i2 = 0; i2 < subreport.axe.length; ++i2) {
            SubreportLink subreportLink = subreport.axe[i2];
            try {
                stringBuffer = Engine.a(stringBuffer, subreportLink);
                continue;
            }
            catch (Exception exception) {
                BaseUtils.printStackTrace(exception);
            }
        }
        if (stringBuffer != null) {
            String string;
            block12: {
                if (cc2.rj() == null) {
                    cc2.g(new FormulaField(cc2));
                    cc2.rj().valueType = 8;
                    cc2.rj().Ug = 1;
                    cc2.rj().name = "Record_Selection";
                }
                string = cc2.rj() == null ? "" : cc2.rj().getFormula();
                boolean bl2 = true;
                try {
                    boolean bl3 = cc2.rj().getSyntax() == 1002;
                    bl2 = FormulaField.isEmpty(string, bl3, cc2.getEngine());
                    if (bl2) {
                        cc2.rj().setFormula(stringBuffer.toString());
                    } else {
                        cc2.rj().setFormula("(" + string + "\n) AND (" + stringBuffer + "\n)");
                    }
                }
                catch (Exception exception) {
                    if (!BaseUtils.isDebug()) break block12;
                    BaseUtils.debug(exception);
                }
            }
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("PATCH SF: " + string + " with " + stringBuffer);
            }
        }
    }

    public Vector getSections() throws ReportException {
        this.iT();
        Vector<Section> vector = new Vector<Section>();
        vector.addAll(this.DE.rc());
        return vector;
    }

    public Area getArea(int n2) throws ReportException {
        this.iT();
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        switch (n2) {
            case 0: {
                return this.DE.asf;
            }
            case 1: {
                return this.DE.asd;
            }
            case 2: {
                return this.DE.ash;
            }
            case 3: {
                return this.DE.asg;
            }
            case 4: {
                return this.DE.ase;
            }
        }
        if (this.DE.rm()) {
            return this.m(n2, 2);
        }
        return this.m(n2, 1);
    }

    private Area m(int n2, int n3) {
        if (this.DE.rl() == null) {
            return null;
        }
        if ((n2 -= 5) < 0) {
            return null;
        }
        int n4 = (n2 - n2 % 2) / 2 + n3;
        if (n4 > this.DE.rl().length - 2) {
            return null;
        }
        Group group = this.DE.rl()[n4];
        if (group == null || group.kh() != 30) {
            return null;
        }
        if (n2 % 2 == 0) {
            return group.UY;
        }
        return group.UZ;
    }

    public Area getArea(String string) throws ReportException {
        this.iT();
        return this.DE.getArea(string);
    }

    public int getAreaCount() throws ReportException {
        this.iU();
        if (this.DE.rl() != null) {
            return this.DE.rl().length * 2 - 1;
        }
        return 5;
    }

    public DatabaseTables getDatabaseTables() throws ReportException {
        this.iU();
        return this.DE.rh();
    }

    public Group addGroup(Field field) throws ReportException {
        Group group = this.g(field);
        group.Vm = this.getFields().b(group);
        return group;
    }

    Group g(Field field) throws ReportException {
        this.iT();
        if (this.DE.rl() == null) {
            throw new IllegalStateException("The report structure is corrupt. Please report this error.");
        }
        Group group = new Group(field, this.DE);
        group.aK(0);
        Group[] groupArray = new Group[this.DE.rl().length + 1];
        groupArray[0] = this.DE.rl()[0];
        int n2 = 1;
        if (this.DE.id == 0) {
            if (this.DE.rl().length < 3) {
                throw new IllegalStateException("The report structure is corrupt. Please report this error.");
            }
            n2 = 2;
            groupArray[1] = this.DE.rl()[1];
        } else if (this.DE.rl().length < 2) {
            throw new IllegalStateException("The report structure is corrupt. Please report this error.");
        }
        while (n2 < groupArray.length - 2) {
            groupArray[n2] = this.DE.rl()[n2];
            ++n2;
        }
        groupArray[groupArray.length - 2] = group;
        groupArray[groupArray.length - 1] = this.DE.rl()[this.DE.rl().length - 1];
        this.DE.a(groupArray);
        group.UY = new Area(31, this.DE);
        Section section = group.UY.addSection();
        section.x = this.DE.getReportProperties().getMarginLeft();
        section.width = this.DE.getReportProperties().getPaperWidth() - this.DE.getReportProperties().getMarginRight() - this.DE.getReportProperties().getMarginLeft();
        group.UZ = new Area(32, this.DE);
        section = group.UZ.addSection();
        section.x = this.DE.getReportProperties().getMarginLeft();
        section.width = this.DE.getReportProperties().getPaperWidth() - this.DE.getReportProperties().getMarginRight() - this.DE.getReportProperties().getMarginLeft();
        return group;
    }

    public int getGroupCount() throws ReportException {
        this.iU();
        return this.DE.getGroupCount();
    }

    public void removeGroup(Group group) throws ReportException {
        this.iT();
        this.removeGroup(group.indexOf());
    }

    public void removeGroup(int n2) throws ReportException {
        int n3;
        int n4;
        Group[] groupArray;
        this.iT();
        Group group = this.getGroup(n2);
        if (group == null) {
            return;
        }
        if (this.DE.arW == null) {
            this.DE.arW = new SummaryField[0];
        }
        for (int i2 = 0; i2 < this.DE.arW.length; ++i2) {
            boolean bl2 = false;
            SummaryField summaryField = this.DE.arW[i2];
            if (summaryField.getGroup() == group) {
                summaryField.setChangeField(null);
                bl2 = true;
            }
            if (summaryField.axI == group) {
                summaryField.setResetField(null);
                bl2 = true;
            }
            if (!bl2) continue;
            --i2;
            if (summaryField.name.indexOf(group.getField().name) <= 0) continue;
            groupArray = null;
            if (summaryField.axE != null) {
                groupArray = summaryField.axE.name;
            }
            summaryField.name = SummaryField.generateName(summaryField.getField().name, null, summaryField.avU, (String)groupArray);
        }
        cb[] cbArray = group.getReferencedObjects();
        for (n4 = 0; n4 < cbArray.length; ++n4) {
            if (!(cbArray[n4] instanceof Field) || !group.equals((groupArray = (Field)cbArray[n4]).getGroup())) continue;
            groupArray.setGroup(null);
        }
        group.gh();
        group.resetReferences();
        if (group.Vm != null) {
            group.Vm.resetReferences();
        }
        group.Vh = null;
        n4 = -1;
        if (group.Vm != null) {
            n4 = group.Vm.indexOf();
        }
        if (n4 > -1) {
            this.getFields().aE(n4);
        }
        if (group.Vm != null) {
            group.Vm.setGroup(null);
        }
        group.Vm = null;
        groupArray = new Group[this.DE.rl().length - 1];
        int n5 = 0;
        if (this.DE.id == 0) {
            n5 = 1;
        }
        for (n3 = 0; n3 < n2 + n5; ++n3) {
            groupArray[n3] = this.DE.rl()[n3];
        }
        for (n3 = n2 + n5 + 1; n3 < groupArray.length; ++n3) {
            groupArray[n3 - 1] = this.DE.rl()[n3];
        }
        groupArray[groupArray.length - 1] = this.DE.rl()[this.DE.rl().length - 1];
        this.DE.a(groupArray);
    }

    public Group getGroup(int n2) throws ReportException, IndexOutOfBoundsException {
        this.iU();
        return this.DE.getGroup(n2 - 1);
    }

    public Group getGroupByField(Field field) throws ReportException {
        this.iT();
        if (field == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.DE.rl().length; ++i2) {
            Field field2 = this.DE.rl()[i2].getField();
            if (field2 == null || !field2.equals(field)) continue;
            return this.DE.rl()[i2];
        }
        return null;
    }

    public void moveGroup(int n2, int n3) throws ReportException {
        int n4;
        this.iT();
        if (n2 == n3) {
            return;
        }
        Group group = this.getGroup(n2);
        Group group2 = this.getGroup(n3);
        int n5 = 0;
        int n6 = 0;
        Group[] groupArray = new Group[this.DE.rl().length];
        for (n4 = 0; n4 < this.DE.rl().length; ++n4) {
            if (this.DE.rl()[n4] == group) {
                n5 = n4;
                continue;
            }
            if (this.DE.rl()[n4] != group2) continue;
            n6 = n4;
        }
        if (n5 > n6) {
            for (n4 = 0; n4 < n6; ++n4) {
                groupArray[n4] = this.DE.rl()[n4];
            }
            groupArray[n6] = this.DE.rl()[n5];
            for (n4 = n6; n4 < n5; ++n4) {
                groupArray[n4 + 1] = this.DE.rl()[n4];
            }
            for (n4 = n5 + 1; n4 < this.DE.rl().length; ++n4) {
                groupArray[n4] = this.DE.rl()[n4];
            }
        } else {
            for (n4 = 0; n4 < n5; ++n4) {
                groupArray[n4] = this.DE.rl()[n4];
            }
            groupArray[n6] = this.DE.rl()[n5];
            for (n4 = n5 + 1; n4 < n6 + 1; ++n4) {
                groupArray[n4 - 1] = this.DE.rl()[n4];
            }
            for (n4 = n6 + 1; n4 < this.DE.rl().length; ++n4) {
                groupArray[n4] = this.DE.rl()[n4];
            }
        }
        this.DE.a(groupArray);
        this.DE.getEngine().getFields().a(group.getField(), 3);
    }

    @Deprecated
    public boolean isXml() {
        try {
            return this.getReportProperties().isCCFormat();
        }
        catch (ReportException reportException) {
            return true;
        }
    }

    static void r(Engine engine) {
        ArrayList<Section> arrayList = engine.DE.rc();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.get(i2).ja();
        }
    }

    void ja() {
        Engine.r(this);
        ArrayList arrayList = this.DE.asi;
        if (arrayList != null) {
            int n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Engine.r(((cc)arrayList.get(i2)).getEngine());
            }
        }
    }

    public void setPrintDate(Date date) throws ReportException {
        this.iT();
        this.DE.b(date);
    }

    public Date getPrintDate() throws ReportException {
        this.iT();
        return this.DE.rb();
    }

    public Exception[] getLoadExceptions() {
        if (this.QJ == null || this.QJ.size() == 0) {
            return null;
        }
        return this.QJ.toArray(new Exception[this.QJ.size()]);
    }

    public void setMsgListener(RDC.MsgListener msgListener) {
        this.QK = msgListener;
    }

    public RDC.MsgListener getMsgListener() {
        return this.QK;
    }

    public boolean isSubEngine() throws ReportException {
        this.iU();
        return this.DE.id != 0;
    }

    public EngineStatus getStatus() {
        if (this.QE) {
            throw new IllegalStateException("EngineStatus is not available for a sub report! Call getStatus() on the main engine instead!");
        }
        return this.QX;
    }

    public ReportProperties getReportProperties() throws ReportException {
        this.iT();
        return this.DE.getReportProperties();
    }

    void resetReferences() throws ReportException {
        int n2;
        int n3;
        FormulaField formulaField;
        FormulaField formulaField2;
        int n4;
        TablesourceList tablesourceList = this.DE.rh().hZ();
        for (n4 = 0; n4 < tablesourceList.size(); ++n4) {
            ((TableSource)tablesourceList.get(n4)).resetReferences();
        }
        if (this.DE.rh().ik() != null) {
            for (n4 = 0; n4 < this.DE.rh().ik().size(); ++n4) {
                this.DE.rh().ik().ga(n4).resetReferences();
            }
        }
        if ((formulaField2 = this.getSFField()) != null) {
            formulaField2.resetReferences();
        }
        if ((formulaField = this.getGFField()) != null) {
            formulaField.resetReferences();
        }
        Fields fields = this.getFields();
        int n5 = fields.getFormulaFieldsCount();
        for (n3 = 0; n3 < n5; ++n3) {
            fields.getFormulaField(n3).resetReferences();
        }
        n5 = fields.getGroupNameFieldsCount();
        for (n3 = 0; n3 < n5; ++n3) {
            fields.getGroupNameField(n3).resetReferences();
        }
        for (n3 = 0; n3 < fields.getSQLExpressionFieldsCount(); ++n3) {
            fields.getSQLExpressionField(n3).resetReferences();
        }
        for (n3 = 0; n3 < fields.getSummaryFieldsCount(); ++n3) {
            fields.getSummaryField(n3).resetReferences();
        }
        for (n3 = 0; n3 < fields.getSortFieldsCount(); ++n3) {
            fields.getSortField(n3).resetReferences();
        }
        Group[] groupArray = this.DE.rl();
        for (n2 = 0; n2 < groupArray.length; ++n2) {
            groupArray[n2].resetReferences();
        }
        for (n2 = 0; n2 < fields.getPromptFieldsCount(); ++n2) {
            fields.getPromptField(n2).resetReferences();
        }
    }

    void setReferences() throws ReportException {
        int n2;
        FormulaField formulaField;
        FormulaField formulaField2;
        int n3;
        TablesourceList tablesourceList = this.DE.rh().hZ();
        for (n3 = 0; n3 < tablesourceList.size(); ++n3) {
            ((TableSource)tablesourceList.get(n3)).setReferences();
        }
        if (this.DE.rh().ik() != null) {
            for (n3 = 0; n3 < this.DE.rh().ik().size(); ++n3) {
                this.DE.rh().ik().ga(n3).setReferences();
            }
        }
        if ((formulaField2 = this.getSFField()) != null) {
            formulaField2.setReferences();
        }
        if ((formulaField = this.getGFField()) != null) {
            formulaField.setReferences();
        }
        Fields fields = this.getFields();
        for (n2 = 0; n2 < fields.getFormulaFieldsCount(); ++n2) {
            fields.getFormulaField(n2).setReferences();
        }
        for (n2 = 0; n2 < fields.getGroupNameFieldsCount(); ++n2) {
            fields.getGroupNameField(n2).setReferences();
        }
        for (n2 = 0; n2 < fields.getSQLExpressionFieldsCount(); ++n2) {
            fields.getSQLExpressionField(n2).setReferences();
        }
        for (n2 = 0; n2 < fields.getSummaryFieldsCount(); ++n2) {
            fields.getSummaryField(n2).setReferences();
        }
        for (n2 = 0; n2 < fields.getSortFieldsCount(); ++n2) {
            fields.getSortField(n2).setReferences();
        }
        for (n2 = 0; n2 < fields.getPromptFieldsCount(); ++n2) {
            fields.getPromptField(n2).setReferences();
        }
        Group[] groupArray = this.DE.rl();
        for (int i2 = 0; i2 < groupArray.length; ++i2) {
            groupArray[i2].setReferences();
        }
    }

    void jb() {
        if (this.je() == 2) {
            this.as(0);
        }
    }

    void jc() throws ReportException {
        int n2;
        if (this.je() == 2) {
            throw new IllegalStateException("references already initialized");
        }
        this.as(1);
        long l2 = System.currentTimeMillis();
        for (n2 = 0; n2 < this.getSubReportCount(); ++n2) {
            this.getSubReport(n2).resetReferences();
        }
        this.resetReferences();
        for (n2 = 0; n2 < this.getSubReportCount(); ++n2) {
            this.getSubReport(n2).setReferences();
        }
        this.setReferences();
        if (this.DE.ra() && BaseUtils.isDebug()) {
            Long l3 = new Long(System.currentTimeMillis() - l2);
            BaseUtils.debug(Msg.getMsg("initRefCounter", l3));
        }
        this.as(2);
    }

    public static List getEmbeddableFontNames() {
        if (QO == null) {
            QO = v.xg();
        }
        return QO;
    }

    ArrayList jd() {
        return this.QZ;
    }

    public void addClippingListener(ClippingListener clippingListener) {
        if (this.QZ == null) {
            this.QZ = new ArrayList();
        }
        this.QZ.add(clippingListener);
    }

    public void removeClippingListener(ClippingListener clippingListener) {
        if (this.QZ == null) {
            return;
        }
        this.QZ.remove(clippingListener);
        if (this.QZ.size() == 0) {
            this.QZ = null;
        }
    }

    public void addFinishListener(EngineFinishListener engineFinishListener) {
        if (this.QP == null) {
            this.QP = new ArrayList();
        }
        this.QP.add(engineFinishListener);
    }

    public void removeFinishListener(EngineFinishListener engineFinishListener) {
        if (this.QP == null) {
            return;
        }
        this.QP.remove(engineFinishListener);
    }

    private void a(URL uRL, long l2) {
        if (this.QP == null) {
            return;
        }
        EngineFinishEvent engineFinishEvent = new EngineFinishEvent(this, uRL, l2);
        for (int i2 = this.QP.size() - 1; i2 >= 0; --i2) {
            try {
                this.QP.get(i2).engineFinish(engineFinishEvent);
                continue;
            }
            catch (Throwable throwable) {
                BaseUtils.printStackTrace(throwable);
            }
        }
    }

    public FormulaField[] getVariableReferences(String string) throws ReportException {
        this.iT();
        return this.DE.ks().getVariableReferences(string);
    }

    @Override
    public NodeParser parseElement(XMLTag xMLTag, String string, Attributes attributes, Map<String, Object> map) throws FatalParserException {
        try {
            XMLTag xMLTag2 = XMLTag.getValueOf(string);
            if (xMLTag2 == XMLTag.Unknown) {
                return null;
            }
            if (xMLTag2 == XMLTag.Field) {
                String string2 = attributes.getValue("type");
                b b2 = b.aq(string2);
                if (b2 != null) {
                    String string3 = attributes.getValue("valueType");
                    int n2 = -1;
                    if (string3 != null) {
                        int n3 = Integer.valueOf(string3);
                        switch (n3 % 128) {
                            case -10: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 10: 
                            case 11: 
                            case 14: 
                            case 15: 
                            case 1024: {
                                n2 = n3 % 128;
                            }
                        }
                    }
                    switch (b2) {
                        case Rg: {
                            FormulaField formulaField = this.getFields().addFormulaField("temp" + System.identityHashCode(string2), "", 0);
                            formulaField.setValueType(n2);
                            this.Qy.Rd = formulaField;
                            return formulaField;
                        }
                        case Rh: {
                            FormulaField formulaField = new FormulaField(this.DE);
                            formulaField.setValueType(n2);
                            this.DE.g(formulaField);
                            this.Qy.Rd = this.DE.rj();
                            formulaField.setFormulaType(1);
                            return formulaField;
                        }
                        case Ri: {
                            FormulaField formulaField = new FormulaField(this.DE);
                            formulaField.setValueType(n2);
                            this.Qy.Rd = this.DE.h(formulaField);
                            formulaField.setFormulaType(2);
                            return formulaField;
                        }
                        case Rj: {
                            PromptField promptField = this.getFields().addPromptField("temp" + System.identityHashCode(string2), "", n2);
                            this.Qy.Rd = promptField;
                            return promptField;
                        }
                        case Rk: {
                            SQLField sQLField = new SQLField(this.DE);
                            sQLField.setValueType(n2);
                            this.DE.arX = (SQLField[])Fields.a((Field[])this.DE.arX, sQLField);
                            this.Qy.Rd = sQLField;
                            return sQLField;
                        }
                        case Rl: {
                            SummaryField summaryField = new SummaryField(this.DE);
                            summaryField.setValueType(n2);
                            this.DE.arW = (SummaryField[])Fields.a((Field[])this.DE.arW, summaryField);
                            this.Qy.Rd = summaryField;
                            return summaryField;
                        }
                        case Rm: {
                            SortField sortField = new SortField(this.DE);
                            sortField.setValueType(n2);
                            this.DE.arY = (SortField[])Fields.a((Field[])this.DE.arY, sortField);
                            this.Qy.Rd = sortField;
                            return sortField;
                        }
                        case Rn: {
                            GroupField groupField = new GroupField(this.DE);
                            groupField.setValueType(n2);
                            this.DE.arV = (GroupField[])Fields.a((Field[])this.DE.arV, groupField);
                            this.Qy.Rd = groupField;
                            return groupField;
                        }
                        case Ro: {
                            com.inet.report.formula.userfunctions.b b3 = new com.inet.report.formula.userfunctions.b(this.DE.arU);
                            b3.setValueType(n2);
                            this.DE.arU.a(b3);
                            this.Qy.Rd = null;
                            return b3;
                        }
                    }
                    BaseUtils.error("unknown Field type: " + (Object)((Object)b2));
                    return null;
                }
                BaseUtils.error("No type given for <Field> Tag! ");
                return null;
            }
            NodeParser nodeParser = null;
            switch (xMLTag2) {
                case Report: {
                    String string4;
                    Fields fields = this.DE.getEngine().getFields();
                    fields.Tx = new d();
                    fields.Ty = new com.inet.report.list.e();
                    String string5 = attributes.getValue("major_version");
                    this.DE.getReportProperties().co(Integer.parseInt(string5));
                    String string6 = attributes.getValue("minor_version");
                    this.DE.getReportProperties().cp(Integer.parseInt(string6));
                    String string7 = attributes.getValue("major_xml_version");
                    if (string7 != null) {
                        int n4 = Integer.parseInt(string7);
                        if (n4 > Engine.getMajorVersion()) {
                            if (this.QJ == null) {
                                this.QJ = new ArrayList();
                            }
                            this.QJ.add(ReportExceptionFactory.createReportException(ErrorCode.LoadingNewerVersion, string7));
                        }
                        this.DE.getReportProperties().cq(n4);
                    }
                    if ((string4 = attributes.getValue("minor_xml_version")) != null) {
                        this.DE.getReportProperties().cr(Integer.parseInt(string4));
                    }
                    this.DE.getReportProperties().aL(true);
                    break;
                }
                case Datasource: {
                    String string8 = attributes.getValue("dll");
                    String string9 = attributes.getValue("host");
                    String string10 = attributes.getValue("schema");
                    String string11 = attributes.getValue("catalog");
                    String string12 = attributes.getValue("user");
                    String string13 = attributes.getValue("password");
                    String string14 = attributes.getValue("url");
                    String string15 = attributes.getValue("properties");
                    string13 = BaseUtils.decrypt(string13);
                    if (string13 != null && string13.length() > 0) {
                        this.getDatabaseTables().setSavePassword(true);
                    } else {
                        string13 = null;
                    }
                    if (string9 == null) break;
                    Datasource datasource = this.Qy.Rc = new Datasource(string8, string9, string10, string11, string12, string13, this);
                    this.getDatabaseTables().d(datasource);
                    if (string14 != null && string14.length() > 0) {
                        datasource.setUrl(string14);
                    }
                    if (string15 == null) break;
                    q.a(string15, datasource, this.DE.Nv);
                    break;
                }
                case DataSourceConfiguration: {
                    String string16 = attributes.getValue("name");
                    if (DataSourceConfigurationManager.exists(string16)) {
                        this.Qy.Rc = this.getDatabaseTables().createDatasource(string16);
                        this.Qy.Re = null;
                        break;
                    }
                    Datasource datasource = new Datasource(string16, this);
                    DataSourceConfiguration dataSourceConfiguration = new DataSourceConfiguration(string16);
                    this.Qy.Re = dataSourceConfiguration;
                    this.Qy.Rf = false;
                    datasource.setDataSourceConfiguration(dataSourceConfiguration);
                    this.getDatabaseTables().d(datasource);
                    this.Qy.Rc = datasource;
                    break;
                }
                case property: {
                    if (this.Qy.Re == null) break;
                    String string17 = attributes.getValue("name");
                    String string18 = attributes.getValue("value");
                    string17 = com.inet.report.config.datasource.a.ci(string17);
                    string18 = com.inet.report.config.datasource.a.ci(string18);
                    if (string17.equals("password")) {
                        string18 = BaseUtils.decrypt(string18);
                    }
                    this.Qy.Re.addProperty(string17, string18);
                    this.Qy.Rf = true;
                    break;
                }
                case Tablesource: {
                    String string19 = attributes.getValue("alias");
                    String string20 = attributes.getValue("databaseIdentifier");
                    if (this.Qy.Rc == null) {
                        this.Qy.Rc = new Datasource(null, null, null, null, null, null, this);
                        this.getDatabaseTables().d(this.Qy.Rc);
                    }
                    return this.Qy.Rc.o(string20, string19);
                }
                case Join: {
                    String string21 = attributes.getValue("from");
                    String string22 = attributes.getValue("to");
                    String string23 = attributes.getValue("type");
                    Join join = new Join(this.DE, DatabaseTables.ae(string23), string21, string22);
                    this.getDatabaseTables().ik().a(join);
                    return join;
                }
                case GroupNameFields: {
                    break;
                }
                case ReportProperties: {
                    this.getReportProperties().setPaperOrient(1, 256);
                    nodeParser = this.DE.getReportProperties();
                    break;
                }
                case AreaPair: {
                    int n5;
                    String string24;
                    int n6 = q.f(attributes);
                    switch (n6) {
                        case 30: {
                            string24 = attributes.getValue("id");
                            n5 = Integer.parseInt(string24);
                            nodeParser = new e(n6, this.DE, n5);
                            break;
                        }
                        case 24: 
                        case 27: 
                        case 33: {
                            nodeParser = new e(n6, this.DE);
                        }
                    }
                }
                case QueryChanges: {
                    String string24 = attributes.getValue("mask");
                    if (string24 == null) break;
                    int n5 = Integer.valueOf(string24);
                    this.DE.rh().it()[0] = (n5 & 1) > 0;
                    this.DE.rh().it()[1] = (n5 & 2) > 0;
                    this.DE.rh().it()[2] = (n5 & 4) > 0;
                    this.DE.rh().it()[3] = (n5 & 8) > 0;
                    this.DE.rh().it()[4] = (n5 & 0x10) > 0;
                    this.DE.rh().it()[5] = (n5 & 0x20) > 0;
                    this.DE.rh().a((String[])null);
                    break;
                }
                case QueryChange: {
                    String[] stringArray;
                    if (this.DE.rh().iu() == null) {
                        this.DE.rh().a(new String[1]);
                    } else {
                        stringArray = new String[this.DE.rh().iu().length + 1];
                        System.arraycopy(this.DE.rh().iu(), 0, stringArray, 0, this.DE.rh().iu().length);
                        this.DE.rh().a(stringArray);
                    }
                    stringArray = attributes.getValue("value");
                    if ("null".equals(stringArray)) {
                        stringArray = null;
                    }
                    this.DE.rh().iu()[this.DE.rh().iu().length - 1] = stringArray;
                    break;
                }
                case Warning: {
                    if (this.QJ == null) {
                        this.QJ = new ArrayList();
                    }
                    return new c(null);
                }
            }
            return nodeParser;
        }
        catch (ReportException reportException) {
            BaseUtils.printStackTrace(reportException);
            return null;
        }
    }

    @Override
    public void parseText(String string, Map<String, Object> map) {
    }

    @Override
    public void parseEndElement(XMLTag xMLTag, String string, Map<String, Object> map) throws FatalParserException {
        try {
            XMLTag xMLTag2 = XMLTag.getValueOf(string);
            switch (xMLTag2) {
                case Datasource: {
                    this.Qy.Rc = null;
                    break;
                }
                case Field: {
                    this.getFields().a(this.Qy.Rd, 0);
                    this.Qy.Rd = null;
                    break;
                }
                case Report: {
                    Fields fields = this.DE.getEngine().getFields();
                    fields.jy();
                    this.Qy = null;
                    break;
                }
                case DataSourceConfiguration: {
                    if (this.Qy.Re == null) break;
                    if (this.Qy.Rf) {
                        this.Qy.Rc.setDataSourceConfiguration(this.Qy.Re);
                        break;
                    }
                    this.Qy.Rc.setDataSourceConfigurationName(this.Qy.Re.getConfigurationName());
                }
            }
        }
        catch (ReportException reportException) {
            BaseUtils.printStackTrace(reportException);
        }
    }

    @Override
    public boolean isDOMParser() {
        return false;
    }

    @Override
    public void parseDOM(Node node, Map<String, Object> map) throws FatalParserException {
    }

    void T(boolean bl2) {
        try {
            this.getReportProperties().aL(bl2);
        }
        catch (ReportException reportException) {
            BaseUtils.printStackTrace(reportException);
        }
    }

    void as(int n2) {
        this.QY = n2;
    }

    int je() {
        return this.QY;
    }

    cc ij() {
        return this.DE;
    }

    public boolean isDrillDownEngine() {
        return this.QH;
    }

    void U(boolean bl2) {
        block2: {
            try {
                this.getFields().X(!bl2);
            }
            catch (ReportException reportException) {
                if (!BaseUtils.isParanoid()) break block2;
                BaseUtils.paranoid("Engine: Could not set auto-update on Fields. The Fields object is currently not available.");
            }
        }
    }

    public Properties getMetaProperties() {
        return this.QQ;
    }

    public void setMetaProperties(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("null not allowed");
        }
        this.QQ = properties;
    }

    public int getReportID() {
        return this.DE.id;
    }

    public Trigger getTrigger() {
        if (this.QR == null) {
            this.QR = new Trigger();
            if (this.DE != null) {
                this.DE.a(this.QR);
            }
        }
        return this.QR;
    }

    @Nonnull
    public EngineStatistics getStatistics() {
        return this.QS;
    }

    static {
        LOG_STATUS = 0;
        LOG_ERROR = 1;
        LOG_WARN = 2;
        LOG_INFO = 3;
        LOG_DEBUG = 4;
    }

    private class c
    implements NodeParser {
        private c() {
        }

        @Override
        public boolean isDOMParser() {
            return false;
        }

        @Override
        public void parseDOM(Node node, Map<String, Object> map) throws FatalParserException {
        }

        @Override
        public NodeParser parseElement(XMLTag xMLTag, String string, Attributes attributes, Map<String, Object> map) throws FatalParserException {
            return null;
        }

        @Override
        public void parseEndElement(XMLTag xMLTag, String string, Map<String, Object> map) throws FatalParserException {
        }

        @Override
        public void parseText(String string, Map<String, Object> map) {
            Engine.this.QJ.add(ReportExceptionFactory.createReportException(ErrorCode.Parser_Misc_Warning, string));
            BaseUtils.warning(string);
        }

        /* synthetic */ c(ab ab2) {
            this();
        }
    }

    private static enum b {
        Rg,
        Rh,
        Ri,
        Rj,
        Rk,
        Rl,
        Rm,
        Rn,
        Ro;

        private static HashMap<String, b> map;

        private static b aq(String string) {
            return map.get(string);
        }

        static {
            map = new HashMap();
            map.put("FormulaField", Rg);
            map.put("RecordSelection", Rh);
            map.put("GroupSelection", Ri);
            map.put("PromptVarField", Rj);
            map.put("SqlExprField", Rk);
            map.put("SummaryField", Rl);
            map.put("SortField", Rm);
            map.put("GroupNameField", Rn);
            map.put("UserFunction", Ro);
        }
    }

    private class a {
        private Datasource Rc = null;
        private Field Rd;
        private DataSourceConfiguration Re;
        private boolean Rf;

        private a() {
        }

        /* synthetic */ a(ab ab2) {
            this();
        }
    }
}

