/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.lib.util.StringFunctions;
import com.inet.report.BaseUtils;
import com.inet.report.Engine;
import com.inet.report.Prompt;
import com.inet.report.PromptRequestWarning;
import com.inet.report.PropertiesChecker;
import com.inet.report.ReportException;
import com.inet.report.ReportKeyFactory;
import com.inet.report.ac;
import com.inet.report.cache.Cache;
import com.inet.report.cg;
import com.inet.report.dw;
import com.inet.report.i18n.ErrorCode;
import com.inet.report.svg.SVGUtils;
import com.inet.report.util.u;
import com.inet.viewer.HasErrorCode;
import com.inet.viewer.PromptData;
import com.inet.viewer.RenderData;
import com.inet.viewer.ViewerException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class EngineRenderData
implements RenderData {
    private final Properties Iq = new Properties();
    private Properties JH;
    private final Hashtable Rq = new Hashtable();
    private String url = null;
    private boolean It;
    protected boolean isRefresh = true;
    private String title;
    private int Is = 1;
    private PropertiesChecker Rr;
    private ZipOutputStream Rs;
    private a Rt;

    public EngineRenderData(String string) {
        dw.sw();
        this.setReportLocation(string);
        this.Rr = new ac(this);
    }

    @Override
    public void setReportLocation(String string) {
        this.Iq.clear();
        this.Iq.put("export_fmt", "java");
        dw.saveParams(string, this.Iq, false);
        try {
            ReportKeyFactory.decodeProps(this.Iq);
        }
        catch (Throwable throwable) {
            BaseUtils.error("cannot decode props " + throwable);
        }
        this.url = string;
    }

    @Override
    public String getReportLocation() {
        return this.url;
    }

    public void clearEngineCache() {
        this.Rq.clear();
    }

    protected Engine createEngine(Properties properties) throws ReportException {
        Engine engine = new Engine(properties.getProperty("export_fmt"));
        this.setEngineParams(engine, properties);
        return engine;
    }

    protected String getKey(Properties properties) throws ReportException {
        if (this.isRefresh && this.isPromptOnRefresh()) {
            this.isRefresh = false;
            properties.put("promptonrefresh", "1");
        } else {
            properties.put("promptonrefresh", "0");
        }
        this.Rr.checkProperties(properties, null);
        return ReportKeyFactory.f(properties).toString();
    }

    protected Engine getEngine(String string) {
        return (Engine)this.Rq.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Engine checkEngine(Properties properties) throws ReportException {
        Hashtable hashtable = this.Rq;
        synchronized (hashtable) {
            boolean bl2 = this.isRefresh;
            String string = this.getKey(properties);
            Engine engine = (Engine)this.Rq.get(string);
            if (engine != null) {
                return engine;
            }
            BaseUtils.info("new engine: " + string);
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("props: " + properties);
            }
            engine = this.createEngine(properties);
            if (bl2) {
                dw.x(engine).op().rE();
            }
            engine.execute();
            this.Rq.put(string, engine);
            return engine;
        }
    }

    protected Engine setEngineParams(Engine engine, Properties properties) {
        return this.setEngineParams(engine, properties, false);
    }

    protected Engine setEngineParams(Engine engine, Properties properties, boolean bl2) {
        try {
            properties = (Properties)properties.clone();
            dw.a(null, engine, properties, this.Rr, null, bl2);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ReportException && ((ReportException)throwable).getErrorCode() == ErrorCode.FeatureForbidden.getErrorCodeNumber()) {
                throw this.a(throwable, properties);
            }
            BaseUtils.printStackTrace(throwable);
            Properties properties2 = new Properties();
            for (String string : properties.keySet()) {
                if (string.startsWith("prompt") && !string.equalsIgnoreCase("promptonrefresh")) continue;
                properties2.put(string, properties.get(string));
            }
            try {
                dw.a(null, engine, properties2, this.Rr, null, true);
            }
            catch (Throwable throwable2) {
                BaseUtils.printStackTrace(throwable2);
                throw this.a("Could not set engine properties, please check URL.\n" + throwable2.getMessage(), throwable2, properties);
            }
        }
        return engine;
    }

    public void setPropertiesChecker(PropertiesChecker propertiesChecker) {
        if (propertiesChecker == null) {
            throw new IllegalArgumentException();
        }
        this.Rr = propertiesChecker;
    }

    public PropertiesChecker getPropertiesChecker() {
        return this.Rr;
    }

    @Override
    public byte[] getPageData(int n2) throws ViewerException {
        try {
            Engine engine = this.checkEngine(this.Iq);
            return engine.getPageData(n2);
        }
        catch (Throwable throwable) {
            throw this.a(throwable, this.Iq);
        }
    }

    @Override
    public int getPageCount() throws ViewerException {
        try {
            Engine engine = this.checkEngine(this.Iq);
            return engine.getPageCount();
        }
        catch (Throwable throwable) {
            throw this.a(throwable, this.Iq);
        }
    }

    @Override
    public boolean isPageLimitExceeded() throws ViewerException {
        try {
            Engine engine = this.getEngine(this.getKey(this.Iq));
            return engine != null && engine.isPageLimitExceeded();
        }
        catch (Throwable throwable) {
            throw this.a(throwable, this.Iq);
        }
    }

    @Override
    public byte[] getNextExportChunk() throws ViewerException {
        try {
            String string;
            Engine engine = this.checkEngine(this.JH);
            switch (string = this.JH.getProperty("export_fmt")) {
                case "svg": {
                    if (this.Is == 0) {
                        ++this.Is;
                        String string2 = this.JH.getProperty("file");
                        string2 = string2.substring(string2.lastIndexOf("/") + 1, string2.lastIndexOf("."));
                        int n2 = SVGUtils.getAutoRefresh(this.JH);
                        return SVGUtils.getSvgViewerPackage(engine.QC.getPageCount(), true, string2, n2);
                    }
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    u.a(byteArrayOutputStream, this.Is + ".svg", engine.getPageData(this.Is++));
                    return byteArrayOutputStream.toByteArray();
                }
                case "png": 
                case "jpeg": 
                case "jpg": 
                case "gif": 
                case "bmp": {
                    if (this.Rt == null) break;
                    int n3 = engine.getPageCount();
                    while (this.Rt.jf() == 0 && this.Is <= n3) {
                        ZipEntry zipEntry = new ZipEntry(this.Is + "." + string);
                        this.Rs.putNextEntry(zipEntry);
                        this.Rs.write(engine.getPageData(this.Is++));
                        this.Rs.closeEntry();
                    }
                    if (this.Is > n3 && this.Rs != null) {
                        this.Rs.close();
                        this.Rs = null;
                    }
                    return this.Rt.jg();
                }
            }
            if (this.Is > 0) {
                return engine.getPageData(this.Is++);
            }
            if (this.Is == 0) {
                ++this.Is;
                return engine.getGroupTree();
            }
            ++this.Is;
            if (string.startsWith("htm")) {
                String string3 = this.JH.getProperty("file");
                string3 = string3.substring(string3.lastIndexOf("/") + 1);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                u.a(byteArrayOutputStream, string3, u.Zj());
                return byteArrayOutputStream.toByteArray();
            }
            return null;
        }
        catch (Throwable throwable) {
            throw this.a(throwable, this.JH);
        }
    }

    @Override
    public int getExportChunkCount(Properties properties) throws ViewerException {
        try {
            String string;
            this.JH = dw.b(this.Iq, properties);
            Engine engine = this.checkEngine(this.JH);
            switch (string = properties.getProperty("export_fmt")) {
                case "svg": {
                    this.Is = 0;
                    return engine.getPageCount() + 1;
                }
                case "png": 
                case "jpeg": 
                case "jpg": 
                case "gif": 
                case "bmp": {
                    int n2 = engine.getPageCount();
                    if (n2 > 1) {
                        this.Is = 1;
                        this.Rt = new a(null);
                        this.Rs = new ZipOutputStream(new BufferedOutputStream(this.Rt, 4096));
                        return 0;
                    }
                    this.Rt = null;
                }
            }
            if (string.startsWith("htm")) {
                this.Is = -1;
                return engine.getPageCount() + 2;
            }
            this.Is = 1;
            return engine.getPageCount();
        }
        catch (Throwable throwable) {
            throw this.a(throwable, this.JH);
        }
    }

    @Override
    public byte[] getGroupTree() throws ViewerException {
        try {
            Engine engine = this.checkEngine(this.Iq);
            return engine.getGroupTree();
        }
        catch (Exception exception) {
            throw this.a(exception, this.Iq);
        }
    }

    @Override
    public byte[] refreshPageData(int n2) throws ViewerException {
        this.isRefresh = true;
        this.Rq.clear();
        return this.getPageData(n2);
    }

    @Override
    public void setReportProperty(String string, String string2) {
        if (string2 == null) {
            this.Iq.remove(string);
        } else {
            this.Iq.setProperty(string, string2);
        }
    }

    @Override
    public final String getReportProperty(String string) {
        return this.Iq.getProperty(string);
    }

    @Override
    public void setPromptOnRefresh(boolean bl2) {
        this.It = bl2;
    }

    @Override
    public boolean isPromptOnRefresh() {
        return this.It;
    }

    private ViewerException a(Throwable throwable, Properties properties) {
        return this.a(StringFunctions.getUserFriendlyErrorMessage(throwable), throwable, properties);
    }

    private ViewerException a(String string, Throwable throwable, Properties properties) {
        int n2;
        if (throwable instanceof PromptRequestWarning) {
            Prompt[] promptArray = ((PromptRequestWarning)throwable).adz;
            PromptData[] promptDataArray = new PromptData[promptArray.length];
            for (int i2 = 0; i2 < promptArray.length; ++i2) {
                Prompt prompt = promptArray[i2];
                promptDataArray[i2] = promptArray[i2].notUsed ? new PromptData(true) : new PromptData(prompt.getName(), prompt.getDisplayName(), prompt.getSubreportName(), prompt.promptText, prompt.defaultValues, prompt.descs, prompt.valueTypeNewProt, prompt.discrete, prompt.range, prompt.multi, prompt.isEditable, prompt.onlyDescs, prompt.informixPrompt, prompt.editMask, prompt.minValue, prompt.maxValue);
                promptDataArray[i2].setCascadingParent(prompt.getCascadingParent());
            }
            return new ViewerException(promptDataArray);
        }
        if (throwable instanceof ViewerException) {
            return (ViewerException)throwable;
        }
        int n3 = 0;
        Cache cache = Cache.getCache();
        int n4 = n2 = cache != null ? cache.getType() : -1;
        if (throwable instanceof HasErrorCode) {
            n3 = ((HasErrorCode)((Object)throwable)).getErrorCode();
        }
        return new ViewerException(n3, string, properties.getProperty("export_fmt"), Engine.getVersion(), System.getProperty("java.version", "") + "; " + System.getProperty("java.vm.name", "") + "; " + System.getProperty("java.vendor"), System.getProperty("os.name", "") + " " + System.getProperty("os.version", ""), n2, "2.1", throwable);
    }

    @Override
    public void setReportTitle(String string) {
        this.title = string;
    }

    @Override
    public String getReportTitle() {
        return this.title;
    }

    @Override
    public RenderData getCopy() {
        EngineRenderData engineRenderData = new EngineRenderData(this.url);
        engineRenderData.getProperties().putAll((Map<?, ?>)this.getProperties());
        engineRenderData.isRefresh = this.isRefresh;
        return engineRenderData;
    }

    @Override
    public Properties getProperties() {
        return this.Iq;
    }

    @Override
    public void stop() {
        Enumeration enumeration = this.Rq.elements();
        while (enumeration.hasMoreElements()) {
            Engine engine = (Engine)enumeration.nextElement();
            if (engine == null) continue;
            engine.stop("API call EngineRenderData.stop()");
        }
        this.Rq.clear();
    }

    @Override
    public byte[] search(String string, int n2, int n3) {
        try {
            return new com.inet.report.ajax.a(this).search(string, n2, n3);
        }
        catch (ViewerException viewerException) {
            return cg.b(viewerException, this.Iq);
        }
    }

    @Override
    public byte[] getFontData(int n2) {
        try {
            Engine engine = this.checkEngine(this.Iq);
            return engine.getFontData(n2);
        }
        catch (ReportException reportException) {
            return cg.b(reportException, this.Iq);
        }
    }

    @Override
    public void resetServerCacheTimeout() {
        throw new ViewerException("resetting does not work for EngineRenderData. You should not see this error.");
    }

    private static class a
    extends OutputStream {
        private final ArrayList<byte[]> Rv = new ArrayList();

        private a() {
        }

        @Override
        public void write(int n2) throws IOException {
            this.Rv.add(new byte[]{(byte)n2});
        }

        @Override
        public void write(byte[] byArray, int n2, int n3) throws IOException {
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, n2, byArray2, 0, n3);
            this.Rv.add(byArray2);
        }

        int jf() {
            return this.Rv.size();
        }

        byte[] jg() {
            if (this.Rv.size() > 0) {
                return this.Rv.remove(0);
            }
            return null;
        }

        /* synthetic */ a(ac ac2) {
            this();
        }
    }
}

