/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.report.BaseUtils;
import com.inet.report.CascadingSource;
import com.inet.report.Database;
import com.inet.report.DatabaseField;
import com.inet.report.Datasource;
import com.inet.report.Engine;
import com.inet.report.Field;
import com.inet.report.PromptField;
import com.inet.report.ReportException;
import com.inet.report.SQLValueProvider;
import com.inet.report.TableSource;
import com.inet.report.parser.FatalParserException;
import com.inet.report.parser.NodeParser;
import com.inet.report.parser.XMLTag;
import java.util.Map;
import org.xml.sax.Attributes;

public class FieldValueProvider
extends SQLValueProvider
implements CascadingSource {
    private Datasource bF;
    private int Jk;
    private DatabaseField Tq;
    private DatabaseField Tr;

    public FieldValueProvider(DatabaseField databaseField, DatabaseField databaseField2, int n2) {
        if (databaseField == null) {
            throw new IllegalArgumentException("values database field is not allowed to be null");
        }
        this.aD(n2);
        this.setValues(databaseField);
        this.Tq = databaseField2;
        this.Jk = n2;
        this.bF = databaseField.Np.getDatasource();
        this.a(databaseField, databaseField2);
    }

    FieldValueProvider() {
    }

    private void a(DatabaseField databaseField, DatabaseField databaseField2) {
        if (databaseField2 != null && !databaseField2.Np.getDatasource().equals(this.bF)) {
            throw new IllegalArgumentException("database fields do not come from the same data source!");
        }
        if (databaseField2 != null && !databaseField2.Np.equals(databaseField.Np)) {
            throw new IllegalArgumentException("database fields do not come from the same table source!");
        }
        if (databaseField.Np.getSql() != null) {
            throw new IllegalArgumentException("database field comes from an SQL Query, this is not allowed!");
        }
    }

    protected String getSQL(String string) {
        try {
            this.aD(this.Jk);
            TableSource tableSource = this.getValues().Np;
            Datasource datasource = tableSource.getDatasource();
            Engine engine = datasource.getEngine();
            Database database = datasource.getDatabase();
            String string2 = database.getSqlIdentifier_Alias(engine.getDatabaseTables(), this.getValues().getName());
            String string3 = null;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("select ").append(string2);
            if (this.Tq != null) {
                string3 = database.getSqlIdentifier_Alias(engine.getDatabaseTables(), this.Tq.getName());
                stringBuffer.append(", ").append(string3);
            }
            stringBuffer.append(" from ").append(tableSource.sp()).append(' ').append(database.getConfiguration().getAliasToken()).append(' ').append(tableSource.getAlias());
            stringBuffer.append(' ').append(string);
            stringBuffer.append("group by " + string2);
            if (this.Tq != null) {
                stringBuffer.append(", ").append(string3);
            }
            if (this.Jk != 2 && database.isUseOrderBy()) {
                stringBuffer.append(" order by ").append(string2);
                if (this.Jk == 0) {
                    stringBuffer.append(" ASC");
                } else if (this.Jk == 1) {
                    stringBuffer.append(" DESC");
                }
            }
            return stringBuffer.toString();
        }
        catch (ReportException reportException) {
            BaseUtils.printStackTrace(reportException);
            return "";
        }
    }

    @Override
    public String getSQL() {
        return this.getSQL("");
    }

    private void aD(int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("sort type " + n2 + " is not a valid sort type.");
            }
        }
    }

    public int getSortType() {
        return this.Jk;
    }

    public void setSortType(int n2) {
        this.aD(n2);
        this.Jk = n2;
    }

    public DatabaseField getDescriptions() {
        return this.Tq;
    }

    public void setDescriptions(DatabaseField databaseField) {
        this.a(this.getValues(), databaseField);
        this.Tq = databaseField;
    }

    public DatabaseField getValues() {
        return this.Tr;
    }

    public void setValues(DatabaseField databaseField) {
        if (databaseField == null) {
            throw new IllegalArgumentException("values field was null");
        }
        this.a(databaseField, this.Tq);
        this.Tr = databaseField;
    }

    @Override
    public Datasource getDatasource() {
        return this.bF;
    }

    public void setDatasource(Datasource datasource) {
        if (datasource == null) {
            throw new IllegalArgumentException("datasource was null");
        }
        this.bF = datasource;
    }

    @Override
    public String getFieldRefName() {
        TableSource tableSource = this.getValues().Np;
        Datasource datasource = tableSource.getDatasource();
        Engine engine = datasource.getEngine();
        Database database = datasource.getDatabase();
        try {
            return database.getSqlIdentifier_Alias(engine.getDatabaseTables(), this.getValues().getName());
        }
        catch (ReportException reportException) {
            BaseUtils.printStackTrace(reportException);
            return "";
        }
    }

    @Override
    public NodeParser parseElement(XMLTag xMLTag, String string, Attributes attributes, Map<String, Object> map) throws FatalParserException {
        Engine engine = (Engine)map.get(PromptField.b.adw.name());
        try {
            switch (a.valueOf(string)) {
                case Tu: {
                    String string2 = attributes.getValue("name");
                    String string3 = attributes.getValue("value");
                    Field field = engine.DE.a(false, string3);
                    if (field == null) {
                        return null;
                    }
                    if (this.bF == null) {
                        this.bF = ((DatabaseField)field).getTableSource().getDatasource();
                    }
                    if ("dynamic value field".equals(string2)) {
                        this.setValues((DatabaseField)field);
                        break;
                    }
                    if (!"dynamic description field".equals(string2)) break;
                    this.setDescriptions((DatabaseField)field);
                    break;
                }
                case Tt: {
                    String string4 = attributes.getValue("value");
                    this.setSortType(Integer.parseInt(string4));
                }
            }
        }
        catch (Throwable throwable) {
            BaseUtils.printStackTrace(throwable);
        }
        return null;
    }

    private static enum a {
        Tt,
        Tu;

    }
}

