/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.report.BaseUtils;
import com.inet.report.DefaultValue;
import com.inet.report.Engine;
import com.inet.report.FormulaField;
import com.inet.report.ReportException;

public class FormulaDefaultValue
extends DefaultValue {
    private String TP;
    private boolean TQ;
    private Engine dC;
    private FormulaField TR;

    protected FormulaDefaultValue(Engine engine, FormulaField formulaField, String string, int n2) {
        super(string, n2);
        this.dC = engine;
        this.TP = formulaField.getFormula();
        this.TQ = formulaField.getSyntax() == 1002;
        this.TR = formulaField;
    }

    public boolean isBasicSyntax() {
        return this.TQ;
    }

    @Override
    public Object getValue() {
        try {
            return this.dC.DE.ks().a(this.TP, this.TQ, null, null);
        }
        catch (ReportException reportException) {
            BaseUtils.printStackTrace(reportException);
            return null;
        }
    }

    @Override
    public void setValue(Object object) {
        if (!(object instanceof FormulaField)) {
            throw new IllegalArgumentException("can not set anything but a formula field as a FormulaDefaultValue's value: " + object);
        }
        this.TP = ((FormulaField)object).getFormula();
    }

    public String toString() {
        try {
            String string = "<html><b>formula:</b>&nbsp;<i>" + this.TP.replaceAll("\\s", "&nbsp;") + "</i>";
            return string;
        }
        catch (Exception exception) {
            return this.TP;
        }
    }

    public String getFormulaText() {
        return this.TP;
    }

    public FormulaField getUnderlyingFormulaField() {
        return this.TR;
    }

    public void setEngine(Engine engine) {
        this.dC = engine;
    }

    public void setUnderlyingFormulaField(FormulaField formulaField) {
        this.TR = formulaField;
        this.TP = formulaField.getFormula();
    }
}

