/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.report.BaseUtils;
import com.inet.report.CascadingValueProvider;
import com.inet.report.Datasource;
import com.inet.report.DefaultValue;
import com.inet.report.DynamicValueProvider;
import com.inet.report.Engine;
import com.inet.report.Field;
import com.inet.report.FieldValueProvider;
import com.inet.report.Fields;
import com.inet.report.FormulaDefaultValue;
import com.inet.report.FormulaField;
import com.inet.report.FormulaRange;
import com.inet.report.PromptRequestWarning;
import com.inet.report.QueryValueProvider;
import com.inet.report.ReferenceHolder;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.SQLValueProvider;
import com.inet.report.TableSource;
import com.inet.report.ah;
import com.inet.report.bq;
import com.inet.report.cb;
import com.inet.report.cc;
import com.inet.report.config.structure.model.ConfigKey;
import com.inet.report.dw;
import com.inet.report.formula.Evaluable;
import com.inet.report.i18n.ErrorCode;
import com.inet.report.i18n.Msg;
import com.inet.report.parser.FatalParserException;
import com.inet.report.parser.NodeParser;
import com.inet.report.parser.XMLTag;
import com.inet.report.q;
import com.inet.report.util.s;
import com.inet.report.y;
import com.inet.viewer.PromptValue;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import org.xml.sax.Attributes;

public class PromptField
extends Field
implements ReferenceHolder {
    transient boolean acF;
    static boolean acG;
    private ArrayList<DefaultValue> acH;
    private DynamicValueProvider acI;
    String acJ;
    TableSource acK;
    String promptText;
    boolean acL;
    int acM;
    boolean range;
    Object acN;
    Object acO;
    String editMask = "";
    boolean acP;
    int acQ;
    boolean acR;
    boolean acS;
    private boolean editable = true;
    private boolean acT;
    Integer acU;
    int acV;
    Object value;
    private Evaluable acW;
    public static final int DISCRETE_VALUE = 0;
    public static final int RANGE_VALUE = 1;
    public static final int DISCRETE_AND_RANGE_VALUE = 2;
    private y Vu = new y(this);

    PromptField(cc cc2) {
        this.type = 16;
        this.DE = cc2;
        this.editable = true;
        this.acR = true;
    }

    @Override
    public final void setName(String string) {
        if (string != null) {
            string = string.trim();
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("The name of a prompt field cannot be empty");
        }
        if (string.equals(this.name)) {
            return;
        }
        if (string.equalsIgnoreCase(this.name)) {
            try {
                this.rename(string);
            }
            catch (ReportException reportException) {
                throw new IllegalArgumentException("Name not allowed", reportException);
            }
            return;
        }
        if (this.DE == null) {
            return;
        }
        if (Fields.a((Field[])this.DE.rg(), string)) {
            throw ah.b("PromptField", string, null);
        }
        try {
            this.rename(string);
        }
        catch (ReportException reportException) {
            throw new IllegalArgumentException("Name not allowed", reportException);
        }
    }

    public final String getPromptText() {
        return this.promptText;
    }

    public final void setPromptText(String string) {
        this.promptText = string;
    }

    public final Object getPromptValue() {
        return this.getValue();
    }

    void o(Object object) throws ReportException {
        String string;
        if (!this.range) {
            return;
        }
        if (this.acN == null && this.acO == null) {
            return;
        }
        if (object instanceof FormulaRange) {
            FormulaRange formulaRange = (FormulaRange)object;
            this.o(formulaRange.getFrom());
            this.o(formulaRange.getTo());
            return;
        }
        if (object instanceof Object[]) {
            for (int i2 = 0; i2 < ((Object[])object).length; ++i2) {
                this.o(((Object[])object)[i2]);
            }
            return;
        }
        switch (this.getPromptType()) {
            case 11: {
                if (object instanceof String && (this.acN == null || (double)((String)object).length() >= ((Number)this.acN).doubleValue()) && (this.acO == null || (double)((String)object).length() <= ((Number)this.acO).doubleValue())) {
                    return;
                }
            }
            case 6: 
            case 7: {
                if (!(object instanceof Number)) break;
                Serializable serializable = (Number)object;
                if (this.acN != null && !(((Number)serializable).doubleValue() >= ((Number)this.acN).doubleValue()) || this.acO != null && !(((Number)serializable).doubleValue() <= ((Number)this.acO).doubleValue())) break;
                return;
            }
            case 8: {
                return;
            }
            case 9: 
            case 10: 
            case 15: {
                if (!(object instanceof java.util.Date)) break;
                Serializable serializable = (java.util.Date)object;
                if (this.acN != null && !((java.util.Date)this.acN).before((java.util.Date)serializable) && !this.acN.equals(serializable) || this.acO != null && !((java.util.Date)this.acO).after((java.util.Date)serializable) && !this.acO.equals(serializable)) break;
                return;
            }
        }
        int n2 = ErrorCode.valueNoBetweenMinMax.getErrorCodeNumber();
        switch (this.getPromptType()) {
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                string = Msg.getMsg("valueNoBetweenMinMax", this.acN, this.acO, this.name);
                break;
            }
            case 8: {
                string = "Range limitations for ranges with boolean type make no sense.";
                break;
            }
            default: {
                string = "Unknown value type for prompt " + this.name;
            }
        }
        throw new PromptRequestWarning(string, n2, Engine.t(this.DE));
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void setPromptValue(Object object) throws ReportException {
        if (object == null) {
            this.value = object;
            this.acF = true;
            return;
        }
        if (object instanceof PromptValue) {
            this.setPromptValueAsFormula("formula:" + ((PromptValue)object).getStringRepresentation());
            return;
        }
        if (this.acL) {
            if (!(object instanceof Object[])) {
                Object[] objectArray = new Object[]{String.valueOf(this.acL)};
                throw ReportExceptionFactory.createReportException(ErrorCode.WrongMultipleDiscreteValue, objectArray);
            }
        } else {
            if (this.acM == 0) {
                if (!(object instanceof Object[]) && !(object instanceof FormulaRange)) {
                    PromptField.a(object, this.valueType, this.name, this.jv());
                    if (this.range) {
                        this.o(object);
                    }
                    this.acF = true;
                    this.value = object;
                    return;
                }
                Object[] objectArray = new Object[]{"Object"};
                this.getDiscreteOrRangeType();
                throw ReportExceptionFactory.createReportException(ErrorCode.WrongDiscreteValue, objectArray);
            }
            if (this.acM != 1) {
                if (this.acM != 2) return;
                Object[] objectArray = new Object[]{String.valueOf(this.acL)};
                throw ReportExceptionFactory.createReportException(ErrorCode.WrongMultipleDiscreteValue, objectArray);
            }
            if (!(object instanceof FormulaRange)) {
                Object[] objectArray = new Object[]{"FormulaRange"};
                throw ReportExceptionFactory.createReportException(ErrorCode.WrongDiscreteValue, objectArray);
            }
            PromptField.a(object, this.valueType, this.name, this.jv());
            if (this.range) {
                this.o(object);
            }
            this.acF = true;
            this.value = object;
            return;
        }
        Object[] objectArray = (Object[])object;
        int n2 = 0;
        while (true) {
            if (n2 >= objectArray.length) {
                this.acF = true;
                this.value = object;
                return;
            }
            PromptField.a(objectArray[n2], this.valueType, this.name, this.jv());
            if (objectArray[n2] instanceof FormulaRange) {
                if (this.acM == 0) {
                    Object[] objectArray2 = new Object[]{String.valueOf(this.acM)};
                    throw ReportExceptionFactory.createReportException(ErrorCode.WrongRangeValue, objectArray2);
                }
                this.o(objectArray[n2]);
            } else if (this.acM == 1) {
                Object[] objectArray3 = new Object[]{String.valueOf(this.acM)};
                throw ReportExceptionFactory.createReportException(ErrorCode.WrongRangeValue, objectArray3);
            }
            ++n2;
        }
    }

    public void setPromptValueAsFormula(String string) throws ReportException {
        this.DE.getEngine().a(this, string);
    }

    public final int getPromptType() {
        if (this.valueType == -1) {
            return this.valueType;
        }
        return this.valueType % 128;
    }

    public final void setPromptType(int n2) {
        if (this.valueType == n2) {
            return;
        }
        this.valueType = n2;
        this.acN = null;
        this.acO = null;
        if (n2 % 128 != 6 && n2 % 128 != -1 && n2 % 128 != 7 && n2 % 128 != 8 && n2 % 128 != 9 && n2 % 128 != 10 && n2 % 128 != 15 && n2 % 128 != 11 && n2 % 128 != 14) {
            throw new IllegalArgumentException("illegal prompt value type " + n2 + "! Must be one of the Field value type constants!");
        }
        this.DE.getFields().a(this, 2);
    }

    public final void setUseRange(boolean bl2) {
        this.range = bl2;
    }

    public final boolean getUseRange() {
        return this.range;
    }

    public final void setDescriptionOnly(boolean bl2) {
        this.acT = bl2;
    }

    public final boolean isDescriptionOnly() {
        return this.acT;
    }

    public final void setEditable(boolean bl2) {
        if (!bl2 && this.isPasswordField()) {
            throw new UnsupportedOperationException("password fields must be editable!");
        }
        this.editable = bl2;
    }

    public final boolean isEditable() {
        return this.editable;
    }

    public boolean isValueSet() {
        return this.acF;
    }

    public final boolean isPasswordField() {
        return "password".equals(this.editMask);
    }

    public final void setPasswordField(boolean bl2) {
        if (bl2) {
            this.editMask = "password";
            this.setDefaultValues(null);
            this.setEditable(true);
            this.setAllowMultipleValues(false);
            try {
                this.setDiscreteOrRangeType(0);
            }
            catch (ReportException reportException) {
                BaseUtils.printStackTrace(reportException);
            }
        } else {
            this.editMask = "";
        }
    }

    public void setDiscreteOrRangeType(int n2) throws ReportException {
        if (n2 != 0 && this.isPasswordField()) {
            throw new UnsupportedOperationException("A password field must have the discrete type DISCRETE_VALUE");
        }
        if (n2 < 0 || n2 > 2) {
            throw ReportExceptionFactory.createReportException(ErrorCode.outOfRange2, new Object[0]);
        }
        this.acM = n2;
    }

    public int getDiscreteOrRangeType() {
        return this.acM;
    }

    public void setAllowMultipleValues(boolean bl2) {
        if (this.isPasswordField() && bl2) {
            throw new UnsupportedOperationException("Password Fields can not be set to allow multiple values.");
        }
        this.acL = bl2;
    }

    public boolean getAllowMultipleValues() {
        return this.acL;
    }

    public int getValuesCount() {
        if (this.getValue() == null) {
            return 0;
        }
        if (this.getValue() instanceof Object[]) {
            return ((Object[])this.getValue()).length;
        }
        return 1;
    }

    public void setMinRangeValue(Object object) throws ReportException {
        if (!this.range) {
            throw new IllegalStateException("Range is disabled");
        }
        if (object == null) {
            this.acN = null;
        } else {
            this.setMinMaxRangeValues(object, this.acO);
        }
    }

    public void setMaxRangeValue(Object object) throws ReportException {
        if (!this.range) {
            throw new IllegalStateException("Range is disabled");
        }
        if (object == null) {
            this.acO = null;
        } else {
            this.setMinMaxRangeValues(this.acN, object);
        }
    }

    public void setMinMaxRangeValues(Object object, Object object2) throws ReportException {
        if (this.range) {
            switch (this.getPromptType()) {
                case 11: {
                    double d2;
                    if (object instanceof Number) {
                        d2 = ((Number)object).doubleValue();
                        if (d2 < 0.0) {
                            Object[] objectArray = new Object[]{object};
                            throw ReportExceptionFactory.createReportException(ErrorCode.MinNegativeForString, objectArray);
                        }
                        if (d2 - Math.floor(d2) > 0.0) {
                            Object[] objectArray = new Object[]{object};
                            throw ReportExceptionFactory.createReportException(ErrorCode.StringLimitIsFractional, objectArray);
                        }
                    }
                    if (object2 instanceof Number) {
                        d2 = ((Number)object2).doubleValue();
                        if (d2 < 0.0) {
                            Object[] objectArray = new Object[]{object2};
                            throw ReportExceptionFactory.createReportException(ErrorCode.MaxNegativeForString, objectArray);
                        }
                        if (d2 - Math.floor(d2) > 0.0) {
                            Object[] objectArray = new Object[]{object2};
                            throw ReportExceptionFactory.createReportException(ErrorCode.StringLimitIsFractional, objectArray);
                        }
                    }
                }
                case 6: 
                case 7: {
                    if (object instanceof Number && object2 instanceof Number) {
                        if (((Number)object).doubleValue() > ((Number)object2).doubleValue()) {
                            Object[] objectArray = new Object[]{object2, object};
                            throw ReportExceptionFactory.createReportException(ErrorCode.MaxLessThanMin, objectArray);
                        }
                    } else if (!(object == null && object2 instanceof Number || object instanceof Number && object2 == null || object == null && object2 == null)) {
                        Object[] objectArray = new Object[]{};
                        throw ReportExceptionFactory.createReportException(ErrorCode.MinMaxNotNumber, objectArray);
                    }
                    this.acN = object;
                    this.acO = object2;
                    break;
                }
                case 8: {
                    Object[] objectArray = new Object[]{};
                    throw ReportExceptionFactory.createReportException(ErrorCode.rangeOnBoolean, objectArray);
                }
                case 9: {
                    if (object instanceof Date && object2 instanceof Date) {
                        if (((Date)object).getTime() > ((Date)object2).getTime()) {
                            Object[] objectArray = new Object[]{object, object2};
                            throw ReportExceptionFactory.createReportException(ErrorCode.MaxLessThanMin, objectArray);
                        }
                    } else if (!(object == null && object2 instanceof Date || object instanceof Date && object2 == null || object == null && object2 == null)) {
                        Object[] objectArray = new Object[]{};
                        throw ReportExceptionFactory.createReportException(ErrorCode.noDateInstance, objectArray);
                    }
                    this.acN = object;
                    this.acO = object2;
                    break;
                }
                case 15: {
                    if (object instanceof Timestamp && object2 instanceof Timestamp) {
                        if (((Timestamp)object).getTime() > ((Timestamp)object2).getTime()) {
                            Object[] objectArray = new Object[]{object, object2};
                            throw ReportExceptionFactory.createReportException(ErrorCode.MaxLessThanMin, objectArray);
                        }
                    } else if (!(object == null && object2 instanceof Timestamp || object instanceof Timestamp && object2 == null || object == null && object2 == null)) {
                        Object[] objectArray = new Object[]{};
                        throw ReportExceptionFactory.createReportException(ErrorCode.noTimeStampInstance, objectArray);
                    }
                    this.acN = object;
                    this.acO = object2;
                    break;
                }
                case 10: {
                    if (object instanceof Time && object2 instanceof Time) {
                        if (((Time)object).getTime() > ((Time)object2).getTime()) {
                            Object[] objectArray = new Object[]{object, object2};
                            throw ReportExceptionFactory.createReportException(ErrorCode.MaxLessThanMin, objectArray);
                        }
                    } else if (!(object == null && object2 instanceof Time || object instanceof Time && object2 == null || object == null && object2 == null)) {
                        Object[] objectArray = new Object[]{};
                        throw ReportExceptionFactory.createReportException(ErrorCode.noTimeInstance, objectArray);
                    }
                    this.acN = object;
                    this.acO = object2;
                    break;
                }
                default: {
                    Object[] objectArray = new Object[]{this.name};
                    throw ReportExceptionFactory.createReportException(ErrorCode.wrongPromptType, objectArray);
                }
            }
        } else {
            Object[] objectArray = new Object[]{};
            throw ReportExceptionFactory.createReportException(ErrorCode.disabledRange, objectArray);
        }
    }

    public Object getMinRangeValue() throws ReportException {
        if (this.range) {
            switch (this.getPromptType()) {
                case 6: 
                case 7: 
                case 11: {
                    return this.acN;
                }
                case 8: {
                    Object[] objectArray = new Object[]{};
                    throw ReportExceptionFactory.createReportException(ErrorCode.rangeOnBoolean, objectArray);
                }
                case 9: {
                    return this.acN;
                }
                case 15: {
                    return this.acN;
                }
                case 10: {
                    return this.acN;
                }
            }
            Object[] objectArray = new Object[]{this.name};
            throw ReportExceptionFactory.createReportException(ErrorCode.wrongPromptType, objectArray);
        }
        Object[] objectArray = new Object[]{};
        throw ReportExceptionFactory.createReportException(ErrorCode.disabledRange, objectArray);
    }

    public Object getMaxRangeValue() throws ReportException {
        if (this.range) {
            switch (this.getPromptType()) {
                case 6: 
                case 7: 
                case 11: {
                    return this.acO;
                }
                case 8: {
                    Object[] objectArray = new Object[]{};
                    throw ReportExceptionFactory.createReportException(ErrorCode.rangeOnBoolean, objectArray);
                }
                case 9: {
                    return this.acO;
                }
                case 15: {
                    return this.acO;
                }
                case 10: {
                    return this.acO;
                }
            }
            Object[] objectArray = new Object[]{this.name};
            throw ReportExceptionFactory.createReportException(ErrorCode.wrongPromptType, objectArray);
        }
        Object[] objectArray = new Object[]{};
        throw ReportExceptionFactory.createReportException(ErrorCode.disabledRange, objectArray);
    }

    public void setPromptValueDescriptions(String[] stringArray) {
        if (stringArray == null) {
            throw new NullPointerException("description array is null");
        }
        int n2 = this.getDefaultValueCount();
        if (n2 != stringArray.length) {
            throw new IllegalArgumentException("description array's length(" + stringArray.length + ") does not match default value count (" + n2 + ")");
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            this.getDefaultValue(i2).setDescription(string);
        }
    }

    public String[] getPromptValueDescriptions() {
        if (this.acI != null) {
            DefaultValue[] defaultValueArray = this.acI.getDefaultValues();
            String[] stringArray = new String[defaultValueArray.length];
            for (int i2 = 0; i2 < defaultValueArray.length; ++i2) {
                DefaultValue defaultValue = defaultValueArray[i2];
                stringArray[i2] = defaultValue.getDescription();
            }
            return stringArray;
        }
        if (this.acH == null) {
            return new String[0];
        }
        String[] stringArray = new String[this.getDefaultValueCount()];
        for (int i3 = 0; i3 < this.getDefaultValueCount(); ++i3) {
            stringArray[i3] = this.getDefaultValue(i3).getDescription();
        }
        return stringArray;
    }

    @Override
    Field[] ak(int n2) {
        return new PromptField[n2];
    }

    void mH() throws ReportException {
        this.value = null;
        int n2 = this.getDefaultValueCount();
        if (acG || this.acH == null || n2 == 0) {
            return;
        }
        if (this.acL) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object = this.getDefaultValue(i2).getValue();
                if (!(object instanceof FormulaRange) && this.getDiscreteOrRangeType() == 1) continue;
                arrayList.add(object);
            }
            this.setPromptValue(arrayList.toArray());
        } else if (this.getDiscreteOrRangeType() != 0) {
            for (int i3 = 0; i3 < n2; ++i3) {
                Object object = this.getDefaultValue(i3).getValue();
                if (!(object instanceof FormulaRange)) continue;
                this.setPromptValue(object);
            }
        } else {
            this.setPromptValue(this.getDefaultValue(0).getValue());
        }
    }

    @Override
    public int getValueType() {
        int n2 = this.valueType;
        if (n2 == -1) {
            return n2;
        }
        if (this.acL && !s.eQ(n2)) {
            n2 += 256;
        }
        if (this.acM != 0 && !s.eR(n2)) {
            n2 += 128;
        }
        return n2;
    }

    @Override
    public String paramString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("\n\tText: ").append(this.promptText);
        stringBuffer.append("\n\tType: ").append(this.valueType);
        stringBuffer.append("\n\tValue:").append(this.getValue());
        stringBuffer.append("\n\tLink: ").append(this.acU);
        return stringBuffer.toString();
    }

    public String getPromptValueAsFormula() {
        return s.i(this.value, this.valueType);
    }

    public void setDefaultValueProvider(DynamicValueProvider dynamicValueProvider) {
        if (dynamicValueProvider instanceof CascadingValueProvider && this.a((CascadingValueProvider)dynamicValueProvider)) {
            throw new IllegalArgumentException("Circular dependency: this prompt is already an ancestor of the prompt being set as parent!");
        }
        this.acI = dynamicValueProvider;
        this.resetReferences();
        this.setReferences();
        if (dynamicValueProvider != null) {
            this.acH = null;
        }
    }

    private boolean a(CascadingValueProvider cascadingValueProvider) {
        PromptField promptField = cascadingValueProvider.getParent();
        ArrayList<PromptField> arrayList = new ArrayList<PromptField>();
        while (true) {
            if (arrayList.contains(promptField)) {
                return true;
            }
            arrayList.add(promptField);
            if (promptField == this) {
                return true;
            }
            DynamicValueProvider dynamicValueProvider = promptField.getDefaultValueProvider();
            if (!(dynamicValueProvider instanceof CascadingValueProvider)) break;
            promptField = ((CascadingValueProvider)dynamicValueProvider).getParent();
        }
        return false;
    }

    public DynamicValueProvider getDefaultValueProvider() {
        return this.acI;
    }

    public DefaultValue[] getDefaultValues() {
        if (this.acI != null) {
            DefaultValue[] defaultValueArray;
            for (DefaultValue defaultValue : defaultValueArray = this.acI.getDefaultValues()) {
                if (DefaultValue.b(defaultValue.getValue(), this.valueType)) continue;
                BaseUtils.error("dynamic default values were not the correct type: " + defaultValue.getValue().getClass().getCanonicalName() + " for value type " + this.jv());
                return new DefaultValue[0];
            }
            if (this.acI instanceof SQLValueProvider && defaultValueArray.length == 1000) {
                this.setEditable(true);
            }
            return defaultValueArray;
        }
        if (this.acH == null) {
            return null;
        }
        return this.acH.toArray(new DefaultValue[0]);
    }

    public void setDefaultValues(DefaultValue[] defaultValueArray) {
        DefaultValue defaultValue;
        int n2;
        if (this.acH != null) {
            for (n2 = 0; n2 < this.acH.size(); ++n2) {
                defaultValue = this.acH.get(n2);
                if (!(defaultValue instanceof FormulaDefaultValue)) continue;
                FormulaField.e(((FormulaDefaultValue)defaultValue).getUnderlyingFormulaField());
            }
        }
        if (defaultValueArray == null || defaultValueArray.length == 0 || defaultValueArray[0] == null) {
            this.acH = null;
            this.acI = null;
            return;
        }
        if (this.isPasswordField()) {
            throw new UnsupportedOperationException("A password field can not have default values");
        }
        this.acH = new ArrayList();
        this.acI = null;
        for (n2 = 0; n2 < defaultValueArray.length; ++n2) {
            if (defaultValueArray[n2] instanceof FormulaDefaultValue) continue;
            try {
                this.o(defaultValueArray[n2].getValue());
                continue;
            }
            catch (ReportException reportException) {
                throw new IllegalArgumentException("The default value '" + defaultValueArray[n2].getValue() + "' is not in the allowed value range.");
            }
        }
        this.acH.clear();
        for (n2 = 0; n2 < defaultValueArray.length; ++n2) {
            defaultValue = defaultValueArray[n2];
            this.acH.add(defaultValue);
        }
        this.mI();
        this.resetReferences();
        this.setReferences();
    }

    public String getDefaultPromptValuesAsString() {
        DefaultValue[] defaultValueArray = this.getDefaultValues();
        if (defaultValueArray == null) {
            return "";
        }
        return s.h(defaultValueArray, this.valueType);
    }

    public void addDefaultValue(DefaultValue defaultValue) {
        this.a(defaultValue);
        this.mI();
    }

    private void mI() {
        String string = dw.azD.get(ConfigKey.PROMPT_BEHAVIOR.getKey());
        if (this.DE != null && this.DE.id > 0 || string != null && string.equalsIgnoreCase("TAKE_VALUE_FROM_DEFAULT_VALUES")) {
            try {
                this.mH();
            }
            catch (ReportException reportException) {
                BaseUtils.printStackTrace(reportException);
                throw new IllegalArgumentException("could not set default value as prompt's value:" + reportException.getMessage());
            }
        }
    }

    private void a(DefaultValue defaultValue) {
        FormulaField formulaField;
        if (this.isPasswordField()) {
            throw new UnsupportedOperationException("Password prompts can not have default values.");
        }
        try {
            this.o(defaultValue.getValue());
        }
        catch (ReportException reportException) {
            try {
                throw new IllegalArgumentException("default value (" + defaultValue.getValue() + ") was not in the allowed range (" + this.getMinRangeValue() + " to " + this.getMaxRangeValue() + ").");
            }
            catch (ReportException reportException2) {
                BaseUtils.printStackTrace(reportException2);
            }
        }
        if (this.acH == null) {
            this.acH = new ArrayList();
        }
        if (this.acI != null) {
            this.acI = null;
        }
        this.acH.add(defaultValue);
        if (defaultValue instanceof FormulaDefaultValue && (formulaField = ((FormulaDefaultValue)defaultValue).getUnderlyingFormulaField()) != null) {
            this.addReferencedObject(formulaField);
        }
    }

    public void removeDefaultValue(int n2) {
        if (this.acH == null) {
            throw new IndexOutOfBoundsException("trying to remove a default value when there are none!");
        }
        this.acH.remove(n2);
        if (this.acH.size() == 0) {
            this.acH = null;
        }
    }

    public int getDefaultValueCount() {
        if (this.acH == null) {
            return 0;
        }
        return this.acH.size();
    }

    public void setDefaultValue(int n2, DefaultValue defaultValue) {
        try {
            this.o(defaultValue.getValue());
        }
        catch (ReportException reportException) {
            throw new IllegalArgumentException("trying to set illegal default value: " + reportException.getMessage());
        }
        if (this.acH == null) {
            throw new IndexOutOfBoundsException("" + n2 + " >= 0");
        }
        this.acH.set(n2, defaultValue);
        this.mI();
    }

    @Override
    void a(int n2, String string, bq bq2) {
        try {
            switch (n2) {
                case 210: {
                    this.range = Boolean.valueOf(string);
                    break;
                }
                case 7701: {
                    this.editMask = string;
                    break;
                }
                case 216: {
                    this.acO = this.be(string);
                    break;
                }
                case 215: {
                    this.acN = this.be(string);
                    break;
                }
                case 208: {
                    this.acM = Integer.parseInt(string);
                    break;
                }
                case 209: {
                    this.promptText = string;
                    break;
                }
                case 223: {
                    if (bq2.abx < this.getDefaultValueCount()) {
                        this.getDefaultValue(bq2.abx).setDescription(string);
                        ++bq2.abx;
                        break;
                    }
                    BaseUtils.warning("truncated prompt descriptions for prompt field " + this.getName() + " - the number of prompt values did not match the number of prompt descriptions!");
                    break;
                }
                case 221: {
                    Datasource datasource;
                    this.acJ = string;
                    if (this.acJ.trim().length() == 0) {
                        this.acJ = this.name;
                    }
                    if (this.acJ != null && (datasource = bq2.aaG.ij().rh().getDatasource(0)).getTableSourceCount() > 0 && this.acK == null) {
                        this.acK = datasource.getTableSource(0);
                    }
                    break;
                }
                case 207: {
                    this.editable = Boolean.valueOf(string);
                    break;
                }
                case 229: {
                    this.acT = Boolean.valueOf(string);
                    break;
                }
                case 206: {
                    this.acL = Boolean.valueOf(string);
                    break;
                }
                case 214: {
                    this.acU = new Integer(Integer.parseInt(string));
                    break;
                }
                case 228: {
                    try {
                        this.acK = bq2.aaG.ij().rh().getTablesource(string);
                    }
                    catch (ReportException reportException) {
                        BaseUtils.error(reportException);
                    }
                    break;
                }
                default: {
                    super.a(n2, string, bq2);
                }
            }
        }
        catch (Throwable throwable) {
            BaseUtils.printStackTrace(throwable);
        }
    }

    private Object be(String string) {
        Comparable<java.util.Date> comparable = null;
        switch (this.getPromptType()) {
            case 6: 
            case 7: 
            case 11: {
                comparable = new Double(string);
                break;
            }
            case 9: {
                comparable = Date.valueOf(string);
                break;
            }
            case 10: {
                comparable = Time.valueOf(string);
                break;
            }
            case 15: {
                comparable = Timestamp.valueOf(string);
            }
        }
        return comparable;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public boolean isParameterOfStoredProcedure() {
        return this.acJ != null && this.acK != null;
    }

    public TableSource[] getTableSources() {
        if (this.acK == null) {
            return null;
        }
        return new TableSource[]{this.acK};
    }

    public boolean isSubreportLink() {
        return this.acV > 0;
    }

    @Override
    public boolean isUsed() {
        if (this.acK != null || this.acJ != null && this.acJ.trim().length() > 0) {
            return true;
        }
        if (!super.isUsed()) {
            ReferenceHolder[] referenceHolderArray = this.getReferenceHolders();
            for (int i2 = 0; i2 < referenceHolderArray.length; ++i2) {
                if (!(referenceHolderArray[i2] instanceof PromptField) || !((PromptField)referenceHolderArray[i2]).isUsed()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    boolean d(TableSource tableSource) {
        if (super.isUsed()) {
            return false;
        }
        return this.acK == tableSource;
    }

    public DefaultValue getDefaultValue(int n2) {
        if (this.acH == null) {
            throw new IndexOutOfBoundsException("trying to retrieve a default value when there are none!");
        }
        return this.acH.get(n2);
    }

    @Override
    protected void p(PrintWriter printWriter, int n2) {
        Object object;
        Object object2;
        String string = BaseUtils.L(n2);
        StringBuilder stringBuilder = new StringBuilder();
        q.a(stringBuilder, n2, a.ada.name(), q.printBoolean(this.acL));
        q.a(stringBuilder, n2, a.adb.name(), q.af(this.acM));
        q.a(stringBuilder, n2, a.adi.name(), q.printBoolean(this.editable));
        q.a(stringBuilder, n2, a.adc.name(), q.printBoolean(this.acT));
        q.a(stringBuilder, n2, a.add.name(), this.editMask);
        if (this.range) {
            object2 = "";
            int n3 = this.getPromptType();
            if ((n3 == 6 || n3 == 7 || n3 == 11) && this.acN != null) {
                object2 = q.printDouble(((Number)this.acN).doubleValue());
            } else if (n3 == 9 && this.acN != null) {
                object2 = this.acN.toString();
            } else if (n3 == 10 && this.acN != null) {
                object2 = this.acN.toString();
            } else if (n3 == 15 && this.acN != null) {
                object2 = this.acN.toString();
            }
            if (((String)object2).length() != 0) {
                q.a(stringBuilder, n2, a.adg.name(), (String)object2);
            }
            object = "";
            if ((n3 == 6 || n3 == 7 || n3 == 11) && this.acO != null) {
                object = q.printDouble(((Number)this.acO).doubleValue());
            } else if (n3 == 9 && this.acO != null) {
                object = this.acO.toString();
            } else if (n3 == 10 && this.acO != null) {
                object = this.acO.toString();
            } else if (n3 == 15 && this.acO != null) {
                object = this.acO.toString();
            }
            if (((String)object).length() != 0) {
                q.a(stringBuilder, n2, a.adh.name(), (String)object);
            }
        }
        q.a(stringBuilder, n2, a.ade.name(), this.promptText);
        q.a(stringBuilder, n2, a.adf.name(), q.printBoolean(this.range));
        if (this.acU != null) {
            q.a(stringBuilder, n2, a.adk.name(), q.af(this.acU));
        }
        q.a(stringBuilder, n2, a.adm.name(), this.acJ);
        if (this.acK != null) {
            q.a(stringBuilder, n2, a.adl.name(), this.acK.getAlias());
        }
        if (this.acI != null) {
            stringBuilder.append(string).append("<").append("DefaultValueProvider");
            if (this.acI instanceof QueryValueProvider) {
                String string2;
                object2 = (QueryValueProvider)this.acI;
                q.a(stringBuilder, "type", "sql");
                stringBuilder.append(">\n");
                stringBuilder.append(string);
                q.a(stringBuilder, n2, a.adp.name(), ((QueryValueProvider)object2).getSQL().replaceAll("\r\n", "\n"));
                String string3 = ((QueryValueProvider)object2).getFieldRefName();
                if (string3 != null) {
                    stringBuilder.append(string);
                    q.a(stringBuilder, n2, a.adq.name(), string3);
                }
                if ((string2 = ((Datasource)(object = ((QueryValueProvider)object2).getDatasource())).getDataSourceConfigurationName()) != null) {
                    stringBuilder.append(string);
                    q.a(stringBuilder, n2, a.adr.name(), string2);
                }
            } else if (this.acI instanceof CascadingValueProvider) {
                q.a(stringBuilder, "type", "cascading");
                stringBuilder.append(">\n");
                object2 = (CascadingValueProvider)this.acI;
                stringBuilder.append(string);
                q.a(stringBuilder, n2, a.adj.name(), q.af(((FieldValueProvider)object2).getSortType()));
                stringBuilder.append(string);
                q.a(stringBuilder, n2, ((FieldValueProvider)object2).getValues(), "dynamic value field");
                if (((FieldValueProvider)object2).getDescriptions() != null) {
                    stringBuilder.append(string);
                    q.a(stringBuilder, n2, ((FieldValueProvider)object2).getDescriptions(), "dynamic description field");
                }
                stringBuilder.append(string);
                q.a(stringBuilder, n2, ((CascadingValueProvider)object2).getParent(), "cascading parent");
            } else if (this.acI instanceof FieldValueProvider) {
                q.a(stringBuilder, "type", "field");
                stringBuilder.append(">\n");
                object2 = (FieldValueProvider)this.acI;
                stringBuilder.append(string);
                q.a(stringBuilder, n2, a.adj.name(), q.af(((FieldValueProvider)object2).getSortType()));
                stringBuilder.append(string);
                q.a(stringBuilder, n2, ((FieldValueProvider)object2).getValues(), "dynamic value field");
                if (((FieldValueProvider)object2).getDescriptions() != null) {
                    stringBuilder.append(string);
                    q.a(stringBuilder, n2, ((FieldValueProvider)object2).getDescriptions(), "dynamic description field");
                }
            } else {
                stringBuilder.append(">\n");
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug("could not save dynamic value provider");
                }
            }
            stringBuilder.append(string + "<" + "/" + "DefaultValueProvider" + ">\n");
        } else if (this.acH != null) {
            int n4 = this.getDefaultValueCount();
            stringBuilder.append(string + "<" + "DefaultPromptValues" + ">\n");
            String[] stringArray = this.getPromptValueDescriptions();
            for (int i2 = 0; i2 < n4; ++i2) {
                DefaultValue defaultValue;
                stringBuilder.append(string + string + "<" + "DefaultValue");
                if (stringArray != null && stringArray.length > i2 && stringArray[i2] != null && !stringArray[i2].equals("")) {
                    stringBuilder.append(q.n("description", stringArray[i2]));
                }
                if ((defaultValue = this.getDefaultValue(i2)) instanceof FormulaDefaultValue) {
                    stringBuilder.append(">\n");
                    stringBuilder.append(string + string + string + q.Z(((FormulaDefaultValue)defaultValue).getFormulaText()) + "\n");
                    stringBuilder.append(string + string + string);
                    q.a(stringBuilder, 0, FormulaField.a.Ur.name(), q.af(((FormulaDefaultValue)defaultValue).isBasicSyntax() ? 1002 : 1001));
                    stringBuilder.append(string + string + "<" + "/" + "DefaultValue" + ">\n");
                    continue;
                }
                stringBuilder.append(q.n("value", s.h(defaultValue.getValue(), this.getPromptType())));
                stringBuilder.append("/>\n");
            }
            stringBuilder.append(string + "<" + "/" + "DefaultPromptValues" + ">\n");
        }
        if (stringBuilder.length() > 0) {
            printWriter.print(stringBuilder);
        }
    }

    @Override
    public void parseText(String string, Map<String, Object> map) {
        if ("formula".equals(map.get("defaultvaluetype"))) {
            map.put("defaultvalueformulatext", string);
        } else {
            super.parseText(string, map);
        }
    }

    @Override
    public NodeParser parseElement(XMLTag xMLTag, String string, Attributes attributes, Map<String, Object> map) throws FatalParserException {
        try {
            a a2 = a.valueOf(string);
            String string2 = attributes.getValue("value");
            switch (a2) {
                case acY: {
                    if (xMLTag != XMLTag.DefaultPromptValues) break;
                    String string3 = attributes.getValue("value");
                    String string4 = attributes.getValue("description");
                    if (string3 != null) {
                        DefaultValue defaultValue = DefaultValue.createDefaultValueFromFormula(string3, string4, this.DE.getEngine());
                        this.a(defaultValue);
                        break;
                    }
                    map.put("defaultvaluetype", "formula");
                    map.put("defaultvaluedescription", string4);
                    break;
                }
                case adt: {
                    map.put("defaultvalueformulasyntax", Integer.valueOf(string2));
                    break;
                }
                case acZ: {
                    this.setName(string2);
                    break;
                }
                case ade: {
                    this.setPromptText(string2);
                    break;
                }
                case ada: {
                    this.setAllowMultipleValues(Boolean.valueOf(string2));
                    break;
                }
                case adb: {
                    this.setDiscreteOrRangeType(Integer.valueOf(string2));
                    break;
                }
                case adc: {
                    this.setDescriptionOnly(Boolean.valueOf(string2));
                    break;
                }
                case adf: {
                    this.setUseRange(Boolean.valueOf(string2));
                    break;
                }
                case add: {
                    this.editMask = string2;
                    break;
                }
                case adi: {
                    this.setEditable(Boolean.valueOf(string2));
                    break;
                }
                case adk: {
                    this.acU = Integer.valueOf(string2);
                    break;
                }
                case adl: {
                    try {
                        this.acK = this.DE.rh().getTablesource(string2);
                    }
                    catch (ReportException reportException) {
                        BaseUtils.error(reportException);
                    }
                    break;
                }
                case adm: {
                    this.acJ = string2;
                    if (this.acJ.trim().length() != 0) break;
                    this.acJ = this.name;
                    break;
                }
                case adg: {
                    this.acN = this.be(string2);
                    break;
                }
                case adh: {
                    this.acO = this.be(string2);
                    break;
                }
                case ado: {
                    String string5 = attributes.getValue("type");
                    map.put(b.adw.name(), this.DE.getEngine());
                    SQLValueProvider sQLValueProvider = null;
                    if ("sql".equals(string5)) {
                        sQLValueProvider = new QueryValueProvider();
                    } else if ("cascading".equals(string5)) {
                        sQLValueProvider = new CascadingValueProvider();
                    } else if ("field".equals(string5)) {
                        sQLValueProvider = new FieldValueProvider();
                    }
                    map.put(b.adx.name(), sQLValueProvider);
                    return sQLValueProvider;
                }
            }
        }
        catch (ReportException reportException) {
            BaseUtils.printStackTrace(reportException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            BaseUtils.printStackTrace(illegalArgumentException);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseEndElement(XMLTag xMLTag, String string, Map<String, Object> map) throws FatalParserException {
        if (XMLTag.DefaultValue.name().equals(string)) {
            String string2 = (String)map.get("defaultvalueformulatext");
            Integer n2 = (Integer)map.get("defaultvalueformulasyntax");
            String string3 = (String)map.get("defaultvaluedescription");
            if (string2 != null && n2 != null && "formula".equals(map.get("defaultvaluetype"))) {
                try {
                    FormulaField formulaField = this.DE.getEngine().getFields().addFormulaField("defaultvalueformula", string2, 3);
                    formulaField.setSyntax(n2);
                    FormulaDefaultValue formulaDefaultValue = DefaultValue.createFormulaFieldDefaultValueFromFormula(formulaField, string3, this.getValueType(), this.DE.getEngine());
                    this.a(formulaDefaultValue);
                }
                catch (ReportException reportException) {
                    BaseUtils.printStackTrace(reportException);
                }
            }
            map.remove("defaultvalueformulatext");
            map.remove("defaultvaluedescription");
            map.remove("defaultvalueformulasyntax");
            map.remove("defaultvaluetype");
            super.parseEndElement(xMLTag, string, map);
            return;
        }
        DynamicValueProvider dynamicValueProvider = (DynamicValueProvider)map.get(b.adx.name());
        if (dynamicValueProvider != null) {
            try {
                QueryValueProvider queryValueProvider;
                if (dynamicValueProvider instanceof CascadingValueProvider) {
                    CascadingValueProvider cascadingValueProvider = (CascadingValueProvider)dynamicValueProvider;
                    if (cascadingValueProvider.getParent() == null || cascadingValueProvider.getParent().getDefaultValueProvider() == null || cascadingValueProvider.getValues() == null) {
                        BaseUtils.warning("could not read cascading prompt: parent - " + cascadingValueProvider.getParent() + "; values - " + cascadingValueProvider.getValues());
                        return;
                    }
                } else if (dynamicValueProvider instanceof FieldValueProvider) {
                    FieldValueProvider fieldValueProvider = (FieldValueProvider)dynamicValueProvider;
                    if (fieldValueProvider.getValues() == null) {
                        BaseUtils.warning("could not read dynamic prompt: values - " + fieldValueProvider.getValues());
                        return;
                    }
                } else if (dynamicValueProvider instanceof QueryValueProvider && ((queryValueProvider = (QueryValueProvider)dynamicValueProvider).getSQL() == null || queryValueProvider.getDatasource() == null)) {
                    BaseUtils.warning("could not read dynamic query-based prompt: sql - " + queryValueProvider.getSQL() + "; datasource - " + queryValueProvider.getDatasource());
                    return;
                }
                this.setDefaultValueProvider(dynamicValueProvider);
            }
            finally {
                map.remove(b.adx.name());
            }
        }
        this.mI();
        super.parseEndElement(xMLTag, string, map);
    }

    @Override
    public void addReferencedObject(cb cb2) {
        this.Vu.addReferencedObject(cb2);
    }

    @Override
    public void removeReferencedObject(cb cb2) {
        this.Vu.removeReferencedObject(cb2);
    }

    @Override
    public int getReferencedObjectCount() {
        return this.Vu.getReferencedObjectCount();
    }

    @Override
    public cb[] getReferencedObjects() {
        return this.Vu.getReferencedObjects();
    }

    @Override
    public void resetReferences() {
        this.Vu.resetReferences();
        if (this.acH != null) {
            for (int i2 = 0; i2 < this.acH.size(); ++i2) {
                FormulaField formulaField;
                DefaultValue defaultValue = this.acH.get(i2);
                if (!(defaultValue instanceof FormulaDefaultValue) || (formulaField = ((FormulaDefaultValue)defaultValue).getUnderlyingFormulaField()) == null) continue;
                formulaField.resetReferences();
            }
        }
    }

    @Override
    public final int getRealReferencedObjectCount() {
        return this.Vu.getRealReferencedObjectCount();
    }

    @Override
    public void setReferences() {
        Field field;
        Serializable serializable;
        NodeParser nodeParser;
        DynamicValueProvider dynamicValueProvider = this.getDefaultValueProvider();
        if (dynamicValueProvider != null && dynamicValueProvider instanceof CascadingValueProvider) {
            nodeParser = ((CascadingValueProvider)dynamicValueProvider).getParent();
            ((Field)nodeParser).addReferenceHolder(this);
        }
        if (dynamicValueProvider != null && dynamicValueProvider instanceof FieldValueProvider) {
            nodeParser = (FieldValueProvider)dynamicValueProvider;
            serializable = ((FieldValueProvider)nodeParser).getValues();
            serializable.addReferenceHolder(this);
            field = ((FieldValueProvider)nodeParser).getDescriptions();
            if (field != null) {
                field.addReferenceHolder(this);
            }
        }
        if (this.acH != null) {
            for (int i2 = 0; i2 < this.acH.size(); ++i2) {
                serializable = this.acH.get(i2);
                if (!(serializable instanceof FormulaDefaultValue) || (field = ((FormulaDefaultValue)serializable).getUnderlyingFormulaField()) == null) continue;
                ((FormulaField)field).resetReferences();
                ((FormulaField)field).setReferences();
                field.addReferenceHolder(this);
            }
        }
    }

    @Override
    public Field duplicate(String string) {
        PromptField promptField;
        try {
            promptField = this.DE.getFields().addPromptField(string, this.getPromptText(), this.getPromptType());
            promptField.setAllowMultipleValues(this.getAllowMultipleValues());
            promptField.setDescriptionOnly(this.isDescriptionOnly());
            promptField.setDiscreteOrRangeType(this.getDiscreteOrRangeType());
            promptField.setEditable(this.isEditable());
            promptField.setUseRange(this.getUseRange());
            if (this.getUseRange()) {
                promptField.setMaxRangeValue(this.getMaxRangeValue());
                promptField.setMinRangeValue(this.getMinRangeValue());
            }
            if (this.getDefaultValueProvider() == null) {
                DefaultValue[] defaultValueArray = this.getDefaultValues();
                if (defaultValueArray != null) {
                    for (DefaultValue defaultValue : defaultValueArray) {
                        try {
                            promptField.addDefaultValue((DefaultValue)defaultValue.clone());
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {
                            BaseUtils.printStackTrace(cloneNotSupportedException);
                        }
                    }
                }
            } else if (this.acI instanceof QueryValueProvider) {
                QueryValueProvider queryValueProvider = (QueryValueProvider)this.getDefaultValueProvider();
                promptField.setDefaultValueProvider(new QueryValueProvider(queryValueProvider.getSQL(), queryValueProvider.getDatasource()));
            } else if (this.acI instanceof CascadingValueProvider) {
                CascadingValueProvider cascadingValueProvider = (CascadingValueProvider)this.getDefaultValueProvider();
                promptField.setDefaultValueProvider(new CascadingValueProvider(cascadingValueProvider.getParent(), cascadingValueProvider.getParentSource(), cascadingValueProvider.getValues(), cascadingValueProvider.getDescriptions(), cascadingValueProvider.getSortType()));
            } else if (this.acI instanceof FieldValueProvider) {
                FieldValueProvider fieldValueProvider = (FieldValueProvider)this.getDefaultValueProvider();
                promptField.setDefaultValueProvider(new FieldValueProvider(fieldValueProvider.getValues(), fieldValueProvider.getDescriptions(), fieldValueProvider.getSortType()));
            } else {
                BaseUtils.warning("cannot duplicate default value provider while duplicating " + this.getName() + " - using no default value provider instead...");
            }
        }
        catch (ReportException reportException) {
            throw new IllegalArgumentException("cannot duplicate prompt field with name " + string, reportException);
        }
        return promptField;
    }

    void a(Evaluable evaluable) {
        this.acW = evaluable;
    }

    public Evaluable getFormulaAst() {
        return this.acW;
    }

    static void a(Object object, int n2, String string, String string2) throws ReportException {
        if (object == null) {
            return;
        }
        switch (n2 %= 128) {
            case 6: 
            case 7: {
                if (object instanceof Number) {
                    return;
                }
                if (object instanceof FormulaRange && (((FormulaRange)object).getFrom() instanceof Number && ((FormulaRange)object).getTo() instanceof Number || ((FormulaRange)object).getFrom() instanceof String || ((FormulaRange)object).getTo() instanceof String || ((FormulaRange)object).getFrom() == null || ((FormulaRange)object).getTo() == null)) {
                    return;
                }
                if (!(object instanceof Object[])) break;
                for (int i2 = 0; i2 < ((Object[])object).length; ++i2) {
                    PromptField.a(((Object[])object)[i2], n2, string, string2);
                }
                return;
            }
            case 8: {
                if (object instanceof Boolean) {
                    return;
                }
                if (object instanceof FormulaRange && ((((FormulaRange)object).getFrom() instanceof Boolean || ((FormulaRange)object).getFrom() == null) && ((FormulaRange)object).getTo() instanceof Boolean || ((FormulaRange)object).getTo() == null)) {
                    return;
                }
                if (!(object instanceof Object[])) break;
                for (int i3 = 0; i3 < ((Object[])object).length; ++i3) {
                    PromptField.a(((Object[])object)[i3], n2, string, string2);
                }
                return;
            }
            case 9: {
                if (object instanceof java.util.Date) {
                    return;
                }
                if (object instanceof FormulaRange && ((((FormulaRange)object).getFrom() instanceof java.util.Date || ((FormulaRange)object).getFrom() == null) && ((FormulaRange)object).getTo() instanceof java.util.Date || ((FormulaRange)object).getTo() == null)) {
                    return;
                }
                if (!(object instanceof Object[])) break;
                for (int i4 = 0; i4 < ((Object[])object).length; ++i4) {
                    PromptField.a(((Object[])object)[i4], n2, string, string2);
                }
                return;
            }
            case 10: {
                if (object instanceof java.util.Date) {
                    return;
                }
                if (object instanceof FormulaRange && ((((FormulaRange)object).getFrom() instanceof java.util.Date || ((FormulaRange)object).getFrom() == null) && ((FormulaRange)object).getTo() instanceof java.util.Date || ((FormulaRange)object).getTo() == null)) {
                    return;
                }
                if (!(object instanceof Object[])) break;
                for (int i5 = 0; i5 < ((Object[])object).length; ++i5) {
                    PromptField.a(((Object[])object)[i5], n2, string, string2);
                }
                return;
            }
            case 11: {
                if (object instanceof String) {
                    return;
                }
                if (object instanceof FormulaRange && ((((FormulaRange)object).getFrom() instanceof String || ((FormulaRange)object).getFrom() == null) && ((FormulaRange)object).getTo() instanceof String || ((FormulaRange)object).getTo() == null)) {
                    return;
                }
                if (!(object instanceof Object[])) break;
                for (int i6 = 0; i6 < ((Object[])object).length; ++i6) {
                    PromptField.a(((Object[])object)[i6], n2, string, string2);
                }
                return;
            }
            case 15: {
                if (object instanceof java.util.Date) {
                    return;
                }
                if (object instanceof FormulaRange) {
                    if ((!(((FormulaRange)object).getFrom() instanceof java.util.Date) && ((FormulaRange)object).getFrom() != null || !(((FormulaRange)object).getTo() instanceof java.util.Date)) && ((FormulaRange)object).getTo() != null) break;
                    return;
                }
                if (!(object instanceof Object[])) break;
                for (int i7 = 0; i7 < ((Object[])object).length; ++i7) {
                    PromptField.a(((Object[])object)[i7], n2, string, string2);
                }
                return;
            }
            case 14: {
                if (!(object instanceof byte[])) break;
                return;
            }
        }
        throw ReportExceptionFactory.createReportException(ErrorCode.WrongPromptData, string, object, object.getClass().getName(), string2);
    }

    public void copySPParametersTo(PromptField promptField) {
        if (this.acJ != null) {
            promptField.acJ = this.acJ;
        }
        if (this.acK != null) {
            try {
                TableSource tableSource = promptField.DE.rh().getTablesource(this.acK.getAlias());
                if (tableSource != null) {
                    promptField.acK = tableSource;
                }
            }
            catch (ReportException reportException) {
                BaseUtils.warning(reportException);
            }
        }
    }

    static enum b {
        adw,
        adx;

    }

    private static enum a {
        acY,
        acZ,
        ada,
        adb,
        adc,
        add,
        ade,
        adf,
        adg,
        adh,
        adi,
        adj,
        adk,
        adl,
        adm,
        adn,
        ado,
        adp,
        adq,
        adr,
        ads,
        adt,
        adu;

    }
}

