/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.report.BaseUtils;
import com.inet.report.ReportException;
import com.inet.report.cr;
import com.inet.report.i18n.ErrorCode;
import com.inet.report.i18n.Msg;
import com.inet.report.permissions.WebUserInfo;
import com.inet.report.permissions.WebUserInfoFactory;
import com.inet.report.permissions.a;
import com.inet.report.permissions.o;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReportExceptionFactory {
    private static Pattern asW = Pattern.compile("(?s)\\[(\\d{1,7})\\].*");

    public static ReportException createReportException(ErrorCode errorCode, Object ... objectArray) {
        String string = ReportExceptionFactory.formatMsg(errorCode, objectArray);
        int n2 = errorCode.getErrorCodeNumber();
        ReportException reportException = new ReportException(string, n2);
        return reportException;
    }

    public static String formatMsg(ErrorCode errorCode, Object ... objectArray) {
        return Msg.getMsg(errorCode.name(), objectArray);
    }

    public static ReportException createReportExceptionWithCauseOutOfMemoryError(String string, Throwable throwable) {
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        Object[] objectArray = new Object[]{String.valueOf(runtime.totalMemory()), String.valueOf(runtime.freeMemory()), string};
        return ReportExceptionFactory.createReportException(ErrorCode.outOfMemory, objectArray).setCause(throwable);
    }

    public static ReportException createReportExceptionWithCause(Throwable throwable, ErrorCode errorCode, Object ... objectArray) {
        ErrorCode errorCode2;
        String string;
        if (throwable instanceof a) {
            String string2;
            WebUserInfo webUserInfo = WebUserInfoFactory.getSessionWebUserInfo();
            String string3 = string2 = webUserInfo == null ? null : webUserInfo.getWebUserName();
            if (BaseUtils.isDebug()) {
                BaseUtils.debug(webUserInfo + "  Current User: " + string2 + ", " + throwable.getMessage());
            }
            return new o(string2 == null ? ErrorCode.UserNotLoggedIn : ErrorCode.AccessDenied, ((a)throwable).getUrl());
        }
        if (throwable instanceof o) {
            return (ReportException)throwable;
        }
        if (throwable instanceof ReportException) {
            StackTraceElement[] stackTraceElementArray;
            int n2 = ((ReportException)throwable).getErrorCode();
            if (n2 == -601) {
                return (ReportException)throwable;
            }
            ReportException reportException = new ReportException(throwable.getMessage(), n2);
            StackTraceElement[] stackTraceElementArray2 = throwable.getStackTrace();
            if (stackTraceElementArray2 != null && stackTraceElementArray2.length > 0 && (stackTraceElementArray = reportException.getStackTrace()) != null && stackTraceElementArray.length > 0) {
                int n3;
                int n4 = stackTraceElementArray2.length - 1;
                for (n3 = stackTraceElementArray.length - 1; n4 >= 0 && n3 >= 0 && stackTraceElementArray2[n4].equals(stackTraceElementArray[n3]); --n4, --n3) {
                }
                if (n3 <= 2 || stackTraceElementArray.length - n3 > 10) {
                    return (ReportException)throwable;
                }
            }
            reportException.initCause(throwable);
            return reportException;
        }
        if (throwable instanceof OutOfMemoryError) {
            return ReportExceptionFactory.createReportExceptionWithCauseOutOfMemoryError("unknown", throwable);
        }
        if (throwable instanceof InterruptedException) {
            return ReportExceptionFactory.createReportException(ErrorCode.Interrupted, new Object[0]).setCause(throwable);
        }
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            return ReportExceptionFactory.createReportException(ErrorCode.SqlError, throwable.getLocalizedMessage(), sQLException.getSQLState(), String.valueOf(sQLException.getErrorCode())).setCause(throwable);
        }
        if (throwable instanceof cr) {
            return ReportExceptionFactory.createReportException(ErrorCode.noActiveRepository, new Object[0]);
        }
        String string4 = string = throwable != null ? throwable.getMessage() : null;
        if (string != null && errorCode == ErrorCode.wrapException && (errorCode2 = ReportExceptionFactory.bq(string)) != null) {
            string = string.substring(string.indexOf(93) + 1).trim();
            return new ReportException(string, errorCode2.getErrorCodeNumber()).setCause(throwable);
        }
        return ReportExceptionFactory.createReportException(errorCode, objectArray).setCause(throwable);
    }

    public static ReportException createReportExceptionWithCause(Throwable throwable) {
        ErrorCode errorCode = ErrorCode.wrapException;
        String string = throwable.getMessage();
        return ReportExceptionFactory.createReportExceptionWithCause(throwable, errorCode, throwable.getClass().getName(), string);
    }

    private static ErrorCode bq(String string) {
        Matcher matcher = asW.matcher(string);
        if (matcher.find()) {
            int n2 = Integer.parseInt(matcher.group(1));
            return ErrorCode.valueOf(n2);
        }
        return null;
    }
}

