/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.lib.util.IOFunctions;
import com.inet.report.BaseUtils;
import com.inet.report.Engine;
import com.inet.report.PromptRequestWarning;
import com.inet.report.PropertiesChecker;
import com.inet.report.RDC;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.ReportKeyFactory;
import com.inet.report.RepositoryServlet;
import com.inet.report.RequestHandler;
import com.inet.report.ay;
import com.inet.report.cache.Cache;
import com.inet.report.cache.KeyNotFoundException;
import com.inet.report.cache.ReportCacheKey;
import com.inet.report.config.ConfigValue;
import com.inet.report.config.structure.model.ConfigKey;
import com.inet.report.cx;
import com.inet.report.de;
import com.inet.report.dw;
import com.inet.report.i18n.ErrorCode;
import com.inet.report.i18n.Msg;
import com.inet.report.permissions.WebUserInfoFactory;
import com.inet.report.permissions.f;
import com.inet.report.schedule.Scheduler;
import com.inet.report.servlets.a;
import com.inet.report.util.ac;
import com.inet.report.util.q;
import com.inet.report.util.t;
import com.inet.report.util.w;
import com.inet.report.util.x;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.FilterChain;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class ReportServlet
extends HttpServlet
implements PropertiesChecker,
FilterChain {
    private RepositoryServlet aux;
    private boolean auy;
    private static PropertiesChecker o;
    private static final ConfigValue<List<RequestHandler>> auz;

    public ReportServlet() {
        BaseUtils.gn();
    }

    @Override
    public void init(ServletConfig servletConfig) throws ServletException {
        block9: {
            super.init(servletConfig);
            w.a(servletConfig);
            dw.aQ(true);
            dw.sw();
            try {
                Scheduler.getInstance();
            }
            catch (Throwable throwable) {
                BaseUtils.warning("Loading scheduler interface failed.");
                BaseUtils.warning(throwable);
            }
            String string = dw.azD.get(ConfigKey.PROPERTY_CHECKER.getKey(), "PropertyChecker").trim();
            try {
                o = dw.azH;
                if (string.length() > 0) {
                    o = (PropertiesChecker)BaseUtils.classForName(string).newInstance();
                }
            }
            catch (Throwable throwable) {
                if (string.equals("PropertyChecker")) {
                    if (BaseUtils.isDebug()) {
                        BaseUtils.debug("[PropertiesChecker] no default PropertiesChecker found");
                    }
                }
                if (BaseUtils.gk()) {
                    BaseUtils.warning("[PropertiesChecker] could not load class \"" + string + "\" reason:" + throwable.getClass().getName());
                }
                if (!BaseUtils.isParanoid()) break block9;
                BaseUtils.paranoid(throwable);
            }
        }
        if (o != null && BaseUtils.isDebug()) {
            BaseUtils.debug("[PropertiesChecker] using class \"" + o.getClass().getName() + "\"");
        }
    }

    private synchronized void rI() {
        if (this.auy) {
            return;
        }
        this.auy = true;
        try {
            this.aux = new RepositoryServlet();
            this.aux.init(this.getServletConfig());
        }
        catch (Throwable throwable) {
            if (throwable instanceof ClassNotFoundException) {
                if (ay.kE().isPlusVersion()) {
                    BaseUtils.warning("The component Repository is not installed or incomplete!\nPlease reinstall the software in order to use the repository.");
                } else {
                    BaseUtils.info("The component Repository is not installed or incomplete! A plus license is necessary to use this feature.");
                }
            }
            BaseUtils.error("Repository can't init.");
            BaseUtils.printStackTrace(throwable);
        }
    }

    @Override
    public void destroy() {
        block4: {
            BaseUtils.info("Servlet destroy called");
            try {
                Field field = URL.class.getDeclaredField("handlers");
                if (field != null) {
                    field.setAccessible(true);
                    Object object = field.get(null);
                    if (object instanceof Hashtable) {
                        ((Hashtable)object).remove("repo");
                    }
                }
            }
            catch (Throwable throwable) {
                if (!BaseUtils.isError()) break block4;
                BaseUtils.error("Could not deregister repo protocol.");
                BaseUtils.error(throwable);
            }
        }
        dw.sv();
        a.destroy();
        BaseUtils.closeLogStream();
        super.destroy();
    }

    public void doExecRequest(Properties properties, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        this.b(properties, properties.getProperty("application_context") + properties.getProperty("context", "/"));
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        ac.a(httpServletRequest, httpServletResponse, (OutputStream)servletOutputStream, properties, this);
    }

    public void doWriteHtmlPage(Properties properties, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ReportException, ServletException {
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        httpServletResponse.setContentType("text/html");
        String string = dw.h(properties);
        properties.put("report", properties.getProperty("http_server_port") + properties.getProperty("application_context", "") + properties.getProperty("context", "/") + "?" + string);
        try {
            this.checkHtmlPageProperties(properties);
        }
        catch (Exception exception) {
            BaseUtils.warning("Could not check HTML properties:");
            BaseUtils.printStackTrace(exception);
            throw new ReportException(String.valueOf(exception.getMessage()), 0);
        }
        ac.a(httpServletRequest, httpServletResponse, servletOutputStream, properties);
    }

    private static final void bv(String string) throws ReportException {
        ay ay2 = ay.kE();
        if (ay2.kQ() != null) {
            if (string.indexOf(58) >= 0) {
                string = IOFunctions.normalizeIPv6(string);
            }
            if (!ay2.kQ().containsKey(string)) {
                ay2.kQ().put(string, string);
            }
            if (ay2.kQ().size() > ay2.kR()) {
                ay2.kQ().remove(string);
                String string2 = ay2.kQ().keySet().toString();
                throw ReportExceptionFactory.createReportException(ErrorCode.MaxClients, ay2.getLicenseText(), string2);
            }
        }
    }

    public void afterPropertiesStoredHook(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Properties properties) throws ServletException, IOException {
    }

    @Override
    public void checkProperties(Properties properties, Object object) throws ReportException {
        this.checkProperties(properties);
    }

    public void checkProperties(Properties properties) throws ReportException {
        if (o != null) {
            o.checkProperties(properties, null);
        }
    }

    @Override
    public void checkProperties(Engine engine, Properties properties, Object object) throws ReportException {
        this.checkProperties(engine, properties);
    }

    public void checkProperties(Engine engine, Properties properties) throws ReportException {
        if (o != null) {
            o.checkProperties(engine, properties, null);
        }
    }

    @Override
    public void checkHtmlPageProperties(Properties properties) throws ReportException {
        if (o != null) {
            o.checkHtmlPageProperties(properties);
        }
    }

    private URL z(String string, String string2) {
        URL uRL = q.ah(null, string);
        if (uRL != null) {
            return uRL;
        }
        try {
            String string3 = "/" + string;
            URL uRL2 = this.getServletContext().getResource(string3);
            if (uRL2 == null) {
                String string4 = this.getServletContext().getRealPath(string3);
                if (string4 != null && (uRL = q.ah("file:", string4)) != null) {
                    return uRL;
                }
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug("Could not find Resource from '" + string3 + "'");
                }
            } else {
                uRL = q.ah(null, uRL2.toString());
                if (uRL != null) {
                    return uRL;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return dw.z(string, string2);
    }

    private void b(Properties properties, String string) {
        URL uRL;
        String string2 = properties.getProperty("report");
        boolean bl2 = false;
        if (string2 == null) {
            if (string.toLowerCase().indexOf(".jsp") != -1) {
                return;
            }
            bl2 = true;
            string2 = string;
            properties.setProperty("report", string2);
        }
        if ((uRL = (URL)dw.azL.get(string2)) == null) {
            try {
                if (bl2) {
                    uRL = this.getServletContext().getResource(string);
                    if (BaseUtils.isDebug()) {
                        BaseUtils.debug("looked in: " + string + " :" + uRL);
                    }
                } else {
                    String string3 = string2;
                    if (string3.startsWith("file:") && string3.indexOf(58, 5) == 6) {
                        string3 = string3.substring(0, 5) + '/' + string3.substring(5);
                        uRL = new URL(string3);
                    } else if (string3.indexOf(58) == 1) {
                        string3 = "file:/" + string3;
                        uRL = new URL(string3);
                    } else {
                        String string4 = string.length() == 1 || string3.startsWith(string) ? null : properties.getProperty("http_server_port");
                        uRL = this.z(string3, string4);
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (uRL == null) {
                return;
            }
        }
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("Found report URL " + string2 + " maps to:" + uRL);
        }
        dw.azL.put(string2, uRL);
        properties.put("report", uRL.toString());
    }

    @Override
    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        a.doFilter(httpServletRequest, httpServletResponse, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        Object object;
        String string;
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        String string2 = httpServletRequest.getMethod();
        if (string2.equals("OPTIONS") || string2.equals("PROPFIND") || httpServletRequest.getRequestURI().startsWith(httpServletRequest.getContextPath() + "/repository")) {
            if (!this.auy) {
                this.rI();
            }
            if (this.aux != null) {
                this.aux.service(httpServletRequest, httpServletResponse);
                return;
            }
        }
        com.inet.report.statistic.a.YD();
        try {
            httpServletRequest.setCharacterEncoding("ISO8859-1");
            ((Request)httpServletRequest).setQueryEncoding("ISO8859-1");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Properties properties = w.c(httpServletRequest);
        t.p(properties);
        try {
            ReportKeyFactory.B(properties, true);
        }
        catch (Exception exception) {
            BaseUtils.printStackTrace(exception);
        }
        String string3 = httpServletRequest.getHeader("Cookie");
        if (string3 != null && string3.length() > 0) {
            properties.put("cookie", string3);
        }
        w.a(httpServletRequest, properties);
        String string4 = properties.getProperty("application_context", "");
        String string5 = properties.getProperty("report");
        if (string5 != null && !string4.isEmpty() && string5.startsWith(string4)) {
            properties.put("report", string5.substring(string4.length()));
        }
        if (properties.getProperty("locale", "").length() == 0 && httpServletRequest.getHeader("accept-language") != null && (string = httpServletRequest.getHeader("accept-language")) != null) {
            object = string.split(",");
            properties.put("locale", object[0]);
        }
        Msg.setThreadLocale(httpServletRequest);
        try {
            Object object2;
            if (!WebUserInfoFactory.createWebUserInfo(httpServletRequest, httpServletResponse, new f())) {
                return;
            }
            string = httpServletRequest.getHeader("X-Forwarded-For");
            if (string == null) {
                string = httpServletRequest.getRemoteAddr();
            }
            string = string.toLowerCase();
            properties.put("clientadress", string);
            this.afterPropertiesStoredHook(httpServletRequest, httpServletResponse, properties);
            dw.c(properties, "after properties stored");
            object = auz.get();
            for (int i2 = 0; i2 < object.size(); ++i2) {
                object2 = (RequestHandler)object.get(i2);
                if (!object2.acceptsRequest(properties)) continue;
                object2.handleRequest(null, httpServletRequest, httpServletResponse, httpServletResponse.getOutputStream(), properties);
                return;
            }
            String string6 = properties.getProperty("report");
            object2 = dw.g(properties);
            boolean bl2 = string2.equals("PUT");
            if (!(bl2 || string6 != null || ((String)object2).equals("rpt") || ((String)object2).equals("jsp") || ((String)object2).equals("xml") || properties.getProperty("init") != null)) {
                x.a(this, httpServletRequest, httpServletResponse, properties);
                return;
            }
            ReportServlet.bv(string);
            com.inet.report.statistic.a.YE();
            boolean bl3 = dw.i(properties);
            if (bl2) {
                if (properties.get("viewer") == null) {
                    properties.put("viewer", "java");
                }
                if (properties.get("cmd") == null) {
                    properties.put("cmd", "get_pg");
                }
                if (httpServletRequest.getContentLength() == 0) {
                    this.b(httpServletRequest, httpServletResponse, properties);
                } else {
                    this.a(httpServletRequest, httpServletResponse, properties);
                }
            } else if (bl3) {
                this.doExecRequest(properties, httpServletRequest, httpServletResponse);
            } else {
                String string7 = properties.getProperty("password", null);
                if (string7 != null) {
                    properties.put("password", RDC.encrypt(string7));
                }
                this.doWriteHtmlPage(properties, httpServletRequest, httpServletResponse);
            }
        }
        catch (Exception exception) {
            BaseUtils.printStackTrace(exception);
            object = httpServletResponse.getOutputStream();
            ac.sendEngineErrorPage(httpServletRequest, httpServletResponse, exception, (OutputStream)object, properties);
        }
        finally {
            WebUserInfoFactory.destroyWebUserInfo();
        }
    }

    private void a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Properties properties) throws IOException, ClassNotFoundException {
        ServletInputStream servletInputStream = httpServletRequest.getInputStream();
        ObjectInputStream objectInputStream = new ObjectInputStream(servletInputStream);
        Engine engine = (Engine)objectInputStream.readObject();
        try {
            DecimalFormat decimalFormat = new DecimalFormat("prompt###");
            for (Map.Entry<Object, Object> object2 : properties.entrySet()) {
                try {
                    engine.setPrompt((String)object2.getValue(), decimalFormat.parse((String)object2.getKey()).intValue());
                }
                catch (Exception string) {}
            }
            engine.execute();
            Cache cache = Cache.getCache();
            ReportCacheKey reportCacheKey = cache.createKey(properties, this, httpServletRequest);
            cache.delete(reportCacheKey);
            cache.addEngine(engine, reportCacheKey);
            String string = httpServletRequest.getHeader("getPageCount");
            if (string != null) {
                int n2 = cache.getPageCountAndWait(reportCacheKey, 600000);
                httpServletResponse.addHeader("pageCount", Integer.toString(n2));
                return;
            }
            ac.a(cache, httpServletRequest, httpServletResponse, (OutputStream)httpServletResponse.getOutputStream(), reportCacheKey, properties, this);
        }
        catch (PromptRequestWarning promptRequestWarning) {
            httpServletResponse.getOutputStream().write(de.b(promptRequestWarning, properties));
            return;
        }
        catch (ReportException reportException) {
            BaseUtils.error(reportException);
            httpServletResponse.addHeader("inetErrorCode", Integer.toString(reportException.getErrorCode()));
            httpServletResponse.addHeader("inetErrorMessage", reportException.getMessage());
            httpServletResponse.sendError(500, "PUT request failed: " + reportException.toString());
            return;
        }
        catch (Exception exception) {
            BaseUtils.error(exception);
            httpServletResponse.addHeader("inetErrorCode", exception.toString());
            httpServletResponse.addHeader("inetErrorMessage", exception.getMessage());
            httpServletResponse.sendError(500, "PUT request failed: " + exception.toString());
            return;
        }
    }

    private void b(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Properties properties) throws IOException {
        Cache cache = Cache.getCache();
        try {
            ReportCacheKey reportCacheKey = cache.createKey(properties, this, httpServletRequest);
            if (cache.exists(reportCacheKey)) {
                if ("rfsh".equals(properties.getProperty("cmd"))) {
                    cache.delete(properties.getProperty("report"));
                    httpServletResponse.sendError(404);
                    return;
                }
                String string = httpServletRequest.getHeader("getPageCount");
                if (string != null) {
                    int n2 = cache.getPageCountAndWait(reportCacheKey, 600000);
                    httpServletResponse.addHeader("pageCount", Integer.toString(n2));
                    return;
                }
                ac.a(cache, httpServletRequest, httpServletResponse, (OutputStream)httpServletResponse.getOutputStream(), reportCacheKey, properties, this);
            } else {
                httpServletResponse.sendError(404);
            }
        }
        catch (KeyNotFoundException keyNotFoundException) {
            httpServletResponse.sendError(404);
            return;
        }
        catch (ReportException reportException) {
            BaseUtils.error(reportException);
            httpServletResponse.addHeader("inetErrorCode", Integer.toString(reportException.getErrorCode()));
            httpServletResponse.addHeader("inetErrorMessage", reportException.getMessage());
            httpServletResponse.sendError(500, "PUT request failed: " + reportException.toString());
            return;
        }
        catch (Exception exception) {
            BaseUtils.error(exception);
            httpServletResponse.addHeader("inetErrorCode", exception.toString());
            httpServletResponse.addHeader("inetErrorMessage", exception.getMessage());
            httpServletResponse.sendError(500, "PUT request failed: " + exception.toString());
            return;
        }
    }

    static {
        auz = new cx(ConfigKey.REQUEST_HANDLER);
    }
}

