/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.report.BaseUtils;
import com.inet.report.BorderProperties;
import com.inet.report.Element;
import com.inet.report.Engine;
import com.inet.report.RDC;
import com.inet.report.Section;
import com.inet.report.SignatureProperties;
import com.inet.report.certificate.CertificateInfo;
import com.inet.report.certificate.CertificateInfoFactory;
import com.inet.report.i18n.Msg;
import com.inet.report.parser.FatalParserException;
import com.inet.report.parser.NodeParser;
import com.inet.report.parser.XMLTag;
import com.inet.report.q;
import java.io.PrintWriter;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.xml.sax.Attributes;

public class SignatureForm
extends Element
implements BorderProperties,
SignatureProperties {
    public static final int INSET_LEFT = 20;
    public static final int INSET_RIGHT = 20;
    public static final int INSET_TOP = 40;
    public static final int INSET_BOTTOM = 20;
    private String avl;
    private String avm;
    private String avn;
    private String avo;
    private String avp;
    private String avq;
    private String avr;
    private Date avs;
    private Date avt;
    private String avu;
    private String reason;
    private boolean avv;
    private boolean avw;
    private int avx;
    private boolean avy;
    private boolean avz;
    private boolean avA;
    private boolean avB;
    private boolean avC;
    private boolean avD;

    SignatureForm(Engine engine, Section section) {
        super(70, engine.ij(), section);
        this.rQ();
    }

    void init() {
        CertificateInfoFactory certificateInfoFactory = RDC.getCertificateFactory();
        if (certificateInfoFactory == null) {
            throw new IllegalStateException("signature parameters are not defined: please define ceritifate info factory");
        }
        CertificateInfo certificateInfo = certificateInfoFactory.getCertificateInfo(this.getEngine());
        Certificate certificate = certificateInfo.getCertificate();
        if (certificate instanceof X509Certificate) {
            X509Certificate x509Certificate = (X509Certificate)certificate;
            X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
            X500Principal x500Principal2 = x509Certificate.getIssuerX500Principal();
            this.avs = x509Certificate.getNotBefore();
            this.avt = x509Certificate.getNotAfter();
            this.avp = x500Principal2.getName();
            this.avr = x500Principal.getName();
            if (this.avr != null) {
                int n2 = this.avr.indexOf("CN=");
                if (n2 == -1 && ((n2 = this.avr.indexOf("cn=")) == -1 || n2 + "CN=".length() >= this.avr.length())) {
                    if (BaseUtils.gk()) {
                        BaseUtils.warning("pdf signature: common name is not defined in the certificate");
                    }
                    this.avq = "";
                    return;
                }
                int n3 = this.avr.indexOf(44, n2);
                if (n3 == -1) {
                    n3 = this.avr.length();
                }
                this.avq = this.avr.substring(n2 + "CN=".length(), n3);
            } else {
                this.avq = "";
            }
        }
    }

    @Override
    void k(PrintWriter printWriter, int n2) {
        String string = BaseUtils.L(n2);
        printWriter.print(string + "<" + "Element" + q.n("type", Element.c.Qn.name()) + this.iP() + ">\n");
        this.b(printWriter, ++n2, Element.OM);
        this.a(printWriter, n2, Element.OM);
        this.r(printWriter, n2);
        this.y(printWriter, n2);
        printWriter.print(string + "<" + "/" + "Element" + ">\n");
    }

    final void y(PrintWriter printWriter, int n2) {
        String string = BaseUtils.L(n2);
        StringBuilder stringBuilder = new StringBuilder();
        q.a(stringBuilder, ++n2, a.avG.name(), q.printBoolean(this.getDivideField()));
        q.a(stringBuilder, n2, a.avI.name(), q.printBoolean(this.getShowSubjectName()));
        q.a(stringBuilder, n2, a.avH.name(), q.printBoolean(this.getWriteCertificateLabels()));
        q.a(stringBuilder, n2, a.avJ.name(), q.printBoolean(this.getWriteCertificateSubjectName()));
        q.a(stringBuilder, n2, a.avK.name(), q.printBoolean(this.getWriteCertificateDistinguishedName()));
        q.a(stringBuilder, n2, a.avL.name(), q.printBoolean(this.getWriteCertificateLocation()));
        q.a(stringBuilder, n2, a.avM.name(), q.printBoolean(this.getWriteCertificateReason()));
        q.a(stringBuilder, n2, a.avN.name(), q.printBoolean(this.getWriteCertificateDate()));
        q.a(stringBuilder, n2, a.avO.name(), q.af(this.getTextPosition()));
        if (stringBuilder.length() > 0) {
            printWriter.print(string + "<" + XMLTag.SignatureFormProperties.name() + ">\n");
            printWriter.print(stringBuilder.toString());
            printWriter.print(string + "<" + "/" + XMLTag.SignatureFormProperties.name() + ">\n");
        }
    }

    @Override
    public NodeParser parseElement(XMLTag xMLTag, String string, Attributes attributes, Map<String, Object> map) throws FatalParserException {
        if (xMLTag != null) {
            switch (xMLTag) {
                case CommonProperties: 
                case BorderProperties: 
                case HyperlinkProperties: {
                    NodeParser nodeParser = super.parseElement(xMLTag, string, attributes, map);
                    return nodeParser;
                }
                case SignatureFormProperties: {
                    String string2 = attributes.getValue("value");
                    if (string2 == null) {
                        return null;
                    }
                    try {
                        this.A(string, string2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
            }
            return null;
        }
        NodeParser nodeParser = null;
        XMLTag xMLTag2 = XMLTag.getValueOf(string);
        switch (xMLTag2) {
            // Empty switch
        }
        return nodeParser;
    }

    private void A(String string, String string2) {
        a a2 = a.avF;
        try {
            a2 = a.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        switch (a2) {
            case avG: {
                this.avv = Boolean.valueOf(string2);
                break;
            }
            case avI: {
                this.avw = Boolean.valueOf(string2);
                break;
            }
            case avJ: {
                this.avD = Boolean.valueOf(string2);
                break;
            }
            case avK: {
                this.avz = Boolean.valueOf(string2);
                break;
            }
            case avL: {
                this.avB = Boolean.valueOf(string2);
                break;
            }
            case avM: {
                this.avC = Boolean.valueOf(string2);
                break;
            }
            case avH: {
                this.avA = Boolean.valueOf(string2);
                break;
            }
            case avN: {
                this.avy = Boolean.valueOf(string2);
                break;
            }
            case avO: {
                this.setTextPosition(Integer.parseInt(string2));
            }
        }
    }

    @Override
    public boolean getDivideField() {
        return this.avv;
    }

    @Override
    public boolean getShowSubjectName() {
        return this.avw;
    }

    @Override
    public int getTextPosition() {
        return this.avx;
    }

    @Override
    public boolean getWriteCertificateDate() {
        return this.avy;
    }

    @Override
    public boolean getWriteCertificateDistinguishedName() {
        return this.avz;
    }

    @Override
    public boolean getWriteCertificateLabels() {
        return this.avA;
    }

    @Override
    public boolean getWriteCertificateLocation() {
        return this.avB;
    }

    @Override
    public boolean getWriteCertificateReason() {
        return this.avC;
    }

    @Override
    public boolean getWriteCertificateSubjectName() {
        return this.avD;
    }

    @Override
    public void setDivideField(boolean bl2) {
        this.avv = bl2;
    }

    @Override
    public void setShowSubjectName(boolean bl2) {
        this.avw = bl2;
    }

    @Override
    public void setTextPosition(int n2) {
        this.avx = 1;
        if (n2 == 0) {
            this.avx = n2;
        }
    }

    @Override
    public void setWriteCertificateDate(boolean bl2) {
        this.avy = bl2;
    }

    @Override
    public void setWriteCertificateDistinguishedName(boolean bl2) {
        this.avz = bl2;
    }

    @Override
    public void setWriteCertificateLabels(boolean bl2) {
        this.avA = bl2;
    }

    @Override
    public void setWriteCertificateLocation(boolean bl2) {
        this.avB = bl2;
    }

    @Override
    public void setWriteCertificateReason(boolean bl2) {
        this.avC = bl2;
    }

    @Override
    public void setWriteCertificateSubjectName(boolean bl2) {
        this.avD = bl2;
    }

    private void rQ() {
        this.avl = Msg.getMsg(this.DE.asy, "ExportSignSignedby", new Object[0]);
        this.avm = Msg.getMsg(this.DE.asy, "ExportSignReason", new Object[0]) + " ";
        this.avn = Msg.getMsg(this.DE.asy, "ExportSignLocation", new Object[0]) + " ";
        this.avo = Msg.getMsg(this.DE.asy, "ExportSignSignDate", new Object[0]) + " ";
    }

    String getSubjectName() {
        return this.avq;
    }

    String rR() {
        return this.avr;
    }

    String getLocation() {
        return this.avu;
    }

    String getReason() {
        return this.reason;
    }

    String rS() {
        return this.avl;
    }

    String rT() {
        return this.avm;
    }

    String rU() {
        return this.avn;
    }

    String rV() {
        return this.avo;
    }

    public static enum a {
        avF,
        avG,
        avH,
        avI,
        avJ,
        avK,
        avL,
        avM,
        avN,
        avO;

    }
}

