/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.lib.swing.WindowIcon;
import com.inet.lib.swing.control.TitleBar;
import com.inet.report.Listener;
import com.inet.report.ReportException;
import com.inet.report.config.Configuration;
import com.inet.report.config.ConfigurationManager;
import com.inet.report.config.datasource.DataSourceConfigurationManager;
import com.inet.report.config.gui.swing.ConfigurationImportChecker;
import com.inet.report.config.gui.swing.ConfigurationImporter;
import com.inet.report.config.structure.model.ConfigKey;
import com.inet.report.do;
import com.inet.report.dp;
import com.inet.report.permissions.Permission;
import com.inet.report.permissions.PermissionHolder;
import com.inet.report.permissions.SystemPermissions;
import com.inet.report.permissions.r;
import com.inet.viewer.SwingViewerContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URL;
import java.util.Properties;
import javax.annotation.Nullable;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class StandaloneConfiguration {
    private static boolean awS;
    private static String awT;
    private static String awU;
    private Listener awV;
    private String url;
    private JLabel awW;

    private StandaloneConfiguration() throws Exception {
        awS = true;
        if (awU == null) {
            this.url = "Starting configuration ...";
            try {
                this.sa();
            }
            catch (HeadlessException headlessException) {
                System.out.println();
                System.out.println("You are using i-net Clear Reports - Standalone Configuration in an");
                System.out.println("environment that does not support a keyboard, display, or mouse.");
                System.out.println("Use the command line parameter '-help' to see the help for more details.");
                System.exit(1);
            }
            this.awV = new Listener(true, this.rZ());
            this.url = "http://127.0.0.1:" + this.awV.getPort() + "/public/remote/configmanager";
            this.awW.setText("<html>" + this.url + "</html>");
            new SwingViewerContext(null).showUrl(this.url, null);
        } else {
            this.awV = new Listener(true, this.rZ());
            System.out.println();
            System.out.println("Connect the configuration manager using:");
            System.out.println("http://" + InetAddress.getLocalHost().getHostName() + ":" + this.awV.getPort() + "/public/remote/configmanager");
            System.out.println("from the client " + awU);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        boolean bl2 = true;
        if (stringArray.length >= 1) {
            bl2 = false;
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string;
                String string2;
                if (stringArray[i2].equalsIgnoreCase("-importConfig") || stringArray[i2].equalsIgnoreCase("-forceImportConfig")) {
                    string2 = null;
                    string = null;
                    if (stringArray.length >= i2 + 3) {
                        string2 = stringArray[i2 + 1];
                        string = stringArray[i2 + 2];
                    }
                    StandaloneConfiguration.b(string2, string, stringArray[i2].equalsIgnoreCase("-forceImportConfig"));
                    continue;
                }
                if (stringArray[i2].equalsIgnoreCase("-importDatasource") || stringArray[i2].equalsIgnoreCase("-forceImportDatasource")) {
                    string2 = null;
                    string = null;
                    if (stringArray.length >= i2 + 3) {
                        string2 = stringArray[i2 + 1];
                        string = stringArray[i2 + 2];
                    }
                    StandaloneConfiguration.c(string2, string, stringArray[i2].equalsIgnoreCase("-forceImportDatasource"));
                    continue;
                }
                if (stringArray[i2].equalsIgnoreCase("-listConfigurations")) {
                    StandaloneConfiguration.sb();
                    continue;
                }
                if (stringArray[i2].equalsIgnoreCase("-exportConfig")) {
                    string2 = null;
                    string = null;
                    if (stringArray.length >= i2 + 3) {
                        string2 = stringArray[i2 + 1];
                        string = stringArray[i2 + 2];
                    }
                    try {
                        StandaloneConfiguration.B(string2, string);
                    }
                    catch (Exception exception) {
                        System.err.println(exception.getMessage());
                    }
                    continue;
                }
                if (stringArray[i2].equals("-clearreports.preferredconfig")) {
                    if (++i2 < stringArray.length) {
                        awT = stringArray[i2];
                    }
                    bl2 = true;
                    continue;
                }
                if (stringArray[i2].equals("-client.ip")) {
                    if (++i2 < stringArray.length) {
                        awU = stringArray[i2];
                    }
                    bl2 = true;
                    continue;
                }
                if (stringArray[i2].equals("-help") || stringArray[i2].equals("--help")) {
                    System.out.println("");
                    System.out.println("System Properties");
                    System.out.println("-----------------");
                    System.out.println("The following system properties are available to control the behavior of");
                    System.out.println("i-net Clear Reports and i-net Designer:");
                    System.out.println("");
                    System.out.println("Parameter Name                   | Description                            ");
                    System.out.println("--------------------------------------------------------------------------");
                    System.out.println("-Dclearreports.config            | Location of the configuration to use   ");
                    System.out.println("                                 |                                        ");
                    System.out.println("--------------------------------------------------------------------------");
                    System.out.println("-Dclearreports.configfile        | Location of a crystalclear.properties  ");
                    System.out.println("                                 | file that will be imported into        ");
                    System.out.println("                                 | temporary configuration                ");
                    System.out.println("--------------------------------------------------------------------------");
                    System.out.println("-DCC:xxxx=yyyy                   | Command line arguments to set property ");
                    System.out.println("                                 | values of the Report Server            ");
                    System.out.println("--------------------------------------------------------------------------");
                    System.out.println("-Ddebug                          | Enable/Disable the debug options       ");
                    System.out.println("--------------------------------------------------------------------------");
                    System.out.println("-Ddebug.maxpages                 | Maximum number of report pages         ");
                    System.out.println("--------------------------------------------------------------------------");
                    System.out.println("-Duser.country                   | Country of the used locale             ");
                    System.out.println("--------------------------------------------------------------------------");
                    System.out.println("-Duser.language                  | Language of the used locale            ");
                    System.out.println("--------------------------------------------------------------------------");
                    System.out.println("-open <report>                   | open a report files at the start of    ");
                    System.out.println("                                 | i-net Designer");
                    System.out.println("--------------------------------------------------------------------------");
                    System.out.println("");
                    System.out.println("Press key for the next section...");
                    System.in.read();
                    System.out.println("Command Line Parameters");
                    System.out.println("-----------------------");
                    System.out.println("With the following command line parameters you can use the Configuration  ");
                    System.out.println("Manager without GUI to import an i-net Clear Reports configuration or a   ");
                    System.out.println("Data Source configuration.                                                ");
                    System.out.println("");
                    System.out.println("Parameter Name                   | Description                            ");
                    System.out.println("--------------------------------------------------------------------------");
                    System.out.println("-listconfigurations              | Lists the existing configurations      ");
                    System.out.println("--------------------------------------------------------------------------");
                    System.out.println("-importConfig <name> <file>      | Imports properties file if specified   ");
                    System.out.println("                                 | configuration does not exist");
                    System.out.println("--------------------------------------------------------------------------");
                    System.out.println("-forceImportConfig <name> <file> | Imports properties file and replace    ");
                    System.out.println("                                 | existing configuration                 ");
                    System.out.println("--------------------------------------------------------------------------");
                    System.out.println("-exportConfig <name> <file>      | Exports the specified configuration in ");
                    System.out.println("                                 | a properties files                     ");
                    System.out.println("--------------------------------------------------------------------------");
                    System.out.println("-importDatasource <scope> <file> | Imports data source from XML as export-");
                    System.out.println("                                 | -ed by the data source manager. If a   ");
                    System.out.println("                                 | data source under the same name already");
                    System.out.println("                                 | exists, an additional one will be creat");
                    System.out.println("                                 | ed with a unique name.                 ");
                    System.out.println("--------------------------------------------------------------------------");
                    System.out.println("-forceImportDatasource           | Imports data source from XML as        ");
                    System.out.println(" <scope> <file>                  | exported by the data source manager.   ");
                    System.out.println("                                 | If a data source under the same name   ");
                    System.out.println("                                 | already exists, it will be replaced.   ");
                    System.out.println("");
                    System.out.println("");
                    System.out.println("With the following command line parameter you can set the active          ");
                    System.out.println("configuration for \"Standalone Configuration & Recovery\" mode.           ");
                    System.out.println("");
                    System.out.println("Parameter Name                   | Description                            ");
                    System.out.println("--------------------------------------------------------------------------");
                    System.out.println("-clearreports.preferredconfig    | Select the active configuration        ");
                    System.out.println("--------------------------------------------------------------------------");
                    System.out.println("-client.ip                       | The IP address (IPv4 or IPv6) of the   ");
                    System.out.println("                                 | client that will be able to connect to ");
                    System.out.println("                                 | the standalone configuration.          ");
                    System.out.println("                                 | This is useful for headless server.    ");
                    System.out.println("                                 | The default value is 127.0.0.1.        ");
                    System.out.println("");
                    System.out.println("java -cp core/ClearReports.jar com.inet.report.StandaloneConfiguration    ");
                    System.out.println("-clearreports.preferredconfig User/Default -client.ip <ip-address>        ");
                    continue;
                }
                if (i2 != 0) continue;
                System.out.println("Invalid argument: " + stringArray[i2] + ", open the help with -help");
            }
        }
        if (bl2) {
            new StandaloneConfiguration();
        }
    }

    private Properties rZ() {
        Properties properties = new Properties();
        SystemPermissions systemPermissions = new SystemPermissions();
        systemPermissions.setPermission(new PermissionHolder("guest", PermissionHolder.TYPE.USER), Permission.MODULE_CONFIGURATIONMANAGER, "true");
        systemPermissions.setPermission(new PermissionHolder("guest", PermissionHolder.TYPE.USER), Permission.MODULE_DATASOURCE, "true");
        properties.setProperty(ConfigKey.SYSTEMPERMISSIONS.getKey(), r.a(systemPermissions));
        properties.setProperty(ConfigKey.SYSTEMPERMISSION_ENABLED.getKey(), "true");
        properties.setProperty(ConfigKey.PERMISSION.getKey(), "<?xml version=\"1.0\" encoding=\"UTF-8\"?><reportpermissions/>");
        properties.setProperty(ConfigKey.PERMISSION_ENABLED.getKey(), "true");
        properties.setProperty(ConfigKey.REMOTEINTERFACE_ENABLED.getKey(), "true");
        properties.setProperty(ConfigKey.PERMISSION_GUEST_ACTIVATED.getKey(), "true");
        if (awU != null) {
            properties.setProperty(ConfigKey.REMOTE_INTERFACE_IPFILTER.getKey(), awU);
        }
        properties.setProperty(ConfigKey.LOG_LEVEL.getKey(), "4");
        return properties;
    }

    private void sa() throws HeadlessException {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        JFrame jFrame = new JFrame("Standalone Configuration & Recovery");
        jFrame.setDefaultCloseOperation(3);
        URL uRL = this.getClass().getResource("Config-Manager.ico");
        WindowIcon.setApplicationIcon(jFrame, uRL);
        Container container = jFrame.getContentPane();
        TitleBar titleBar = new TitleBar();
        titleBar.setTitle("Recovery and Configuration for your i-net Clear Reports Server");
        titleBar.setDescription("Allows localhost only access to a configuration tool via a separate web application.");
        titleBar.setIcon(ConfigurationImporter.getIcon("Config_32.png"));
        container.add((Component)titleBar, "North");
        JLabel jLabel = new JLabel("<html><center><p>This tool is mainly designed for configuration recovery purposes.<p>All features from the remote configuration manager are available.<p style='padding-top: 5px;'><span style='color: #aa0000; font-size: 80%;'>Attention: the access is localhost only and does not provide any reporting functionality.</span>");
        this.awW = new JLabel("<html>" + this.url + "</html>");
        this.awW.setFont(new Font("Dialog", 0, 20));
        this.awW.setForeground(new Color(16823));
        this.awW.setCursor(new Cursor(12));
        this.awW.addMouseListener(new do(this));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 20, 0), 0, 0));
        jPanel.add((Component)this.awW, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        Dimension dimension = jPanel.getPreferredSize();
        dimension.height = Math.max(200, dimension.height);
        jPanel.setPreferredSize(dimension);
        container.add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout(2, 10, 10));
        dp dp2 = new dp(this, "Shutdown");
        jFrame.getRootPane().setDefaultButton(dp2);
        jPanel2.add(dp2);
        container.add((Component)jPanel2, "South");
        jFrame.pack();
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }

    public static boolean isStandaloneConfiguration() {
        return awS;
    }

    public static String getClientIP() {
        return awU;
    }

    @Nullable
    public static String getPreferredConfiguration() {
        return awT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void b(String string, String string2, boolean bl2) {
        if (bl2) {
            System.out.println("Forced import of configuration requested (will overwrite old configuration if necessary).");
        } else {
            System.out.println("Import of configuration requested.");
        }
        if (string == null) {
            System.err.println("The new configuration name must be specified in the format scope/name, e.g. User/myConfig");
            if (bl2) {
                System.err.println("Usage: java -jar ClearReports.jar -forceImportConfig <name> <file>");
            } else {
                System.err.println("Usage: java -jar ClearReports.jar -importConfig <name> <file>");
            }
            return;
        }
        if (string2 == null) {
            System.err.println("A properties file must be specified.");
            if (bl2) {
                System.err.println("Usage: java -jar ClearReports.jar -forceImportConfig <name> <file>");
            } else {
                System.err.println("Usage: java -jar ClearReports.jar -importConfig <name> <file>");
            }
            return;
        }
        int n2 = string.indexOf(47);
        if (n2 < 0) {
            System.err.println("The configuration name must be in the format scope/name, e.g. User/myConfig");
            return;
        }
        String string3 = string.substring(0, n2);
        String string4 = string.substring(n2 + 1);
        int n3 = StandaloneConfiguration.bB(string3);
        if (!StandaloneConfiguration.cy(n3)) {
            return;
        }
        if (string4.length() <= 0) {
            System.err.println("A name for the new configuration must be specified.");
            return;
        }
        ConfigurationManager configurationManager = ConfigurationManager.getInstance();
        if (configurationManager.get(n3, string4) != null && !bl2) {
            System.err.println("A configuration with the name \"" + string4 + "\" already exists in the scope \"" + ConfigurationManager.getScopeName(n3) + "\". Please specify another name,\nor use the command line argument forceImportConfig instead, to overwrite the configuration, e.g.:\njava -jar -forceImportConfig " + string + " " + string2);
            return;
        }
        File file = new File(string2);
        if (!StandaloneConfiguration.f(file)) {
            return;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            if (configurationManager.get(n3, string4) != null && bl2) {
                System.out.println("Deleting old configuration at " + string + "...");
                configurationManager.delete(n3, string4);
            }
            System.out.println("Importing configuration into " + string + "...");
            configurationManager.importFromStream(n3, string4, fileInputStream);
            fileInputStream.close();
            Configuration configuration = configurationManager.get(n3, string4);
            ConfigurationImportChecker configurationImportChecker = new ConfigurationImportChecker(true, n3, string4, null);
            configurationImportChecker.checkForDLLs(configuration);
            System.out.print("The configuration \"" + string4 + "\" was successfully imported into the scope \"" + ConfigurationManager.getScopeName(n3) + "\"");
            if (n3 == 2) {
                System.out.println(" for the user \"" + System.getProperty("user.name") + "\".");
            } else {
                System.out.println(".");
            }
            System.out.println("Please note: DLL settings from your properties files haven't been converted to data sources, you have to create them manually.");
        }
        catch (SecurityException securityException) {
            System.err.println("A SecurityException occurred, please check your rights for the selected scope.");
            System.err.println(securityException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            System.err.println("A exception occurred while reading from the specified file.");
            System.err.println(iOException.getLocalizedMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("Importing failed due to the following problem:");
            System.err.println(illegalArgumentException.getLocalizedMessage());
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static boolean f(File file) {
        if (!file.exists()) {
            System.err.println("A file with the name \"" + file.getName() + "\" does not exist.");
            return false;
        }
        if (!file.isFile()) {
            System.err.println("The specified source file \"" + file.getName() + "\" is not a file.");
            return false;
        }
        if (!file.canRead()) {
            System.err.println("The specified source file \"" + file.getName() + "\" is not readable.");
            return false;
        }
        return true;
    }

    private static boolean cy(int n2) {
        if (n2 == -1) {
            System.err.println("Only the import to scope \"" + ConfigurationManager.getScopeName(2) + "\" or \"" + ConfigurationManager.getScopeName(1) + "\" is possible.");
            return false;
        }
        if (!ConfigurationManager.isWriteable(n2)) {
            System.err.println("You have no writing rights to scope \"" + ConfigurationManager.getScopeName(n2) + "\".");
            return false;
        }
        return true;
    }

    private static boolean cz(int n2) {
        if (n2 == -1) {
            System.err.println("Only the export from scope \"" + ConfigurationManager.getScopeName(2) + "\" or \"" + ConfigurationManager.getScopeName(1) + "\" is possible.");
            return false;
        }
        if (!ConfigurationManager.isReadable(n2)) {
            System.err.println("You have no rights to read from scope \"" + ConfigurationManager.getScopeName(n2) + "\".");
            return false;
        }
        return true;
    }

    private static int bB(String string) {
        int n2 = -1;
        if (string.equalsIgnoreCase(ConfigurationManager.getScopeName(2))) {
            n2 = 2;
        } else if (string.equalsIgnoreCase(ConfigurationManager.getScopeName(1))) {
            n2 = 1;
        }
        return n2;
    }

    private static void c(String string, String string2, boolean bl2) {
        if (string == null || string2 == null) {
            System.err.println("The scope as well as the datasource file you wish to import must be specified.");
            if (bl2) {
                System.err.println("Usage: java -jar ClearReports.jar -forceImportDatasource <scope> <file>");
            } else {
                System.err.println("Usage: java -jar ClearReports.jar -importDatasource <scope> <file>");
            }
            return;
        }
        int n2 = StandaloneConfiguration.bB(string);
        if (!StandaloneConfiguration.cy(n2)) {
            return;
        }
        File file = new File(string2);
        if (!StandaloneConfiguration.f(file)) {
            return;
        }
        try {
            if (bl2) {
                DataSourceConfigurationManager.forceImportDataSourceConfigurations(n2, file);
            } else {
                DataSourceConfigurationManager.importDataSourceConfigurations(n2, file);
            }
        }
        catch (ReportException reportException) {
            System.err.println("Error encountered while importing datasource:");
            reportException.printStackTrace(System.err);
        }
    }

    private static void B(String string, String string2) throws SecurityException, IOException {
        Object object;
        System.out.println("Export of configuration requested.");
        if (string == null || string2 == null) {
            System.err.println("The configuration name (in the format scope/name, e.g. User/myConfig) and a file to export to must be specified.");
            System.err.println("Usage: java -jar ClearReports.jar -exportConfig <name> <file>");
            return;
        }
        int n2 = string.indexOf(47);
        if (n2 < 0) {
            System.err.println("The configuration name must be in the format scope/name, e.g. User/myConfig");
            return;
        }
        String string3 = string.substring(0, n2);
        String string4 = string.substring(n2 + 1);
        int n3 = StandaloneConfiguration.bB(string3);
        if (!StandaloneConfiguration.cz(n3)) {
            return;
        }
        if (string4.length() <= 0) {
            System.err.println("A name for the configuration must be specified.");
            return;
        }
        ConfigurationManager configurationManager = ConfigurationManager.getInstance();
        try {
            object = configurationManager.get(n3, string4);
            if (object == null) {
                System.err.println("The Configuration " + ConfigurationManager.getScopeName(n3) + "/" + string4 + " does not exist.");
                return;
            }
        }
        catch (SecurityException securityException) {
            System.err.println("Access denied for the scope " + ConfigurationManager.getScopeName(n3) + ".");
            return;
        }
        object = new FileOutputStream(new File(string2));
        configurationManager.exportToStream(n3, string4, (OutputStream)object);
    }

    private static void sb() {
        System.out.println("System Scope");
        System.out.println("------------");
        StandaloneConfiguration.cA(1);
        System.out.println();
        System.out.println("User Scope");
        System.out.println("----------");
        StandaloneConfiguration.cA(2);
    }

    private static void cA(int n2) {
        Configuration[] configurationArray;
        for (Configuration configuration : configurationArray = ConfigurationManager.getInstance().getAll(n2)) {
            System.out.println(configuration.getName());
        }
    }

    static /* synthetic */ String a(StandaloneConfiguration standaloneConfiguration) {
        return standaloneConfiguration.url;
    }

    static /* synthetic */ JLabel b(StandaloneConfiguration standaloneConfiguration) {
        return standaloneConfiguration.awW;
    }
}

